/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.importacaoexcel;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemLeituraArquivoPonto;
import com.touchcomp.basementor.model.vo.LeituraArquivoPonto;
import com.touchcomp.basementor.model.vo.OpcoesIntegracaoPonto;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.touchvomodel.VOProcessResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.apuracaoponto.UtiltityAberturaFolhaPonto;
import mentorcore.service.impl.rh.apuracaoponto.apuracaopontoportxt.UtilityApuracaoPontoTxt;
import mentorcore.service.impl.rh.apuracaoponto.apuracaoporocorrencia.UtilityApuracaoPontoPorOcorrencia;

public class ServiceApuracaoPontoColaboradorFolha
extends CoreService {
    public static final String APURAR_PONTO_EMPRESA_POR_OCORRENCIA = "apurarPontoEmpresaPorOcorrencia";
    public static final String EFETUAR_IMPORTACAO_PONTO_TXT = "efetuarImportacaoPontoTxt";
    public static final String FIND_APURACAO_PTO_DESLIGAMENTO = "findApuracaoPtoDesligamento";
    public static final String FIND_APURACAO_PTO = "findApuracaoPto";
    public static final String SALVAR_MOVIMENTACAO_INDIVIDUAL = "salvarMovimentacaoIndividual";
    public static final String BUSCAR_APURACAO_PERIODO = "buscarApuracaoPeriodo";
    public static final String CRIAR_PONTO_FOLHA = "criarPontoFolha";
    public static final String REPROCESSAR_PONTO_FOLHA = "reprocessarPontoFolha";
    public static final String SALVAR_DADOS_PONTO = "salvarDadosPonto";

    public List apurarPontoEmpresaPorOcorrencia(CoreRequestContext request) throws ExceptionService {
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        AberturaPeriodo aberturaPeriodo = (AberturaPeriodo)request.getAttribute("abertura");
        return new UtilityApuracaoPontoPorOcorrencia().apuracaoPontoPorOcorrencia(dataInicio, dataFinal, empresaRh, aberturaPeriodo);
    }

    public HashMap efetuarImportacaoPontoTxt(CoreRequestContext request) throws IOException, FileNotFoundException, ExceptionService {
        File file = (File)request.getAttribute("file");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        PeriodoFolhaPagamento periodo = (PeriodoFolhaPagamento)request.getAttribute("periodo");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityApuracaoPontoTxt().apuracaoPontoArquivoTexto(file, empresa, periodo, empresaRh);
    }

    public List findApuracaoPtoDesligamento(CoreRequestContext r) {
        Date dataInicio = (Date)r.getAttribute("dataInicio");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        return new UtilityApuracaoPontoPorOcorrencia().apuracaoPontoPorOcorrenciaDesligamento(dataInicio, dataFinal, empresa, colaborador);
    }

    public List findApuracaoPto(CoreRequestContext r) {
        PeriodoFolhaPagamento periodo = (PeriodoFolhaPagamento)r.getAttribute("periodo");
        return new UtilityApuracaoPontoTxt().getPontosColaboradoresPeriodo(periodo);
    }

    public void salvarMovimentacaoIndividual(CoreRequestContext r) throws ExceptionDatabase {
        List lista = (List)r.getAttribute("lista");
        CoreDAOFactory.getInstance().getDAOItemLeituraArquivoPonto().saveOrUpdateCollection(lista);
    }

    public List buscarApuracaoPeriodo(CoreRequestContext r) {
        Date inicioImportacao = (Date)r.getAttribute("inicialImportacao");
        Date finalImportacao = (Date)r.getAttribute("finalImportacao");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return null;
    }

    public List criarPontoFolha(CoreRequestContext r) throws ExceptionService {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        PeriodoFolhaPagamento periodoFolha = (PeriodoFolhaPagamento)r.getAttribute("periodoFolha");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        OpcoesIntegracaoPonto opcoesIntegracaoPonto = (OpcoesIntegracaoPonto)r.getAttribute("opcoesIntegracaoPonto");
        return new UtiltityAberturaFolhaPonto().efetuarAberturaPonto(periodoFolha.getDataInicialApPonto(), periodoFolha.getDataFinalApPonto(), empresa, empresaRh, opcoesIntegracaoPonto);
    }

    public VOProcessResult reprocessarPontoFolha(CoreRequestContext r) throws ExceptionService, ExceptionDatabase {
        VOProcessResult res = new VOProcessResult();
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        LeituraArquivoPonto vo = (LeituraArquivoPonto)r.getAttribute("abertura");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        OpcoesIntegracaoPonto opcoesIntegracaoPonto = (OpcoesIntegracaoPonto)r.getAttribute("opcoesIntegracaoPonto");
        res = new UtiltityAberturaFolhaPonto().reprocessarPonto(vo, opcoesIntegracaoPonto, res);
        return res;
    }

    public void salvarDadosPonto(CoreRequestContext r) throws ExceptionDatabase {
        List lista = (List)r.getAttribute("lista");
        for (HashMap h : lista) {
            ItemLeituraArquivoPonto i = (ItemLeituraArquivoPonto)h.get("ITEM");
            CoreDAOFactory.getInstance().getDAOItemLeituraArquivoPonto().saveOrUpdate(i);
        }
    }
}

