/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.importacaoexcel;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.exceptions.ExceptionService;

public class UtilImportacaoExcelMultiplosEventos {
    public void criarLancamentosImportados(MovimentoFolha mov, List<HashMap> hashEventos, EmpresaRh empresaRh) throws ExceptionService {
        boolean achou = false;
        Iterator<HashMap> iterator = hashEventos.iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            HashMap hh = hashMap = iterator.next();
            Long codigoEvento = (Long)hh.get("CODIGO_EVENTO");
            Short tipo = (Short)hh.get("TIPO");
            double d = ToolMethods.isNotNull(hh.get("VALOR_REFERENCIA")) != false ? (Double)hh.get("VALOR_REFERENCIA") : 0.0;
            Double valorReferencia = d;
            if (!(valorReferencia > 0.0)) continue;
            for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(codigoEvento)) continue;
                achou = true;
                if (tipo.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()) && item.getEventoColaborador().getTipoCalculoEvento().getConverterRerenciaHora().equals((short)0)) {
                    item.setInformarReferencia(Short.valueOf((short)1));
                    item.setReferencia(valorReferencia);
                    continue;
                }
                if (tipo.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()) && item.getEventoColaborador().getTipoCalculoEvento().getConverterRerenciaHora().equals((short)1)) {
                    item.setInformarReferencia(Short.valueOf((short)1));
                    item.setReferenciaHora(valorReferencia);
                    item.setReferencia(this.getReferenciaHora(valorReferencia));
                    continue;
                }
                item.setInformarValor(Short.valueOf((short)1));
                item.setValor(valorReferencia);
            }
            if (!achou) {
                ItemMovimentoFolha item;
                EventoColaborador evt = this.createEventoColaborador(codigoEvento, mov);
                item = this.createItemMovimentoFolha(mov, evt, tipo, valorReferencia);
                mov.getItensMovimentoFolha().add(item);
            }
            this.verificarEventosFaltasAtestado(mov, this.getTipoCalculoEvento(codigoEvento), empresaRh, valorReferencia);
            achou = false;
        }
    }

    private EventoColaborador createEventoColaborador(Long codigoEvento, MovimentoFolha mov) throws ExceptionService {
        EventoColaborador evento = new EventoColaborador();
        TipoCalculoEvento tipoCalculoEvento = this.getTipoCalculoEvento(codigoEvento);
        evento.setTipoCalculoEvento(tipoCalculoEvento);
        evento.setColaborador(mov.getColaborador());
        evento.setDataInicial(mov.getAberturaPeriodo().getDataInicio());
        evento.setDataFinal(mov.getAberturaPeriodo().getDataFinal());
        evento.setTipoOcorrencia(Short.valueOf((short)2));
        evento.setEventoFixo(Short.valueOf((short)0));
        evento.setValor(Double.valueOf(0.0));
        return evento;
    }

    private TipoCalculoEvento getTipoCalculoEvento(Long codigoEvento) {
        ServiceTipoCalculoEventoImpl service = (ServiceTipoCalculoEventoImpl)Context.get(ServiceTipoCalculoEventoImpl.class);
        return service.getTipoCalculoEvento(codigoEvento);
    }

    private ItemMovimentoFolha createItemMovimentoFolha(MovimentoFolha vo, EventoColaborador ev, Short tipo, Double valorReferencia) {
        ItemMovimentoFolha i = new ItemMovimentoFolha();
        i.setMovimentoFolha(vo);
        i.setValor(Double.valueOf(0.0));
        i.setReferencia(Double.valueOf(0.0));
        i.setEventoColaborador(ev);
        i.setGeraFeriDecRec(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue());
        if (tipo.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
            if (ev.getTipoCalculoEvento().getConverterRerenciaHora().equals((short)0)) {
                i.setInformarReferencia(Short.valueOf((short)1));
                i.setReferencia(valorReferencia);
            } else {
                i.setInformarReferencia(Short.valueOf((short)1));
                i.setReferenciaHora(valorReferencia);
                i.setReferencia(this.getReferenciaHora(valorReferencia));
            }
        } else {
            i.setInformarValor(Short.valueOf((short)1));
            i.setValor(valorReferencia);
        }
        return i;
    }

    private void verificarEventosFaltasAtestado(MovimentoFolha mov, TipoCalculoEvento tipoCalculoEvento, EmpresaRh empresaRh, Double valor) {
        if (empresaRh.getTipoCalculoAtestado() != null && empresaRh.getTipoCalculoAtestado().equals((Object)tipoCalculoEvento)) {
            mov.setInformarAtestadoManual(Short.valueOf((short)1));
            mov.setDiasAtestado(valor);
        }
        if (empresaRh.getTpAtestadoHoras() != null && empresaRh.getTpAtestadoHoras().equals((Object)tipoCalculoEvento)) {
            mov.setInformarAtestadoManual(Short.valueOf((short)1));
            mov.setHorasAtestado(valor);
        }
        if (empresaRh.getTpFaltaHoras() != null && empresaRh.getTpFaltaHoras().equals((Object)tipoCalculoEvento)) {
            mov.setHorasFaltas(valor);
        }
        if (empresaRh.getTpFaltas() != null && empresaRh.getTpFaltas().equals((Object)tipoCalculoEvento)) {
            mov.setDiasFaltosos(valor);
        }
    }

    private Double getReferenciaHora(Double valorReferencia) {
        valorReferencia = Math.abs(valorReferencia);
        Integer inteira = valorReferencia.intValue();
        Integer decimal = (int)Math.round((valorReferencia - (double)valorReferencia.intValue()) * 100.0);
        Double dec = ContatoFormatUtil.arrredondarNumero((Double)((double)decimal.intValue() * 100.0 / 60.0), (int)0);
        Double referencia = 0.0;
        referencia = dec < 10.0 ? Double.valueOf(inteira + ".0" + dec.intValue()) : Double.valueOf(inteira + "." + dec.intValue());
        return referencia;
    }
}

