/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.impostofolha;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.AlocadorTomadorServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemAlocadorTomadorServico;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.impostofolha.UtilityImpostoFolhaPagamento;
import mentorcore.service.impl.rh.impostofolha.UtilityProcessarTomadores;

public class CoreServiceCalculoInss
extends CoreService {
    public static final String APURAR_VALORES_MATERNIDADE_GPS_DEC = "apurarValoresMaternidadeGpsDec";
    public static final String APURAR_TOMADORES_SERVICO = "apurarTomadoesServico";
    public static final String VERIFICAR_AFASTADOS_DECIMO_TERCEIRO = "verificarAfastadosDecimoTerceiro";

    public Double apurarValoresMaternidadeGpsDec(CoreRequestContext request) {
        TipoCalculoEvento tpCalculo = (TipoCalculoEvento)request.getAttribute("tipoCalculo");
        Integer ano = (Integer)request.getAttribute("ano");
        AberturaPeriodo aberturaPeriodo = (AberturaPeriodo)request.getAttribute("aberturaPeriodo");
        return new UtilityImpostoFolhaPagamento().deducaoMaternidadeGPSDecimoTerceiro(tpCalculo, ano, aberturaPeriodo);
    }

    public List apurarTomadoesServico(CoreRequestContext request) throws ExceptionService {
        AberturaPeriodo abertura = (AberturaPeriodo)request.getAttribute("abertura");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityProcessarTomadores().processarTomadores(abertura, empresaRh);
    }

    public void verificarAfastadosDecimoTerceiro(CoreRequestContext r) {
        AlocadorTomadorServico aloc = (AlocadorTomadorServico)r.getAttribute("aloc");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date periodo = (Date)r.getAttribute("periodo");
        String hql = " from MovimentoFolha mo  where  mo.colaborador.empresa = :empresa  and  mo.colaborador.dataDemissao is null  and  mo.aberturaPeriodo.dataFinal = :periodo  and exists (from MovimentoFolha m          where          m.colaborador = mo.colaborador          and          m.aberturaPeriodo.dataFinal=:periodo          and          m.aberturaPeriodo.tipoCalculo.tipoFolha= :folhaDec) and  not exists (from MovimentoFolha m          where          m.colaborador = mo.colaborador          and          m.aberturaPeriodo.dataFinal=:periodo          and          m.aberturaPeriodo.tipoCalculo.tipoFolha= :pagamento)";
        List lista = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa).setParameter("periodo", (Object)periodo).setParameter("pagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setParameter("folhaDec", (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()).list();
        if (lista == null || lista.isEmpty()) {
            return;
        }
        for (Object object : lista) {
            MovimentoFolha mov = (MovimentoFolha)object;
            ItemAlocadorTomadorServico i = new ItemAlocadorTomadorServico(mov);
            i.setAlocadorTomador(aloc);
            aloc.getItemTomadores().add(i);
        }
    }
}

