/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.impostofolha;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemAlocadorTomadorServico;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementor.model.vo.TomadorServicoRh;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityProcessarTomadores {
    /*
     * WARNING - void declaration
     */
    public List processarTomadores(AberturaPeriodo abertura, EmpresaRh empresaRh) throws ExceptionService {
        CentroCusto centroCustoEmpresa = empresaRh.getCentroCustoPadrao();
        if (!this.existeAlocacao(abertura)) {
            this.verificarFaltaAlocacaoCC(abertura, empresaRh);
            ArrayList tomadores = new ArrayList();
            for (MovimentoFolha m : abertura.getMovimentoFolha()) {
                void var10_15;
                CentroCusto centroCusto = m.getColaborador().getCentroCusto();
                boolean achou = false;
                for (Object e : tomadores) {
                    HashMap hash = (HashMap)e;
                    TomadorServicoRh tomador = (TomadorServicoRh)hash.get("TOMADOR");
                    if (!tomador.getCentroCusto().equals((Object)centroCusto)) continue;
                    achou = true;
                    List lista = (List)hash.get("ITENS");
                    ItemAlocadorTomadorServico i = new ItemAlocadorTomadorServico(m);
                    lista.add(i);
                    hash.put("ITENS", lista);
                    break;
                }
                if (achou) continue;
                TomadorPrestadorRps prestador = this.getPrestador(centroCusto);
                Object var10_12 = null;
                Double valorInss = 0.0;
                if (prestador != null) {
                    Pessoa pessoa = prestador.getPessoa();
                    valorInss = this.getValorInss(abertura, prestador);
                } else if (centroCustoEmpresa.getCodigo().substring(0, 3).equals(centroCusto.getCodigo().substring(0, 3))) {
                    Pessoa pessoa = abertura.getEmpresa().getPessoa();
                } else {
                    throw new ExceptionService("Centro de Custo: " + centroCusto.getNome() + " n\u00e3o alocado");
                }
                TomadorServicoRh newTomador = new TomadorServicoRh();
                newTomador.setEmpresa(abertura.getEmpresa());
                newTomador.setCentroCusto(centroCusto);
                newTomador.setPessoa((Pessoa)var10_15);
                newTomador.setDataCadastro(new Date());
                newTomador.setDescricao(var10_15.getNome());
                ItemAlocadorTomadorServico i = new ItemAlocadorTomadorServico(m);
                ArrayList<ItemAlocadorTomadorServico> lista = new ArrayList<ItemAlocadorTomadorServico>();
                lista.add(i);
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("TOMADOR", newTomador);
                hash.put("ITENS", lista);
                hash.put("VALOR_INSS", valorInss);
                tomadores.add(hash);
            }
            return tomadores;
        }
        return new ArrayList();
    }

    private TomadorPrestadorRps getPrestador(CentroCusto centroCusto) throws ExceptionService {
        String hql = " select distinct tomador.tomador  from TomadorPrestadorRpsCentroCusto tomador  where  tomador.centroCusto = :centroCusto ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("centroCusto", (Object)centroCusto).list();
        if (retorno != null && !retorno.isEmpty() && retorno.size() > 1) {
            throw new ExceptionService("Centro de Custo: " + centroCusto.getNome() + " alocado em mais de um Tomador");
        }
        if (retorno != null && !retorno.isEmpty()) {
            return (TomadorPrestadorRps)retorno.get(0);
        }
        return null;
    }

    private Double getValorInss(AberturaPeriodo abertura, TomadorPrestadorRps prestador) {
        String hql = "SELECT  coalesce(sum(r.valorInss),0)  FROM Rps r WHERE (CAST(r.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND ( r.unidadeTomPrestRPS.tomadorPrestadorRPS.identificador BETWEEN :tomadorServicoInicial AND :tomadorServicoFinal) AND ( r.empresa.identificador BETWEEN :empresaInicial AND :empresaFinal)  AND r.numeroNFse IS NOT NULL and r.status = :status   AND r.valorInss >= 29.00 ";
        Double retorno = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataEmissaoInicial", abertura.getDataInicio()).setShort("status", (short)1).setDate("dataEmissaoFinal", abertura.getDataFinal()).setLong("tomadorServicoInicial", prestador.getIdentificador().longValue()).setLong("tomadorServicoFinal", prestador.getIdentificador().longValue()).setLong("empresaInicial", abertura.getEmpresa().getIdentificador().longValue()).setLong("empresaFinal", abertura.getEmpresa().getIdentificador().longValue()).uniqueResult();
        if (retorno == null) {
            return 0.0;
        }
        return retorno;
    }

    private boolean existeAlocacao(AberturaPeriodo abertura) {
        String hql = " select coalesce(count(al.identificador),0) from AlocadorTomadorServico al  where al.aberturaPeriodo = :abertura ";
        Long retorno = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("abertura", (Object)abertura).uniqueResult();
        return retorno != null && retorno != 0L;
    }

    private void verificarFaltaAlocacaoCC(AberturaPeriodo abertura, EmpresaRh empRh) throws ExceptionService {
        Object filtrarCC = this.getFiltrarCentroCusto(empRh);
        filtrarCC = (String)filtrarCC + "___";
        String hql = " select c.identificador AS ID_CC, c.nome as CENTRO_CUSTO  from CentroCusto c  where  exists(select m.identificador         from MovimentoFolha m         where m.centroCusto = c         and         m.aberturaPeriodo.identificador = :id_abertura ) and  not exists ( select tt.identificador               from TomadorPrestadorRpsCentroCusto tt               where               tt.centroCusto = c )  and  c.codigo not like :filtrarCC order by c.nome ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("id_abertura", abertura.getIdentificador().longValue()).setString("filtrarCC", (String)filtrarCC).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (retorno == null || retorno.isEmpty()) {
            return;
        }
        Object excecao = " CENTRO DE CUSTO SEM ALOCA\u00c7\u00d5ES: \n ";
        Integer cont = 0;
        for (Object object : retorno) {
            cont = cont + 1;
            HashMap hash = (HashMap)object;
            String nome = (String)hash.get("CENTRO_CUSTO");
            String path = cont + "- CENTRO CUSTO: " + nome;
            excecao = (String)excecao + path + ";\n";
        }
        throw new ExceptionService((String)excecao);
    }

    private String getFiltrarCentroCusto(EmpresaRh empresaRh) {
        if (empresaRh.getCentroCustoPadrao() == null) {
            return "000000";
        }
        return empresaRh.getCentroCustoPadrao().getCodigo().substring(0, 6);
    }
}

