/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.indicadoresrh;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import net.sf.jasperreports.engine.JasperPrint;

public class UtilListagemIndicadoresRH {
    public JasperPrint dadosIndicadoresRh(Date periodoInicial, Date periodoFinal, Empresa empresa, Nodo nodo, HashMap parametros) throws ExceptionService {
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo).setAttribute("isPaisagem", true), "setarParametrosRelatorio");
        this.getDadosRecrutamentoSelecao(parametros, periodoInicial, periodoFinal, empresa);
        this.getSesmt(parametros, periodoInicial, periodoFinal, empresa);
        this.getFolhaPagamento(parametros, periodoInicial, periodoFinal, empresa);
        this.getTreinamento(parametros, periodoInicial, periodoFinal);
        this.getSexo(parametros, periodoInicial, periodoFinal, empresa);
        this.getIdade(parametros, periodoInicial, periodoFinal, empresa);
        this.getTempoEmpresa(parametros, periodoInicial, periodoFinal, empresa);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "indicadoresrh" + File.separator + "INDICADORES_RH.jasper";
        ArrayList<Colaborador> dados = new ArrayList<Colaborador>();
        dados.add(new Colaborador());
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private void getDadosRecrutamentoSelecao(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getAdmissoes(parametros, periodoInicial, periodoFinal, (short)0, "NR_ADMISSAO_ADM", empresa);
        this.getDemissoes(parametros, periodoInicial, periodoFinal, (short)0, "NR_RECISAO_ADM", empresa);
        this.getColaboradoresAtivos(parametros, periodoInicial, periodoFinal, (short)0, "ATIVOS_ADM", empresa);
        this.getAfastadosPrevidencia(parametros, periodoInicial, periodoFinal, (short)0, "AFASTAMENTO_PREVIDENCIA_ADM", empresa);
        this.getAfastadosAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)0, "AFASTAMENTO_ACIDENTE_ADM", empresa);
        this.getLicencaMaternidade(parametros, periodoInicial, periodoFinal, (short)0, "AFASTAMENTO_MATERNIDADE_ADM", empresa);
        this.getTurnover(parametros, periodoInicial, periodoFinal, (short)0, "TURNOVER_ADM", empresa);
        this.getAdmissoes(parametros, periodoInicial, periodoFinal, (short)1, "NR_ADMISSAO_COM", empresa);
        this.getDemissoes(parametros, periodoInicial, periodoFinal, (short)1, "NR_RECISAO_COM", empresa);
        this.getColaboradoresAtivos(parametros, periodoInicial, periodoFinal, (short)1, "ATIVOS_COM", empresa);
        this.getAfastadosPrevidencia(parametros, periodoInicial, periodoFinal, (short)1, "AFASTAMENTO_PREVIDENCIA_COM", empresa);
        this.getAfastadosAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)1, "AFASTAMENTO_ACIDENTE_COM", empresa);
        this.getLicencaMaternidade(parametros, periodoInicial, periodoFinal, (short)1, "AFASTAMENTO_MATERNIDADE_COM", empresa);
        this.getTurnover(parametros, periodoInicial, periodoFinal, (short)1, "TURNOVER_COM", empresa);
        this.getAdmissoes(parametros, periodoInicial, periodoFinal, (short)2, "NR_ADMISSAO_PROD", empresa);
        this.getDemissoes(parametros, periodoInicial, periodoFinal, (short)2, "NR_RECISAO_PROD", empresa);
        this.getColaboradoresAtivos(parametros, periodoInicial, periodoFinal, (short)2, "ATIVOS_PROD", empresa);
        this.getAfastadosPrevidencia(parametros, periodoInicial, periodoFinal, (short)2, "AFASTAMENTO_PREVIDENCIA_PROD", empresa);
        this.getAfastadosAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)2, "AFASTAMENTO_ACIDENTE_PROD", empresa);
        this.getLicencaMaternidade(parametros, periodoInicial, periodoFinal, (short)2, "AFASTAMENTO_MATERNIDADE_PROD", empresa);
        this.getTurnover(parametros, periodoInicial, periodoFinal, (short)2, "TURNOVER_PROD", empresa);
    }

    private void getAdmissoes(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa and  c.dataAdmissao between :periodoInicial and :periodoFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getDemissoes(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(r.identificador)  from Recisao r  where  r.empresa.identificador = :empresa  and  r.dataAfastamento between :periodoInicial and :periodoFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = r.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getColaboradoresAtivos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim and c.dataDemissao is null  AND  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("setor", setor.shortValue()).setLong("empresa", empresa.getIdentificador().longValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getAfastadosPrevidencia(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(af.identificador)  from AfastamentoColaborador af  where  af.colaborador.empresa = :empresa  and  af.afastamentoRais.codigo != :maternidade  and  af.afastamentoRais.codigo != :acidente  and  af.dataAfastamento <= :periodoInicial  and  (af.dataRetorno is null or af.dataRetorno > :periodoInicial)  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = af.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setLong("empresa", empresa.getIdentificador().longValue()).setString("maternidade", "50").setString("acidente", "10").setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getAfastadosAcidenteTrabalho(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(af.identificador)  from AfastamentoColaborador af  where  af.colaborador.empresa = :empresa  and  af.afastamentoRais.codigo = :acidente  and  af.dataAfastamento <= :periodoInicial  and  (af.dataRetorno is null or af.dataRetorno > :periodoInicial)  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = af.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setString("acidente", "10").uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getLicencaMaternidade(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(af.identificador)  from AfastamentoColaborador af  where  af.colaborador.empresa.identificador = :empresa  and   af.afastamentoRais.codigo = :maternidade  and  af.dataAfastamento <= :periodoInicial  and  (af.dataRetorno is null or af.dataRetorno > :periodoInicial)  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = af.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setString("maternidade", "50").uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTurnover(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Long admitidos = this.getAdmissaoPorSetor(periodoInicial, periodoFinal, setor, empresa);
        Long rescisao = this.getRescisaoPorSetor(periodoInicial, periodoFinal, setor, empresa);
        Long ativosTurnover = this.getAtivos(periodoFinal, setor);
        if (admitidos <= 0L && rescisao <= 0L) {
            parametros.put(nome, 0.0);
        } else {
            Double turnover = (admitidos.doubleValue() + rescisao.doubleValue()) / 2.0 / ativosTurnover.doubleValue() * 100.0;
            parametros.put(nome, turnover);
        }
    }

    private Long getAtivos(Date periodoFinal, Short setor) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodoFinal);
        g.add(2, -1);
        g.add(5, g.getActualMaximum(5));
        String hql = " select count(c.identificador) from Colaborador c  where  c.dataAdmissao <= :periodoAnterior  and  c.ativo = :sim  and  (c.dataDemissao is null or c.dataDemissao >= :periodoAnterior)  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        return (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoAnterior", g.getTime()).setShort("setor", setor.shortValue()).setShort("sim", (short)1).uniqueResult();
    }

    private void getSesmt(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)0, "CAT_ADM", empresa);
        this.getExamesPeriodicosRealizados(parametros, periodoInicial, periodoFinal, (short)0, "EXAMES_REALIZADOS_ADM");
        this.getExamesPeriodicosPendentes(parametros, periodoInicial, periodoFinal, (short)0, "EXAMES_PENDENTES_ADM");
        this.getAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)1, "CAT_COM", empresa);
        this.getExamesPeriodicosRealizados(parametros, periodoInicial, periodoFinal, (short)1, "EXAMES_COM");
        this.getExamesPeriodicosPendentes(parametros, periodoInicial, periodoFinal, (short)1, "EXAMES_PENDENTES_COM");
        this.getAcidenteTrabalho(parametros, periodoInicial, periodoFinal, (short)2, "CAT_PROD", empresa);
        this.getExamesPeriodicosRealizados(parametros, periodoInicial, periodoFinal, (short)2, "EXAMES_REALIZADOS_PROD");
        this.getExamesPeriodicosPendentes(parametros, periodoInicial, periodoFinal, (short)2, "EXAMES_PENDENTES_PROD");
    }

    private void getAcidenteTrabalho(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(cat.identificador)  from ComunicaoAcidenteTrabalho cat  where  cat.empresa.identificador = :empresa  and  cat.dataHoraAcidente between :periodoInicial and :periodoFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = cat.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getExamesPeriodicosRealizados(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome) {
        String hql = " select count(item.identificador)  from ItemManutencaoRotinasPessoas item  where  item.dataRelizacao between :periodoInicial and :periodoFinal  and  item.rotina.classificacao.tipo = :exame  and  exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.agrupamento.setorAgrupamento = :setor         and         exists (select c.identificador                 from Colaborador c                 where c.centroCusto = itemC.centroCusto                 and                 c.pessoa = item.pessoa))";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("setor", setor.shortValue()).setShort("exame", (short)0).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getExamesPeriodicosPendentes(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome) {
        String hql = " select count(item.identificador)  from ItemManutencaoRotinasPessoas item  where  item.dataVencimento < :periodoInicial  and  item.rotina.classificacao.tipo = :exame  and  item.itemAnterior is null  and  exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.agrupamento.setorAgrupamento = :setor         and         exists (select c.identificador         from Colaborador c         where c.centroCusto = itemC.centroCusto         and         c.pessoa = item.pessoa))";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setShort("exame", (short)0).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getFolhaPagamento(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getFolhaSemEncargos(parametros, periodoInicial, periodoFinal, (short)0, "FOLHA_SEM_ENCARGO_ADM", empresa);
        this.getFolhaComEncargos(parametros, periodoInicial, periodoFinal, (short)0, "FOLHA_COM_ENCARGOS_ADM", empresa);
        this.getValorPagoFerias(parametros, periodoInicial, periodoFinal, (short)0, "FERIAS_PAGO_ADM", empresa);
        this.getValorPagoRescisao(parametros, periodoInicial, periodoFinal, (short)0, "RECISAO_PAGO_ADM", empresa);
        this.getAdvertenciaColaborador(parametros, periodoInicial, periodoFinal, (short)0, "ADVERTENCIA_ADM");
        this.getSuspensaoColaborador(parametros, periodoInicial, periodoFinal);
        this.getFolhaSemEncargos(parametros, periodoInicial, periodoFinal, (short)1, "FOLHA_SEM_ENCARGO_COM", empresa);
        this.getFolhaComEncargos(parametros, periodoInicial, periodoFinal, (short)1, "FOLHA_COM_ENCARGOS_COM", empresa);
        this.getValorPagoFerias(parametros, periodoInicial, periodoFinal, (short)1, "FERIAS_PAGO_COM", empresa);
        this.getValorPagoRescisao(parametros, periodoInicial, periodoFinal, (short)1, "RECISAO_PAGO_COM", empresa);
        this.getAdvertenciaColaborador(parametros, periodoInicial, periodoFinal, (short)1, "ADVERTENCIA_COM");
        this.getSuspensaoColaborador(parametros, periodoInicial, periodoFinal);
        this.getFolhaSemEncargos(parametros, periodoInicial, periodoFinal, (short)2, "FOLHA_SEM_ENCARGO_PROD", empresa);
        this.getFolhaComEncargos(parametros, periodoInicial, periodoFinal, (short)2, "FOLHA_COM_ENCARGOS_PROD", empresa);
        this.getValorPagoFerias(parametros, periodoInicial, periodoFinal, (short)2, "FERIAS_PAGO_PROD", empresa);
        this.getValorPagoRescisao(parametros, periodoInicial, periodoFinal, (short)2, "RECISAO_PAGO_PROD", empresa);
        this.getAdvertenciaColaborador(parametros, periodoInicial, periodoFinal, (short)2, "ADVERTENCIA_PROD");
        this.getSuspensaoColaborador(parametros, periodoInicial, periodoFinal);
    }

    private void getTreinamento(HashMap parametros, Date periodoInicial, Date periodoFinal) {
        this.getNrTreinamento(parametros, periodoInicial, periodoFinal, (short)0, "TREINAMENTO_ADM");
        this.getNrTreinamento(parametros, periodoInicial, periodoFinal, (short)1, "TREINAMENTO_COM");
        this.getNrTreinamento(parametros, periodoInicial, periodoFinal, (short)2, "TREINAMENTO_PROD");
    }

    private void getNrTreinamento(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome) {
        String hql = " select count(item.identificador)  from ItemManutencaoRotinasPessoas item  where  item.dataRelizacao between :periodoInicial and :periodoFinal  and  item.rotina.classificacao.tipo = :treinamento  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.agrupamento.setorAgrupamento = :setor         and         exists (select c.identificador         from Colaborador c         where c.centroCusto = itemC.centroCusto         and         c.pessoa = item.pessoa))";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("setor", setor.shortValue()).setShort("treinamento", (short)1).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getSexo(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getHomens(parametros, periodoFinal, (short)0, "HOMENS_ADM", empresa);
        this.getMulheres(parametros, periodoFinal, (short)0, "MULHERES_ADM", empresa);
        this.getHomens(parametros, periodoFinal, (short)1, "HOMENS_COM", empresa);
        this.getMulheres(parametros, periodoFinal, (short)1, "MULHERES_COM", empresa);
        this.getHomens(parametros, periodoFinal, (short)2, "HOMENS_PROD", empresa);
        this.getMulheres(parametros, periodoFinal, (short)2, "MULHERES_PROD", empresa);
    }

    private void getHomens(HashMap parametros, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.sexo = :homem  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setShort("setor", setor.shortValue()).setShort("homem", (short)0).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getMulheres(HashMap parametros, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.sexo = :mulher  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setShort("setor", setor.shortValue()).setShort("mulher", (short)1).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getIdade20Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_20_ANOS_ADM", empresa);
        this.getIdade21a25Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_21_25_ANOS_ADM", empresa);
        this.getIdade26a30Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_26_30_ANOS_ADM", empresa);
        this.getIdade31a35Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_31_35_ANOS_ADM", empresa);
        this.getIdade36a40Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_36_40_ANOS_ADM", empresa);
        this.getIdade41a45Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_41_45_ANOS_ADM", empresa);
        this.getIdadeAcima46Anos(parametros, periodoInicial, periodoFinal, (short)0, "IDADE_46_ANOS_ADM", empresa);
        this.getIdade20Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_20_ANOS_COM", empresa);
        this.getIdade21a25Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_21_25_ANOS_COM", empresa);
        this.getIdade26a30Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_26_30_ANOS_COM", empresa);
        this.getIdade31a35Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_31_35_ANOS_COM", empresa);
        this.getIdade36a40Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_36_40_ANOS_COM", empresa);
        this.getIdade41a45Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_41_45_ANOS_COM", empresa);
        this.getIdadeAcima46Anos(parametros, periodoInicial, periodoFinal, (short)1, "IDADE_46_ANOS_COM", empresa);
        this.getIdade20Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_20_ANOS_PROD", empresa);
        this.getIdade21a25Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_21_25_ANOS_PROD", empresa);
        this.getIdade26a30Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_26_30_ANOS_PROD", empresa);
        this.getIdade31a35Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_31_35_ANOS_PROD", empresa);
        this.getIdade36a40Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_36_40_ANOS_PROD", empresa);
        this.getIdade41a45Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_41_45_ANOS_PROD", empresa);
        this.getIdadeAcima46Anos(parametros, periodoInicial, periodoFinal, (short)2, "IDADE_46_ANOS_PROD", empresa);
    }

    private void getTempoEmpresa(HashMap parametros, Date periodoInicial, Date periodoFinal, Empresa empresa) {
        this.getTempoEmpresa1Ano(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_1_ANO_ADM", empresa);
        this.getTempoEmpresa2a3Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_2_3_ANOS_ADM", empresa);
        this.getTempoEmpresa4a5Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_4_5_ANOS_ADM", empresa);
        this.getTempoEmpresa6a10Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_6_10_ANOS_ADM", empresa);
        this.getTempoEmpresa11a15Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_11_15_ANOS_ADM", empresa);
        this.getTempoEmpresa16a20Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_16_20_ANOS_ADM", empresa);
        this.getTempoAcima21Anos(parametros, periodoInicial, periodoFinal, (short)0, "TEMPO_EMPRESA_21_ANOS_ADM", empresa);
        this.getTempoEmpresa1Ano(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_1_ANO_COM", empresa);
        this.getTempoEmpresa2a3Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_2_3_ANOS_COM", empresa);
        this.getTempoEmpresa4a5Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_4_5_ANOS_COM", empresa);
        this.getTempoEmpresa6a10Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_6_10_ANOS_COM", empresa);
        this.getTempoEmpresa11a15Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_11_15_ANOS_COM", empresa);
        this.getTempoEmpresa16a20Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_16_20_ANOS_COM", empresa);
        this.getTempoAcima21Anos(parametros, periodoInicial, periodoFinal, (short)1, "TEMPO_EMPRESA_21_ANOS_COM", empresa);
        this.getTempoEmpresa1Ano(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_1_ANO_PROD", empresa);
        this.getTempoEmpresa2a3Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_2_3_ANOS_PROD", empresa);
        this.getTempoEmpresa4a5Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_4_5_ANOS_PROD", empresa);
        this.getTempoEmpresa6a10Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_6_10_ANOS_PROD", empresa);
        this.getTempoEmpresa11a15Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_11_15_ANOS_PROD", empresa);
        this.getTempoEmpresa16a20Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_16_20_ANOS_PROD", empresa);
        this.getTempoAcima21Anos(parametros, periodoInicial, periodoFinal, (short)2, "TEMPO_EMPRESA_21_ANOS_PROD", empresa);
    }

    private void getIdade20Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimete = 20;
        Date parametro = DateUtil.nextYear(periodoFinal, -idadeLimete.intValue());
        System.err.println(DateUtil.dateToStr(parametro, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento >= :periodoInicial   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametro).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade21a25Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimeteInicial = 25;
        Integer idadeLimiteFinal = 20;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -idadeLimeteInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -idadeLimiteFinal.intValue());
        System.err.println(DateUtil.dateToStr(parametroInicial, "dd/MM/yyyy"));
        System.err.println(DateUtil.dateToStr(parametroFinal, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento between :parametroInicial and :parametroFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", empresa.getIdentificador().longValue()).setDate("parametroInicial", parametroInicial).setDate("parametroFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade26a30Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimeteInicial = 30;
        Integer idadeLimiteFinal = 25;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -idadeLimeteInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -idadeLimiteFinal.intValue());
        System.err.println(DateUtil.dateToStr(parametroInicial, "dd/MM/yyyy"));
        System.err.println(DateUtil.dateToStr(parametroFinal, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento between :parametroInicial and :parametroFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", empresa.getIdentificador().longValue()).setDate("parametroInicial", parametroInicial).setDate("parametroFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade31a35Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimeteInicial = 35;
        Integer idadeLimiteFinal = 30;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -idadeLimeteInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -idadeLimiteFinal.intValue());
        System.err.println(DateUtil.dateToStr(parametroInicial, "dd/MM/yyyy"));
        System.err.println(DateUtil.dateToStr(parametroFinal, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento between :parametroInicial and :parametroFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", empresa.getIdentificador().longValue()).setDate("parametroInicial", parametroInicial).setDate("parametroFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade36a40Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimeteInicial = 40;
        Integer idadeLimiteFinal = 35;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -idadeLimeteInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -idadeLimiteFinal.intValue());
        System.err.println(DateUtil.dateToStr(parametroInicial, "dd/MM/yyyy"));
        System.err.println(DateUtil.dateToStr(parametroFinal, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento between :parametroInicial and :parametroFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("parametroInicial", parametroInicial).setShort("setor", setor.shortValue()).setDate("parametroFinal", parametroFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdade41a45Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimeteInicial = 45;
        Integer idadeLimiteFinal = 40;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -idadeLimeteInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -idadeLimiteFinal.intValue());
        System.err.println(DateUtil.dateToStr(parametroInicial, "dd/MM/yyyy"));
        System.err.println(DateUtil.dateToStr(parametroFinal, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento between :parametroInicial and :parametroFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("parametroInicial", parametroInicial).setDate("parametroFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getIdadeAcima46Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer idadeLimete = 46;
        Date parametro = DateUtil.nextYear(periodoFinal, -idadeLimete.intValue());
        System.err.println(DateUtil.dateToStr(parametro, "dd/MM/yyyy"));
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.pessoa.complemento.dataNascimento < :periodoInicial   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametro).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa1Ano(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresa = 1;
        Date parametro = DateUtil.nextYear(periodoFinal, -tempoEmpresa.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao >= :periodoInicial   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametro).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoAcima21Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresa = 21;
        Date parametro = DateUtil.nextYear(periodoFinal, -tempoEmpresa.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao <= :periodoInicial   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setShort("setor", setor.shortValue()).setDate("periodoInicial", parametro).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa2a3Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresaInicial = 3;
        Integer tempoEmpresaFinal = 1;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -tempoEmpresaInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -tempoEmpresaFinal.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao between :periodoInicial and :periodoFinal   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametroInicial).setDate("periodoFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa4a5Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresaInicial = 5;
        Integer tempoEmpresaFinal = 3;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -tempoEmpresaInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -tempoEmpresaFinal.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao between :periodoInicial and :periodoFinal   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametroInicial).setShort("setor", setor.shortValue()).setDate("periodoFinal", parametroFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa6a10Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresaInicial = 10;
        Integer tempoEmpresaFinal = 5;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -tempoEmpresaInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -tempoEmpresaFinal.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao between :periodoInicial and :periodoFinal   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametroInicial).setDate("periodoFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa11a15Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresaInicial = 15;
        Integer tempoEmpresaFinal = 10;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -tempoEmpresaInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -tempoEmpresaFinal.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao between :periodoInicial and :periodoFinal   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametroInicial).setDate("periodoFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getTempoEmpresa16a20Anos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        Integer tempoEmpresaInicial = 20;
        Integer tempoEmpresaFinal = 15;
        Date parametroInicial = DateUtil.nextYear(periodoFinal, -tempoEmpresaInicial.intValue());
        Date parametroFinal = DateUtil.nextDays(periodoFinal, -1);
        parametroFinal = DateUtil.nextYear(parametroFinal, -tempoEmpresaFinal.intValue());
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao between :periodoInicial and :periodoFinal   and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setShort("sim", (short)1).setDate("periodoInicial", parametroInicial).setDate("periodoFinal", parametroFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getFolhaSemEncargos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select coalesce(sum(i.valor),0)  from ItemMovimentoFolha i  where  i.movimentoFolha.empresa.identificador = :empresa  and  i.movimentoFolha.aberturaPeriodo.dataInicio = :dataInicio  and  i.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  i.eventoColaborador.tipoCalculoEvento.evento.codigo = :salario  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = i.movimentoFolha.colaborador.centroCusto         and         item.agrupamento.setorAgrupamento = :setor )";
        Double ret = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", periodoInicial).setLong("empresa", empresa.getIdentificador().longValue()).setLong("salario", 1L).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0.0) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0.0);
        }
    }

    private void getFolhaComEncargos(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select coalesce(sum(item.valor),0)  from ItemMovimentoFolha item  where   item.movimentoFolha.empresa.identificador = :empresa  and  item.movimentoFolha.aberturaPeriodo.dataInicio = :dataInicio  and  item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = :provento  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and   exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.centroCusto = item.movimentoFolha.colaborador.centroCusto         and         itemC.agrupamento.setorAgrupamento = :setor )";
        Double ret = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", periodoInicial).setLong("empresa", empresa.getIdentificador().longValue()).setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0.0) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0.0);
        }
    }

    private void getValorPagoFerias(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select coalesce(sum(f.vrLiquidoFerias),0)  from FeriasColaborador f  where  f.periodoAqFeriasColab.colaborador.empresa.identificador = :empresa  and  f.dataPagamento between :periodoInicial and :periodoFinal  and  exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.centroCusto = f.periodoAqFeriasColab.colaborador.centroCusto         and         itemC.agrupamento.setorAgrupamento = :setor )";
        Double ret = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoFinal", periodoFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0.0) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0.0);
        }
    }

    private void getValorPagoRescisao(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome, Empresa empresa) {
        String hql = " select sum(r.vlrLiquido) from Recisao r  where  r.empresa.identificador = :empresa  and  r.dataPagamento between :periodoInicial and :periodoFinal  and  exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.centroCusto = r.colaborador.centroCusto         and         itemC.agrupamento.setorAgrupamento = :setor )";
        Double ret = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoFinal", periodoFinal).setShort("setor", setor.shortValue()).uniqueResult();
        if (ret != null && ret > 0.0) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0.0);
        }
    }

    private void getAdvertenciaColaborador(HashMap parametros, Date periodoInicial, Date periodoFinal, Short setor, String nome) {
        String hql = " select coalesce(sum(advertencia.identificador),0)  from AdvertenciaColaborador advertencia  where  advertencia.dataAdvertencia between :periodoInicial and :periodoFinal  and  exists(select itemC.identificador         from ItemAgrupamentoCentroCusto itemC         where         itemC.centroCusto = advertencia.colaborador.centroCusto         and         itemC.agrupamento.setorAgrupamento = :setor )";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("setor", setor.shortValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            parametros.put(nome, ret);
        } else {
            parametros.put(nome, 0L);
        }
    }

    private void getSuspensaoColaborador(HashMap parametros, Date periodoInicial, Date periodoFinal) {
    }

    private Long getRescisaoPorSetor(Date periodoInicial, Date periodoFinal, Short setor, Empresa empresa) {
        String hql = " select count(r.identificador)  from Recisao r  where  r.empresa.identificador = :empresa  and  r.dataAfastamento between :periodoInicial and :periodoFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = r.colaborador.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        return (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setLong("empresa", empresa.getIdentificador().longValue()).setShort("setor", setor.shortValue()).uniqueResult();
    }

    private Long getAdmissaoPorSetor(Date periodoInicial, Date periodoFinal, Short setor, Empresa empresa) {
        String hql = " select count(c.identificador)  from Colaborador c  where  c.empresa.identificador = :empresa  and  c.dataAdmissao between :periodoInicial and :periodoFinal  and  exists(select item.identificador         from ItemAgrupamentoCentroCusto item         where         item.centroCusto = c.centroCusto and item.agrupamento.setorAgrupamento = :setor )";
        return (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setDate("periodoInicial", periodoInicial).setShort("setor", setor.shortValue()).setDate("periodoFinal", periodoFinal).uniqueResult();
    }
}

