/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.integracaofinanceiro;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.ColaboradorIntegracaoFinanceiro;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TitulosIntegracaoFinanceiro;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;

public class UtilityIntegracaoFinanceiroRh {
    public List efetuarApuracaoFinanceiroRh(GrupoEmpresa grupoEmpresa, Date periodoInicial, Date periodoFinal, List aberturas) throws ExceptionService {
        String hql = " from Titulo titulo  where  titulo.dataVencimento <= :periodoFinal  and  titulo.valorSaldo > 0  and  titulo.pagRec = :recebimento  and  titulo.provisao = :realizado  and  exists (from MovimentoFolha m          where          m.colaborador.pessoa = titulo.pessoa          and          m.aberturaPeriodo.dataFinal = :periodoFinal          and          m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento          and          m.statusFolha.codigo != :recisao )";
        List titulos = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("periodoFinal", (Object)periodoFinal).setParameter("realizado", (Object)1).setParameter("recebimento", (Object)1).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setParameter("recisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).list();
        if (titulos == null || titulos.isEmpty()) {
            throw new ExceptionService("Titulos n\u00e3o encontrados para os Parametros informados");
        }
        ArrayList<ColaboradorIntegracaoFinanceiro> listaValores = new ArrayList<ColaboradorIntegracaoFinanceiro>();
        for (Titulo titulo : titulos) {
            ColaboradorIntegracaoFinanceiro integracao2;
            boolean achou = false;
            for (ColaboradorIntegracaoFinanceiro integracao2 : listaValores) {
                if (!integracao2.getMovimentoFolha().getColaborador().getPessoa().equals((Object)titulo.getPessoa())) continue;
                achou = true;
                integracao2.getTitulos().add(new TitulosIntegracaoFinanceiro(titulo, integracao2));
            }
            if (achou) continue;
            MovimentoFolha mov = this.getFolhaPagamento(aberturas, titulo.getPessoa());
            integracao2 = new ColaboradorIntegracaoFinanceiro(mov);
            integracao2.getTitulos().add(new TitulosIntegracaoFinanceiro(titulo, integracao2));
            listaValores.add(integracao2);
        }
        this.calcularTotalizadoresTitulos(listaValores);
        return listaValores;
    }

    private void calcularTotalizadoresTitulos(List<ColaboradorIntegracaoFinanceiro> listaValores) {
        for (ColaboradorIntegracaoFinanceiro integracao : listaValores) {
            Double valorTotal = 0.0;
            for (TitulosIntegracaoFinanceiro titulo : integracao.getTitulos()) {
                valorTotal = valorTotal + titulo.getTitulo().getValorSaldo();
            }
            integracao.setValorTotalCompras(valorTotal);
            Double salarioNominal = integracao.getMovimentoFolha().getValorSalarioNominal() / 30.0 * (integracao.getMovimentoFolha().getDiasUteis() + integracao.getMovimentoFolha().getDiasFolgas() + integracao.getMovimentoFolha().getDiasFeriados()) * integracao.getMovimentoFolha().getColaborador().getPercDescontoCompras() / 100.0;
            if (salarioNominal > valorTotal) {
                integracao.setValorProjetado(valorTotal);
                continue;
            }
            integracao.setValorProjetado(salarioNominal);
        }
    }

    private MovimentoFolha getFolhaPagamento(List aberturas, Pessoa pessoa) throws ExceptionService {
        for (Object obj : aberturas) {
            AberturaPeriodo abertura = (AberturaPeriodo)obj;
            for (MovimentoFolha movimentoFolha : abertura.getMovimentoFolha()) {
                if (!movimentoFolha.getColaborador().getPessoa().equals((Object)pessoa)) continue;
                return movimentoFolha;
            }
        }
        throw new ExceptionService("Nenhuma Folha encontrada para o colaborador: " + pessoa.toString());
    }
}

