/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.medidaprovisoria;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdesao;
import com.touchcomp.basementor.model.vo.CadastroReducaoColaborador;
import com.touchcomp.basementor.model.vo.CadastroReducaoSuspensaoContrato;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import utilities.StringUtil;

public class UtilityGeracaoArquivoEmergencial {
    public void gerarArquivoBeneficioEmergencialCadastro(File arquivo, CadastroReducaoSuspensaoContrato vo) throws IOException {
        if (arquivo.exists()) {
            arquivo.delete();
        }
        arquivo.createNewFile();
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("\"Tipo Inscricao\";\"CNPJ/CEI\";\"CNO\";\"Data Admissao\";\"CPF Trabalhador\";\"PIS/PASEP Trabalhador\";\"Nome Trabalhador\";\"Nome Mae Trabalhador\";\"Data Nascimento Trabalhador\";\"Tipo Adesao\";\"Data Acordo\";\"Percentual Reducao Carga Horaria\";\"Dias Duracao\";\"Codigo Banco\";\"Agencia Bancaria\";\"DV Agencia Bancaria\";\"Conta Bancaria\";\"DV Conta Bancaria\";\"Tipo Conta\";\"Ultimo Salario\";\"Penultimo Salario\";\"Antepenultimo Salario\"");
        p.println();
        Integer cont = 0;
        for (CadastroReducaoColaborador r : vo.getReducoes()) {
            cont = cont + 1;
            p.append("\"1\";");
            p.append("\"" + StringUtil.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append(";");
            p.append("\"" + this.getData(r.getColaborador().getDataAdmissao()) + "\";");
            p.append("\"" + StringUtil.refina((String)r.getColaborador().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append("\"" + ToolString.completaZeros((String)r.getColaborador().getNumeroPis(), (int)11) + "\";");
            p.append("\"" + r.getColaborador().getPessoa().getNome() + "\";");
            p.append("\"" + r.getColaborador().getNomeMae() + "\";");
            p.append("\"" + this.getData(r.getColaborador().getPessoa().getComplemento().getDataNascimento()) + "\";");
            if (vo.getTipoAdesao().equals(EnumConstTipoAdesao.ADESAO_REDUCAO.getEnumId())) {
                p.append("\"1\";");
            } else {
                p.append("\"0\";");
            }
            p.append("\"" + this.getData(r.getDataInicio()) + "\";");
            if (vo.getTipoAdesao().equals(EnumConstTipoAdesao.ADESAO_REDUCAO.getEnumId())) {
                Integer perc = r.getPercentualReducao().intValue();
                p.append("\"" + perc + "\";");
            } else {
                p.append(";");
            }
            p.append("\"" + vo.getQtadeDias() + "\";");
            if (r.getContaBancaria() != null && r.getContaBancaria().length() > 0) {
                p.append("\"" + ToolString.completaZeros((String)r.getCodigoBanco(), (int)3, (boolean)true) + "\";");
                p.append("\"" + ToolString.completaZeros((String)r.getAgenciaBancaria(), (int)4, (boolean)true) + "\";");
                p.append("\"" + ToolString.completaZeros((String)r.getDigitoAgencia(), (int)1, (boolean)true) + "\";");
                p.append("\"" + ToolString.completaZeros((String)r.getContaBancaria(), (int)12, (boolean)true) + "\";");
                p.append("\"" + ToolString.completaZeros((String)r.getDigitoConta(), (int)1, (boolean)true) + "\";");
                if (r.getTipoConta() != null && r.getTipoConta().equals((short)0)) {
                    p.append("\"0\";");
                } else {
                    p.append("\"1\";");
                }
            } else {
                p.append(";");
                p.append(";");
                p.append(";");
                p.append(";");
                p.append(";");
                p.append(";");
            }
            p.append("\"" + this.getFormatarNumero(r.getUltimoSalario()) + "\";");
            p.append("\"" + this.getFormatarNumero(r.getPenultimoSalario()) + "\";");
            p.append("\"" + this.getFormatarNumero(r.getAntePenultimoSalario()) + "\"");
            if (cont >= vo.getReducoes().size()) continue;
            p.println();
        }
        p.flush();
        p.close();
    }

    private String getData(Date dataAdmissao) {
        Integer d = ToolDate.dayFromDate((Date)dataAdmissao);
        Object dia = d < 10 ? "0" + d.toString() : d.toString();
        Integer m = ToolDate.monthFromDate((Date)dataAdmissao);
        Object mes = m < 10 ? "0" + m.toString() : m.toString();
        return (String)dia + "/" + (String)mes + "/" + ToolDate.yearFromDate((Object)dataAdmissao);
    }

    private ContaSalarioColaborador getContaSalario(Pessoa pessoa) {
        for (ContaSalarioColaborador conta : pessoa.getContaSalarioColaborador()) {
            if (!conta.getAtivo().equals((short)1)) continue;
            return conta;
        }
        return null;
    }

    private String getFormatarNumero(Double valor) {
        if (valor == null || valor == 0.0) {
            return ToolString.completaEspacos((String)"0000000001", (int)10);
        }
        Object numero = "";
        valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + "0" + decimal.toString() : inteira.toString() + decimal.toString();
        return ToolString.completaZeros((String)numero, (int)10, (boolean)true);
    }

    public void geracaoArquivoEmergencialCancelamento(File arquivo, CadastroReducaoSuspensaoContrato vo) throws IOException {
        if (arquivo.exists()) {
            arquivo.delete();
        }
        arquivo.createNewFile();
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("\"Tipo Inscricao\";\"CNPJ/CEI\";\"CNO\";\"Data Admissao\";\"CPF Trabalhador\";\"Data Acordo\"");
        p.println();
        Integer cont = 0;
        for (CadastroReducaoColaborador r : vo.getReducoes()) {
            cont = cont + 1;
            p.append("\"1\";");
            p.append("\"" + StringUtil.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append(";");
            p.append("\"" + this.getData(r.getColaborador().getDataAdmissao()) + "\";");
            p.append("\"" + StringUtil.refina((String)r.getColaborador().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append("\"" + this.getData(r.getDataInicio()) + "\"");
        }
        p.flush();
        p.close();
    }

    public void geracaoArquivoEmergencialReducao(File arquivo, CadastroReducaoSuspensaoContrato vo) throws IOException {
        if (arquivo.exists()) {
            arquivo.delete();
        }
        arquivo.createNewFile();
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("\"Tipo Inscricao\";\"CNPJ/CEI\";\"CNO\";\"Data Admissao\";\"CPF Trabalhador\";\"Data Acordo\";\"Data Antecipacao\"");
        p.println();
        Integer cont = 0;
        for (CadastroReducaoColaborador r : vo.getReducoes()) {
            cont = cont + 1;
            p.append("\"1\";");
            p.append("\"" + StringUtil.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append(";");
            p.append("\"" + this.getData(r.getColaborador().getDataAdmissao()) + "\";");
            p.append("\"" + StringUtil.refina((String)r.getColaborador().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append("\"" + this.getData(r.getDataInicio()) + "\";");
            p.append("\"" + this.getData(r.getDataFinal()) + "\"");
            if (cont >= vo.getReducoes().size()) continue;
            p.println();
        }
        p.flush();
        p.close();
    }

    public void geracaoArquivoEmergencialProrrogacao(File arquivo, CadastroReducaoSuspensaoContrato vo) throws IOException {
        if (arquivo.exists()) {
            arquivo.delete();
        }
        arquivo.createNewFile();
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("\"Tipo Inscricao\";\"CNPJ/CEI\";\"CNO\";\"Data Admissao\";\"CPF Trabalhador\";\"Data Acordo\";\"Dias Prorrogacao\"");
        p.println();
        Integer cont = 0;
        for (CadastroReducaoColaborador r : vo.getReducoes()) {
            cont = cont + 1;
            p.append("\"1\";");
            p.append("\"" + StringUtil.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append(";");
            p.append("\"" + this.getData(r.getColaborador().getDataAdmissao()) + "\";");
            p.append("\"" + StringUtil.refina((String)r.getColaborador().getPessoa().getComplemento().getCnpj()) + "\";");
            p.append("\"" + this.getData(r.getDataInicio()) + "\";");
            p.append("\"" + r.getDiasProrrogacao() + "\"");
            if (cont >= vo.getReducoes().size()) continue;
            p.println();
        }
        p.flush();
        p.close();
    }
}

