/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.movimentofolha;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ManutencaoMovFolhaFinalizado;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceMovimentoFolha
extends CoreService {
    public static final String VALIDAR_FOLHA_COMPLEMENTAR_COM_PAGAMENTO = "validarFolhaComplementarPagamento";
    public static final String VALIDAR_EXISTENCIA_FOLHA_PAGAMENTO = "validarExistenciaFolhaPagamento";
    public static final String APURAR_QUANTIDADE_HORAS_BD_HORAS = "apurarQuantidadeHorasBdHoras";
    public static final String ATUALIZAR_AND_SALVAR_MANUT_FOLHA = "atualizarAndSalvarMovFolha";
    public static final String FIND_FOLHA_DEC_COMPLEMENTO = "findFolhaDecComplemento";

    public Integer validarFolhaComplementarPagamento(CoreRequestContext request) {
        Date periodoApuracao = (Date)request.getAttribute("periodoApuracao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOMovimentoFolha().validarFolhaComplementarComPagamento(periodoApuracao, empresa);
    }

    public Integer validarExistenciaFolhaPagamento(CoreRequestContext request) {
        Date periodoApuracao = (Date)request.getAttribute("periodoApuracao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOMovimentoFolha().validarExistenciaFolhaPagamento(periodoApuracao, empresa);
    }

    public List apurarQuantidadeHorasBdHoras(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date periodoFolha = (Date)request.getAttribute("periodoFolha");
        Short numeroMeses = (Short)request.getAttribute("numeroMeses");
        return CoreDAOFactory.getInstance().getDAOMovimentoFolha().findApuracaoBancoHoras(colaborador, numeroMeses, periodoFolha);
    }

    public Object atualizarAndSalvarMovFolha(CoreRequestContext request) throws ExceptionDatabase {
        ManutencaoMovFolhaFinalizado vo = (ManutencaoMovFolhaFinalizado)request.getAttribute("vo");
        vo.getMovimentoFolha().setBcFgtsSalario(vo.getBaseFgts());
        vo.getMovimentoFolha().setVrFgtsSalario(vo.getValorFgts());
        vo.getMovimentoFolha().setInformarImpostosManualmente(Short.valueOf((short)1));
        vo.getMovimentoFolha().setMotivo("IMPOSTO ALTERADO PELO RECURSO DE MANUTENCAO DE  FOLHA FINALIZADA");
        vo = (ManutencaoMovFolhaFinalizado)CoreDAOFactory.getInstance().getDAOManutencaoMovFolhaFinalizado().saveOrUpdate(vo);
        return vo;
    }

    public MovimentoFolha findFolhaDecComplemento(CoreRequestContext request) {
        MovimentoFolha mov = (MovimentoFolha)request.getAttribute("movPagamento");
        return CoreDAOFactory.getInstance().getDAOMovimentoFolha().findMovFolhaDec(mov);
    }
}

