/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.parcelamentofgts;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemApVlrFgtsColaborador;
import com.touchcomp.basementor.model.vo.ItemApuracaoVlrFgtsPeriodo;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityControleProcessoFgts {
    public List listaValoresFGTS(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        String hql = " from MovimentoFolha m  where  m.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal  and  m.colaborador.empresa = :empresa  and  m.colaborador.dataDemissao is null  and  (m.bcFgtsSalario+ m.bcFgtsFerias + m.bcFgts13Sal) > 0   order by m.aberturaPeriodo.dataInicio ";
        List r = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("dataInicio", (Object)periodoInicial).setParameter("dataFinal", (Object)periodoFinal).setParameter("empresa", (Object)empresa).list();
        if (r == null || r.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<ItemApuracaoVlrFgtsPeriodo> fgtsPeriodo = new ArrayList<ItemApuracaoVlrFgtsPeriodo>();
        for (Object object : r) {
            MovimentoFolha mov = (MovimentoFolha)object;
            Date periodo = mov.getAberturaPeriodo().getDataFinal();
            boolean achou = false;
            for (ItemApuracaoVlrFgtsPeriodo item : fgtsPeriodo) {
                if (!item.getPeriodo().equals(periodo)) continue;
                achou = true;
                boolean achouCol = false;
                for (ItemApVlrFgtsColaborador itemCol : item.getItensColaboradores()) {
                    if (!itemCol.getColaborador().equals((Object)mov.getColaborador())) continue;
                    itemCol.setBaseFgts(Double.valueOf(itemCol.getBaseFgts() + mov.getBcFgts13Sal() + mov.getBcFgtsFerias() + mov.getBcFgtsSalario()));
                    itemCol.setVlrFgts(Double.valueOf(itemCol.getVlrFgts() + mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()));
                    achouCol = true;
                }
                if (achouCol) continue;
                ItemApVlrFgtsColaborador i = new ItemApVlrFgtsColaborador();
                i.setColaborador(mov.getColaborador());
                i.setBaseFgts(Double.valueOf(mov.getBcFgts13Sal() + mov.getBcFgtsFerias() + mov.getBcFgtsSalario()));
                i.setVlrFgts(Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()));
                i.setItemApuracao(item);
                item.getItensColaboradores().add(i);
            }
            if (achou) continue;
            ItemApuracaoVlrFgtsPeriodo ii = new ItemApuracaoVlrFgtsPeriodo();
            ii.setPeriodo(mov.getAberturaPeriodo().getDataFinal());
            ItemApVlrFgtsColaborador i = new ItemApVlrFgtsColaborador();
            i.setColaborador(mov.getColaborador());
            i.setBaseFgts(Double.valueOf(mov.getBcFgts13Sal() + mov.getBcFgtsFerias() + mov.getBcFgtsSalario()));
            i.setVlrFgts(Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()));
            i.setItemApuracao(ii);
            ii.getItensColaboradores().add(i);
            fgtsPeriodo.add(ii);
        }
        return fgtsPeriodo;
    }

    public HashMap verificarSaldo(Colaborador c) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        String hql = " select sum(i.vlrFgts) from ItemApVlrFgtsColaborador i where i.colaborador = :colaborador";
        Double valoresApurados = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).uniqueResult();
        h.put("VALORES_APURADOS", valoresApurados);
        String hql1 = " select sum(i.valorUtilizado) from ItemParcelamentoFgts i where i.colaborador = :colaborador ";
        Double valoresUtilizado = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql1).setEntity("colaborador", (Object)c).uniqueResult();
        h.put("VALORES_UTILIZADOS", valoresUtilizado);
        return h;
    }
}

