/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.parcelamentofgts;

import com.touchcomp.basementor.model.vo.CadastroProcessoFgts;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemParcelamentoFgts;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityParcelamentoFGTS {
    public List apurarValoresFGTS(Empresa empresa, Date dataInicio, Date dataFinal, Short filtrarDemitidos) {
        String hql = " from MovimentoFolha m  where  m.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal  and  m.colaborador.empresa = :empresa  and  m.colaborador.dataDemissao is null  and  (m.bcFgtsSalario+ m.bcFgtsFerias + m.bcFgts13Sal) > 0 ";
        List r = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("dataInicio", (Object)dataInicio).setParameter("dataFinal", (Object)dataFinal).setParameter("empresa", (Object)empresa).list();
        return r;
    }

    public void verificarSaldoAnterior(List<ItemParcelamentoFgts> parcelamentos) {
        for (ItemParcelamentoFgts p : parcelamentos) {
            String hql = " select coalesce(i.saldo,0)   from ItemParcelamentoFgts i  where  i.colaborador = :colaborador  order by i.identificador desc ";
            Double valor = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)p.getColaborador()).setMaxResults(1).uniqueResult();
            if (valor == null) continue;
            p.setValorFgts(valor);
        }
    }

    public Double buscarValorApurado(Empresa empresa) {
        String hql = " select  (c.totalFgts)  from ControleParcelamentoFgts c  where c.empresa = :empresa  order by c.identificador desc ";
        Double valor = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa).setMaxResults(1).uniqueResult();
        if (valor == null) {
            return 0.0;
        }
        return valor;
    }

    public CadastroProcessoFgts findCadastroProcessoFgts(Empresa empresa) {
        String hql = " from CadastroProcessoFgts c  where  c.empresa = :empresa  order by c.identificador desc ";
        return (CadastroProcessoFgts)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa).setMaxResults(1).uniqueResult();
    }

    public Long quantidadeParcelamentoFgts(Empresa empresa) {
        String hql = " select coalesce(count(c.identificador),0)  from ControleParcelamentoFgts c where c.empresa = :empresa   ";
        return (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa).uniqueResult();
    }
}

