/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.previsaofinanceira;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemPrevisaoFinanceiraFerias;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementor.model.vo.TipoFerias;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;
import mentorcore.tools.DateUtil;

public class UtilityPrevisaoFinanceiraFerias {
    public List calcularPrevisaoFinanceiraFerias(Date dataInicio, TipoFerias tipoFerias, Short filtrarCC, CentroCusto centroCusto, Short impostoDesonerado, EmpresaRh empresaRh, Short descartarImpostos) throws ExceptionService {
        List<Colaborador> colaboradoroes = this.findColaboradores(dataInicio, filtrarCC, centroCusto, empresaRh);
        List<ItemPrevisaoFinanceiraFerias> itens = this.createItens(colaboradoroes, dataInicio, impostoDesonerado, empresaRh, tipoFerias, descartarImpostos);
        return itens;
    }

    private List<Colaborador> findColaboradores(Date dataInicio, Short filtrarCC, CentroCusto centroCusto, EmpresaRh empresaRh) {
        String hql = " select distinct c   from Colaborador c  where  c.ativo = :sim  and  c.dataDemissao is null  and  c.dataAdmissao <= :dataParametro  and  (c.tipoColaborador.identificador = :empregado  or  c.tipoColaborador.identificador = :menorAprendiz ) and  c.empresa.identificador = :idEmpresa  and  (:filtrarCC = 0 or c.centroCusto.identificador = :idCentroCusto)  order by c.pessoa.nome ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("sim", (Object)1).setParameter("dataParametro", (Object)dataInicio).setParameter("empregado", (Object)EnumConstTipoColaborador.EMPREGADO.getValue()).setParameter("menorAprendiz", (Object)EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).setParameter("idEmpresa", (Object)empresaRh.getEmpresa().getIdentificador()).setInteger("filtrarCC", filtrarCC.intValue()).setParameter("idCentroCusto", (Object)(centroCusto != null ? centroCusto.getIdentificador() : 0L)).list();
        return ret;
    }

    private List<ItemPrevisaoFinanceiraFerias> createItens(List<Colaborador> colaboradoroes, Date dataInicio, Short impostoDesonerado, EmpresaRh empresaRh, TipoFerias tipoFerias, Short descartarImpostos) throws ExceptionService {
        ArrayList<ItemPrevisaoFinanceiraFerias> itens = new ArrayList<ItemPrevisaoFinanceiraFerias>();
        for (Colaborador c : colaboradoroes) {
            ItemPrevisaoFinanceiraFerias i = new ItemPrevisaoFinanceiraFerias();
            i.setColaborador(c);
            i.setSalarioBase(this.getSalarioBase(c, dataInicio));
            Double valor = this.findValorMedias(c);
            i.setVlrMedias(valor);
            Double baseFerias = ContatoFormatUtil.arrredondarNumero((Double)((i.getSalarioBase() + valor / 12.0) / 30.0 * (tipoFerias.getNrDiasAbonoPecuniario().doubleValue() + tipoFerias.getNrDiasGozoFerias().doubleValue())), (int)2);
            i.setVlrMaiorRemuneracao(baseFerias);
            i.setVlrFerias(ContatoFormatUtil.arrredondarNumero((Double)baseFerias, (int)2));
            i.setVlrFerias13(ContatoFormatUtil.arrredondarNumero((Double)(i.getVlrFerias() / 3.0), (int)2));
            Double baseInss = i.getVlrFerias() + i.getVlrFerias13();
            if (descartarImpostos.equals((short)0)) {
                i.setVlrInssEmpresa(this.getInssEmpresa(impostoDesonerado, baseInss, empresaRh));
                i.setVlrInssTerceiros(ContatoFormatUtil.arrredondarNumero((Double)(baseInss * empresaRh.getPercTerceiros() / 100.0), (int)2));
                i.setVlrRat(ContatoFormatUtil.arrredondarNumero((Double)(baseInss * empresaRh.getIndiceFAP() * empresaRh.getPercRat() / 100.0), (int)2));
                i.setVlrAposentadoria25(this.getValorAposentadoria(c, baseInss, empresaRh));
                i.setVlrFgts(ContatoFormatUtil.arrredondarNumero((Double)(baseInss * 0.08), (int)2));
            }
            itens.add(i);
        }
        return itens;
    }

    private Double getSalarioBase(Colaborador c, Date dataInicio) {
        return new UtilCalculoFolhaPagamento().findSalarioNominal(c, dataInicio);
    }

    private Double getValorAposentadoria(Colaborador c, Double baseInss, EmpresaRh empresaRh) {
        if (c.getCategoriaSefip().getCodigo().equals("04")) {
            return ContatoFormatUtil.arrredondarNumero((Double)(baseInss * empresaRh.getPercAposentadoriaEspecial25Anos() / 100.0), (int)2);
        }
        return 0.0;
    }

    private Double getInssEmpresa(Short impostoDesonerado, Double baseInss, EmpresaRh empresaRh) {
        if (impostoDesonerado.equals((short)0)) {
            return ContatoFormatUtil.arrredondarNumero((Double)(baseInss * (empresaRh.getPercEmpresa() / 100.0)), (int)2);
        }
        return 0.0;
    }

    private Double findValorMedias(Colaborador c) throws ExceptionService {
        HashMap hash = this.ultimoPeriodoAquisitivo(c);
        Date dataInicio = (Date)hash.get("dataInicio");
        Date dataFinal = (Date)hash.get("dataFinal");
        return this.findMediaFerias(dataInicio, dataFinal, c);
    }

    public Double findMediaFerias(Date dataInicio, Date dataFinal, Colaborador colaborador) throws ExceptionService {
        String query = "          select coalesce(sum(item.valor),0)         from ItemMovimentoFolha item         where         item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = :provento         and         (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :referencia or (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :valor))        and         item.movimentoFolha.colaborador = :colaborador         and        ((item.movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicio        and        item.movimentoFolha.aberturaPeriodo.dataFinal <= :dataFim)         or       (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataFim         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataFim         and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoFinal <= 15 )        and         (:dataFimInicioPeriodo - :diaPeriodoInicial+1) < 15 )         or         (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataInicio         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataInicio          and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoInicial >= 15 )))        and         item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(query).setDate("dataInicio", dataInicio).setDate("dataFim", dataFinal).setInteger("diaPeriodoFinal", DateUtil.dayFromDate(dataFinal).intValue()).setInteger("diaPeriodoInicial", DateUtil.dayFromDate(dataInicio).intValue()).setEntity("colaborador", (Object)colaborador).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("dataFimInicioPeriodo", DateUtil.getCalendar(dataInicio).getActualMaximum(5)).setShort("valor", (short)2).setShort("referencia", (short)1).setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue()).uniqueResult();
    }

    private HashMap ultimoPeriodoAquisitivo(Colaborador c) {
        HashMap<String, Date> hash = new HashMap<String, Date>();
        String hql = " select distinct p from PeriodoAqFeriasColab p  where  p.colaborador = :colaborador ";
        PeriodoAqFeriasColab p = (PeriodoAqFeriasColab)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setMaxResults(1).uniqueResult();
        if (p != null) {
            Date dataInicial = DateUtil.nextDays(p.getDataFinal(), 1);
            Date dataFinal = DateUtil.nextYear(dataInicial, 1);
            hash.put("dataInicio", dataInicial);
            hash.put("dataFinal", DateUtil.nextDays(dataFinal, -1));
            return hash;
        }
        String hql1 = " select d  from ColaboradorDadosFerias d  where  d.colaborador = :colaborador";
        ColaboradorDadosFerias d = (ColaboradorDadosFerias)CoreBdUtil.getInstance().getSession().createQuery(hql1).setEntity("colaborador", (Object)c).setMaxResults(1).uniqueResult();
        if (d != null) {
            Date dataInicial = DateUtil.nextDays(d.getDataFimPeriodo(), 1);
            Date dataFinal = DateUtil.nextYear(dataInicial, 1);
            hash.put("dataInicio", dataInicial);
            hash.put("dataFinal", DateUtil.nextDays(dataFinal, -1));
            return hash;
        }
        hash.put("dataInicio", c.getDataAdmissao());
        hash.put("dataFinal", DateUtil.nextDays(DateUtil.nextYear(c.getDataAdmissao(), 1), -1));
        return hash;
    }
}

