/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.previsaorecisao;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemPrevisaoRecisao;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.calculofolha.CalculoFolhaPagamentoUtilities;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoDecimoTerceiro;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;
import mentorcore.tools.DateUtil;

public class UtilityPrevisaoRecisao {
    public List<Colaborador> findColaboradoresAtivos(Empresa empresa, Long centroCusto) throws Exception {
        String hql = " select distinct c  from Colaborador c  where  c.ativo = :sim  and  c.empresa = :empresa  and  c.dataDemissao is null  and  (:centroCusto = 0 or c.centroCusto.identificador = :centroCusto ) and  (c.tipoColaborador.identificador = :empregado  or  c.tipoColaborador.identificador = :menorAprendiz )";
        List colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).setShort("sim", (short)1).setLong("centroCusto", centroCusto.longValue()).list();
        if (colaboradores.isEmpty()) {
            throw new Exception("N\u00e3o existem Colaboradores com Previs\u00e3o de Rescis\u00e3o.");
        }
        return colaboradores;
    }

    public ItemPrevisaoRecisao calcularPrevisaoRescisao(Colaborador colaborador, Date dataDesligamento, Short calcularFgts, Short tipoAviso) throws ExceptionService {
        Double vlrSalarioNominal = new CalculoFolhaPagamentoUtilities().findSalarioMensal(colaborador, dataDesligamento);
        ItemPrevisaoRecisao previsao = new ItemPrevisaoRecisao();
        previsao.setColaborador(colaborador);
        previsao.setVlrSalarioNominal(vlrSalarioNominal);
        previsao.setVlrFerias(this.getCalculoFerias(previsao, dataDesligamento));
        previsao.setVlrDec(this.getCalculoDecimoTerceiro(previsao, dataDesligamento));
        this.getValorAvisoIndenizado(previsao, dataDesligamento, tipoAviso);
        previsao.setSaldoSalario(this.getSaldoSalario(previsao, dataDesligamento));
        previsao.setSaldoFgts(this.getSaldoFgts(calcularFgts, previsao, dataDesligamento));
        previsao.setVlrFgts(this.getVlrFGTSMes(previsao));
        previsao.setVlrTotalFgts(ContatoFormatUtil.arrredondarNumero((Double)(previsao.getSaldoFgts() + previsao.getVlrFgts()), (int)2));
        Double perc = tipoAviso.equals((short)2) ? 0.2 : 0.4;
        previsao.setVlrMultaFgts(ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrTotalFgts() * perc), (int)2));
        previsao.setVlrInss(Double.valueOf(0.0));
        previsao.setVlrLiquido(this.getLiquidoRescisao(previsao));
        previsao.setVlrTotalGeral(this.getTotalGeral(previsao));
        return previsao;
    }

    private Double getCalculoFerias(ItemPrevisaoRecisao previsao, Date dataDesligamento) throws ExceptionService {
        HashMap hash = new UtilCalculoProvisaoFerias().findAvosProvisao(previsao.getColaborador(), dataDesligamento);
        Double avos = new Double(((Integer)hash.get("avos")).intValue());
        Double ferias = ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrSalarioNominal() / 12.0 * avos), (int)2);
        ferias = ferias + ContatoFormatUtil.arrredondarNumero((Double)(ferias / 3.0), (int)2);
        return ferias;
    }

    private Double getCalculoDecimoTerceiro(ItemPrevisaoRecisao previsao, Date dataDesligamento) throws ExceptionService {
        Double avos = new UtilCalculoProvisaoDecimoTerceiro().getNrAvosDec(previsao.getColaborador(), dataDesligamento);
        return ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrSalarioNominal() / 12.0 * avos), (int)2);
    }

    private void getValorAvisoIndenizado(ItemPrevisaoRecisao previsao, Date dataDesligamento, Short tipoAviso) {
        if (!tipoAviso.equals((short)1)) {
            Integer diasAviso = this.getDiasAviso(previsao.getColaborador(), dataDesligamento);
            diasAviso = diasAviso > 90 ? 90 : diasAviso;
            Double divisao = tipoAviso.equals((short)2) ? 2.0 : 1.0;
            previsao.setVlrAvisoIndenizado(ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrSalarioNominal() / 30.0 * diasAviso.doubleValue() / divisao), (int)2));
            previsao.setVlrFeriasIndenizadas(this.getFeriasIndenizadas(previsao, diasAviso));
            previsao.setVlrDecimoTerceiroIndenizado(this.getDecimoTerceiroIndenizado(previsao, diasAviso));
        }
    }

    private Integer getDiasAviso(Colaborador colaborador, Date dataDesligamento) {
        Integer diasDatas = DateUtil.diferenceDayBetweenDates(colaborador.getDataAdmissao(), dataDesligamento);
        diasDatas = diasDatas / 365;
        return diasDatas * 3 + 30;
    }

    private Double getFeriasIndenizadas(ItemPrevisaoRecisao previsao, Integer diasAviso) {
        Integer avosIndenizados = 0;
        if (diasAviso <= 44) {
            avosIndenizados = 1;
        } else if (diasAviso >= 45 && diasAviso <= 74) {
            avosIndenizados = 2;
        } else if (diasAviso >= 75) {
            avosIndenizados = 3;
        }
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrAvisoIndenizado() / 12.0 * avosIndenizados.doubleValue()), (int)2);
        return valor;
    }

    private Double getDecimoTerceiroIndenizado(ItemPrevisaoRecisao previsao, Integer diasAviso) {
        Integer avosIndenizados = 0;
        if (diasAviso <= 44) {
            avosIndenizados = 1;
        } else if (diasAviso >= 45 && diasAviso <= 74) {
            avosIndenizados = 2;
        } else if (diasAviso >= 75) {
            avosIndenizados = 3;
        }
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrAvisoIndenizado() / 12.0 * avosIndenizados.doubleValue()), (int)2);
        return valor;
    }

    private Double getSaldoSalario(ItemPrevisaoRecisao previsao, Date dataDesligamento) {
        Integer diasTrabalhados = DateUtil.dayFromDate(dataDesligamento);
        return ContatoFormatUtil.arrredondarNumero((Double)(previsao.getVlrSalarioNominal() / (double)ToolDate.getDaysOnMonth((Date)dataDesligamento).intValue() * diasTrabalhados.doubleValue()), (int)2);
    }

    private Double getSaldoFgts(Short calculoFgts, ItemPrevisaoRecisao previsao, Date dataDesligamento) {
        if (calculoFgts.equals((short)0)) {
            Integer numeroMeses = this.getDiferencaNumeroMes(previsao.getColaborador().getDataAdmissao(), dataDesligamento);
            Double vlrFgtsCalculado = previsao.getVlrSalarioNominal() * numeroMeses.doubleValue() * 0.08;
            return vlrFgtsCalculado;
        }
        return 0.0;
    }

    public Integer getDiferencaNumeroMes(Date date1, Date date2) {
        GregorianCalendar g = new GregorianCalendar();
        GregorianCalendar g1 = new GregorianCalendar();
        g.setTime(date1);
        g1.setTime(date2);
        int m1 = g.get(1) * 12 + g.get(2);
        int m2 = g1.get(1) * 12 + g1.get(2);
        return m2 - m1 + 1;
    }

    private Double getVlrFGTSMes(ItemPrevisaoRecisao previsao) {
        Double baseCalculoFgts = ContatoFormatUtil.arrredondarNumero((Double)(previsao.getSaldoSalario() + previsao.getVlrDec()), (int)2);
        return ContatoFormatUtil.arrredondarNumero((Double)(baseCalculoFgts * 8.0 / 100.0), (int)2);
    }

    private Double getLiquidoRescisao(ItemPrevisaoRecisao previsao) {
        Double valorLiquido = previsao.getSaldoSalario() + previsao.getVlrFerias() + previsao.getVlrFeriasIndenizadas() + previsao.getVlrDec() + previsao.getVlrDecimoTerceiroIndenizado() + previsao.getVlrAvisoIndenizado();
        return ContatoFormatUtil.arrredondarNumero((Double)valorLiquido, (int)2);
    }

    private Double getTotalGeral(ItemPrevisaoRecisao previsao) {
        Double totalGeral = previsao.getVlrLiquido() + previsao.getVlrMultaFgts();
        return ContatoFormatUtil.arrredondarNumero((Double)totalGeral, (int)2);
    }
}

