/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.provisao.EnumConsiderarEmpresa;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoDecimoTerceiro;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoGerencialProvisaoDecimoTerceiro;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoProvisaoDec;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoProvisaoDecCentroCusto;

public class ServiceProvisaoDecimoTerceiro
extends CoreService {
    public static final String CALCULAR_PROVISAO_DECIMO_TERCEIRO = "calcularProvisaoDecimoTerceiro";
    public static final String SALVAR_AND_CONTABILIZAR_PROVISAO_DEC = "salvarAndContabilizarProvisaoDec";
    public static final String IMPRIMIR_PROVISAO_DEC = "getProvisaoDec";
    public static final String CALCULAR_PROVISAO_13_POR_CENTRO_CUSTO = "calcularProvisao13PorCentroCusto";
    public static final String VERIFICAR_FOLHA_PAGAMENTO_CONTABILIZADA = "verificarFolhaPagamentoContabilizada";
    public static final String FIND_PROVISAO_POR_PERIODO_AND_GRUPO_EMPRESA = "findProvisaoPorPeriodoAndGrupoEmpresa";

    public List calcularProvisaoDecimoTerceiro(CoreRequestContext request) throws ExceptionService {
        ArrayList<ItemProvisaoDec> itens = new ArrayList<ItemProvisaoDec>();
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        Double percDesoneracao = (Double)request.getAttribute("percDesoneracao");
        Empresa empresaFiltrada = (Empresa)request.getAttribute("empresaFiltrada");
        EnumConsiderarEmpresa enumConsiderarEmpresa = (EnumConsiderarEmpresa)request.getAttribute("filtroColaborador");
        List colaboradores = new ArrayList();
        colaboradores = empresaRh.getContabilizarProvisaoCC().equals((short)1) ? new UtilCalculoProvisaoDecimoTerceiro().findColaboradoresProvisaoDecCentroCusto(dataInicial, dataFinal, grupoEmpresa, empresaRh.getEmpresa(), enumConsiderarEmpresa) : new UtilCalculoProvisaoDecimoTerceiro().findColaboradoresProvisaoDec(dataInicial, dataFinal, grupoEmpresa, empresaFiltrada, enumConsiderarEmpresa);
        int tamanhoColaborador = colaboradores.size();
        int i = 1;
        for (Colaborador colaborador : colaboradores) {
            System.out.println(tamanhoColaborador + " / " + i);
            ItemProvisaoDec item = new UtilCalculoProvisaoDecimoTerceiro().calcularProvisaoDecimoTerceiro(colaborador, dataInicial, dataFinal, empresaRh, percDesoneracao);
            if (item != null) {
                itens.add(item);
            }
            ++i;
        }
        return itens;
    }

    public ProvisaoDec salvarAndContabilizarProvisaoDec(CoreRequestContext r) throws ExceptionService, ExceptionDatabase, SQLException {
        ProvisaoDec vo = (ProvisaoDec)r.getAttribute("provisaoDec");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        CoreBdUtil.getInstance().getSession().clear();
        vo = (ProvisaoDec)ServiceProvisaoDecimoTerceiro.simpleSave(CoreDAOFactory.getInstance().getDAOProvisaoDecimoTerceiro(), vo);
        CoreBdUtil.getInstance().getSession().flush();
        LoteContabil lote = null;
        lote = empresaRh.getContabilizarProvisaoCC().equals((short)1) ? new UtilLancamentoProvisaoDecCentroCusto().gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao()) : new UtilLancamentoProvisaoDec().gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao());
        if (vo.getLoteContabil() != null) {
            CoreDAOFactory.getInstance().getDAOProvisaoDecimoTerceiro().evict(vo);
        }
        vo.setLoteContabil(lote);
        CoreBdUtil.getInstance().getSession().clear();
        if (empresaRh.getGerarLancamentosGerenciais().equals((short)1)) {
            UtilLancamentoGerencialProvisaoDecimoTerceiro.integrandoLancamentosGerenciaisProvisaoDecimoTerceiro(vo);
        }
        vo = (ProvisaoDec)ServiceProvisaoDecimoTerceiro.simpleSave(CoreDAOFactory.getInstance().getDAOProvisaoDecimoTerceiro(), vo);
        return vo;
    }

    public List getProvisaoDec(CoreRequestContext r) {
        ProvisaoDec provisao = (ProvisaoDec)r.getAttribute("provisao");
        return new UtilCalculoProvisaoDecimoTerceiro().getProvisaoDec(provisao);
    }

    public List calcularProvisao13PorCentroCusto(CoreRequestContext request) throws ExceptionService {
        ArrayList<ItemProvisaoDec> itens = new ArrayList<ItemProvisaoDec>();
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        Double percDesoneracao = (Double)request.getAttribute("percDesoneracao");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCusto");
        Empresa empresaFiltrada = (Empresa)request.getAttribute("empresaFiltrada");
        EnumConsiderarEmpresa enumConsiderarEmpresa = (EnumConsiderarEmpresa)request.getAttribute("filtroColaborador");
        List<Colaborador> colaboradores = new UtilCalculoProvisaoDecimoTerceiro().findColaboradoresProvisao13CentroCusto(dataInicial, dataFinal, grupoEmpresa, centroCusto, empresaFiltrada, enumConsiderarEmpresa);
        for (Colaborador colaborador : colaboradores) {
            ItemProvisaoDec item = new UtilCalculoProvisaoDecimoTerceiro().calcularProvisaoDecimoTerceiro(colaborador, dataInicial, dataFinal, empresaRh, percDesoneracao);
            if (item == null) continue;
            itens.add(item);
        }
        return itens;
    }

    public Integer verificarFolhaPagamentoContabilizada(CoreRequestContext request) {
        Date periodo = (Date)request.getAttribute("periodo");
        return new UtilCalculoProvisaoDecimoTerceiro().verificarExistenciaIntegContFolha(periodo);
    }

    public ProvisaoDec findProvisaoPorPeriodoAndGrupoEmpresa(CoreRequestContext request) {
        Date periodo = (Date)request.getAttribute("periodo");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        return CoreDAOFactory.getInstance().getDAOProvisaoDecimoTerceiro().findProvisaoPorPeriodoAndGrupoEmpresa(periodo, grupoEmpresa);
    }
}

