/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.provisao.EnumConsiderarEmpresa;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoGerencialProvisaoFerias;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoProvisaoFerias;
import mentorcore.service.impl.rh.provisoes.UtilLancamentoProvisaoFeriasCentroCusto;

public class ServiceProvisaoFerias
extends CoreService {
    public static final String CALCULAR_PROVISAO_FERIAS = "calcularProvisaoFerias";
    public static final String IMPRIMIR_PROVISAO_FERIAS = "getProvisaoFerias";
    public static final String SALVAR_AND_CONTABILIZAR_PROVISAO_FERIAS = "salvarAndContabilizarProvisaoFerias";
    public static final String CALCULAR_PROVISAO_POR_CENTRO_CUSTO = "calcularProvisaoPorCentroCusto";
    public static final String FIND_PROVISAO_POR_PERIODO_AND_GRUPO_EMPRESA = "findProvisaoPorPeriodoAndGrupoEmpresa";

    public List calcularProvisaoFerias(CoreRequestContext request) throws ExceptionService {
        ArrayList<ItemProvisaoFerias> itensProvisao = new ArrayList<ItemProvisaoFerias>();
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        Double percDesoneracao = (Double)request.getAttribute("percDesoneracao");
        Empresa empresaFiltrada = (Empresa)request.getAttribute("empresaFiltrada");
        EnumConsiderarEmpresa enumConsiderarEmpresa = (EnumConsiderarEmpresa)request.getAttribute("filtroColaborador");
        List colaboradores = new ArrayList();
        colaboradores = empresaRh.getContabilizarProvisaoCC().equals((short)1) ? new UtilCalculoProvisaoFerias().findColaboradoresProvisaoFeriasCentroCusto(dataInicial, dataFinal, grupoEmpresa, empresaRh.getEmpresa(), enumConsiderarEmpresa) : new UtilCalculoProvisaoFerias().findColaboradoresProvisaoFerias(dataInicial, dataFinal, grupoEmpresa, empresaFiltrada, enumConsiderarEmpresa);
        int tamanhoColaborador = colaboradores.size();
        int i = 1;
        for (Colaborador colaborador : colaboradores) {
            System.out.println(tamanhoColaborador + " / " + i);
            ItemProvisaoFerias item = new UtilCalculoProvisaoFerias().findItemProvisaoFerias(colaborador, dataInicial, dataFinal, percDesoneracao, empresaRh);
            if (item != null && item.getAvos() > 0.0) {
                itensProvisao.add(item);
            }
            ++i;
        }
        return itensProvisao;
    }

    public List getProvisaoFerias(CoreRequestContext r) {
        ProvisaoFerias provisao = (ProvisaoFerias)r.getAttribute("provisao");
        return new UtilCalculoProvisaoFerias().getProvisaoFerias(provisao);
    }

    public ProvisaoFerias salvarAndContabilizarProvisaoFerias(CoreRequestContext r) throws ExceptionService, ExceptionDatabase, SQLException {
        ProvisaoFerias vo = (ProvisaoFerias)r.getAttribute("provisaoFerias");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        CoreBdUtil.getInstance().getSession().clear();
        vo = (ProvisaoFerias)ServiceProvisaoFerias.simpleSave(CoreDAOFactory.getInstance().getDAOProvisaoFerias(), vo);
        CoreBdUtil.getInstance().getSession().flush();
        LoteContabil l = null;
        l = empresaRh.getContabilizarProvisaoCC().equals((short)1) ? new UtilLancamentoProvisaoFeriasCentroCusto().gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao()) : new UtilLancamentoProvisaoFerias().gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao());
        if (vo.getLoteContabil() != null) {
            CoreDAOFactory.getInstance().getDAOProvisaoFerias().evict(vo);
        }
        vo.setLoteContabil(l);
        CoreBdUtil.getInstance().getSession().clear();
        if (empresaRh.getGerarLancamentosGerenciais().equals((short)1)) {
            UtilLancamentoGerencialProvisaoFerias.integrandoLancamentosGerenciaisProvisaoFerias(vo);
        }
        vo = (ProvisaoFerias)ServiceProvisaoFerias.simpleSave(CoreDAOFactory.getInstance().getDAOProvisaoFerias(), vo);
        return vo;
    }

    public List calcularProvisaoPorCentroCusto(CoreRequestContext request) throws ExceptionService {
        ArrayList<ItemProvisaoFerias> itensProvisao = new ArrayList<ItemProvisaoFerias>();
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        Double percDesoneracao = (Double)request.getAttribute("percDesoneracao");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCusto");
        Empresa empresaFiltrada = (Empresa)request.getAttribute("empresaFiltrada");
        EnumConsiderarEmpresa enumConsiderarEmpresa = (EnumConsiderarEmpresa)request.getAttribute("filtroColaborador");
        List<Colaborador> colaboradores = new UtilCalculoProvisaoFerias().findColaboradoresProvisaoCentroCusto(dataInicial, dataFinal, grupoEmpresa.getIdentificador(), centroCusto, empresaFiltrada, enumConsiderarEmpresa);
        for (Colaborador colaborador : colaboradores) {
            ItemProvisaoFerias item = new UtilCalculoProvisaoFerias().findItemProvisaoFerias(colaborador, dataInicial, dataFinal, percDesoneracao, empresaRh);
            if (!(item.getAvos() > 0.0)) continue;
            itensProvisao.add(item);
        }
        return itensProvisao;
    }

    public ProvisaoFerias findProvisaoPorPeriodoAndGrupoEmpresa(CoreRequestContext request) {
        Date periodo = (Date)request.getAttribute("periodo");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        return CoreDAOFactory.getInstance().getDAOProvisaoFerias().findProvisaoPorPeriodoAndGrupoEmpresa(periodo, grupoEmpresa);
    }
}

