/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.provisao.EnumConsiderarEmpresa;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCalculoProvisaoDecimoTerceiro {
    public ItemProvisaoDec calcularProvisaoDecimoTerceiro(Colaborador colaborador, Date dataInicial, Date dataFinal, EmpresaRh empresaRh, Double percDesoneracao) throws ExceptionService {
        Double avosDec = this.getNrAvosDec(colaborador, dataFinal);
        if (avosDec > 0.0) {
            Double vlrSalarioBase = this.getSalarioBase(colaborador);
            Double vlrMedia = this.vlrMediaProvDecimoTerceiro(colaborador, dataInicial);
            Double vlrMaiorRemuneracao = ContatoFormatUtil.arrredondarNumero((Double)(vlrSalarioBase + vlrMedia / avosDec), (int)2);
            Double vlrDec = UtilCalculoProvisaoDecimoTerceiro.getDec(vlrMaiorRemuneracao, avosDec);
            Double vlrInssEmpresa = UtilCalculoProvisaoDecimoTerceiro.getVlrInssEmpresa(vlrDec, percDesoneracao, empresaRh);
            Double vlrInssTerceiros = UtilCalculoProvisaoDecimoTerceiro.getVlrInssTer(vlrDec, empresaRh);
            Double vlrFgts = UtilCalculoProvisaoDecimoTerceiro.getVlFgts(vlrDec);
            Double vlrRat = UtilCalculoProvisaoDecimoTerceiro.getVlrRat(vlrDec, empresaRh);
            Double vlrAposentadoria25 = UtilCalculoProvisaoDecimoTerceiro.getVlrAposentadoriaEspecial25(colaborador, vlrDec, empresaRh);
            Double vlrPis = this.getValorPis(vlrDec, empresaRh);
            Double vlrMensal = ToolFormatter.arrredondarNumero((Double)((vlrDec + vlrAposentadoria25 + vlrFgts + vlrInssEmpresa + vlrInssTerceiros + vlrRat) / avosDec), (int)2);
            ItemProvisaoDec item = new ItemProvisaoDec(colaborador, vlrSalarioBase, vlrMedia, vlrMaiorRemuneracao, avosDec, vlrDec, vlrInssEmpresa, vlrInssTerceiros, vlrFgts, vlrRat, vlrAposentadoria25, vlrPis, vlrMensal);
            return item;
        }
        return null;
    }

    public Double getNrAvosDec(Colaborador c, Date periodoProvisao) throws ExceptionService {
        boolean continuar = true;
        Double avosAfastado = this.colaboradorAfastadoProvisaoDec(c, periodoProvisao);
        Integer avos = 0;
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        GregorianCalendar periodo = new GregorianCalendar();
        dataAdmissao.setTime(c.getDataAdmissao());
        periodo.setTime(periodoProvisao);
        if (dataAdmissao.get(1) == periodo.get(1)) {
            avos = UtilCalculoProvisaoDecimoTerceiro.getPrimeiroAvos(c.getDataAdmissao());
            dataAdmissao.add(2, 1);
            do {
                if (dataAdmissao.before(periodo)) {
                    avos = avos + 1;
                    continuar = true;
                } else {
                    continuar = false;
                }
                dataAdmissao.add(2, 1);
            } while (continuar);
            return avos.doubleValue() - avosAfastado;
        }
        if (dataAdmissao.get(1) < periodo.get(1)) {
            avos = periodo.get(2) + 1;
            if (periodo.get(5) < 15) {
                avos = avos - 1;
            }
            return avos.doubleValue() - avosAfastado;
        }
        return avosAfastado;
    }

    private static Integer getPrimeiroAvos(Date dataP) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataP);
        Integer aux = DateUtil.getLastDayOnMonth(g.get(1), g.get(2) + 1) - g.get(5) + 1;
        if (aux >= 15) {
            return 1;
        }
        return 0;
    }

    private Double colaboradorAfastadoProvisaoDec(Colaborador c, Date periodoProvisao) throws ExceptionService {
        System.err.println(c.toString());
        List ret = this.afastamentoColaborador(c, periodoProvisao);
        if (ret == null || ret.isEmpty()) {
            return 0.0;
        }
        Double avosTotal = 0.0;
        for (Object ob : ret) {
            Double avos1;
            Date dataAfastamento;
            HashMap h = (HashMap)ob;
            String tipoAfastametento = (String)h.get("TIPO_AFASTAMENTO");
            if (tipoAfastametento.equals("SAIDA_ANO_SEM_RETORNO")) {
                dataAfastamento = (Date)h.get("DATA_AFASTAMENTO");
                avos1 = UtilCalculoProvisaoDecimoTerceiro.calcularAvosAfastamento(dataAfastamento, periodoProvisao, UtilCalculoProvisaoDecimoTerceiro.dataFimPrimeiroAvos(dataAfastamento));
                avosTotal = avos1 + avosTotal;
                continue;
            }
            if (tipoAfastametento.equals("SAIDA_ANO_COM_RETORNO")) {
                dataAfastamento = (Date)h.get("DATA_AFASTAMENTO");
                Date dataRetorno = (Date)h.get("DATA_RETORNO");
                Double avos12 = UtilCalculoProvisaoDecimoTerceiro.calcularAvosAfastamento(dataAfastamento, dataRetorno, UtilCalculoProvisaoDecimoTerceiro.dataFimPrimeiroAvos(dataAfastamento));
                avosTotal = avosTotal + avos12;
                continue;
            }
            if (!tipoAfastametento.equals("SAIDA_ANO_ANTERIOR_COM_RETORNO")) continue;
            Date dataRetorno = (Date)h.get("DATA_RETORNO");
            avos1 = UtilCalculoProvisaoDecimoTerceiro.calcularAvosAfastamento(UtilCalculoProvisaoDecimoTerceiro.dataInicioAno(periodoProvisao, c), dataRetorno, dataRetorno);
            avosTotal = avosTotal + avos1;
        }
        return avosTotal;
    }

    private static Double calcularAvosAfastamento(Date dataInicio, Date dataFim, Date dataFimPrimeiroAvos) {
        Integer avos = 0;
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        GregorianCalendar periodo = new GregorianCalendar();
        dataAdmissao.setTime(dataInicio);
        periodo.setTime(dataFim);
        boolean continuar = true;
        if (dataAdmissao.get(1) == periodo.get(1)) {
            avos = UtilCalculoProvisaoDecimoTerceiro.getPrimeiroAvosAfastamento(dataInicio, dataFimPrimeiroAvos);
            dataAdmissao.add(2, 1);
            do {
                if (dataAdmissao.before(periodo)) {
                    avos = avos + 1;
                    continuar = true;
                } else {
                    continuar = false;
                }
                dataAdmissao.add(2, 1);
            } while (continuar);
            return avos.doubleValue();
        }
        if (dataAdmissao.get(1) < periodo.get(1)) {
            avos = periodo.get(2) + 1;
            if (periodo.get(5) < 15) {
                avos = avos - 1;
            }
            return avos.doubleValue();
        }
        return 0.0;
    }

    private static Date dataInicioAno(Date periodoProvisao, Colaborador c) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodoProvisao);
        Date janeiro = DateUtil.intToDate(g.get(1), 1, 1);
        if (c.getDataAdmissao().before(janeiro)) {
            return janeiro;
        }
        return c.getDataAdmissao();
    }

    private static Integer getPrimeiroAvosAfastamento(Date dataInicio, Date dataFim) {
        Integer dias = DateUtil.diferenceDayBetweenDates(dataInicio, dataFim) + 1;
        if (dias >= 15) {
            return 1;
        }
        return 0;
    }

    private static Date dataFimPrimeiroAvos(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(5, g.getActualMaximum(5));
        return g.getTime();
    }

    public List afastamentoColaborador(Colaborador c, Date dataProvisao) {
        List ret = new ArrayList();
        Integer ano = DateUtil.yearFromDate(dataProvisao);
        String hql = " ";
        hql = " select af.dataAfastamento as DATA_AFASTAMENTO from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  extract(year from af.dataAfastamento) = :ano  and  af.dataAfastamento < :dataProvisao  and  (af.dataRetorno is null or af.dataRetorno > :dataProvisao)  and  af.afastamentoSefip.codigo != :cod1 and af.afastamentoSefip.codigo != :cod3";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", ano.intValue()).setDate("dataProvisao", dataProvisao).setEntity("colaborador", (Object)c).setString("cod1", "Q1").setString("cod3", "U1").setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_SEM_RETORNO");
            }
            return ret;
        }
        hql = " select af.dataAfastamento as DATA_AFASTAMENTO, af.dataRetorno as DATA_RETORNO  from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  extract(year from af.dataAfastamento) = :ano  and  af.dataAfastamento < :dataProvisao  and  af.dataRetorno < :dataProvisao  and  af.afastamentoSefip.codigo != :cod1 and af.afastamentoSefip.codigo != :cod3";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("dataProvisao", dataProvisao).setString("cod1", "Q1").setString("cod3", "U1").setInteger("ano", ano.intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_COM_RETORNO");
            }
            return ret;
        }
        hql = " select af.dataRetorno as DATA_RETORNO  from AfastamentoColaborador af where   af.colaborador = :colaborador  and  extract(year from af.dataAfastamento) < :ano  and  extract(year from af.dataRetorno) = :ano  and  af.dataRetorno < :dataProvisao  and  af.afastamentoSefip.codigo != :cod1 and af.afastamentoSefip.codigo != :cod3";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setString("cod1", "Q1").setString("cod3", "U1").setDate("dataProvisao", dataProvisao).setInteger("ano", ano.intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (ret != null && !ret.isEmpty()) {
            for (Object obj : ret) {
                HashMap retorno = (HashMap)obj;
                retorno.put("TIPO_AFASTAMENTO", "SAIDA_ANO_ANTERIOR_COM_RETORNO");
            }
            return ret;
        }
        return null;
    }

    public static Double getDec(Double maiorRemuneracao, Double avos) {
        return ContatoFormatUtil.arrredondarNumero((Double)(maiorRemuneracao / 12.0 * avos), (int)2);
    }

    public static Double getVlrInssEmpresa(Double vlrDec, Double percDesoneracao, EmpresaRh empresaRh) {
        if (empresaRh.getPossuiDesoneracao().equals((short)0)) {
            Double vlrBaseInss = ContatoFormatUtil.arrredondarNumero((Double)vlrDec, (int)2);
            Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
            return ContatoFormatUtil.arrredondarNumero((Double)(vlrBaseInss * percInssEmpresa), (int)2);
        }
        Double vlrBaseInss = ContatoFormatUtil.arrredondarNumero((Double)vlrDec, (int)2);
        Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
        Double inss = vlrBaseInss * percInssEmpresa;
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return inss;
    }

    public static Double getVlrInssTer(Double vlrDec, EmpresaRh empresaRh) {
        Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)vlrDec, (int)2);
        Double percInssTer = empresaRh.getPercTerceiros() / 100.0;
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * percInssTer), (int)2);
    }

    public static Double getVlrRat(Double vlrDec, EmpresaRh empresaRh) {
        Double indiceFat = empresaRh.getIndiceFAP();
        Double rat = empresaRh.getPercRat();
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrDec * indiceFat * (rat / 100.0)), (int)2);
    }

    public static Double getVlrAposentadoriaEspecial25(Colaborador colaborador, Double vlrDec, EmpresaRh empresaRh) {
        if (colaborador.getCategoriaSefip().getCodigo().equals("04")) {
            Double percAposentadoria25 = empresaRh.getPercAposentadoriaEspecial25Anos();
            return ContatoFormatUtil.arrredondarNumero((Double)(vlrDec * (percAposentadoria25 / 100.0)), (int)2);
        }
        return 0.0;
    }

    public static Double getVlFgts(Double vlrDec) {
        Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)vlrDec, (int)2);
        Double percFgts = 0.08;
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * percFgts), (int)2);
    }

    public Double vlrMediaProvDecimoTerceiro(Colaborador colaborador, Date dataInicial) {
        String hql = " select  coalesce(sum(item.valor),0) as VALOR  from ItemMovimentoFolha item  where  (item.eventoColaborador.tipoCalculoEvento.media13Salario = :referencia  or  (item.eventoColaborador.tipoCalculoEvento.media13Salario = :valor)) and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = :provento  and  (extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano)  and  item.movimentoFolha.aberturaPeriodo.dataInicio <= :dataInicio  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :tipoFolha ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("referencia", (short)1).setShort("valor", (short)2).setInteger("ano", DateUtil.yearFromDate(dataInicial).intValue()).setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue()).setShort("tipoFolha", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("dataInicio", dataInicial).uniqueResult();
    }

    public List findColaboradoresProvisaoDec(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        Object hql;
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR)) {
            hql = " select c     from Colaborador c     where     c.ativo = 1     and     (c.tipoColaborador.identificador = 0     and     c.dataAdmissao <= :dataFinal )     and     (c.dataDemissao is null or c.dataDemissao > :dataFinal )    and     not exists ( select af.colaborador                  from AfastamentoColaborador af                  where                  af.colaborador = c                  and                  af.afastamentoSefip.codigo != :cod1                  and                  af.afastamentoSefip.codigo != :cod2                  and                  af.afastamentoSefip.codigo != :cod3                  and                  (af.dataRetorno is null or af.dataRetorno > :dataFinal)                  and                  af.dataAfastamento < :dataInicial )  and  c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa ";
            if (empresaFiltrada != null) {
                hql = (String)hql + " and c.empresa =:empresa ";
            }
        } else {
            hql = "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo b INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e INNER JOIN e.empresaDados    d INNER JOIN d.grupoEmpresa    g WHERE c.ativo = 1 AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND NOT EXISTS ( SELECT a.colaborador FROM       AfastamentoColaborador a INNER JOIN a.afastamentoSefip     s WHERE a.colaborador = c AND s.codigo != :cod1 AND s.codigo != :cod2 AND s.codigo != :cod3 AND (a.dataRetorno IS NULL OR a.dataRetorno > :dataFinal) AND a.dataAfastamento < :dataInicial) AND g = :grupoEmpresa AND b.dataFinal BETWEEN :dataInicial AND :dataFinal";
            if (ToolMethods.isNotNull((Object)empresaFiltrada).booleanValue()) {
                hql = (String)hql + " AND e = :empresa ";
            }
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setString("cod1", "Z1");
        q.setString("cod2", "Q1");
        q.setString("cod3", "U1");
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        if (empresaFiltrada != null) {
            q.setEntity("empresa", (Object)empresaFiltrada);
        }
        List colaboradores = q.list();
        return colaboradores;
    }

    public List findColaboradoresProvisaoDecCentroCusto(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        String hql = ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR) ? " select c     from Colaborador c     where     c.ativo = 1     and     (c.tipoColaborador.identificador = 0     and     c.dataAdmissao <= :dataFinal )     and     (c.dataDemissao is null or c.dataDemissao > :dataFinal )    and     not exists ( select af.colaborador                  from AfastamentoColaborador af                  where                  af.colaborador = c                  and                  af.afastamentoSefip.codigo != :cod1                  and                  af.afastamentoSefip.codigo != :cod2                  and                  af.afastamentoSefip.codigo != :cod3                  and                  (af.dataRetorno is null or af.dataRetorno > :dataFinal)                  and                  af.dataAfastamento < :dataInicial )  and  c.empresa = :grupoEmpresa " : "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo b INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e WHERE c.ativo = 1 AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND NOT EXISTS ( SELECT a.colaborador FROM       AfastamentoColaborador a INNER JOIN a.afastamentoSefip     s WHERE a.colaborador = c AND s.codigo != :cod1 AND s.codigo != :cod2 AND s.codigo != :cod3 AND (a.dataRetorno IS NULL OR a.dataRetorno > :dataFinal) AND a.dataAfastamento < :dataInicial) AND e = :grupoEmpresa AND b.dataFinal BETWEEN :dataInicial AND :dataFinal";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setString("cod1", "Z1");
        q.setString("cod2", "Q1");
        q.setString("cod3", "U1");
        q.setEntity("grupoEmpresa", (Object)empresaFiltrada);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        List colaboradores = q.list();
        return colaboradores;
    }

    public List getProvisaoDec(ProvisaoDec provisao) {
        String hql = " select item.colaborador.numeroRegistro as Registro,  item.colaborador.pessoa.nome as Colaborador,  item.colaborador.dataAdmissao as admissao,  item.salarioBase as salarioBase,  item.maiorRemuneracao as maiorRemuneracao,  item.avos as avos,  item.vlrDec as vlrDec,  item.vlrInssEmpresa as inssEmpresa,  item.vlrInssTerceiros as inssTerceiros, item.vlrFgts as fgts, item.provisao.periodo as periodo,  item.colaborador.centroCusto.codigo as CODIGO,  item.colaborador.centroCusto.nome as CENTRO_C,  item.vlrRat as rat, item.vlrAposentadoria25Anos as aposentadoria   from ItemProvisaoDec item  where item.provisao = :provisao  order by item.colaborador.centroCusto.nome, item.colaborador.pessoa.nome";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("provisao", (Object)provisao).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public List getPlanoContaImpostoProvisaoDec(CentroCusto centroCusto) {
        String hql = " select planoConta  from PlanoContaImpostoFolha planoConta  inner join planoConta.itensCentroCusto item  inner join planoConta.itensTipoFolha itemFolha  where  item.centroCusto = :centroCusto  and  itemFolha.tipoFolha.tipoFolha = :tipoCalculo ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("centroCusto", (Object)centroCusto).setShort("tipoCalculo", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).list();
    }

    public List findProvisaoDecPorPeriodoAndEmpresa(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "select distinct b from ProvisaoDec b  where (b.periodo between :periodoInicial and :periodoFinal)  and (b.loteContabil is null)  and (b.empresa = :empresa) ";
        Query query = s.createQuery(q);
        query.setDate("periodoInicial", periodoInicial);
        query.setDate("periodoFinal", periodoFinal);
        query.setEntity("empresa", (Object)empresa);
        return query.list();
    }

    public void deleteLoteInProvisao(LoteContabil loteContabil) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update ProvisaoDec n set n.loteContabil = null where n.loteContabil = :lote");
        q.setEntity("lote", (Object)loteContabil);
        q.executeUpdate();
    }

    List<Colaborador> findColaboradoresProvisao13CentroCusto(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, CentroCusto centroCusto, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        Object hql;
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR)) {
            hql = " select c     from Colaborador c     where     c.ativo = 1     and     (c.tipoColaborador.identificador = 0     and     c.centroCusto = :centroCusto     and     c.dataAdmissao <= :dataFinal )     and     c.dataDemissao > :dataFinal      and     not exists ( select af.colaborador                  from AfastamentoColaborador af                  where                  af.colaborador = c                  and                  af.afastamentoSefip.codigo != :cod1                  and                  af.afastamentoSefip.codigo != :cod2                  and                  af.afastamentoSefip.codigo != :cod3                  and                  (af.dataRetorno is null or af.dataRetorno > :dataFinal)                  and                  af.dataAfastamento < :dataInicial )  and  c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa ";
            if (empresaFiltrada != null) {
                hql = (String)hql + " and c.empresa = :empresa";
            }
        } else {
            hql = "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo b INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e INNER JOIN e.empresaDados    d INNER JOIN d.grupoEmpresa    g INNER JOIN c.centroCusto     n WHERE c.ativo = 1 AND n = :centroCusto AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND NOT EXISTS ( SELECT a.colaborador FROM       AfastamentoColaborador a INNER JOIN a.afastamentoSefip     s WHERE a.colaborador = c AND s.codigo != :cod1 AND s.codigo != :cod2 AND s.codigo != :cod3 AND (a.dataRetorno IS NULL OR a.dataRetorno > :dataFinal) AND a.dataAfastamento < :dataInicial) AND g = :grupoEmpresa AND b.dataFinal BETWEEN :dataInicial AND :dataFinal";
            if (ToolMethods.isNotNull((Object)empresaFiltrada).booleanValue()) {
                hql = (String)hql + " AND e = :empresa ";
            }
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setString("cod1", "Z1");
        q.setString("cod2", "Q1");
        q.setString("cod3", "U1");
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("centroCusto", (Object)centroCusto);
        if (empresaFiltrada != null) {
            q.setEntity("empresa", (Object)empresaFiltrada);
        }
        List colaboradores = q.list();
        return colaboradores;
    }

    public Integer verificarExistenciaIntegContFolha(Date periodo) {
        String hql = " select coalesce(count(i.identificador),0) from IntegracaoMovimentoFolha i  where  i.abertura.dataInicio = :periodo  and  i.abertura.tipoCalculo.tipoFolha = :folhaPagamento ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodo", periodo).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).uniqueResult();
        if (ret != null && ret > 0L) {
            return 1;
        }
        return 0;
    }

    private Double getValorPis(Double vlrDec, EmpresaRh empresaRh) {
        Empresa empresa = empresaRh.getEmpresa();
        if (empresa.getEmpresaDados().getIndicadorNaturezaJuridica() == null || !empresa.getEmpresaDados().getIndicadorNaturezaJuridica().getCodigo().equals("02")) {
            return 0.0;
        }
        if (empresaRh.getAliquotaPis() <= 0.0) {
            return 0.0;
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrDec * empresaRh.getAliquotaPis() / 100.0), (int)2);
    }

    private Double getSalarioBase(Colaborador colaborador) {
        if (colaborador.getTipoSalario().getCodigo().equals("1")) {
            return colaborador.getValorSalario();
        }
        return colaborador.getValorSalario() * colaborador.getHorasTrabDia() * colaborador.getDiasJornada();
    }
}

