/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.provisao.EnumConsiderarEmpresa;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.SCompCalculoAvos2;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCalculoProvisaoFerias {
    public ItemProvisaoFerias findItemProvisaoFerias(Colaborador colaborador, Date periodoInicial, Date periodoFinal, Double percDesoneracao, EmpresaRh empresaRh) throws ExceptionService {
        SCompCalculoAvos2.ProvisaoFeriasAvos provisaoFeriasAvos;
        Double vrSalarioBase = new UtilCalculoFolhaPagamento().salarioProvisao(colaborador);
        if (colaborador.getNumeroRegistro().equals("55")) {
            System.out.println("");
        }
        if ((provisaoFeriasAvos = ((SCompCalculoAvos2)ConfApplicationContext.getBean(SCompCalculoAvos2.class)).calcularAvosProvisao(colaborador, periodoFinal)) != null && provisaoFeriasAvos.totalAvos() > 0) {
            Integer aux = provisaoFeriasAvos.totalAvos();
            Double avos = aux.doubleValue();
            Date ultimaDataFerias = provisaoFeriasAvos.ultimoPeriodoAquisitivoValido();
            Double vlrMedias = this.getMediaFeriasColaborador(ultimaDataFerias, periodoFinal, colaborador);
            Double vlrMaiorRemuneracao = 0.0;
            vlrMaiorRemuneracao = avos > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(vrSalarioBase + vlrMedias / avos), (int)2) : ContatoFormatUtil.arrredondarNumero((Double)vrSalarioBase, (int)2);
            Double vlrFerias = UtilCalculoProvisaoFerias.getFerias(vlrMaiorRemuneracao, avos);
            Double vlr13Ferias = UtilCalculoProvisaoFerias.get13Ferias(vlrFerias);
            Double vlrInssEmpresa = UtilCalculoProvisaoFerias.getVlrInssEmpresa(vlrFerias, vlr13Ferias, percDesoneracao, empresaRh);
            Double vlrInssTer = UtilCalculoProvisaoFerias.getVlrInssTer(vlrFerias, vlr13Ferias, empresaRh);
            Double vlrFgts = UtilCalculoProvisaoFerias.getVlFgts(vlrFerias, vlr13Ferias);
            Double vlrRat = UtilCalculoProvisaoFerias.getVlrRat(vlrFerias, vlr13Ferias, empresaRh);
            Double vlrAposentadoria25 = UtilCalculoProvisaoFerias.getVlrAposentadoriaEspecial25Anos(colaborador, vlrFerias, vlr13Ferias, empresaRh);
            Double vlrPis = this.getVlrPis(vlrFerias + vlr13Ferias, empresaRh);
            ItemProvisaoFerias item = new ItemProvisaoFerias(colaborador, vrSalarioBase, vlrMedias, avos, vlrFerias, vlr13Ferias, vlrInssEmpresa, vlrInssTer, vlrFgts, vlrMaiorRemuneracao, vlrRat, vlrAposentadoria25, ultimaDataFerias, vlrPis);
            return item;
        }
        return null;
    }

    public static Double get13Ferias(Double vlrFerias) {
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias / 3.0), (int)2);
    }

    public static Double getFerias(Double maiorRemuneracao, Double avos) {
        return ContatoFormatUtil.arrredondarNumero((Double)(maiorRemuneracao / 12.0 * avos), (int)2);
    }

    public static Double getVlrInssEmpresa(Double vlrFerias, Double vlr13Ferias, Double percDesoneracao, EmpresaRh empresaRh) {
        if (empresaRh.getPossuiDesoneracao().equals((short)0)) {
            Double vlrBaseInss = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
            Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
            return ContatoFormatUtil.arrredondarNumero((Double)(vlrBaseInss * percInssEmpresa), (int)2);
        }
        Double vlrBaseInss = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
        Double inss = vlrBaseInss * percInssEmpresa;
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return inss;
    }

    public static Double getVlrInssTer(Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percInssTer = empresaRh.getPercTerceiros() / 100.0;
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * percInssTer), (int)2);
    }

    public static Double getVlFgts(Double vlrFerias, Double vlr13Ferias) {
        Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percFgts = 0.08;
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * percFgts), (int)2);
    }

    public static Double getVlrRat(Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double indiceFat = empresaRh.getIndiceFAP();
        Double rat = empresaRh.getPercRat();
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * indiceFat * (rat / 100.0)), (int)2);
    }

    public static Double getVlrAposentadoriaEspecial25Anos(Colaborador c, Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        if (c.getCategoriaSefip().getCodigo().equals("04")) {
            Double vlrBase = ContatoFormatUtil.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
            Double percAposent25 = empresaRh.getPercAposentadoriaEspecial25Anos();
            return ContatoFormatUtil.arrredondarNumero((Double)(vlrBase * (percAposent25 / 100.0)), (int)2);
        }
        return 0.0;
    }

    public HashMap findAvosProvisao(Colaborador c, Date periodoProvisao) throws ExceptionService {
        HashMap<String, Comparable<Date>> h = new HashMap<String, Comparable<Date>>();
        if (c.getNumeroRegistro().equals("327")) {
            // empty if block
        }
        boolean continuar = true;
        Integer avos = 0;
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        GregorianCalendar dataProvisao = new GregorianCalendar();
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataAdmissao.setTime(c.getDataAdmissao());
        dataProvisao.setTime(periodoProvisao);
        Object obj = this.getDatafinalFerias(c, periodoProvisao);
        if (obj instanceof HashMap) {
            return (HashMap)obj;
        }
        if (obj instanceof Date) {
            dataFinalFerias.setTime((Date)obj);
        }
        if (dataFinalFerias.getTime() != null) {
            Date dataRetorno = this.verificarPercaPeriodoAquisitivo(c, dataFinalFerias.getTime(), periodoProvisao);
            if (dataRetorno != null) {
                dataFinalFerias.setTime(dataRetorno);
            }
            h.put("ultimaDataFerias", dataFinalFerias.getTime());
            Date dataProxPeriodo = DateUtil.nextYear(dataFinalFerias.getTime(), 1);
            continuar = true;
            avos = this.getPrimeiroAvosFeriasNormais(dataFinalFerias.getTime(), dataProvisao.getTime(), c.getDataAdmissao());
            dataFinalFerias.add(2, 1);
            dataFinalFerias.getTime();
            do {
                if (dataFinalFerias.getTime().equals(dataProxPeriodo)) {
                    dataRetorno = this.verificarPercaPeriodoAquisitivo(c, dataProxPeriodo, periodoProvisao);
                    if (dataRetorno != null) {
                        dataFinalFerias.setTime(dataRetorno);
                    }
                    dataProxPeriodo = DateUtil.nextDays(dataProxPeriodo, 1);
                }
                if (dataFinalFerias.before(dataProvisao) && 15 < DateUtil.diferenceDayBetweenDates(dataFinalFerias.getTime(), dataProvisao.getTime()) + 1) {
                    avos = avos + 1;
                } else {
                    dataFinalFerias.getTime();
                    avos = UtilCalculoProvisaoFerias.getUltimoAvosFerias(dataFinalFerias.getTime(), dataProvisao.getTime()) + avos;
                    continuar = false;
                }
                dataFinalFerias.add(2, 1);
                dataFinalFerias.getTime();
            } while (continuar);
            h.put("avos", avos);
        }
        return h;
    }

    private Object getDatafinalFerias(Colaborador vo, Date dataProvisao) throws ExceptionService {
        AfastamentoColaborador afs;
        GregorianCalendar g = new GregorianCalendar();
        Date dataAfastamento = null;
        HashMap h = this.colaboradorAfastado(vo, dataProvisao);
        if (h == null) {
            Date finalFerias = this.getDataFinalFerias(vo, dataProvisao);
            g.setTime(finalFerias);
            g.add(7, 1);
            return g.getTime();
        }
        AfastamentoColaborador af = (AfastamentoColaborador)h.get("afastamento");
        dataAfastamento = !af.getAfastamentoSefip().getCodigo().equals("U3") ? af.getDataAfastamento() : ((afs = (AfastamentoColaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOAfastamentoColaborador(), "dataRetorno", DateUtil.nextDays(af.getDataAfastamento(), -1), 0)) == null || afs.getDataAfastamento() == null ? af.getDataAfastamento() : afs.getDataAfastamento());
        Date finalFerias = this.getDataFinalFerias(vo, dataProvisao);
        g.setTime(finalFerias);
        g.add(7, 1);
        Integer avos = 0;
        System.err.println(af.getColaborador().getIdentificador());
        if (DateUtil.diferenceDayBetweenDates(dataAfastamento, dataProvisao) > 180) {
            avos = UtilCalculoProvisaoFerias.getAvosAfastados(g.getTime(), dataAfastamento);
            if (avos <= 6) {
                avos = 0;
            }
        } else {
            avos = UtilCalculoProvisaoFerias.getAvosAfastados(g.getTime(), dataProvisao);
        }
        h.put("avos", avos);
        h.put("ultimaDataFerias", g.getTime());
        return h;
    }

    public HashMap colaboradorAfastado(Colaborador c, Date dataProvisao) throws ExceptionService {
        String hql = "  select af      from AfastamentoColaborador af      where      af.colaborador = :colaborador      and      af.afastamentoSefip.codigo != :cod1      and        af.afastamentoSefip.codigo != :cod2      and      af.afastamentoSefip.codigo != :cod3      and      (af.dataRetorno is null or af.dataRetorno > :dataProvisao)      and      af.dataAfastamento < :dataProvisao ";
        List lista = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").setDate("dataProvisao", dataProvisao).list();
        if (!ToolMethods.isWithData((Collection)lista)) {
            return null;
        }
        if (lista.size() == 1) {
            HashMap h = new HashMap();
            h.put("afastamento", lista.get(0));
            return h;
        }
        throw new ExceptionService("Econtrado mais de um afastamento para o colaborador: " + c.toString());
    }

    public Date getDataFinalFerias(Colaborador colaborador, Date dataProvisao) throws ExceptionService {
        Object obj = this.calculoPeriodoProvisaoFerias(colaborador, dataProvisao);
        if (obj instanceof PeriodoAqFeriasColab) {
            PeriodoAqFeriasColab periodo = (PeriodoAqFeriasColab)obj;
            return periodo.getDataFinal();
        }
        if (obj instanceof ColaboradorDadosFerias) {
            ColaboradorDadosFerias colaboradorDados = (ColaboradorDadosFerias)obj;
            return colaboradorDados.getDataFimPeriodo();
        }
        if (obj instanceof Colaborador) {
            Colaborador c = (Colaborador)obj;
            return DateUtil.nextDays(c.getDataAdmissao(), -1);
        }
        return colaborador.getDataAdmissao();
    }

    private Object calculoPeriodoProvisaoFerias(Colaborador c, Date periodoProvisao) {
        List l = new ArrayList();
        Object resul = null;
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" from PeriodoAqFeriasColab p  where  p.fechado = 1  and  p.colaborador.identificador = :idcolaborador and  p.dataFinal = (select max(ferias.periodoAqFeriasColab.dataFinal)                 from FeriasColaborador ferias                 where                 ferias.periodoAqFeriasColab= p                and                 ferias.periodoAqFeriasColab.colaborador.identificador = :idcolaborador                and                ferias.dataGozoInicial <= :periodoProvisao) order by p.identificador  ");
        q.setLong("idcolaborador", c.getIdentificador().longValue());
        q.setDate("periodoProvisao", periodoProvisao);
        l = q.list();
        if (l.size() == 1) {
            resul = l.get(0);
        } else if (l.size() > 1) {
            resul = l.get(l.size() - 1);
        }
        if (resul != null) {
            return resul;
        }
        String hql = " from ColaboradorDadosFerias a     where a.colaborador.identificador = :idcolaborador     and a.dataFimPeriodo = (select max(aa.dataFimPeriodo)                             from ColaboradorDadosFerias aa                             where aa.colaborador.identificador = :idcolaborador)";
        Query q2 = s.createQuery(hql);
        q2.setLong("idcolaborador", c.getIdentificador().longValue());
        l = q2.list();
        if (this.fechouPeriodoAnterior(l)) {
            if (l.size() == 1) {
                resul = l.get(0);
            } else if (l.size() > 1) {
                resul = l.get(l.size() - 1);
            }
        }
        if (resul != null) {
            return resul;
        }
        return c;
    }

    private boolean fechouPeriodoAnterior(List l) {
        Integer diasGozados = 0;
        for (Object obj : l) {
            ColaboradorDadosFerias dados = (ColaboradorDadosFerias)obj;
            diasGozados = DateUtil.diferenceDayBetweenDates(dados.getInicioGozoFerias(), dados.getFimGozoFerias()) + 1 + diasGozados;
        }
        return true;
    }

    private static Integer getAvosAfastados(Date finalFerias, Date dataAfast) {
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        GregorianCalendar dataAfastamento = new GregorianCalendar();
        dataFinalFerias.setTime(finalFerias);
        dataAfastamento.setTime(dataAfast);
        boolean continuar = true;
        Integer avos = 0;
        avos = UtilCalculoProvisaoFerias.getPrimeiroAvosFerias(dataFinalFerias.getTime(), dataAfastamento.getTime());
        dataFinalFerias.add(2, 1);
        dataFinalFerias.getTime();
        do {
            if (dataFinalFerias.before(dataAfastamento) && 15 < DateUtil.diferenceDayBetweenDates(dataFinalFerias.getTime(), dataAfastamento.getTime()) + 1) {
                avos = avos + 1;
            } else {
                dataFinalFerias.getTime();
                avos = UtilCalculoProvisaoFerias.getUltimoAvosFerias(dataFinalFerias.getTime(), dataAfastamento.getTime()) + avos;
                continuar = false;
            }
            dataFinalFerias.add(2, 1);
            dataFinalFerias.getTime();
        } while (continuar);
        return avos;
    }

    private static Integer getPrimeiroAvosFerias(Date dataFerias, Date dataProvisao) {
        if (dataProvisao.before(dataFerias)) {
            return 0;
        }
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataFerias);
        GregorianCalendar dataFinalDemissao = new GregorianCalendar();
        dataFinalDemissao.setTime(dataProvisao);
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(dataFerias);
        aux.add(2, 1);
        Integer aux1 = dataFinalFerias.getActualMaximum(5) - dataFinalFerias.get(5) + 1;
        if (aux1 >= 15) {
            return 1;
        }
        return 0;
    }

    private static Integer getUltimoAvosFerias(Date dataFerias, Date dataDemissao) {
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataFerias);
        GregorianCalendar dataFinalDemissao = new GregorianCalendar();
        dataFinalDemissao.setTime(dataDemissao);
        Integer aux = DateUtil.diferenceDayBetweenDates(dataFinalFerias.getTime(), dataDemissao) + 2;
        if (aux >= 15) {
            return 1;
        }
        return 0;
    }

    private Double getMediaFeriasColaborador(Date dataInicio, Date dataFinal, Colaborador colaborador) throws ExceptionService {
        return this.findMediaFerias(dataInicio, dataFinal, colaborador);
    }

    public Double findMediaFerias(Date dataInicio, Date dataFinal, Colaborador colaborador) throws ExceptionService {
        String query = "          select coalesce(sum(item.valor),0)         from ItemMovimentoFolha item         where         item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = :provento         and         (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :referencia or (item.eventoColaborador.tipoCalculoEvento.mediaFerias = :valor))        and         item.movimentoFolha.colaborador = :colaborador         and        ((item.movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicio        and        item.movimentoFolha.aberturaPeriodo.dataFinal <= :dataFim)         or       (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataFim         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataFim         and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoFinal <= 15 )        and         (:dataFimInicioPeriodo - :diaPeriodoInicial+1) < 15 )         or         (item.movimentoFolha.aberturaPeriodo.dataInicio < :dataInicio         and         item.movimentoFolha.aberturaPeriodo.dataFinal > :dataInicio          and         (extract(day from item.movimentoFolha.aberturaPeriodo.dataFinal) - :diaPeriodoInicial >= 15 )))        and         item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(query).setDate("dataInicio", dataInicio).setDate("dataFim", dataFinal).setInteger("diaPeriodoFinal", DateUtil.dayFromDate(dataFinal).intValue()).setInteger("diaPeriodoInicial", DateUtil.dayFromDate(dataInicio).intValue()).setEntity("colaborador", (Object)colaborador).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("dataFimInicioPeriodo", DateUtil.getCalendar(dataInicio).getActualMaximum(5)).setShort("valor", (short)2).setShort("referencia", (short)1).setShort("provento", EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue().shortValue()).uniqueResult();
    }

    public List findColaboradoresProvisaoFerias(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        Object hql;
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR)) {
            hql = " select c  from Colaborador c  where  c.ativo = :sim  and  (c.tipoColaborador.identificador = 0  and  c.dataAdmissao <= :dataFinal )  and   (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa";
            if (empresaFiltrada != null) {
                hql = (String)hql + " and c.empresa = :empresa ";
            }
        } else {
            hql = "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo a INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e INNER JOIN e.empresaDados    d INNER JOIN d.grupoEmpresa    g WHERE c.ativo = :sim AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND g = :grupoEmpresa AND a.dataFinal BETWEEN :dataInicial AND :dataFinal";
            if (ToolMethods.isNotNull((Object)empresaFiltrada).booleanValue()) {
                hql = (String)hql + " AND e = :empresa ";
            }
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_MOVIMENTACAO_COMPETENCIA)) {
            q.setDate("dataInicial", dataInicial);
        }
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", (short)1);
        if (empresaFiltrada != null) {
            q.setEntity("empresa", (Object)empresaFiltrada);
        }
        List colaboradores = q.list();
        return colaboradores;
    }

    public List findColaboradoresProvisaoFeriasCentroCusto(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        String hql = ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR) ? " select c  from Colaborador c  where  c.ativo = :sim  and  (c.tipoColaborador.identificador = 0  and  c.dataAdmissao <= :dataFinal )  and   (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.empresa= :empresa" : "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo a INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e WHERE c.ativo = :sim AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND e = :empresa AND a.dataFinal BETWEEN :dataInicial AND :dataFinal";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("empresa", (Object)empresaFiltrada);
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_MOVIMENTACAO_COMPETENCIA)) {
            q.setDate("dataInicial", dataInicial);
        }
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", (short)1);
        List colaboradores = q.list();
        return colaboradores;
    }

    public List getPlanoContaImpostoProvFerias(CentroCusto centroCusto) {
        String hql = " select planoConta  from PlanoContaImpostoFolha planoConta  inner join planoConta.itensCentroCusto item  inner join planoConta.itensTipoFolha itemFolha  where  item.centroCusto = :centroCusto  and  itemFolha.tipoFolha.tipoFolha = :tipoCalculo ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("centroCusto", (Object)centroCusto).setShort("tipoCalculo", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).list();
    }

    public List findProvisaoFeriasPorPeriodoAndEmpresa(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "select distinct b from ProvisaoFerias b  where (b.periodo between :periodoInicial and :periodoFinal)  and (b.loteContabil is null)  and (b.empresa = :empresa) ";
        Query query = s.createQuery(q);
        query.setDate("periodoInicial", periodoInicial);
        query.setDate("periodoFinal", periodoFinal);
        query.setEntity("empresa", (Object)empresa);
        return query.list();
    }

    public void deleteLoteInProvisao(LoteContabil loteContabil) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update ProvisaoFerias n set n.loteContabil = null where n.loteContabil = :lote");
        q.setEntity("lote", (Object)loteContabil);
        q.executeUpdate();
    }

    public List getProvisaoFerias(ProvisaoFerias provisao) {
        String hql = " select item.colaborador.numeroRegistro as Registro,  item.colaborador.pessoa.nome as Colaborador,  item.ultimaDataFerias as dataAdmissao, item.salarioBase as salarioBase,  item.vlrMaiorRemuneracao as maiorRemuneracao,  item.avos as avos,  item.vlrFerias as ferias , item.vlrFerias13 as feriasUmTerco,  item.vlrInssEmpresa as inssEmpresa,  item.vlrInssTerceiros as inssTerceiros,  item.vlrFgts as fgts,  item.provisao.periodo as periodo,  item.colaborador.centroCusto.codigo as CODIGO,  item.colaborador.centroCusto.nome as CENTRO_C,  item.vlrRat as rat, item.vlrAposentadoria25 as aposentadoria  from ItemProvisaoFerias item  where item.provisao = :provisao  order by item.colaborador.centroCusto.nome , item.colaborador.pessoa.nome ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("provisao", (Object)provisao).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private Integer getPrimeiroAvosFeriasNormais(Date dataFerias, Date dataProvisao, Date dataAdmissao) {
        if (dataProvisao.before(dataFerias)) {
            return 0;
        }
        if (DateUtil.diferenceDayBetweenDates(dataFerias, dataProvisao) + 1 < 15) {
            return 0;
        }
        GregorianCalendar admissao = new GregorianCalendar();
        admissao.setTime(dataAdmissao);
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataFerias);
        GregorianCalendar finalProvisao = new GregorianCalendar();
        finalProvisao.setTime(dataProvisao);
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(dataFerias);
        aux.add(2, 1);
        if (dataFerias.equals(dataProvisao)) {
            Integer aux1 = dataFinalFerias.getActualMaximum(5) - dataFinalFerias.get(5) + 1;
            if (aux1 >= 15) {
                return 1;
            }
            return 0;
        }
        Integer aux1 = DateUtil.diferenceDayBetweenDates(dataFerias, aux.getTime()) + 1;
        if (aux1 >= 15) {
            return 1;
        }
        return 0;
    }

    private Date verificarPercaPeriodoAquisitivo(Colaborador c, Date dataFinalFerias, Date periodoProvisao) {
        Date dataInicioPeriodo = dataFinalFerias;
        Date dataFinalPeriodo = DateUtil.nextYear(dataInicioPeriodo, 1);
        dataFinalPeriodo = DateUtil.nextDays(dataFinalPeriodo, -1);
        String hql = " from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  af.dataAfastamento >= :dataInicio  and  af.dataRetorno is not null   ";
        List afastamentos = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("dataInicio", dataInicioPeriodo).list();
        if (!afastamentos.isEmpty()) {
            for (AfastamentoColaborador afastamento : afastamentos) {
                Integer diffDays = DateUtil.diferenceDayBetweenDates(afastamento.getDataAfastamento(), afastamento.getDataRetorno());
                if (diffDays <= 179) continue;
                return afastamento.getDataRetorno();
            }
        }
        return null;
    }

    List<Colaborador> findColaboradoresProvisaoCentroCusto(Date dataInicial, Date dataFinal, Long grupoEmpresa, CentroCusto centroCusto, Empresa empresaFiltrada, EnumConsiderarEmpresa enumConsiderarEmpresa) {
        Object hql;
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR)) {
            hql = " select c  from Colaborador c  where  c.ativo = :sim  and  c.centroCusto = :centroCusto  and  (c.tipoColaborador.identificador = 0  and  c.dataAdmissao <= :dataFinal )  and  (c.dataDemissao is null or c.dataDemissao > :dataFinal)  and  c.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa";
            if (empresaFiltrada != null) {
                hql = (String)hql + " and c.empresa = :empresa ";
            }
        } else {
            hql = "SELECT DISTINCT c FROM       MovimentoFolha    m INNER JOIN m.aberturaPeriodo a INNER JOIN m.colaborador     c INNER JOIN c.tipoColaborador t INNER JOIN m.empresa         e INNER JOIN e.empresaDados    d INNER JOIN d.grupoEmpresa    g INNER JOIN c.centroCusto     n WHERE c.ativo = :sim AND n = :centroCusto AND (t.identificador = 0 AND c.dataAdmissao <= :dataFinal) AND (c.dataDemissao IS NULL OR c.dataDemissao > :dataFinal) AND g.identificador = :grupoEmpresa AND a.dataFinal BETWEEN :dataInicial AND :dataFinal";
            if (ToolMethods.isNotNull((Object)empresaFiltrada).booleanValue()) {
                hql = (String)hql + " AND e = :empresa ";
            }
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setLong("grupoEmpresa", grupoEmpresa.longValue());
        if (ToolMethods.isEquals((Object)enumConsiderarEmpresa, (Object)EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_MOVIMENTACAO_COMPETENCIA)) {
            q.setDate("dataInicial", dataInicial);
        }
        q.setDate("dataFinal", dataFinal);
        q.setShort("sim", (short)1);
        q.setEntity("centroCusto", (Object)centroCusto);
        if (empresaFiltrada != null) {
            q.setEntity("empresa", (Object)empresaFiltrada);
        }
        List colaboradores = q.list();
        return colaboradores;
    }

    private Double getVlrPis(Double baseCalculo, EmpresaRh empresaRh) {
        Empresa empresa = empresaRh.getEmpresa();
        if (empresa.getEmpresaDados().getIndicadorNaturezaJuridica() == null || !empresa.getEmpresaDados().getIndicadorNaturezaJuridica().getCodigo().equals("02")) {
            return 0.0;
        }
        if (empresaRh.getAliquotaPis() <= 0.0) {
            return 0.0;
        }
        Double valorPis = ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * empresaRh.getAliquotaPis() / 100.0), (int)2);
        return valorPis;
    }
}

