/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ParametrizacaoContabilizacaoFolha;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionPlanoContaEventoNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;

public class UtilContabilizarRPA {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public void gerarLancamentoRPA(GeracaoReciboRpa vo) throws ExceptionPlanoContaEventoNotFound, ExceptionService {
        PlanoContaImpostoFolha pp;
        CentroCusto centroCusto = vo.getColaborador().getCentroCusto();
        TipoCalculoEvento tipoCalculo = vo.getTipoCalculoEvento();
        Short tipoFolha = EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue();
        TipoColaborador tipoColaborador = vo.getColaborador().getTipoColaborador();
        Double valorRPA = vo.getValorRpa();
        Double inss = vo.getVlrInss();
        Double irrf = vo.getVlrIrrf();
        PlanoConta planoContaDebito = null;
        PlanoConta planoContaCredito = null;
        HistoricoPadrao h = null;
        if (valorRPA <= 0.0) {
            return;
        }
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLote(), vo.getPeriodoFolha(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.RECIBO_AUTONOMO);
        List ret = CoreDAOFactory.getInstance().getDAOParamContabilizacaoFolha().findParamFolhaRPA(centroCusto, tipoColaborador, tipoFolha, tipoCalculo);
        if (ret.size() > 1) {
            String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\nEvento : " + tipoCalculo.getEvento().getDescricao() + "\nTipo de colaborador: " + tipoColaborador.getDescricao() + "\nTipo de Folha: Folha de Pagamento \nIdentificadores: ";
            for (Object obj : ret) {
                ParametrizacaoContabilizacaoFolha p = (ParametrizacaoContabilizacaoFolha)obj;
                retorno = retorno + " " + p.getIdentificador().toString() + ";";
            }
            throw new ExceptionPlanoContaEventoNotFound(retorno);
        }
        if (ret.isEmpty() || ret.size() == 0) {
            throw new ExceptionPlanoContaEventoNotFound("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\nEvento : " + tipoCalculo.getEvento().getDescricao() + "\nTipo de colaborador: " + tipoColaborador.getDescricao() + "\nTipo de Folha: Folha de Pagamento");
        }
        ParametrizacaoContabilizacaoFolha p = (ParametrizacaoContabilizacaoFolha)ret.get(0);
        planoContaCredito = p.getPlanoContaCredito();
        planoContaDebito = p.getPlanoContaDebito();
        h = p.getHistorico();
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        l.setHistorico("Valor RPA do colaborador: " + vo.getColaborador().toString() + " Identificador: " + vo.getIdentificador());
        l.setLoteContabil(lote);
        l.setPlanoContaCred(planoContaCredito);
        l.setPlanoContaDeb(planoContaDebito);
        l.setValor(valorRPA);
        lote.getLancamentos().add(l);
        if (inss > 0.0) {
            ret = new UtilCalculoProvisaoFerias().getPlanoContaImpostoProvFerias(centroCusto);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\n  Id: ";
                for (Object obj : ret) {
                    PlanoContaImpostoFolha pp2 = (PlanoContaImpostoFolha)obj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionService(retorno);
            }
            if (ret.isEmpty() || ret.size() == 0) {
                throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O DE IMPOSTO PARA: \nCentro de custo: " + centroCusto.getNome());
            }
            pp = (PlanoContaImpostoFolha)ret.get(0);
            l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            l.setHistorico("Inss RPA do colaborador: " + vo.getColaborador().toString() + " Identificador: " + vo.getIdentificador());
            l.setPlanoContaCred(pp.getPlanoCCCreditoInssFolha());
            l.setPlanoContaDeb(pp.getPlanoCCDebitoInssFolha());
            l.setValor(inss);
            lote.getLancamentos().add(l);
        }
        if (irrf > 0.0) {
            ret = new UtilCalculoProvisaoFerias().getPlanoContaImpostoProvFerias(centroCusto);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\n  Id: ";
                for (Object obj : ret) {
                    PlanoContaImpostoFolha pp3 = (PlanoContaImpostoFolha)obj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionService(retorno);
            }
            if (ret.isEmpty() || ret.size() == 0) {
                throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O DE IMPOSTO PARA: \nCentro de custo: " + centroCusto.getNome());
            }
            pp = (PlanoContaImpostoFolha)ret.get(0);
            l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            l.setHistorico("IRRF RPA do colaborador: " + vo.getColaborador().toString() + " Identificador: " + vo.getIdentificador());
            l.setPlanoContaCred(pp.getPlanoCCCreditoIrrfFolha());
            l.setPlanoContaDeb(pp.getPlanoCCDebitoIrrfFolha());
            l.setValor(irrf);
            lote.getLancamentos().add(l);
        }
        if (!lote.getLancamentos().isEmpty()) {
            vo.setLote(lote);
        }
    }
}

