/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;

public class UtilLancamentoGerencialProvisaoDecimoTerceiro {
    public static void integrandoLancamentosGerenciaisProvisaoDecimoTerceiro(ProvisaoDec provisao) throws ExceptionService {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        for (ItemProvisaoDec item : provisao.getItensProvisoes()) {
            LancamentoCtbGerencial lanc;
            String historico;
            PlanoContaGerencial planoConta;
            Double valor;
            Short tipoLancamento;
            CentroCusto cc = item.getColaborador().getCentroCusto();
            List ret = new UtilCalculoProvisaoFerias().getPlanoContaImpostoProvFerias(cc);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome() + "\n  Id: ";
                for (Object obj : ret) {
                    PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)obj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionService(retorno);
            }
            if (ret.isEmpty() || ret.size() == 0) {
                throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome());
            }
            PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)ret.get(0);
            if (item.getVlrDec() > 0.0) {
                if (p.getPlanoCGDecSalarioProv() == null || p.getHistoricoDecSalarioProv() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n" + "Valores Decimo Terceiro ".toUpperCase() + "\nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrDec();
                planoConta = p.getPlanoCGDecSalarioProv();
                historico = p.getHistoricoDecSalarioProv().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssEmpresa() > 0.0) {
                if (p.getPlanoCGInssDecProv() == null || p.getHistoricoInssDecProv() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nINSS PARTE EMPRESA : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssEmpresa();
                planoConta = p.getPlanoCGInssDecProv();
                historico = p.getHistoricoInssDecProv().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrFgts() > 0.0) {
                if (p.getPlanoCGFgtsDecProv() == null || p.getHistoricoFgtsDecProv() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nFGTS : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrFgts();
                planoConta = p.getPlanoCGFgtsDecProv();
                historico = p.getHistoricoFgtsDecProv().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssTerceiros() > 0.0) {
                if (p.getPlanoCGTerceirosDecProv() == null || p.getHistoricoTerceirosProvDec() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE TERCEIROS : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssTerceiros();
                planoConta = p.getPlanoCGTerceirosDecProv();
                historico = p.getHistoricoTerceirosProvDec().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrRat() > 0.0) {
                if (p.getPlanoCGRatDecProv() == null || p.getHistoricoRatDecProv() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE RAT : \n IDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrRat();
                planoConta = p.getPlanoCGRatDecProv();
                historico = p.getHistoricoRatDecProv().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (!(item.getVlrAposentadoria25Anos() > 0.0)) continue;
            if (p.getPlanoCGRatDecProv() == null || p.getHistoricoRatDecProv() == null) {
                throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \n" + "Centro de custo: ".toUpperCase() + cc.getNome() + "\n RAT : \nIDENTIFICADOR: " + p.getIdentificador());
            }
            tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
            valor = item.getVlrAposentadoria25Anos();
            planoConta = p.getPlanoCGRatDecProv();
            historico = p.getHistoricoRatDecProv().getDescricao();
            lanc = UtilLancamentoGerencialProvisaoDecimoTerceiro.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            lancs.add(lanc);
        }
        provisao.setLancsGerencial(lancs);
    }

    private static LancamentoCtbGerencial criarLancamentoGerencial(Short tipoLancamento, Double valor, String historico, CentroCusto centroCusto, PlanoContaGerencial planoConta, Date dataCadastro, Timestamp dataAtualizacao, Empresa empresa, Short gerado) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataCadastro, dataCadastro, tipoLancamento, empresa, gerado, historico, planoConta, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return l;
    }
}

