/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;

public class UtilLancamentoGerencialProvisaoFerias {
    public static void integrandoLancamentosGerenciaisProvisaoFerias(ProvisaoFerias provisao) throws ExceptionService {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        for (ItemProvisaoFerias item : provisao.getItensProvisoes()) {
            LancamentoCtbGerencial lanc;
            String historico;
            PlanoContaGerencial planoConta;
            Double valor;
            Short tipoLancamento;
            CentroCusto cc = item.getColaborador().getCentroCusto();
            List ret = new UtilCalculoProvisaoFerias().getPlanoContaImpostoProvFerias(cc);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome() + "\n  Id: ";
                for (Object obj : ret) {
                    PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)obj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionService(retorno);
            }
            if (ret.isEmpty() || ret.size() == 0) {
                throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome());
            }
            PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)ret.get(0);
            Double valorFerias = item.getVlrFerias() + item.getVlrFerias13();
            if (valorFerias > 0.0) {
                if (p.getPlanoCGFeriasProv() == null || p.getHistoricoFeriasProv() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n" + "Valores de Ferias e/ou 1\u0003 ferias ".toUpperCase() + "\nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = valorFerias;
                planoConta = p.getPlanoCGFeriasProv();
                historico = p.getHistoricoFeriasProv().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssEmpresa() > 0.0) {
                if (p.getPlanoCGInssProvFerias() == null || p.getHistoricoInssProvFerias() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nINSS PARTE EMPRESA : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssEmpresa();
                planoConta = p.getPlanoCGInssProvFerias();
                historico = p.getHistoricoInssProvFerias().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrFgts() > 0.0) {
                if (p.getPlanoCGFgtsProvFerias() == null || p.getHistoricoFgtsProvFerias() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nFGTS : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrFgts();
                planoConta = p.getPlanoCGFgtsProvFerias();
                historico = p.getHistoricoFgtsProvFerias().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssTerceiros() > 0.0) {
                if (p.getPlanoCGTerceirosProvFerias() == null || p.getHistoricoTerceirosProvFerias() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE TERCEIROS : \nIDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssTerceiros();
                planoConta = p.getPlanoCGTerceirosProvFerias();
                historico = p.getHistoricoTerceirosProvFerias().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrRat() > 0.0) {
                if (p.getPlanoCGRatProvFerias() == null || p.getHistoricoRatProvFerias() == null) {
                    throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE RAT : \n IDENTIFICADOR: " + p.getIdentificador());
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrRat();
                planoConta = p.getPlanoCGRatProvFerias();
                historico = p.getHistoricoRatProvFerias().getDescricao();
                lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (!(item.getVlrAposentadoria25() > 0.0)) continue;
            if (p.getPlanoCGRatProvFerias() == null || p.getHistoricoRatProvFerias() == null) {
                throw new ExceptionService("N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \n" + "Centro de custo: ".toUpperCase() + cc.getNome() + "\n RAT : \nIDENTIFICADOR: " + p.getIdentificador());
            }
            tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
            valor = item.getVlrAposentadoria25();
            planoConta = p.getPlanoCGRatProvFerias();
            historico = p.getHistoricoRatProvFerias().getDescricao();
            lanc = UtilLancamentoGerencialProvisaoFerias.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            lancs.add(lanc);
        }
        provisao.setLancsGerencial(lancs);
    }

    private static LancamentoCtbGerencial criarLancamentoGerencial(Short tipoLancamento, Double valor, String historico, CentroCusto centroCusto, PlanoContaGerencial planoConta, Date dataCadastro, Timestamp dataAtualizacao, Empresa empresa, Short gerado) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataCadastro, dataCadastro, tipoLancamento, empresa, gerado, historico, planoConta, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return l;
    }
}

