/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoDecimoTerceiro;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilLancamentoProvisaoDec {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(ProvisaoDec vo, Short ajustarContaInss, Short empresaDesonerada) throws ExceptionService, SQLException {
        LoteContabil lote = this.contabilizarProvisaoDec(vo, ajustarContaInss, empresaDesonerada);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    public LoteContabil contabilizarProvisaoDec(ProvisaoDec vo, Short ajustarContaInss, Short empresaDesonerada) throws ExceptionService, SQLException {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), vo.getPeriodo(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.PROVISAO_DEC);
        List centroCustos = this.findCentroCustos(vo);
        for (CentroCusto centroCusto : centroCustos) {
            Double vrDec = 0.0;
            Double vrInssEmpresa = 0.0;
            Double vrInssTerceiros = 0.0;
            Double vrFgts = 0.0;
            Double vrRat = 0.0;
            Double vrAposentadoria = 0.0;
            HashMap valores = this.findValoresProvisao(vo.getPeriodo(), centroCusto, vo);
            vrDec = (Double)valores.get("VR_DEC");
            vrInssEmpresa = (Double)valores.get("VR_INSS_EMPRESA");
            vrInssTerceiros = (Double)valores.get("VR_INSS_TERCEIROS");
            vrFgts = (Double)valores.get("VR_FGTS");
            vrRat = (Double)valores.get("VR_RAT");
            vrAposentadoria = (Double)valores.get("VR_APOSENTADORIA");
            this.criarLancamentosPorCentroCusto(lote, centroCusto, vrDec, vrInssEmpresa, vrInssTerceiros, vrFgts, vrRat, vrAposentadoria, ajustarContaInss, empresaDesonerada, vo.getEmpresa());
        }
        this.verificarSaldoAnterior(lote, vo.getEmpresa());
        return lote;
    }

    private List findCentroCustos(ProvisaoDec vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct i.colaborador.centroCusto  from ItemProvisaoDec i where i.provisao = :provisao";
        Query q = s.createQuery(hql);
        q.setEntity("provisao", (Object)vo);
        return q.list();
    }

    private HashMap findValoresProvisao(Date periodo, CentroCusto c, ProvisaoDec provisaoDec) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select coalesce(sum(i.vlrDec),0)                 as VR_DEC,   coalesce(sum(i.vlrInssEmpresa),0)                 as VR_INSS_EMPRESA,   coalesce(sum(i.vlrInssTerceiros),0)               as VR_INSS_TERCEIROS,   coalesce(sum(i.vlrFgts),0)                        as VR_FGTS,   coalesce(sum(i.vlrRat),0)                         as VR_RAT,  coalesce(sum(i.vlrAposentadoria25Anos),0)         as VR_APOSENTADORIA  from ItemProvisaoDec i where i.provisao.periodo = :periodo and i.colaborador.centroCusto = :centroCusto and i.provisao = :provisaoDec";
        Query q = s.createQuery(hql);
        q.setDate("periodo", periodo);
        q.setEntity("centroCusto", (Object)c);
        q.setEntity("provisaoDec", (Object)provisaoDec);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    private Date getDataAnterior(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        g.add(2, -1);
        return g.getTime();
    }

    private void getLancamento(Double valor, PlanoConta planoCredito, PlanoConta planoDebito, HistoricoPadrao historicoPadrao, LoteContabil lote, Empresa emp) {
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!lancamento.getPlanoContaDeb().equals((Object)planoDebito) || !lancamento.getPlanoContaCred().equals((Object)planoCredito)) continue;
            lancamento.setValor(Double.valueOf(lancamento.getValor() + valor));
            return;
        }
        Lancamento vo = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)emp);
        vo.setValor(valor);
        vo.setPlanoContaDeb(planoDebito);
        vo.setPlanoContaCred(planoCredito);
        vo.setHistoricoPadrao(historicoPadrao);
        vo.setHistorico(historicoPadrao.getDescricao());
        lote.getLancamentos().add(vo);
    }

    private void criarLancamentosPorCentroCusto(LoteContabil lote, CentroCusto centroCusto, Double vrDec, Double vrInssEmpresa, Double vrInssTerceiros, Double vrFgts, Double vrRat, Double vrAposentadoria, Short ajustarContaInss, Short empresaDesonerada, Empresa emp) throws ExceptionService {
        List ret = new UtilCalculoProvisaoDecimoTerceiro().getPlanoContaImpostoProvisaoDec(centroCusto);
        if (ret.size() > 1) {
            String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + " para Provis\u00e3o de Dec. Terceiro ";
            for (Object obj : ret) {
                PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)obj;
                retorno = retorno + " " + p.getIdentificador().toString() + ";";
            }
            throw new ExceptionService(retorno);
        }
        if (ret.isEmpty() || ret.size() == 0) {
            throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + " para a Provis\u00e3o de Dec. Terceiro");
        }
        PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)ret.get(0);
        if (vrDec > 0.0) {
            if (p.getPlanoCCCreditoDecSalarioProv() != null && p.getPlanoCCDebitoDecSalarioProv() != null) {
                this.getLancamento(vrDec, p.getPlanoCCCreditoDecSalarioProv(), p.getPlanoCCDebitoDecSalarioProv(), p.getHistoricoDecSalarioProv(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de D\u00e9cimo Sal\u00e1rio encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
        if (vrInssEmpresa > 0.0 || ajustarContaInss.equals((short)1) && empresaDesonerada.equals((short)1)) {
            if (p.getPlanoCCCreditoInssDecProv() != null && p.getPlanoCCDebitoInssDecProv() != null) {
                this.getLancamento(vrInssEmpresa, p.getPlanoCCCreditoInssDecProv(), p.getPlanoCCDebitoInssDecProv(), p.getHistoricoInssDecProv(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Empresa encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
        if (vrInssTerceiros > 0.0) {
            if (p.getPlanoCCCreditoTerceirosDecProv() != null && p.getPlanoCCDebitoTerceirosDecProv() != null) {
                this.getLancamento(vrInssTerceiros, p.getPlanoCCCreditoTerceirosDecProv(), p.getPlanoCCDebitoTerceirosDecProv(), p.getHistoricoTerceirosProvDec(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Terceiros encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
        if (vrFgts > 0.0) {
            if (p.getPlanoCCCreditoFgtsDecProv() != null && p.getPlanoCCDebitoFgtsDecProv() != null) {
                this.getLancamento(vrFgts, p.getPlanoCCCreditoFgtsDecProv(), p.getPlanoCCDebitoFgtsDecProv(), p.getHistoricoFgtsDecProv(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de FGTS encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
        if (vrRat > 0.0) {
            if (p.getPlanoCCCreditoRatDecProv() != null && p.getPlanoCCDebitoRatDecProv() != null) {
                this.getLancamento(vrRat, p.getPlanoCCCreditoRatDecProv(), p.getPlanoCCDebitoRatDecProv(), p.getHistoricoRatDecProv(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
        if (vrAposentadoria > 0.0) {
            if (p.getPlanoCCCreditoRatDecProv() != null && p.getPlanoCCDebitoRatDecProv() != null) {
                this.getLancamento(vrAposentadoria, p.getPlanoCCCreditoRatDecProv(), p.getPlanoCCDebitoRatDecProv(), p.getHistoricoRatDecProv(), lote, emp);
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + centroCusto.getCodigo() + " - " + centroCusto.getNome());
            }
        }
    }

    private void verificarSaldoAnterior(LoteContabil lote, Empresa empresa) throws ExceptionService, SQLException {
        ArrayList<Lancamento> aux = new ArrayList<Lancamento>();
        for (Lancamento lancamento : lote.getLancamentos()) {
            Date data = lote.getDataLote();
            SaldoContaContabil saldo = new CoreDAOFactory().getDAOSaldoConta().findSaldoContaUnica(lancamento.getPlanoContaCred().getCodigo(), data, data, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador(), null, null, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL);
            if (lancamento.getValor() == 0.0 && saldo.getSaldoAtual() * -1.0 == 0.0) continue;
            if (lancamento.getValor() > saldo.getSaldoAtual() * -1.0) {
                Double valorLancamento = ContatoFormatUtil.arrredondarNumero((Double)(lancamento.getValor() - saldo.getSaldoAtual() * -1.0), (int)2);
                lancamento.setValor(valorLancamento);
                aux.add(lancamento);
                continue;
            }
            this.tratarReversao(lancamento, saldo);
            aux.add(lancamento);
        }
        lote.setLancamentos(aux);
    }

    private void tratarReversao(Lancamento lancamento, SaldoContaContabil saldo) {
        PlanoConta contaCredito = lancamento.getPlanoContaDeb();
        PlanoConta contaDebito = lancamento.getPlanoContaCred();
        Double valorLancamento = ContatoFormatUtil.arrredondarNumero((Double)(saldo.getSaldoAtual() * -1.0 - lancamento.getValor()), (int)2);
        lancamento.setPlanoContaCred(contaCredito);
        lancamento.setPlanoContaDeb(contaDebito);
        lancamento.setValor(valorLancamento);
    }
}

