/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.provisoes;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.provisoes.UtilCalculoProvisaoFerias;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilLancamentoProvisaoFeriasCentroCusto {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(ProvisaoFerias vo, Short ajustarContaInss, Short empresaDesonerada) throws ExceptionService, SQLException {
        LoteContabil lote = this.contabilizarProvisaoFerias(vo, ajustarContaInss, empresaDesonerada);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    public LoteContabil contabilizarProvisaoFerias(ProvisaoFerias vo, Short ajustarContaInss, Short empresaDesonerada) throws ExceptionService, SQLException {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), vo.getPeriodo(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.PROVISAO_FERIAS);
        List colaboradores = this.findCentroCustos(vo);
        for (Colaborador colaborador : colaboradores) {
            HashMap valores = this.findValoresProvisaoAnterior(vo.getPeriodo(), colaborador, vo);
            Double vlrFerias = (Double)valores.get("VR_FERIAS");
            Double vlrUmTercFerias = (Double)valores.get("VR_UM_TERC_FERIAS");
            Double vrInssEmpresa = (Double)valores.get("VR_INSS_EMPRESA");
            Double vrInssTerceiros = (Double)valores.get("VR_INSS_TERCEIROS");
            Double vrFgts = (Double)valores.get("VR_FGTS");
            Double vrRat = (Double)valores.get("VR_RAT");
            Double vrAposentadoria = (Double)valores.get("VR_APOSENTADORIA");
            this.criarLancamentosPorCentroCusto(lote, colaborador, vlrFerias, vlrUmTercFerias, vrInssEmpresa, vrInssTerceiros, vrFgts, vrRat, vrAposentadoria, ajustarContaInss, empresaDesonerada);
        }
        this.verificarSaldoContaAnterior(lote, vo.getEmpresa());
        this.verificarLancamentosZerados(lote);
        return lote;
    }

    private List findCentroCustos(ProvisaoFerias vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct i.colaborador  from ItemProvisaoFerias i where i.provisao = :provisao";
        Query q = s.createQuery(hql);
        q.setEntity("provisao", (Object)vo);
        return q.list();
    }

    private HashMap findValoresProvisaoAnterior(Date periodo, Colaborador c, ProvisaoFerias provisaoFerias) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select coalesce(sum(i.vlrFerias),0)   as VR_FERIAS,    coalesce(sum(i.vlrFerias13),0)        as VR_UM_TERC_FERIAS ,   coalesce(sum(i.vlrInssEmpresa),0)     as VR_INSS_EMPRESA,    coalesce(sum(i.vlrInssTerceiros),0)   as VR_INSS_TERCEIROS,    coalesce(sum(i.vlrFgts),0)            as VR_FGTS ,    coalesce(sum(i.vlrRat),0)             as VR_RAT,    coalesce(sum(i.vlrAposentadoria25),0) as VR_APOSENTADORIA    from ItemProvisaoFerias i   where i.provisao.periodo = :periodo   and i.colaborador = :colaborador   and i.provisao = :provisaoFerias";
        Query q = s.createQuery(hql);
        q.setDate("periodo", periodo);
        q.setEntity("colaborador", (Object)c);
        q.setEntity("provisaoFerias", (Object)provisaoFerias);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    private void getLancamento(Double valor, PlanoConta planoCredito, PlanoConta planoDebito, HistoricoPadrao historicoPadrao, LoteContabil lote, CentroResultadoContFin centroResultado, Empresa emp) {
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!lancamento.getPlanoContaCred().equals((Object)planoCredito) || !lancamento.getPlanoContaDeb().equals((Object)planoDebito) || !lancamento.getCentroResultadoContFin().equals((Object)centroResultado)) continue;
            lancamento.setValor(Double.valueOf(lancamento.getValor() + valor));
            return;
        }
        Lancamento vo = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)emp);
        vo.setValor(valor);
        vo.setPlanoContaDeb(planoDebito);
        vo.setPlanoContaCred(planoCredito);
        vo.setHistoricoPadrao(historicoPadrao);
        vo.setHistorico(historicoPadrao.getDescricao());
        lote.getLancamentos().add(vo);
    }

    private void criarLancamentosPorCentroCusto(LoteContabil lote, Colaborador colaborador, Double vlrFerias, Double vlrUmTercFerias, Double vrInssEmpresa, Double vrInssTerceiros, Double vrFgts, Double vrRat, Double vrAposentadoria, Short ajustarContaInss, Short empresaDesonerada) throws ExceptionService {
        List ret = new UtilCalculoProvisaoFerias().getPlanoContaImpostoProvFerias(colaborador.getCentroCusto());
        if (ret.size() > 1) {
            String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome() + "\n  Id: ";
            for (Object obj : ret) {
                PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)obj;
                retorno = retorno + " " + p.getIdentificador().toString() + ";";
            }
            throw new ExceptionService(retorno);
        }
        if (ret.isEmpty() || ret.size() == 0) {
            throw new ExceptionService("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome());
        }
        PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)ret.get(0);
        if (vlrFerias > 0.0) {
            if (p.getPlanoCCCreditoFeriasProv() != null && p.getPlanoCCDebitoFeriasProv() != null) {
                this.getLancamento(vlrFerias, p.getPlanoCCCreditoFeriasProv(), p.getPlanoCCDebitoFeriasProv(), p.getHistoricoFeriasProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de Ferias  encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vlrUmTercFerias > 0.0) {
            if (p.getPlanoCCCreditoTercProvFerias() != null && p.getPlanoCCdebitoUmTercProvFerias() != null) {
                this.getLancamento(vlrUmTercFerias, p.getPlanoCCCreditoTercProvFerias(), p.getPlanoCCdebitoUmTercProvFerias(), p.getHistoricoUmTercFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de  1/3 de Ferias  encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vrInssEmpresa > 0.0 || ajustarContaInss.equals((short)1) && empresaDesonerada.equals((short)1)) {
            if (p.getPlanoCCCreditoInssProvFerias() != null && p.getPlanoCCDebitoInssProvFerias() != null) {
                this.getLancamento(vrInssEmpresa, p.getPlanoCCCreditoInssProvFerias(), p.getPlanoCCDebitoInssProvFerias(), p.getHistoricoInssProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Empresa encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vrInssTerceiros > 0.0) {
            if (p.getPlanoCCCreditoTerceirosProvFerias() != null && p.getPlanoCCDebitoTerceirosProvFerias() != null) {
                this.getLancamento(vrInssTerceiros, p.getPlanoCCCreditoTerceirosProvFerias(), p.getPlanoCCDebitoTerceirosProvFerias(), p.getHistoricoTerceirosProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Terceiros encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vrFgts > 0.0) {
            if (p.getPlanoCCCreditoFgtsProvFerias() != null && p.getPlanoCCDebitoFgtsProvFerias() != null) {
                this.getLancamento(vrFgts, p.getPlanoCCCreditoFgtsProvFerias(), p.getPlanoCCDebitoFgtsProvFerias(), p.getHistoricoFgtsProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de FGTS encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vrRat > 0.0) {
            if (p.getPlanoCCCreditoRatProvFerias() != null && p.getPlanoCCDebitoRatProvFerias() != null) {
                this.getLancamento(vrRat, p.getPlanoCCCreditoRatProvFerias(), p.getPlanoCCDebitoRatProvFerias(), p.getHistoricoRatProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
        if (vrAposentadoria > 0.0) {
            if (p.getPlanoCCCreditoRatProvFerias() != null && p.getPlanoCCDebitoRatProvFerias() != null) {
                this.getLancamento(vrAposentadoria, p.getPlanoCCCreditoRatProvFerias(), p.getPlanoCCDebitoRatProvFerias(), p.getHistoricoRatProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionService("Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome());
            }
        }
    }

    private void verificarSaldoContaAnterior(LoteContabil lote, Empresa empresa) throws ExceptionService, SQLException {
        ArrayList<Lancamento> aux = new ArrayList<Lancamento>();
        for (Lancamento lancamento : lote.getLancamentos()) {
            Date data = lote.getDataLote();
            SaldoContaContabil saldo = new CoreDAOFactory().getDAOSaldoConta().findSaldoContaUnica(lancamento.getPlanoContaCred().getCodigo(), data, data, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador(), lancamento.getCentroResultadoContFin().getIdentificador(), lancamento.getCentroResultadoContFin().getIdentificador(), EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO);
            if (lancamento.getValor() == 0.0 && saldo.getSaldoAtual() * -1.0 == 0.0) continue;
            if (lancamento.getValor() >= saldo.getSaldoAtual() * -1.0) {
                Double valorLancamento = ContatoFormatUtil.arrredondarNumero((Double)(lancamento.getValor() - saldo.getSaldoAtual() * -1.0), (int)2);
                lancamento.setValor(valorLancamento);
                aux.add(lancamento);
                continue;
            }
            this.tratarReversao(lancamento, saldo);
            aux.add(lancamento);
        }
        lote.setLancamentos(aux);
    }

    private void tratarReversao(Lancamento lancamento, SaldoContaContabil saldo) {
        PlanoConta contaCredito = lancamento.getPlanoContaDeb();
        PlanoConta contaDebito = lancamento.getPlanoContaCred();
        Double valorLancamento = ContatoFormatUtil.arrredondarNumero((Double)(saldo.getSaldoAtual() * -1.0 - lancamento.getValor()), (int)2);
        lancamento.setPlanoContaCred(contaCredito);
        lancamento.setPlanoContaDeb(contaDebito);
        lancamento.setValor(valorLancamento);
    }

    private void verificarLancamentosZerados(LoteContabil lote) {
        ArrayList<Lancamento> lancs = new ArrayList<Lancamento>();
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!(lancamento.getValor() > 0.0)) continue;
            lancs.add(lancamento);
        }
        lote.setLancamentos(lancs);
    }
}

