/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.rateiovaloresdirf;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.ItemCadastroDependentePlanoSaude;
import com.touchcomp.basementor.model.vo.ItemCadastroRateioValorPlanoSaude;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityRateioValoresPlanoSaude {
    public List findColaboradoresComPlanoSaude(TipoCalculoEvento tipoCalculo, Date periodo, Long empresa) throws ExceptionService {
        this.verificarParametrizacaoDirf(tipoCalculo);
        String hql = " select  item.valor as valorPlano ,  item.movimentoFolha.colaborador.identificador as idColaborador  from ItemMovimentoFolha item  where  item.movimentoFolha.aberturaPeriodo.dataFinal = :periodoInicial  and  item.eventoColaborador.tipoCalculoEvento = :tipoCalculo  and  item.movimentoFolha.empresa.identificador = :empresa  order by item.movimentoFolha.colaborador.pessoa.nome ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("tipoCalculo", (Object)tipoCalculo).setDate("periodoInicial", periodo).setLong("empresa", empresa.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<HashMap> colaboradoresPlanoSaude = new ArrayList<HashMap>();
        for (Object obj : l) {
            HashMap hashMap = (HashMap)obj;
            Long idColaborador = (Long)hashMap.get("idColaborador");
            Colaborador c = (Colaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOColaborador(), "identificador", idColaborador, 0);
            hashMap.put("colaborador", c);
            colaboradoresPlanoSaude.add(hashMap);
        }
        ArrayList<ItemCadastroRateioValorPlanoSaude> retorno = new ArrayList<ItemCadastroRateioValorPlanoSaude>();
        for (Object e : colaboradoresPlanoSaude) {
            HashMap h = (HashMap)e;
            ItemCadastroRateioValorPlanoSaude item = new ItemCadastroRateioValorPlanoSaude();
            Colaborador colaborador = (Colaborador)h.get("colaborador");
            Double valorPlano = (Double)h.get("valorPlano");
            item.setValorTotalDescontoPlanoSaude(valorPlano);
            item.setColaborador(colaborador);
            item.setValorPlanoSaudeTitular(valorPlano);
            List dependentes = this.getDependentesPlanoSaude(colaborador, periodo, item);
            item.setItensDepentendes(dependentes);
            retorno.add(item);
        }
        return retorno;
    }

    private void verificarParametrizacaoDirf(TipoCalculoEvento tipoCalculo) throws ExceptionService {
        String hql = " from DeParaTipoEventoDirf dePara  where  dePara.evento = :evento  and  dePara.tipoEventoDirf.codigo = :codigoPlanoSaude ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("evento", (Object)tipoCalculo.getEvento()).setParameter("codigoPlanoSaude", (Object)"PSE").list();
        if (ret == null || ret.isEmpty()) {
            throw new ExceptionService("Evento n\u00e3o est\u00e1 Parametrizado no codigo PSE da DIRF");
        }
    }

    private List getDependentesPlanoSaude(Colaborador colaborador, Date periodo, ItemCadastroRateioValorPlanoSaude item) {
        HelperColaborador helper = (HelperColaborador)Context.get(HelperColaborador.class);
        List deps = helper.build(colaborador).getDependentesPlanoSaude(periodo);
        ArrayList<ItemCadastroDependentePlanoSaude> dependentes = new ArrayList<ItemCadastroDependentePlanoSaude>();
        for (ColaboradorDependente dep : deps) {
            ItemCadastroDependentePlanoSaude itemDep = new ItemCadastroDependentePlanoSaude();
            itemDep.setDependente(dep);
            itemDep.setItemCadastroRateio(item);
            itemDep.setValorPlanoDependente(Double.valueOf(0.0));
            dependentes.add(itemDep);
        }
        return dependentes;
    }

    public List valoresPlanoSaudePersonalizados(List<Colaborador> list, Date periodo) {
        ArrayList<ItemCadastroRateioValorPlanoSaude> retorno = new ArrayList<ItemCadastroRateioValorPlanoSaude>();
        for (Colaborador colab : list) {
            ItemCadastroRateioValorPlanoSaude item = new ItemCadastroRateioValorPlanoSaude();
            Double valorPlano = 0.0;
            item.setValorTotalDescontoPlanoSaude(valorPlano);
            item.setColaborador(colab);
            item.setValorPlanoSaudeTitular(valorPlano);
            List dependentes = this.getDependentesPlanoSaude(colab, periodo, item);
            item.setItensDepentendes(dependentes);
            retorno.add(item);
        }
        return retorno;
    }
}

