/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.rescisao;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilityCadastroRescisao {
    public List findRescisao(Empresa empresa) {
        String hql = " select distinct(r)  from CadastroRecisao r  left join r.empresas e  where  (r.filtrarEmpresa = :nao or e.empresa = :empresa)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("nao", (short)0).setEntity("empresa", (Object)empresa).list();
    }

    public void verificarExistenciaFolhaPagamento(Colaborador colaborador, Date dataAfastamento) throws ExceptionService {
        String hql = " select coalesce(count(m.identificador),0)  from MovimentoFolha m  where  m.colaborador = :colaborador  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  extract(year from m.aberturaPeriodo.periodoApuracao) = :ano  and  extract(month from m.aberturaPeriodo.periodoApuracao) = :mes";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setParameter("ano", (Object)DateUtil.yearFromDate(dataAfastamento)).setParameter("mes", (Object)DateUtil.monthFromDate(dataAfastamento)).uniqueResult();
        if (ret != null && ret > 0L) {
            throw new ExceptionService("Existe uma Folha de Pagamento para este Colaborador na competencia de Desligamento. Fa\u00e7a a Exclus\u00e3o");
        }
    }
}

