/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.rescisao;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.BaseInssEscalonada;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemRecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.ItemTabelaINSS;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRF;
import com.touchcomp.basementor.model.vo.RecisaoComplementar;
import com.touchcomp.basementor.model.vo.RecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityCalculoRecisaoComplementarEsocial {
    public List folhaComplementarRecisaoEsocial(Colaborador colaborador, Date periodoInicial, Date periodoFinal) throws ExceptionService {
        String hql = " select item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  item.movimentoFolha.aberturaPeriodo.periodoApuracao as PERIODO,  item.valor as VALOR  from ItemMovimentoFolha item  where  item.movimentoFolha.aberturaPeriodo.periodoApuracao between :periodoInicial and :periodoFinal  and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento.compoeDissidioColetivo = :sim  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento   and  item.movimentoFolha.statusFolha.codigo != :desligamento ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setParameter("desligamento", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setShort("sim", (short)1).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        for (Object object : ret) {
            HashMap h = (HashMap)object;
            Long idEvento = (Long)h.get("ID_EVENTO");
            TipoCalculoEvento tp = (TipoCalculoEvento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoCalculoEvento(), "identificador", idEvento, 0);
            h.put("TP_EVENTO", tp);
        }
        return ret;
    }

    public void findValoresBasesIrrfPeriodo(Colaborador colaborador, Date dataPagamento, HashMap h) {
        String hql = " select  coalesce(sum(mov.bcIrrfSalario),0) as BC_IRRF , coalesce(sum(mov.vrIrrfSalario),0) as VLR_IRRF,  coalesce(sum(mov.bcInss13Sal),0) - coalesce(sum(mov.vrInss13Sal),0) as BC_IRRF_DEC , coalesce(sum(mov.vrIrrf13Sal),0) as VLR_IRRF_DEC  from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  extract(year from mov.aberturaPeriodo.dataPagamento) = :ano  and  extract(month from mov.aberturaPeriodo.dataPagamento) = :mes  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  mov.statusFolha.codigo != :rescisao ";
        HashMap hh = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("ano", (Object)DateUtil.yearFromDate(dataPagamento)).setParameter("mes", (Object)DateUtil.monthFromDate(dataPagamento)).setParameter("rescisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (hh != null) {
            h.put("BC_IRRF", hh.get("BC_IRRF"));
            h.put("VLR_IRRF_DEC", hh.get("VLR_IRRF_DEC"));
            h.put("BC_IRRF_DEC", hh.get("BC_IRRF_DEC"));
            h.put("VLR_IRRF", hh.get("VLR_IRRF"));
        }
    }

    public void findValoresBasesInssPeriodo(Colaborador colaborador, Date periodoApuracao, HashMap h) {
        String hql = " select  coalesce(sum(mov.bcInssSalario),0) + coalesce(sum(mov.bcInssFerias),0) as BC_INSS , coalesce(sum(mov.vrInss13Sal),0) as VLR_INSS_DEC,  coalesce(sum(mov.bcInss13Sal),0)  as BC_INSS_DEC , coalesce(sum(mov.vrInssSalario),0) + coalesce(sum(mov.vrInssFerias),0) as VLR_INSS  from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  extract(year from mov.aberturaPeriodo.periodoApuracao) = :ano  and  extract(month from mov.aberturaPeriodo.periodoApuracao) = :mes  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  mov.statusFolha.codigo != :rescisao ";
        HashMap hh = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("ano", (Object)DateUtil.yearFromDate(periodoApuracao)).setParameter("mes", (Object)DateUtil.monthFromDate(periodoApuracao)).setParameter("rescisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (hh != null) {
            h.put("BC_INSS", hh.get("BC_INSS"));
            h.put("VLR_INSS_DEC", hh.get("VLR_INSS_DEC"));
            h.put("BC_INSS_DEC", hh.get("BC_INSS_DEC"));
            h.put("VLR_INSS", hh.get("VLR_INSS"));
        }
    }

    public List calcularImpostoComplementar(List<RecisaoComplementarPeriodo> listaValores, Date dataPagamento) throws ExceptionService {
        TabelaINSS tabelaInss = this.getTabelaInss(dataPagamento);
        if (tabelaInss == null) {
            throw new ExceptionService("Tabela de Inss n\u00e3o encontrada.");
        }
        TabelaIRRF tabelaIrrf = this.getTabelaIrrf(dataPagamento);
        if (tabelaIrrf == null) {
            throw new ExceptionService("Tabela de Irrf n\u00e3o encontrada.");
        }
        for (RecisaoComplementarPeriodo r : listaValores) {
            this.getBaseInss(r);
            this.calcularValorInss(r, tabelaInss);
            this.getBaseIrrf(r);
            this.calcularValorIrrf(r, tabelaIrrf);
            this.getBaseFgts(r);
            this.calcularFgts(r);
            this.calcularLiquido(r);
        }
        return listaValores;
    }

    private TabelaINSS getTabelaInss(Date dataPagamento) throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOTabelaINSS().getVOClass());
        bc.and().lessEqual("dataInicial", dataPagamento);
        bc.and().greaterEqual("dataFinal", dataPagamento);
        return (TabelaINSS)CoreService.executeSearchUniqueResult(bc);
    }

    private TabelaIRRF getTabelaIrrf(Date dataPagamento) throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOTabelaIRRF().getVOClass());
        bc.and().lessEqual("dataInicial", dataPagamento);
        bc.and().greaterEqual("dataFinal", dataPagamento);
        return (TabelaIRRF)CoreService.executeSearchUniqueResult(bc);
    }

    private void getBaseInss(RecisaoComplementarPeriodo r) {
        Double baseInssProvento = 0.0;
        Double baseInssDesconto = 0.0;
        Double baseInssDecProvento = 0.0;
        Double baseInssDecDesconto = 0.0;
        for (ItemRecisaoComplementarPeriodo item : r.getRecisaoPeriodo()) {
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseInssDecProvento = baseInssDecProvento + item.getValor();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseInssDecDesconto = baseInssDecDesconto + item.getValor();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseInssProvento = baseInssProvento + item.getValor();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseInssDesconto = baseInssDesconto + item.getValor();
        }
        r.setBaseInss(Double.valueOf(baseInssProvento - baseInssDesconto));
        r.setBaseInssDec(Double.valueOf(baseInssDecProvento - baseInssDecDesconto));
    }

    private void getBaseIrrf(RecisaoComplementarPeriodo r) {
        Double baseIrrfProvento = 0.0;
        Double baseIrrfDesconto = 0.0;
        Double baseIrrfDecProvento = 0.0;
        Double baseIrrfDecDesconto = 0.0;
        for (ItemRecisaoComplementarPeriodo item : r.getRecisaoPeriodo()) {
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseIrrfDecProvento = baseIrrfDecProvento + item.getValor();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseIrrfDecDesconto = baseIrrfDecDesconto + item.getValor();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseIrrfProvento = baseIrrfProvento + item.getValor();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseIrrfDesconto = baseIrrfDesconto + item.getValor();
        }
        r.setBaseIrrf(Double.valueOf(baseIrrfProvento - baseIrrfDesconto));
        r.setBaseIrrfDec(Double.valueOf(baseIrrfDecProvento - baseIrrfDecDesconto));
    }

    private void getBaseFgts(RecisaoComplementarPeriodo r) {
        Double baseFgtsProvento = 0.0;
        Double baseFgtsDesconto = 0.0;
        for (ItemRecisaoComplementarPeriodo item : r.getRecisaoPeriodo()) {
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseFgtsProvento = baseFgtsProvento + item.getValor();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseFgtsDesconto = baseFgtsDesconto + item.getValor();
        }
        r.setBaseFgts(Double.valueOf(baseFgtsProvento - baseFgtsDesconto));
    }

    private static Double getInss(List<BaseInssEscalonada> bases) {
        Double valor = 0.0;
        for (BaseInssEscalonada base : bases) {
            valor = valor + base.getValor();
        }
        return valor;
    }

    private void calcularValorInss(RecisaoComplementarPeriodo r, TabelaINSS tabelaInss) {
        BaseInssEscalonada base;
        BaseInssEscalonada base2;
        Double bcCalculado;
        Double baseTotalInss = 0.0;
        Double baseTotalInssDec = 0.0;
        Double aliquotaInss = 0.0;
        if (r.getBaseInss() == 0.0 && r.getBaseInssDec() == 0.0) {
            return;
        }
        baseTotalInss = r.getBaseInss() + r.getBaseInssAnterior();
        baseTotalInssDec = r.getBaseInssDec() + r.getBaseInssDecAnterior();
        ArrayList<Object> bases = new ArrayList<BaseInssEscalonada>();
        Double bcInssSobra = ContatoFormatUtil.arrredondarNumero((Double)baseTotalInss, (int)2);
        Double baseAnterior = 0.0;
        boolean menor = false;
        for (ItemTabelaINSS item : tabelaInss.getItensTabelaINSS()) {
            if (baseTotalInss >= item.getValorAte()) {
                bcCalculado = 0.0;
                if (bcInssSobra > item.getValorAte()) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else if (bcInssSobra > item.getValorAte() - baseAnterior) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else {
                    bcCalculado = bcInssSobra;
                    menor = true;
                }
                baseAnterior = item.getValorAte();
                base2 = new BaseInssEscalonada("FOLHA");
                base2.setBaseInss(bcCalculado);
                baseAnterior = item.getValorAte();
                base2.setAliquota(item.getAliquotaInss());
                base2.setValor(UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(base2.getBaseInss() * base2.getAliquota() / 100.0));
                bases.add(base2);
                if (!menor) continue;
                break;
            }
            base = new BaseInssEscalonada("FOLHA");
            base.setBaseInss(bcInssSobra);
            base.setAliquota(item.getAliquotaInss());
            base.setValor(UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(bcInssSobra * base.getAliquota() / 100.0));
            bases.add(base);
            break;
        }
        if (r.getBaseInss() > 0.0) {
            r.setVrInss(ContatoFormatUtil.arrredondarNumero((Double)(UtilityCalculoRecisaoComplementarEsocial.getInss(bases) - r.getVrInssAnterior()), (int)2));
        }
        bases = new ArrayList();
        bcInssSobra = ContatoFormatUtil.arrredondarNumero((Double)baseTotalInssDec, (int)2);
        baseAnterior = 0.0;
        menor = false;
        for (ItemTabelaINSS item : tabelaInss.getItensTabelaINSS()) {
            if (baseTotalInssDec >= item.getValorAte()) {
                bcCalculado = 0.0;
                if (bcInssSobra > item.getValorAte()) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else if (bcInssSobra > item.getValorAte() - baseAnterior) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else {
                    bcCalculado = bcInssSobra;
                    menor = true;
                }
                baseAnterior = item.getValorAte();
                base2 = new BaseInssEscalonada("FOLHA");
                base2.setBaseInss(bcCalculado);
                baseAnterior = item.getValorAte();
                base2.setAliquota(item.getAliquotaInss());
                base2.setValor(UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(base2.getBaseInss() * base2.getAliquota() / 100.0));
                bases.add(base2);
                if (!menor) continue;
                break;
            }
            base = new BaseInssEscalonada("FOLHA");
            base.setBaseInss(bcInssSobra);
            base.setAliquota(item.getAliquotaInss());
            base.setValor(UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(bcInssSobra * base.getAliquota() / 100.0));
            bases.add(base);
            break;
        }
        if (r.getBaseInssDec() > 0.0) {
            r.setVrInssDec(ContatoFormatUtil.arrredondarNumero((Double)(UtilityCalculoRecisaoComplementarEsocial.getInss(bases) - r.getVrInssdecAnterior()), (int)2));
        }
        if (r.getVrInssDec() < 0.0 || r.getVrInssDec() == 0.01) {
            r.setVrInssDec(Double.valueOf(0.0));
        }
    }

    private static Double getTruncarValor(Double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, 1);
        return bd.doubleValue();
    }

    private void calcularValorIrrf(RecisaoComplementarPeriodo r, TabelaIRRF tabelaIrrf) {
        Double totalBaseIrrf = 0.0;
        Double totalBaseIrrfDec = 0.0;
        Double aliquotaIrrf = 0.0;
        Double vrDeducao = 0.0;
        if (r.getBaseIrrf() <= 0.0) {
            return;
        }
        Double vrDependente = tabelaIrrf.getVrDeducaoPorDependente();
        totalBaseIrrf = r.getBaseIrrf() + r.getBaseIrrfAnterior() + vrDependente * (double)r.getNrDepIrrf().shortValue();
        Double totalDesconto = 0.0;
        totalDesconto = vrDependente * (double)r.getNrDepIrrf().shortValue() + r.getVrInss() > tabelaIrrf.getValorDescontoSimplicado() ? Double.valueOf(vrDependente * (double)r.getNrDepIrrf().shortValue() + r.getVrInss()) : tabelaIrrf.getValorDescontoSimplicado();
        totalBaseIrrf = r.getBaseIrrf() + r.getBaseIrrfAnterior() - totalDesconto;
        totalBaseIrrfDec = r.getBaseIrrfDec() + r.getBaseIrrfDecAnterior() - r.getVrInssDec() - vrDependente * (double)r.getNrDepIrrf().shortValue();
        for (Object o : tabelaIrrf.getItensTabela()) {
            ItemTabelaIRRF i = (ItemTabelaIRRF)o;
            if (!(i.getValorAte() > totalBaseIrrf)) continue;
            aliquotaIrrf = (double)i.getAliquota();
            vrDeducao = (double)i.getVrDeducao();
            break;
        }
        r.setBaseIrrf(totalBaseIrrf);
        r.setAliquotaIrrf(aliquotaIrrf);
        Double vlrIrrf = UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(r.getBaseIrrf() * aliquotaIrrf / 100.0) - r.getVrIrrfAnterior() - vrDeducao;
        if (vlrIrrf < 0.0 || vlrIrrf < tabelaIrrf.getVrMinimoADescontar()) {
            vlrIrrf = 0.0;
        }
        r.setVrIrrf(vlrIrrf);
        for (Object o : tabelaIrrf.getItensTabela()) {
            ItemTabelaIRRF i = (ItemTabelaIRRF)o;
            if (!(i.getValorAte() > totalBaseIrrfDec)) continue;
            aliquotaIrrf = (double)i.getAliquota();
            vrDeducao = (double)i.getVrDeducao();
            break;
        }
        r.setBaseIrrfDec(totalBaseIrrfDec);
        r.setAliquotaIrrfDec(aliquotaIrrf);
        Double vlrIrrfDec = UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(totalBaseIrrfDec * aliquotaIrrf / 100.0) - r.getVrIrrfDecAnterior() - vrDeducao;
        if (vlrIrrfDec < 0.0) {
            vlrIrrfDec = 0.0;
        }
        r.setVrIrrfDec(vlrIrrfDec);
    }

    private void calcularFgts(RecisaoComplementarPeriodo r) {
        r.setVrFgts(UtilityCalculoRecisaoComplementarEsocial.getTruncarValor(r.getBaseFgts() * 8.0 / 100.0));
    }

    private void calcularLiquido(RecisaoComplementarPeriodo r) {
        Double totalProventos = 0.0;
        Double totalDescontos = 0.0;
        Double liquido = 0.0;
        totalDescontos = r.getVrInss() + r.getVrIrrf();
        for (ItemRecisaoComplementarPeriodo item : r.getRecisaoPeriodo()) {
            if (item.getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                totalProventos = totalProventos + item.getValor();
                totalProventos = ToolFormatter.arrredondarNumero((Double)totalProventos, (int)2);
                continue;
            }
            if (!item.getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("2")) continue;
            totalDescontos = totalDescontos + item.getValor();
            totalDescontos = ToolFormatter.arrredondarNumero((Double)totalDescontos, (int)2);
        }
        liquido = ToolFormatter.arrredondarNumero((Double)(totalProventos - totalDescontos), (int)2);
        r.setTotalProventos(totalProventos);
        r.setTotalDescontos(totalDescontos);
        r.setVlrLiquido(liquido);
    }

    public void calcularRubricasRescisaoComplementar(RecisaoComplementar recisaoComplementar, EmpresaRh empresaRh) {
        for (RecisaoComplementarPeriodo recisaoPeriodo : recisaoComplementar.getRecisaoPeriodo()) {
            ArrayList<Rubricas1200> rubricas1200 = new ArrayList<Rubricas1200>();
            ArrayList<Rubricas1210> rubricas1210 = new ArrayList<Rubricas1210>();
            if (recisaoPeriodo.getRubricas1200() == null) {
                recisaoPeriodo.setRubricas1200(new ArrayList());
            }
            if (recisaoPeriodo.getRubricas1210() == null) {
                recisaoPeriodo.setRubricas1210(new ArrayList());
            }
            for (ItemRecisaoComplementarPeriodo item : recisaoPeriodo.getRecisaoPeriodo()) {
                TipoCalculoEvento tp = item.getTipoCalculoEvento();
                if (item.getValor() > 0.0 && (tp.getEsocRubricasFolhaPagamento() == null || !tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA))) {
                    System.err.println(tp.getEvento().getCodigo());
                    rubricas1200.add(new Rubricas1200(tp, item.getValor(), recisaoPeriodo));
                    continue;
                }
                if (!(item.getValor() > 0.0) || !tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                rubricas1210.add(new Rubricas1210(tp, item.getValor(), recisaoPeriodo));
            }
            if (recisaoPeriodo.getVrIrrf() > 0.0) {
                rubricas1210.add(new Rubricas1210(empresaRh.getTpIrrf(), recisaoPeriodo.getVrIrrf(), recisaoPeriodo));
            }
            if (recisaoPeriodo.getVrIrrfDec() > 0.0) {
                rubricas1210.add(new Rubricas1210(empresaRh.getTpIrrfDec(), recisaoPeriodo.getVrIrrfDec(), recisaoPeriodo));
            }
            if (recisaoPeriodo.getVrInss() > 0.0) {
                rubricas1200.add(new Rubricas1200(empresaRh.getTpInss(), recisaoPeriodo.getVrInss(), recisaoPeriodo));
            }
            if (recisaoPeriodo.getVrInssDec() > 0.0) {
                rubricas1200.add(new Rubricas1200(empresaRh.getTpInssDec(), recisaoPeriodo.getVrInssDec(), recisaoPeriodo));
            }
            if (recisaoPeriodo.getVrFgts() > 0.0) {
                rubricas1200.add(new Rubricas1200(empresaRh.getTpFgts(), recisaoPeriodo.getVrFgts(), recisaoPeriodo));
            }
            recisaoPeriodo.setRubricas1200(rubricas1200);
            recisaoPeriodo.setRubricas1210(rubricas1210);
        }
    }
}

