/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.terminocontratotsv;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemTerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.SituacaoColaborador;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceTerminoContratoTSV
extends CoreService {
    public static final String SALVAR_TERMINO_TSV = "salvarTerminoTSV";
    public static final String EXCLUIR_TERMINO_TSV = "excluirRescisao";

    public Object salvarTerminoTSV(CoreRequestContext r) throws ExceptionService, ExceptionDatabase {
        TerminoTrabalhadorSemVinculo vo = (TerminoTrabalhadorSemVinculo)r.getAttribute("vo");
        vo = (TerminoTrabalhadorSemVinculo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOTerminoTrabalhadorSemVinculo(), vo);
        Colaborador colaborador = vo.getColaborador();
        colaborador.setDataDemissao(vo.getDataTermino());
        colaborador.setSituacaoColaborador((SituacaoColaborador)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOSituacaoColaborador(), 3L));
        colaborador = (Colaborador)CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(colaborador);
        return vo;
    }

    public void excluirRescisao(CoreRequestContext request) throws ExceptionService {
        TerminoTrabalhadorSemVinculo vo = (TerminoTrabalhadorSemVinculo)request.getAttribute("vo");
        Date dataPagamento = vo.getDataPagamento();
        ArrayList<EventoColaborador> evts = new ArrayList<EventoColaborador>();
        for (ItemTerminoTrabalhadorSemVinculo item : vo.getItensTerminoTsv()) {
            evts.add(item.getEventoColaborador());
        }
        Colaborador colaborador = vo.getColaborador();
        ServiceTerminoContratoTSV.simpleDelete(CoreDAOFactory.getInstance().getDAOTerminoTrabalhadorSemVinculo(), vo);
        this.deletarEventoColaboradorRecisao(evts, dataPagamento);
        CoreDAOFactory.getInstance().getDAOTerminoTrabalhadorSemVinculo().updateDataDemissaoColaborador(colaborador);
        CoreDAOFactory.getInstance().getDAOTerminoTrabalhadorSemVinculo().updateSituacaoColaborador(colaborador);
    }

    private void deletarEventoColaboradorRecisao(List<EventoColaborador> evts, Date dataPagamento) throws ExceptionService {
        ArrayList<EventoColaborador> aux = new ArrayList<EventoColaborador>();
        for (EventoColaborador evt : evts) {
            System.err.println(evt.getIdentificador());
            if (evt.getDataInicial() != null && evt.getDataInicial().equals(dataPagamento) && evt.getDataFinal().equals(dataPagamento)) {
                aux.add(evt);
                continue;
            }
            System.err.println(" Este n\u00e3o faz parte: " + evt.getTipoCalculoEvento().getEvento().getDescricao());
        }
        for (EventoColaborador eventoColaborador : aux) {
            ServiceTerminoContratoTSV.simpleDelete(CoreDAOFactory.getInstance().getDAOEventoColaborador(), eventoColaborador);
        }
    }
}

