/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rotaclientepedido;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeSituacoes;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.RotaClientePedido;
import com.touchcomp.basementor.model.vo.RotaClientePedidoPedido;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceRotaClientePedido
extends CoreService {
    public static final String FIND_PEDIDOS_POR_FILTROS = "findPedidosPorFiltros";
    public static String SINC_ROTA_CLIENTE_GR_CIDADES = "sincronizaRotaClienteGrCidades";
    public static final String FIND_ROTA_POR_PEDIDO = "findRotaPorPedido";
    public static final String SALVAR_ROTA_GERAR_BONIFICACAO = "salvarRotaGerarBonificacao";
    public static final String FIND_ROTA_CLIENTE_PEDIDO_PEDIDO_POR_PEDIDO = "findRotaClientePedidoPedidoPorPedido";

    public Object findPedidosPorFiltros(CoreRequestContext request) {
        Short filtrarData = (Short)request.getAttribute("filtrarData");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        GrupoDeSituacoes grupoSituacoesPed = (GrupoDeSituacoes)request.getAttribute("grupoSitPedidos");
        Short tipoData = (Short)request.getAttribute("tipoData");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short filtrarTransportador = (Short)request.getAttribute("filtrarTransportador");
        Transportador transportador = (Transportador)request.getAttribute("transportador");
        return CoreDAOFactory.getInstance().getDAORotaClientePedido().findPedidosPorFiltros(filtrarData, dataInicial, dataFinal, grupoSituacoesPed, tipoData, empresa, filtrarTransportador, transportador);
    }

    public String sincronizaRotaClienteGrCidades(CoreRequestContext request) throws ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAORotaClienteItem().sincronizaRotaClienteGrCidades();
    }

    public List findRotaPorPedido(CoreRequestContext request) {
        Short filtrarData = (Short)request.getAttribute("filtrarData");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        SituacaoPedidos situacaoPedido = (SituacaoPedidos)request.getAttribute("situacaoPedido");
        Short tipoData = (Short)request.getAttribute("tipoData");
        Short filtrarTransportador = (Short)request.getAttribute("filtrarTransportador");
        Transportador transportador = (Transportador)request.getAttribute("transportador");
        return CoreDAOFactory.getInstance().getDAORotaClientePedido().findRotasPorPedido(filtrarData, dataInicial, dataFinal, situacaoPedido, tipoData, empresa, filtrarTransportador, transportador);
    }

    public RotaClientePedido salvarRotaGerarBonificacao(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        RotaClientePedido rota = (RotaClientePedido)request.getAttribute("rota");
        OpcoesFaturamento opcoes = (OpcoesFaturamento)request.getAttribute("opcoesFaturamento");
        OpcoesFinanceiras opcoesFin = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        OpcoesVendas opcoesVendas = (OpcoesVendas)request.getAttribute("opcoesVendas");
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("opcoesFaturamento", opcoes);
        cq.setAttribute("opcoesFinanceiras", opcoesFin);
        this.atualizarPedido(rota, opcoesVendas, usuario);
        return (RotaClientePedido)CoreDAOFactory.getInstance().getDAORotaClientePedido().saveOrUpdate(rota);
    }

    private void atualizarPedido(RotaClientePedido rota, OpcoesVendas opcoesVendas, Usuario usuario) {
        if (opcoesVendas != null && opcoesVendas.getAtualizarDadosPedRotaPed() == 1) {
            for (RotaClientePedidoPedido r : rota.getRotaClientePedidoPedido()) {
                if (r.getPedido().getExpedicao() != null && !r.getPedido().getExpedicao().isEmpty()) continue;
                r.getPedido().setTransportador(rota.getTransportador());
                r.getPedido().setUsuarioUltMod(usuario);
                if (opcoesVendas.getSituacaoPedidosRota() == null) continue;
                r.getPedido().setSituacaoPedido(opcoesVendas.getSituacaoPedidosRota());
            }
        }
    }

    public RotaClientePedidoPedido findRotaClientePedidoPedidoPorPedido(CoreRequestContext r) {
        Pedido pedido = (Pedido)r.getAttribute("pedido");
        return CoreDAOFactory.getInstance().getDAORotaClientePedido().findRotaClientePedidoPedidoPorPedido(pedido);
    }
}

