/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.saldoestproprio;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.Date;
import java.util.HashMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceSaldoEstProprio
extends CoreService {
    public static final String FIND_LOTE_FABRICACAO_ABERTOS = "findLotesAbertos";
    public static final String GET_MAX_ID_PROD_ANALISE_ESTOQUE = "getMaxIdProdAnaliseEstoque";
    public static final String FIND_MELHOR_LOTE_FABRICACAO = "findMelhorLoteFabricacao";
    public static final String FIND_MELHOR_LOTE_FABRICACAO_POR_CENTRO_ESTOQUE = "findMelhorLoteFabricacaoPorCentroEstoque";
    public static final String FIND_LOTE_FABRICACAO_ABERTOS_POR_CENTRO_ESTOQUE = "findLotesAbertosPorCentroEstoque";
    public static final String FIND_LOTES_FABRICACAO = "findLotesFabricacao";
    public static final String FIND_LOTES_FABRICACAO_POR_CENTRO_ESTOQUE = "findLotesFabricacaoPorCentroEstoque";
    public static final String GET_SALDO_EST_PROPRIO_DISPONIVEL_BASICO = "getSaldoEstProprioDisponivelBasico";
    public static final String REPROCESSAR_ESTOQUE = "reprocessarEstoque";
    public static final String FIND_PRECO_MEDIO_POR_PRODUTO = "findPrecoMedioProduto";
    public static final String FIND_PRECO_MEDIO_POR_ID_PRODUTO = "findPrecoMedioIdProduto";
    public static final String FIND_SALDO_GRADE_COR = "findSaldoGradeCor";
    public static final String FIND_SALDO_ID_GRADE_COR_LISTA = "findSaldoIdGradeCorLista";
    public static final String FIND_SALDO_ID_GRADE_COR_LISTA_BASICO = "findSaldoIdGradeCorListaBasico";
    public static final String FIND_SALDO_PRODUTO_BASICO = "findSaldoProdutoBasico";
    public static final String FIND_SALDO_PRODUTO_LISTA = "findSaldoProdutoLista";
    public static final String FIND_SALDO_PRODUTO_LISTA_BASICO = "findSaldoProdutoListaBasico";
    public static final String FIND_SALDO_GRADE_COR_CENTRO_ESTOQUE_BASICO = "findSaldoGradeCorCentroEstoque";
    public static final String FIND_SALDO_GRADE_COR_CENTRO_ESTOQUE_LISTA_BASICO = "findSaldoGradeCorCentroEstoqueLista";
    public static final String FIND_SALDO_ID_PRODUTO_ID_CENTRO_ESTOQUE = "findSaldoIdProdutoIdCentroEstoque";
    public static final String FIND_SALDO_GRADE_CENTRO_ESTOQUE_LOTE_FAB = "findSaldoGradeCentroEstoqueLote";
    public static final String FIND_SALDO_GRADE_CENTRO_ESTOQUE_LOTE_FAB_LISTA = "findSaldoGradeCentroEstoqueLoteLista";

    public Object findLotesAbertos(CoreRequestContext request) throws ExceptionDatabase {
        Produto p = (Produto)request.getAttribute("produto");
        GradeCor g = (GradeCor)request.getAttribute("grade");
        Empresa e = (Empresa)request.getAttribute("empresa");
        Short tipoCentroEstPropTerc = (Short)request.getAttribute("tipoCentroEstPropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findLotesAbertos(p, g, e, tipoCentroEstPropTerc);
    }

    public Long getMaxIdProdAnaliseEstoque(CoreRequestContext r) throws ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getMaxIdProdAnaliseEstoque();
    }

    public Object findMelhorLoteFabricacao(CoreRequestContext r) throws ExceptionDatabase {
        GradeCor g = (GradeCor)r.getAttribute("grade");
        Empresa e = (Empresa)r.getAttribute("empresa");
        Date d = (Date)r.getAttribute("data");
        Short tipoCentroEstPropTerc = (Short)r.getAttribute("tipoCentroEstPropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findMelhorLote(g, d, e, tipoCentroEstPropTerc);
    }

    public Object findMelhorLoteFabricacaoPorCentroEstoque(CoreRequestContext r) throws ExceptionDatabase {
        GradeCor g = (GradeCor)r.getAttribute("grade");
        Empresa e = (Empresa)r.getAttribute("empresa");
        Date d = (Date)r.getAttribute("data");
        CentroEstoque c = (CentroEstoque)r.getAttribute("centroEstoque");
        Short tipoCentroEstPropTerc = (Short)r.getAttribute("tipoCentroEstPropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findMelhorLotePorCentroEstoque(g, d, e, c, tipoCentroEstPropTerc);
    }

    public Object findLotesAbertosPorCentroEstoque(CoreRequestContext request) throws ExceptionDatabase {
        Produto p = (Produto)request.getAttribute("produto");
        GradeCor g = (GradeCor)request.getAttribute("grade");
        Empresa e = (Empresa)request.getAttribute("empresa");
        CentroEstoque c = (CentroEstoque)request.getAttribute("centroEstoque");
        Short tipoCentroEstPropTerc = (Short)request.getAttribute("tipoCentroEstPropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findLotesAbertosPorCentroEstoque(p, g, e, c, tipoCentroEstPropTerc);
    }

    public Object findLotesFabricacao(CoreRequestContext request) throws ExceptionDatabase {
        Produto p = (Produto)request.getAttribute("produto");
        GradeCor g = (GradeCor)request.getAttribute("grade");
        Empresa e = (Empresa)request.getAttribute("empresa");
        Short tipoCentroEstoquePropTerc = (Short)request.getAttribute("tipoCentroEstoquePropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findLotes(p, g, e, tipoCentroEstoquePropTerc);
    }

    public Object findLotesFabricacaoPorCentroEstoque(CoreRequestContext request) throws ExceptionDatabase {
        Produto p = (Produto)request.getAttribute("produto");
        GradeCor g = (GradeCor)request.getAttribute("grade");
        Empresa e = (Empresa)request.getAttribute("empresa");
        CentroEstoque c = (CentroEstoque)request.getAttribute("centroEstoque");
        Short tipoCentroEstPropTerc = (Short)request.getAttribute("tipoCentroEstPropTerc");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findLotesPorCentroEstoque(p, g, e, c, tipoCentroEstPropTerc);
    }

    public Object getSaldoEstProprioDisponivelBasico(CoreRequestContext r) throws ExceptionDatabase {
        Date data = (Date)r.getAttribute("data");
        Long produtoInicial = (Long)r.getAttribute("produtoInicial");
        Long produtoFinal = (Long)r.getAttribute("produtoFinal");
        Long especieInicial = (Long)r.getAttribute("especieInicial");
        Long especieFinal = (Long)r.getAttribute("especieFinal");
        Long subEspecieInicial = (Long)r.getAttribute("subEspecieInicial");
        Long subEspecieFinal = (Long)r.getAttribute("subEspecieFinal");
        Long centroEstInicial = (Long)r.getAttribute("centroEstInicial");
        Long centroEstFinal = (Long)r.getAttribute("centroEstFinal");
        Long fabricanteInicial = (Long)r.getAttribute("fabricanteInicial");
        Long fabricanteFinal = (Long)r.getAttribute("fabricanteFinal");
        Long localizacaoInicial = (Long)r.getAttribute("localizacaoInicial");
        Long localizacaoFinal = (Long)r.getAttribute("localizacaoFinal");
        Long gradeInicial = (Long)r.getAttribute("gradeInicial");
        Long gradeFinal = (Long)r.getAttribute("gradeFinal");
        Integer tipoProdutoInicial = (Integer)r.getAttribute("tipoProdutoInicial");
        Integer tipoProdutoFinal = (Integer)r.getAttribute("tipoProdutoFinal");
        Short tipoPesquisa = (Short)r.getAttribute("tipoPesquisa");
        Long idEmpresa = (Long)r.getAttribute("idEmpresa");
        Short tipoDisponibilidade = (Short)r.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)r.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)r.getAttribute("idParceiro");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceirosBasico(data, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, centroEstInicial, centroEstFinal, fabricanteInicial, fabricanteFinal, localizacaoInicial, localizacaoFinal, gradeInicial, gradeFinal, tipoProdutoInicial, tipoProdutoFinal, tipoPesquisa, idEmpresa, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object reprocessarEstoque(CoreRequestContext r) throws ExceptionDatabase {
        Date d = (Date)r.getAttribute("data");
        Long idInicial = (Long)r.getAttribute("idInicial");
        Long idFinal = (Long)r.getAttribute("idFinal");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().reprocessarEstoque(d, idInicial, idFinal);
    }

    public Double findPrecoMedioProduto(CoreRequestContext r) {
        Produto p = (Produto)r.getAttribute("produto");
        Empresa e = (Empresa)r.getAttribute("empresa");
        Date data = (Date)r.getAttribute("data");
        Integer tipoSaldo = (Integer)r.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)r.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)r.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)r.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)r.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)r.getAttribute("idParceiro");
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        SaldoEstoqueGeralBasico saldo = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoUnicoBasico(idProduto, data, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    public Double findPrecoMedioIdProduto(CoreRequestContext r) {
        Date data = (Date)r.getAttribute("data");
        Integer tipoSaldo = (Integer)r.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)r.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)r.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)r.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)r.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)r.getAttribute("idParceiro");
        Long idProduto = (Long)r.getAttribute("idProduto");
        Long idEmpresa = (Long)r.getAttribute("idEmpresa");
        SaldoEstoqueGeralBasico saldo = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoUnicoBasico(idProduto, data, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    public Object findSaldoGradeCor(CoreRequestContext request) {
        Produto produto = (Produto)request.getAttribute("produto");
        GradeCor grade = (GradeCor)request.getAttribute("grade");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idGrade = grade != null ? grade.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeUnicoBasico(idProduto, data, idEmpresa, idGrade, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoIdGradeCorLista(CoreRequestContext request) {
        Long idProdutoInicial = (Long)request.getAttribute("idProdutoInicial");
        Long idProdutoFinal = (Long)request.getAttribute("idProdutoFinal");
        Long idGradeCorInicial = (Long)request.getAttribute("idGradeCorInicial");
        Long idGradeCorFinal = (Long)request.getAttribute("idGradeCorFinal");
        Date data = (Date)request.getAttribute("data");
        Long empresaInicial = (Long)request.getAttribute("idEmpresaInicial");
        Long empresaFinal = (Long)request.getAttribute("idEmpresaFinal");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        HashMap paramsAdicionais = (HashMap)request.getAttribute("paramsAdicionais");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGrade(idProdutoInicial, idProdutoFinal, data, empresaInicial, empresaFinal, idGradeCorInicial, idGradeCorFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro, paramsAdicionais);
    }

    public Object findSaldoIdGradeCorListaBasico(CoreRequestContext request) {
        Long idProdutoInicial = (Long)request.getAttribute("idProdutoInicial");
        Long idProdutoFinal = (Long)request.getAttribute("idProdutoFinal");
        Long idGradeCorInicial = (Long)request.getAttribute("idGradeCorInicial");
        Long idGradeCorFinal = (Long)request.getAttribute("idGradeCorFinal");
        Date data = (Date)request.getAttribute("data");
        Long empresaInicial = (Long)request.getAttribute("idEmpresaInicial");
        Long empresaFinal = (Long)request.getAttribute("idEmpresaFinal");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeBasico(idProdutoInicial, idProdutoFinal, data, empresaInicial, empresaFinal, idGradeCorInicial, idGradeCorFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoProdutoBasico(CoreRequestContext request) {
        Produto produto = (Produto)request.getAttribute("produto");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoUnicoBasico(idProduto, data, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoProdutoLista(CoreRequestContext request) {
        Produto produtoInicial = (Produto)request.getAttribute("produtoInicial");
        Produto produtoFinal = (Produto)request.getAttribute("produtoFinal");
        Date data = (Date)request.getAttribute("data");
        Empresa empresaInicial = (Empresa)request.getAttribute("empresaInicial");
        Empresa empresaFinal = (Empresa)request.getAttribute("empresaFinal");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProduto(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoProdutoListaBasico(CoreRequestContext request) {
        Produto produtoInicial = (Produto)request.getAttribute("produtoInicial");
        Produto produtoFinal = (Produto)request.getAttribute("produtoFinal");
        Date data = (Date)request.getAttribute("data");
        Empresa empresaInicial = (Empresa)request.getAttribute("empresaInicial");
        Empresa empresaFinal = (Empresa)request.getAttribute("empresaFinal");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoBasico(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoGradeCorCentroEstoque(CoreRequestContext request) {
        Produto produto = (Produto)request.getAttribute("produto");
        GradeCor grade = (GradeCor)request.getAttribute("grade");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        CentroEstoque centro = (CentroEstoque)request.getAttribute("centroEstoque");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idCentroEstoque = centro != null ? centro.getIdentificador() : null;
        Long idGradeCor = grade != null ? grade.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(idProduto, data, idEmpresa, idGradeCor, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoGradeCorCentroEstoqueLista(CoreRequestContext request) {
        Produto produtoInicial = (Produto)request.getAttribute("produtoInicial");
        Produto produtoFinal = (Produto)request.getAttribute("produtoFinal");
        GradeCor gradeInicial = (GradeCor)request.getAttribute("gradeInicial");
        GradeCor gradeFinal = (GradeCor)request.getAttribute("gradeFinal");
        Date data = (Date)request.getAttribute("data");
        Empresa empresaInicial = (Empresa)request.getAttribute("empresaInicial");
        Empresa empresaFinal = (Empresa)request.getAttribute("empresaFinal");
        CentroEstoque centroInicial = (CentroEstoque)request.getAttribute("centroEstoqueInicial");
        CentroEstoque centroFinal = (CentroEstoque)request.getAttribute("centroEstoqueFinal");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idCentroEstoqueInicial = centroInicial != null ? centroInicial.getIdentificador() : null;
        Long idCentroEstoqueFinal = centroFinal != null ? centroFinal.getIdentificador() : null;
        Long idGradeCorInicial = gradeInicial != null ? gradeInicial.getIdentificador() : 0L;
        Long idGradeCorFinal = gradeFinal != null ? gradeFinal.getIdentificador() : 999999999L;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeCentroEstoqueBasico(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idGradeCorInicial, idGradeCorFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public SaldoEstoqueGeralBasico findSaldoIdProdutoIdCentroEstoque(CoreRequestContext request) {
        Long p = (Long)request.getAttribute("prod");
        Date d = (Date)request.getAttribute("data");
        Long e = (Long)request.getAttribute("empresa");
        Long centroEstoque = (Long)request.getAttribute("centroEstoque");
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(p, d, e, null, centroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoGradeCentroEstoqueLote(CoreRequestContext request) throws ExceptionDatabase {
        Produto produto = (Produto)request.getAttribute("produto");
        GradeCor grade = (GradeCor)request.getAttribute("grade");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        LoteFabricacao lote = (LoteFabricacao)request.getAttribute("lote");
        CentroEstoque centro = (CentroEstoque)request.getAttribute("centro");
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idCentroEstoque = centro != null ? centro.getIdentificador() : null;
        Long idGradeCor = grade != null ? grade.getIdentificador() : null;
        Long idLote = lote != null ? lote.getIdentificador() : null;
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, empresa.getIdentificador(), empresa.getIdentificador(), idCentroEstoque, idCentroEstoque, idGradeCor, idGradeCor, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public Object findSaldoGradeCentroEstoqueLoteLista(CoreRequestContext request) throws ExceptionDatabase {
        Produto produtoInicial = (Produto)request.getAttribute("produtoInicial");
        Produto produtoFinal = (Produto)request.getAttribute("produtoFinal");
        GradeCor gradeInicial = (GradeCor)request.getAttribute("gradeInicial");
        GradeCor gradeFinal = (GradeCor)request.getAttribute("gradeFinal");
        Date data = (Date)request.getAttribute("data");
        Empresa empresaInicial = (Empresa)request.getAttribute("empresaInicial");
        Empresa empresaFinal = (Empresa)request.getAttribute("empresaFinal");
        LoteFabricacao lote = (LoteFabricacao)request.getAttribute("lote");
        CentroEstoque centroInicial = (CentroEstoque)request.getAttribute("centroInicial");
        CentroEstoque centroFinal = (CentroEstoque)request.getAttribute("centroFinal");
        Short tipoDisponibilidade = (Short)request.getAttribute("tipoDisponibilidade");
        Short tipoEstoqueCentroEstoque = (Short)request.getAttribute("tipoEstoqueCentroEstoque");
        Long idParceiro = (Long)request.getAttribute("idParceiro");
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idCentroEstoqueInicial = centroInicial != null ? centroInicial.getIdentificador() : null;
        Long idCentroEstoqueFinal = centroFinal != null ? centroFinal.getIdentificador() : null;
        Long idGradeCorInicial = gradeInicial != null ? gradeInicial.getIdentificador() : null;
        Long idGradeCorFinal = gradeFinal != null ? gradeFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        Long idLote = lote != null ? lote.getIdentificador() : null;
        Integer tipoSaldo = (Integer)request.getAttribute("tipoSaldo");
        Integer tipoQtde = (Integer)request.getAttribute("tipoQtde");
        Integer tipoCarregamento = (Integer)request.getAttribute("tipoCarregamento");
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }
}

