/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.servicegeracaoarqimasicca;

import com.touchcomp.basementor.model.vo.Empresa;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ServiceFieldError;
import mentorcore.tools.ClearUtil;

class UtilGeracaoArqIMASICCA {
    UtilGeracaoArqIMASICCA() {
    }

    Object gerarArquivoImaSICCA(Date dataInicial, Date dataFinal, Empresa empresa) throws ServiceFieldError {
        List notaTerceiros = (List)CoreDAOFactory.getInstance().getDAONotaFiscalTerceiros().getItensNotaTerceirosIMASICCA(dataInicial, dataFinal, empresa);
        List notaPropria = (List)CoreDAOFactory.getInstance().getDAONotaFiscalPropria().getItensNotaPropriaIMASICCA(dataInicial, dataFinal, empresa);
        return this.criarArquivo(notaTerceiros, notaPropria);
    }

    private Object criarArquivo(List notaTerceiros, List notaPropria) throws ServiceFieldError {
        StringBuilder strw = new StringBuilder();
        strw = this.gerarArquivoNotaPropria(strw, notaPropria);
        strw = this.gerarArquivoNotaTerceiros(strw, notaTerceiros);
        return strw.toString();
    }

    private StringBuilder gerarArquivoNotaPropria(StringBuilder strw, List notaPropria) throws ServiceFieldError {
        for (Object o : notaPropria) {
            HashMap h = (HashMap)o;
            if (h.get("CNPJ") == null || h.get("CNPJ").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o CNPJ da empresa da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(ClearUtil.refina(h.get("CNPJ").toString()));
            if (h.get("TIPO_MOVIMENTACAO") != null && !h.get("TIPO_MOVIMENTACAO").toString().isEmpty()) {
                if (h.get("TIPO_MOVIMENTACAO").equals((short)2)) {
                    strw.append(";").append("ENTRADA");
                } else if (h.get("TIPO_MOVIMENTACAO").equals((short)1)) {
                    strw.append(";").append("SAIDA");
                }
            } else {
                throw new ServiceFieldError("Primeiro, informe o Tipo de Movimenta\u00e7\u00e3o da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            if (h.get("NUMERO_NOTA") == null || h.get("NUMERO_NOTA").toString().isEmpty()) {
                throw new ServiceFieldError("Existem Notas Pr\u00f3prias sem o N\u00famero da Nota informado!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("NUMERO_NOTA").toString()));
            if (h.get("SERIE_NOTA") == null || h.get("SERIE_NOTA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a S\u00e9rie da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("SERIE_NOTA").toString()));
            if (h.get("DATA_ENTRADA_SAIDA") == null || h.get("DATA_ENTRADA_SAIDA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Data de Emiss\u00e3o da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(h.get("DATA_ENTRADA_SAIDA"));
            if (h.get("RAZAO_SOCIAL") == null || h.get("RAZAO_SOCIAL").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Raz\u00e3o Social do Cliente da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(h.get("RAZAO_SOCIAL").toString().toUpperCase());
            if (h.get("CPF_CNPJ") == null || h.get("CPF_CNPJ").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o CPF/CNPJ do Cliente da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("CPF_CNPJ").toString()));
            if (h.get("ENDERECO") != null && !h.get("ENDERECO").toString().isEmpty()) {
                strw.append(";").append(h.get("ENDERECO").toString().toUpperCase());
            } else {
                if (h.get("TIPO_MOVIMENTACAO").equals((short)1)) {
                    throw new ServiceFieldError("Primeiro, informe o Endereco do Cliente da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
                }
                strw.append(";");
            }
            if (h.get("CODIGO_MUNICIPIO") != null && !h.get("CODIGO_MUNICIPIO").toString().isEmpty()) {
                strw.append(";").append(ClearUtil.refina(h.get("CODIGO_MUNICIPIO").toString()));
            } else {
                if (h.get("TIPO_MOVIMENTACAO").equals((short)1)) {
                    throw new ServiceFieldError("Primeiro, informe o C\u00f3digo do Munic\u00edpio do Cliente da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
                }
                strw.append(";");
            }
            strw.append(";");
            if (h.get("NOME_PROPRIEDADE") != null && !h.get("NOME_PROPRIEDADE").toString().isEmpty()) {
                strw.append(";").append(h.get("NOME_PROPRIEDADE").toString().toUpperCase());
            } else {
                if (h.get("TIPO_MOVIMENTACAO").equals((short)1)) {
                    throw new ServiceFieldError("Primeiro, informe o Nome da Propriedade da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
                }
                strw.append(";");
            }
            if (h.get("INSCRICAO_ESTADUAL_PROPRIEDADE") != null && !h.get("INSCRICAO_ESTADUAL_PROPRIEDADE").toString().isEmpty()) {
                strw.append(";").append(ClearUtil.refina(h.get("INSCRICAO_ESTADUAL_PROPRIEDADE").toString()));
            } else {
                strw.append(";");
            }
            if (h.get("CODIGO_MUNICIPIO_PROPRIEDADE") == null || h.get("CODIGO_MUNICIPIO_PROPRIEDADE").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o C\u00f3digo do Munic\u00edpio da Propriedade da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("CODIGO_MUNICIPIO_PROPRIEDADE").toString()));
            if (h.get("NR_REGISTRO_AGROTOXICO_MAPA") == null || h.get("NR_REGISTRO_AGROTOXICO_MAPA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o Nr. de Registro Agrot\u00f3xico no MAPA dos Produtos da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("NR_REGISTRO_AGROTOXICO_MAPA").toString()));
            if (h.get("QUANTIDADE") == null || h.get("QUANTIDADE").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Quantidade Total da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(String.format(new Locale("pt", "BR"), "%.4f", h.get("QUANTIDADE")));
            if (h.get("EMBALAGEM") == null || h.get("EMBALAGEM").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Embalagem dos Produtos da Nota Pr\u00f3pria: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("EMBALAGEM").toString()));
            strw.append("\n");
        }
        return strw;
    }

    private StringBuilder gerarArquivoNotaTerceiros(StringBuilder strw, List notaTerceiros) throws ServiceFieldError {
        for (Object o : notaTerceiros) {
            HashMap h = (HashMap)o;
            if (h.get("CNPJ") == null || h.get("CNPJ").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o CNPJ da empresa da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(ClearUtil.refina(h.get("CNPJ").toString()));
            strw.append(";").append("ENTRADA");
            if (h.get("NUMERO_NOTA") == null || h.get("NUMERO_NOTA").toString().isEmpty()) {
                throw new ServiceFieldError("Existem Notas Terceiros sem o N\u00famero da Nota informado!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("NUMERO_NOTA").toString()));
            if (h.get("SERIE_NOTA") == null || h.get("SERIE_NOTA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a S\u00e9rie da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("SERIE_NOTA").toString()));
            if (h.get("DATA_ENTRADA_SAIDA") == null || h.get("DATA_ENTRADA_SAIDA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Data de Entrada da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(h.get("DATA_ENTRADA_SAIDA"));
            if (h.get("RAZAO_SOCIAL") == null || h.get("RAZAO_SOCIAL").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Raz\u00e3o Social do Cliente da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(h.get("RAZAO_SOCIAL").toString().toUpperCase());
            if (h.get("CPF_CNPJ") == null || h.get("CPF_CNPJ").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o CPF/CNPJ do Cliente da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("CPF_CNPJ").toString()));
            if (h.get("ENDERECO") != null && !h.get("ENDERECO").toString().isEmpty()) {
                strw.append(";").append(h.get("ENDERECO").toString().toUpperCase());
            } else {
                strw.append(";");
            }
            if (h.get("CODIGO_MUNICIPIO") != null && !h.get("CODIGO_MUNICIPIO").toString().isEmpty()) {
                strw.append(";").append(ClearUtil.refina(h.get("CODIGO_MUNICIPIO").toString()));
            } else {
                strw.append(";");
            }
            strw.append(";");
            if (h.get("NOME_PROPRIEDADE") != null && !h.get("NOME_PROPRIEDADE").toString().isEmpty()) {
                strw.append(";").append(h.get("NOME_PROPRIEDADE").toString().toUpperCase());
            } else {
                strw.append(";");
            }
            if (h.get("INSCRICAO_ESTADUAL_PROPRIEDADE") != null && !h.get("INSCRICAO_ESTADUAL_PROPRIEDADE").toString().isEmpty()) {
                strw.append(";").append(ClearUtil.refina(h.get("INSCRICAO_ESTADUAL_PROPRIEDADE").toString()));
            } else {
                strw.append(";");
            }
            if (h.get("CODIGO_MUNICIPIO_PROPRIEDADE") == null || h.get("CODIGO_MUNICIPIO_PROPRIEDADE").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o C\u00f3digo do Munic\u00edpio da Propriedade da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("CODIGO_MUNICIPIO_PROPRIEDADE").toString()));
            if (h.get("NR_REGISTRO_AGROTOXICO_MAPA") == null || h.get("NR_REGISTRO_AGROTOXICO_MAPA").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe o Nr. de Registro Agrot\u00f3xico no MAPA dos Produtos da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("NR_REGISTRO_AGROTOXICO_MAPA").toString()));
            if (h.get("QUANTIDADE") == null || h.get("QUANTIDADE").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Quantidade Total da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(String.format(new Locale("pt", "BR"), "%.4f", h.get("QUANTIDADE")));
            if (h.get("EMBALAGEM") == null || h.get("EMBALAGEM").toString().isEmpty()) {
                throw new ServiceFieldError("Primeiro, informe a Embalagem dos Produtos da Nota Terceiros: " + h.get("NUMERO_NOTA").toString() + "!");
            }
            strw.append(";").append(ClearUtil.refina(h.get("EMBALAGEM").toString()));
            strw.append("\n");
        }
        return strw;
    }
}

