/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.sintegra;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralTerceiros;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoMovimento;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.sintegra.Registro50;
import mentorcore.service.impl.sintegra.Registro51;
import mentorcore.service.impl.sintegra.Registro53;
import mentorcore.service.impl.sintegra.Registro54;
import mentorcore.service.impl.sintegra.Registro54Opcional;
import mentorcore.service.impl.sintegra.Registro61;
import mentorcore.service.impl.sintegra.Registro61R;
import mentorcore.service.impl.sintegra.Registro70;
import mentorcore.service.impl.sintegra.Registro71;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class SintegraNatOperacaoTotalUtilities {
    private TLogger logger = TLogger.get(this.getClass());
    private HashSet produtos;

    SintegraNatOperacaoTotalUtilities() {
    }

    public Object gerarSintegra(CoreRequestContext request) throws ExceptionService {
        PrintWriter p = null;
        try {
            Date dataInicial = (Date)request.getAttribute("dataInicial");
            Date dataFinal = (Date)request.getAttribute("dataFinal");
            String responsavel = (String)request.getAttribute("responsavel");
            String arquivo = (String)request.getAttribute("arquivo");
            Short natOperacao = (Short)request.getAttribute("naturezaOperacao");
            Short finalidade = (Short)request.getAttribute("finalidade");
            List uf = (List)request.getAttribute("uf");
            Short gerarInventario = (Short)request.getAttribute("gerarInventario");
            Date dataInventario = (Date)request.getAttribute("dataInventario");
            Long idEmpresa = (Long)request.getAttribute("empresa");
            Short somarIpiOutros = (Short)request.getAttribute("somarIpiOutros");
            Empresa empresa = this.getEmpresa(idEmpresa);
            List listNaoTipoMovimento = (List)request.getAttribute("listNaoTipoMovimento");
            this.produtos = new HashSet();
            TreeMap counter = new TreeMap();
            p = new PrintWriter(arquivo, StandardCharsets.ISO_8859_1.name());
            List reg50Proprio = this.listarReg50Proprio(empresa, dataInicial, dataFinal);
            List reg50Terceiros = this.listarReg50Terceiros(empresa, dataInicial, dataFinal);
            List reg50Inutilizacoes = this.listarReg50Inutilizacoes(empresa, dataInicial, dataFinal);
            List reg51Proprio = this.listarReg51Proprio(empresa, dataInicial, dataFinal);
            List reg51Terceiros = this.listarReg51Terceiros(empresa, dataInicial, dataFinal);
            List reg53Proprio = this.listarReg53Proprio(empresa, dataInicial, dataFinal);
            List reg53Terceiros = this.listarReg53Terceiros(empresa, dataInicial, dataFinal);
            List reg54Proprios = this.listarReg54Proprios(empresa, dataInicial, dataFinal, somarIpiOutros);
            List reg54Terceiros = this.listarReg54Terceiros(empresa, dataInicial, dataFinal, somarIpiOutros);
            List reg54PropOpcional = this.listarReg54ProprioOpcional(empresa, dataInicial, dataFinal);
            List reg54TercOpcional = this.listarReg54TerceirosOpcional(empresa, dataInicial, dataFinal);
            List reg61 = this.listarReg61(empresa, dataInicial, dataFinal);
            List reg61NFCe = this.listarReg61NFCe(empresa, dataInicial, dataFinal);
            List reg61R = this.listarReg61R(empresa, dataInicial, dataFinal);
            List reg70CTeCTRC = this.listarReg70Proprio(empresa, dataInicial, dataFinal);
            List reg70Terceiros = this.listarReg70Terceiros(empresa, dataInicial, dataFinal);
            List reg71CTeCTRC = this.listarReg71CTeCTRC(empresa, dataInicial, dataFinal);
            this.appendReg10(counter, p, empresa, dataInicial, dataFinal, natOperacao, finalidade);
            this.appendReg11(counter, p, empresa, responsavel);
            this.appendReg50(counter, p, reg50Proprio, reg50Terceiros, reg50Inutilizacoes);
            this.appendReg51(counter, p, reg51Proprio, reg51Terceiros);
            this.appendReg53(counter, p, reg53Proprio, reg53Terceiros);
            this.appendReg54(counter, p, reg54Proprios, reg54Terceiros);
            this.appendReg54Opcional(counter, p, reg54PropOpcional, reg54TercOpcional);
            this.appendReg61(counter, p, reg61, reg61NFCe, reg61R);
            this.appendReg70(counter, p, reg70CTeCTRC, reg70Terceiros);
            this.appendReg71(counter, p, reg71CTeCTRC);
            this.appendReg74(counter, p, dataInventario, empresa, natOperacao, gerarInventario);
            this.appendReg74Terceiros(counter, p, dataInventario, empresa, natOperacao, gerarInventario, listNaoTipoMovimento);
            this.appendReg75(counter, p, dataInicial, dataFinal);
            this.appendReg88EAN(counter, p);
            this.appendReg90(counter, p, empresa);
            String string = arquivo;
            return string;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage());
        }
        catch (ExceptionDatabase ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao realizar pesquisa.");
        }
        catch (FileNotFoundException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao escrever no arquivo.");
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao escrever no arquivo.");
        }
        finally {
            if (p != null) {
                p.flush();
                p.close();
            }
        }
    }

    private void appendReg10(TreeMap counter, PrintWriter p, Empresa empresa, Date dataIncial, Date dataFinal, Short natOperacao, Short finalidade) {
        p.append(this.getRegistro10(counter, empresa, dataIncial, dataFinal, natOperacao, finalidade));
    }

    private void appendReg11(TreeMap counter, PrintWriter p, Empresa empresa, String responsavel) {
        p.append(this.getRegistro11(counter, empresa, responsavel));
    }

    private void appendReg50(TreeMap counter, PrintWriter p, List registrosProprios, List registrosTerceiros, List registrosInutilizacoes) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro50(counter, registrosProprios, "P"));
        sb.append(this.getRegistro50(counter, registrosInutilizacoes, "P"));
        sb.append(this.getRegistro50(counter, registrosTerceiros, "T"));
        p.append(sb.toString());
    }

    private void appendReg51(TreeMap counter, PrintWriter p, List registrosProprios, List registrosTerceiros) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getRegistro51(counter, registrosProprios));
        sb.append((CharSequence)this.getRegistro51(counter, registrosTerceiros));
        p.append(sb.toString());
    }

    private void appendReg53(TreeMap counter, PrintWriter p, List registrosProprios, List registrosTerceiros) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getRegistro53(counter, registrosProprios, "P"));
        sb.append((CharSequence)this.getRegistro53(counter, registrosTerceiros, "T"));
        p.append(sb.toString());
    }

    private void appendReg54(TreeMap counter, PrintWriter p, List registrosProprios, List registrosTerceiros) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro54(counter, registrosProprios));
        sb.append(this.getRegistro54(counter, registrosTerceiros));
        p.append(sb.toString());
    }

    private void appendReg54Opcional(TreeMap counter, PrintWriter p, List registrosProprios, List RegistrosTerceiros) {
        Integer numItem;
        Double valorPisCofins;
        Double valorDespAcess;
        Double valorSeguro;
        Double valorFrete;
        Registro54Opcional vo;
        StringBuilder sb = new StringBuilder();
        for (Object o : registrosProprios) {
            vo = (Registro54Opcional)o;
            if (!this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            valorFrete = vo.getValorFrete();
            valorSeguro = vo.getValorSeguro();
            valorDespAcess = vo.getValorDespAcessoria();
            valorPisCofins = vo.getValorPisCofins();
            if (valorFrete > 0.0) {
                numItem = 991;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorFrete));
            }
            if (valorSeguro > 0.0) {
                numItem = 992;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorSeguro));
            }
            if (valorPisCofins > 0.0) {
                numItem = 993;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorPisCofins));
            }
            if (!(valorDespAcess > 0.0)) continue;
            numItem = 999;
            vo.setNumeroItem(numItem);
            sb.append(this.getRegistro54Opcional(counter, vo, valorDespAcess));
        }
        for (Object o : RegistrosTerceiros) {
            vo = (Registro54Opcional)o;
            if (!this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            valorFrete = vo.getValorFrete();
            valorSeguro = vo.getValorSeguro();
            valorDespAcess = vo.getValorDespAcessoria();
            valorPisCofins = vo.getValorPisCofins();
            if (valorFrete > 0.0) {
                numItem = 991;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorFrete));
            }
            if (valorSeguro > 0.0) {
                numItem = 992;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorSeguro));
            }
            if (valorPisCofins > 0.0) {
                numItem = 993;
                vo.setNumeroItem(numItem);
                sb.append(this.getRegistro54Opcional(counter, vo, valorPisCofins));
            }
            if (!(valorDespAcess > 0.0)) continue;
            numItem = 999;
            vo.setNumeroItem(numItem);
            sb.append(this.getRegistro54Opcional(counter, vo, valorDespAcess));
        }
        p.append(sb.toString());
    }

    private void appendReg61(TreeMap counter, PrintWriter p, List registros61, List registros61NFCe, List registros61R) {
        StringBuilder sb = new StringBuilder();
        ArrayList lista = new ArrayList();
        lista.addAll(registros61);
        lista.addAll(registros61NFCe);
        sb.append(this.getRegistro61(counter, lista, registros61R));
        p.append(sb.toString());
    }

    private void appendReg70(TreeMap counter, PrintWriter p, List registrosProprios, List registrosTerceiros) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro70Proprio(counter, registrosProprios));
        sb.append(this.getRegistro70Terceiros(counter, registrosTerceiros));
        p.append(sb.toString());
    }

    private void appendReg71(TreeMap counter, PrintWriter p, List registrosProprios) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro71(counter, registrosProprios));
        p.append(sb.toString());
    }

    private void appendReg74(TreeMap counter, PrintWriter p, Date dataInventario, Empresa empresa, Short natOperacao, Short gerarInventario) throws ExceptionDatabase, ExceptionService {
        if (natOperacao == 3 && gerarInventario == 1) {
            StringBuilder sb = new StringBuilder();
            List<SaldoEstoqueGeral> saldos = this.getSaldosProprios(dataInventario, empresa);
            short codPosse = 1;
            String cnpj = empresa.getPessoa().getComplemento().getCnpj();
            String inscEst = "";
            String sigla = empresa.getPessoa().getEndereco().getCidade().getUf().getSigla();
            sb.append(this.getRegistro74Proprios(counter, dataInventario, codPosse, cnpj, inscEst, sigla, saldos));
            p.append(sb.toString());
        }
    }

    private void appendReg74Terceiros(TreeMap counter, PrintWriter p, Date dataInventario, Empresa empresa, Short natOperacao, Short gerarInventario, List<TipoMovimento> listNaoTipoMovimento) throws ExceptionDatabase, ExceptionService {
        if (natOperacao == 3 && gerarInventario == 1) {
            StringBuilder sb = new StringBuilder();
            List<SaldoEstoqueGeralTerceiros> aux = this.getSaldosTerceiros(dataInventario, empresa, 2, listNaoTipoMovimento);
            if (!aux.isEmpty() && aux != null) {
                Iterator<SaldoEstoqueGeralTerceiros> iterator = aux.iterator();
                while (iterator.hasNext()) {
                    SaldoEstoqueGeralTerceiros object;
                    SaldoEstoqueGeralTerceiros m = object = iterator.next();
                    String inscEst = m.getInscricaoEst();
                    String cpnj = m.getCnpj();
                    String sigla = m.getSigla();
                    ArrayList<SaldoEstoqueGeralTerceiros> temp = new ArrayList<SaldoEstoqueGeralTerceiros>();
                    temp.add(m);
                    sb.append(this.getRegistro74Terceiros(counter, dataInventario, (short)2, cpnj, inscEst, sigla, temp));
                }
            }
            List<SaldoEstoqueGeralTerceiros> aux2 = this.getSaldosTerceiros(dataInventario, empresa, 6, listNaoTipoMovimento);
            if (!aux.isEmpty() && aux != null) {
                Iterator<SaldoEstoqueGeralTerceiros> iterator = aux2.iterator();
                while (iterator.hasNext()) {
                    SaldoEstoqueGeralTerceiros object;
                    SaldoEstoqueGeralTerceiros m = object = iterator.next();
                    String inscEst = m.getInscricaoEst();
                    String cpnj = m.getCnpj();
                    String sigla = m.getSigla();
                    ArrayList<SaldoEstoqueGeralTerceiros> temp = new ArrayList<SaldoEstoqueGeralTerceiros>();
                    temp.add(m);
                    sb.append(this.getRegistro74Terceiros(counter, dataInventario, (short)3, cpnj, inscEst, sigla, temp));
                }
            }
            p.append(sb);
        }
    }

    private void appendReg75(TreeMap counter, PrintWriter p, Date dataInicial, Date dataFinal) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro75(counter, dataInicial, dataFinal));
        p.append(sb.toString());
    }

    private void appendReg90(TreeMap counter, PrintWriter p, Empresa empresa) {
        p.append(this.getRegistro90(counter, empresa).toString());
    }

    private String getRegistro10(TreeMap counter, Empresa empresa, Date dataIncial, Date dataFinal, Short natOperacao, Short finalidade) {
        StringBuilder sb = new StringBuilder();
        sb.append("10");
        String aux = this.getClearString(empresa.getPessoa().getComplemento().getCnpj());
        sb.append(this.getFormatedString(aux, 14));
        aux = this.getClearString(empresa.getPessoa().getComplemento().getInscEst());
        sb.append(this.getFormatedString(aux, 14));
        sb.append(this.getFormatedString(empresa.getPessoa().getNome(), 35));
        sb.append(this.getFormatedString(empresa.getPessoa().getEndereco().getCidade().getDescricao(), 30));
        sb.append(this.getFormatedString(empresa.getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
        if (empresa.getPessoa().getComplemento().getFax1() != null && empresa.getPessoa().getComplemento().getFax1().trim().length() > 0) {
            sb.append(this.getFormatedString(empresa.getPessoa().getComplemento().getFax1(), 10));
        } else {
            sb.append(this.getFormatedNumero(0, 0, 10));
        }
        sb.append(DateUtil.dateToStr(dataIncial, "yyyyMMdd"));
        sb.append(DateUtil.dateToStr(dataFinal, "yyyyMMdd"));
        sb.append("3");
        sb.append(this.getFormatedNumero(natOperacao, 0, 1));
        sb.append(this.getFormatedNumero(finalidade, 0, 1));
        sb.append(this.getFinalLine());
        this.putCount(counter, "10", 1L);
        return sb.toString();
    }

    private String getRegistro11(TreeMap counter, Empresa empresa, String responsavel) {
        StringBuffer sb = new StringBuffer();
        sb.append("11");
        sb.append(this.getFormatedString(empresa.getPessoa().getEndereco().getLogradouro(), 34));
        String aux = empresa.getPessoa().getEndereco().getNumero();
        try {
            sb.append(this.getFormatedNumero(new Integer(aux), 0, 5));
        }
        catch (Exception ex) {
            sb.append(this.getFormatedNumero(1, 0, 5));
        }
        aux = this.getClearString(empresa.getPessoa().getEndereco().getComplemento());
        sb.append(this.getFormatedString(aux, 22));
        sb.append(this.getFormatedString(empresa.getPessoa().getEndereco().getBairro(), 15));
        aux = this.getClearString(empresa.getPessoa().getEndereco().getCep());
        sb.append(this.getFormatedNumero(Integer.parseInt(aux), 0, 8));
        sb.append(this.getFormatedString(responsavel, 28));
        aux = empresa.getPessoa().getComplemento().getFone1();
        sb.append(this.getFormatedNumero(Long.parseLong(aux), 0, 12));
        sb.append(this.getFinalLine());
        this.putCount(counter, "11", 1L);
        return sb.toString();
    }

    private StringBuffer getRegistro50(TreeMap counter, List registros50, String tipo) throws ExceptionService {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (Object o : registros50) {
            Registro50 vo = (Registro50)o;
            System.out.println("NR NOTA:" + vo.getNrNota().toString());
            if (!this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            sb.append("50");
            if (vo.getCnpj() != null && vo.getCnpj().trim().length() > 0) {
                sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            } else {
                sb.append("00000000000000");
            }
            if (vo.getInscEst() == null || vo.getInscEst().isEmpty()) {
                sb.append(this.getFormatedString("ISENTO", 14));
            } else {
                sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            }
            sb.append(this.getFormatedDate(vo.getDataMovimento()));
            if (vo.getUf() != null && vo.getUf().trim().length() > 0) {
                sb.append(vo.getUf());
            } else {
                sb.append(this.getFormatedString("", 2));
            }
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedNumero(Integer.valueOf(this.getClearString(vo.getCfop())), 0, 4));
            sb.append(tipo);
            sb.append(this.getFormatedNumero(vo.getValorTotal(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsTributado(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcms(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsIsento(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsOutra(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getAliquotaIcms(), 2, 2));
            try {
                sb.append(this.getSituacaoDocumento(vo.getSituacaoDoc()));
            }
            catch (ExceptionService ex) {
                throw new ExceptionService("Situa\u00e7\u00e3o de documento invalida para sintegra NF:" + vo.getNrNota() + ".\n" + ex.getMessage());
            }
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "50", count);
        return sb;
    }

    private StringBuilder getRegistro51(TreeMap counter, List registros51) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        long count = 0L;
        for (Object o : registros51) {
            Registro51 vo = (Registro51)o;
            if (!(vo.getIpi() > 0.0) || !this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            sb.append("51");
            if (vo.getCnpj() == null || vo.getCnpj().isEmpty()) {
                sb.append(this.getFormatedNumero(0, 0, 14));
            } else {
                sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            }
            if (vo.getInscEst() == null || vo.getInscEst().isEmpty()) {
                sb.append(this.getFormatedString("ISENTO", 14));
            } else {
                sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            }
            sb.append(DateUtil.dateToStr(vo.getDataMovimento(), "yyyyMMdd"));
            sb.append(this.getFormatedString(vo.getUf(), 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            sb.append(this.getFormatedNumero(vo.getValorTotal(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getIpi(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getIpiIsento(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getIpiOutros(), 2, 11));
            sb.append(this.getFormatedString("", 20));
            sb.append(this.getSituacaoDocumento(vo.getSituacaoDoc()));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "51", count);
        return sb;
    }

    private StringBuilder getRegistro53(TreeMap counter, List registros53, String tipo) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        long count = 0L;
        for (Object o : registros53) {
            Registro53 vo = (Registro53)o;
            if (!(vo.getValorIcmsSt() > 0.0) || !this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            sb.append("53");
            if (vo.getCnpj() == null || vo.getCnpj().isEmpty()) {
                sb.append(this.getFormatedNumero(0, 0, 14));
            } else {
                sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            }
            if (vo.getInscEst() == null || vo.getInscEst().isEmpty()) {
                sb.append(this.getFormatedString("ISENTO", 14));
            } else {
                sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            }
            sb.append(DateUtil.dateToStr(vo.getDataMovimento(), "yyyyMMdd"));
            sb.append(this.getFormatedString(vo.getUf(), 2));
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            sb.append(tipo);
            sb.append(this.getFormatedNumero(vo.getValorBaseCalcIcmsSt(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsSt(), 2, 11));
            vo.setDespesasAcessorias(vo.getDespesasAcessorias());
            sb.append(this.getFormatedNumero(vo.getDespesasAcessorias(), 2, 11));
            sb.append(this.getSituacaoDocumento(vo.getSituacaoDoc()));
            sb.append("1");
            sb.append(this.getFormatedString("", 29));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "53", count);
        return sb;
    }

    private StringBuffer getRegistro54(TreeMap counter, List registros54) {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : registros54) {
            Registro54 vo = (Registro54)o;
            if (!this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) continue;
            sb.append("54");
            if (vo.getCnpj() == null || vo.getCnpj().isEmpty()) {
                sb.append(this.getFormatedNumero(0, 0, 14));
            } else {
                sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            }
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            String incIcms = vo.getIncidenciaIcms();
            if (incIcms.trim().length() >= 4) {
                incIcms = incIcms.substring(1, 4);
            }
            sb.append(incIcms);
            sb.append(this.getFormatedNumero(vo.getNumeroItem(), 0, 3));
            sb.append(this.getFormatedString(this.getClearString(vo.getProduto().toString()), 14));
            sb.append(this.getFormatedNumero(vo.getQuantidade(), 3, 8));
            sb.append(this.getFormatedNumero(vo.getValorProduto(), 2, 10));
            sb.append(this.getFormatedNumero(vo.getValorDesconto(), 2, 10));
            sb.append(this.getFormatedNumero(vo.getValorIcmsTributado(), 2, 10));
            sb.append(this.getFormatedNumero(vo.getValorBaseCalcIcmsSt(), 2, 10));
            sb.append(this.getFormatedNumero(vo.getValorIpi(), 2, 10));
            sb.append(this.getFormatedNumero(vo.getAliquotaIcms(), 2, 2));
            sb.append(this.getFinalLine());
            this.addProduto(vo.getProduto());
            ++count;
        }
        this.putCount(counter, "54", count);
        return sb;
    }

    private StringBuffer getRegistro54Opcional(TreeMap counter, Registro54Opcional vo, Double valor) {
        StringBuffer sb = new StringBuffer();
        if (this.validarModeloDocFiscal(vo.getCodigoModeloDocFiscal())) {
            sb.append("54");
            if (vo.getCnpj() == null || vo.getCnpj().isEmpty()) {
                sb.append(this.getFormatedNumero(0, 0, 14));
            } else {
                sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            }
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            sb.append(this.getFormatedString("", 3));
            sb.append(this.getFormatedNumero(vo.getNumeroItem(), 0, 3));
            sb.append(this.getFormatedString("", 14));
            sb.append(this.getFormatedNumero(0, 3, 8));
            sb.append(this.getFormatedNumero(0, 2, 10));
            sb.append(this.getFormatedNumero(valor, 2, 10));
            sb.append(this.getFormatedNumero(0, 2, 10));
            sb.append(this.getFormatedNumero(0, 2, 10));
            sb.append(this.getFormatedNumero(0, 2, 10));
            sb.append(this.getFormatedNumero(0, 2, 2));
            sb.append(this.getFinalLine());
            this.putCount(counter, "54", 1L);
        }
        return sb;
    }

    private StringBuffer getRegistro61(TreeMap counter, List registros61, List registros61R) {
        Object vo;
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : registros61) {
            vo = (Registro61)o;
            sb.append("61");
            sb.append(this.getFormatedString("", 28));
            sb.append(DateUtil.dateToStr(((Registro61)vo).getDataEmissao(), "yyyyMMdd"));
            sb.append(this.getFormatedNumero(Integer.parseInt(((Registro61)vo).getModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(((Registro61)vo).getSerie(), 3));
            sb.append(this.getFormatedString("", 2));
            sb.append(this.getFormatedNumero(((Registro61)vo).getNumInicial(), 0, 6));
            sb.append(this.getFormatedNumero(((Registro61)vo).getNumFinal(), 0, 6));
            sb.append(this.getFormatedNumero(((Registro61)vo).getValorTotal(), 2, 11));
            sb.append(this.getFormatedNumero(((Registro61)vo).getValorBCIcms(), 2, 11));
            sb.append(this.getFormatedNumero(((Registro61)vo).getValorIcms(), 2, 10));
            sb.append(this.getFormatedNumero(((Registro61)vo).getValorIcmsIsento(), 2, 11));
            sb.append(this.getFormatedNumero(((Registro61)vo).getValorIcmsOutras(), 2, 11));
            sb.append(this.getFormatedNumero(((Registro61)vo).getAliquotaIcms(), 2, 2));
            sb.append(this.getFormatedString("", 1));
            sb.append(this.getFinalLine());
            ++count;
        }
        for (Object o : registros61R) {
            vo = (Registro61R)o;
            sb.append("61");
            sb.append("R");
            sb.append(DateUtil.dateToStr(((Registro61R)vo).getPeriodo(), "MMyyyy"));
            sb.append(this.getFormatedString(((Registro61R)vo).getCodProduto(), 14));
            sb.append(this.getFormatedNumero(((Registro61R)vo).getQuantidadeTotal(), 3, 10));
            sb.append(this.getFormatedNumero(((Registro61R)vo).getValorTotal(), 2, 14));
            sb.append(this.getFormatedNumero(((Registro61R)vo).getValorBCIcms(), 2, 14));
            sb.append(this.getFormatedNumero(((Registro61R)vo).getAliquotaIcms(), 2, 2));
            sb.append(this.getFormatedString("", 54));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "61", count);
        return sb;
    }

    private StringBuffer getRegistro70Proprio(TreeMap counter, List registros70) throws ExceptionService {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : registros70) {
            Registro70 vo = (Registro70)o;
            sb.append("70");
            sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            sb.append(DateUtil.dateToStr(vo.getDataMovimento(), "yyyyMMdd"));
            sb.append(this.getFormatedString(vo.getUf(), 2));
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            sb.append(this.getFormatedNumero(vo.getValorTotal(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsTributado(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcms(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcmsIsento(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcmsOutros(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getTipoFrete(), 0, 1));
            sb.append(this.getSituacaoDocumento(vo.getSituacaoDoc()));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "70", count);
        return sb;
    }

    private StringBuffer getRegistro70Terceiros(TreeMap counter, List registros70) throws ExceptionService {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : registros70) {
            Registro70 vo = (Registro70)o;
            sb.append("70");
            sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            sb.append(DateUtil.dateToStr(vo.getDataMovimento(), "yyyyMMdd"));
            sb.append(this.getFormatedString(vo.getUf(), 2));
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerie(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNota(), 0, 6));
            sb.append(this.getFormatedString(this.getClearString(vo.getCfop()), 4));
            sb.append(this.getFormatedNumero(vo.getValorTotal(), 2, 11));
            sb.append(this.getFormatedNumero(vo.getValorIcmsTributado(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcms(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcmsIsento(), 2, 12));
            sb.append(this.getFormatedNumero(vo.getValorIcmsOutros(), 2, 12));
            if (vo.getTipoFrete() != null && vo.getTipoFrete() == 1) {
                sb.append("2");
            } else if (vo.getTipoFrete() != null && vo.getTipoFrete() == 0) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            sb.append(this.getSituacaoDocumento(vo.getSituacaoDoc()));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "70", count);
        return sb;
    }

    private StringBuffer getRegistro71(TreeMap counter, List registros71) {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : registros71) {
            Registro71 vo = (Registro71)o;
            sb.append("71");
            sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpj())), 0, 14));
            sb.append(this.getFormatedString(this.getClearString(vo.getInscEst()), 14));
            sb.append(DateUtil.dateToStr(vo.getDataEmissao(), "yyyyMMdd"));
            sb.append(this.getFormatedString(vo.getUf(), 2));
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerieCTe(), 3));
            sb.append(this.getFormatedNumero(vo.getNrCTe(), 0, 6));
            sb.append(this.getFormatedString(vo.getUfRemetenteDestinatario(), 2));
            sb.append(this.getFormatedNumero(Long.valueOf(this.getClearString(vo.getCnpjRemetente())), 0, 14));
            sb.append(this.getFormatedString(this.getClearString(vo.getInscEstRemetente()), 14));
            sb.append(DateUtil.dateToStr(vo.getDataEmissaoNotaFiscal(), "yyyyMMdd"));
            sb.append(this.getFormatedNumero(Integer.parseInt(vo.getCodigoModeloDocFiscalNotaFiscal()), 0, 2));
            sb.append(this.getFormatedString(vo.getSerieNotaFiscal(), 3));
            sb.append(this.getFormatedNumero(vo.getNrNotaFiscal(), 0, 6));
            sb.append(this.getFormatedNumero(vo.getValorTotalNotaFiscal(), 2, 12));
            sb.append(this.getFormatedString("", 12));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "71", count);
        return sb;
    }

    private StringBuffer getRegistro74Proprios(TreeMap counter, Date data, short codigoPosse, String cnpj, String inscEstadual, String sigla, List produtos) throws ExceptionService {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : produtos) {
            SaldoEstoqueGeral s = (SaldoEstoqueGeral)o;
            StringBuilder provLine = new StringBuilder();
            provLine.append("74");
            provLine.append(DateUtil.dateToStr(data, "yyyyMMdd"));
            provLine.append(this.getFormatedString(this.getClearString(s.getProduto().getIdentificador().toString()), 14));
            provLine.append(this.getFormatedNumero(s.getQuantidade(), 3, 10));
            provLine.append(this.getFormatedNumero(s.getValor(), 2, 11));
            provLine.append(codigoPosse);
            provLine.append(this.getFormatedString(this.getClearString(cnpj), 14));
            provLine.append(this.getFormatedString(this.getClearString(inscEstadual), 14));
            provLine.append(this.getFormatedString(sigla, 2));
            provLine.append(this.getFormatedString("", 45));
            provLine.append(this.getFinalLine());
            sb.append(provLine.toString());
            this.addProduto(s.getProduto());
            ++count;
        }
        this.putCount(counter, "74", count);
        return sb;
    }

    private StringBuffer getRegistro74Terceiros(TreeMap counter, Date data, short codigoPosse, String cnpj, String inscEstadual, String sigla, List<SaldoEstoqueGeralTerceiros> saldos) throws ExceptionService {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        Iterator<SaldoEstoqueGeralTerceiros> iterator = saldos.iterator();
        while (iterator.hasNext()) {
            SaldoEstoqueGeralTerceiros o;
            SaldoEstoqueGeralTerceiros s = o = iterator.next();
            StringBuilder provLine = new StringBuilder();
            provLine.append("74");
            provLine.append(DateUtil.dateToStr(data, "yyyyMMdd"));
            provLine.append(this.getFormatedString(this.getClearString(s.getIdProduto().toString()), 14));
            provLine.append(this.getFormatedNumero(s.getQuantidade(), 3, 10));
            provLine.append(this.getFormatedNumero(s.getValorTotal(), 2, 11));
            provLine.append(codigoPosse);
            provLine.append(this.getFormatedString(this.getClearString(cnpj), 14));
            provLine.append(this.getFormatedString(this.getClearString(inscEstadual), 14));
            provLine.append(this.getFormatedString(sigla, 2));
            provLine.append(this.getFormatedString("", 45));
            provLine.append(this.getFinalLine());
            sb.append(provLine.toString());
            this.addProduto((Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), s.getIdProduto()));
            ++count;
        }
        this.putCount(counter, "74", count);
        return sb;
    }

    private StringBuffer getRegistro75(TreeMap counter, Date dataInicial, Date dataFinal) {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : this.produtos) {
            Produto pr = (Produto)o;
            sb.append("75");
            sb.append(DateUtil.dateToStr(dataInicial, "yyyyMMdd"));
            sb.append(DateUtil.dateToStr(dataFinal, "yyyyMMdd"));
            sb.append(this.getFormatedString(this.getClearString(pr.getIdentificador().toString()), 14));
            if (pr.getNcm() != null) {
                sb.append(this.getFormatedString(this.getClearString(pr.getNcm().getCodigo()), 8));
            } else {
                sb.append(this.getFormatedString("", 8));
            }
            sb.append(this.getFormatedString(pr.getNome(), 53));
            sb.append(this.getFormatedString(pr.getUnidadeMedida().getSigla(), 6));
            sb.append(this.getFormatedNumero(pr.getAliquotaIpi(), 2, 3));
            sb.append(this.getFormatedNumero(pr.getAliquotaIcms(), 2, 2));
            sb.append(this.getFormatedNumero(pr.getReducaoBaseCalcIcms(), 2, 3));
            if (pr.getValorTabICMSST() != null) {
                sb.append(this.getFormatedNumero(pr.getValorTabICMSST(), 2, 11));
            } else {
                sb.append(this.getFormatedNumero(0, 2, 11));
            }
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "75", count);
        return sb;
    }

    private TreeMap filterHashMaior0(TreeMap counter) {
        TreeMap h = new TreeMap();
        Set keys = counter.keySet();
        Long soma = 0L;
        for (Object o : keys) {
            Long value = (Long)counter.get(o);
            if (value == null || value <= 0L) continue;
            h.put(o, value);
            soma = soma + value;
        }
        h.put("99", soma);
        return h;
    }

    private List getObjetos(TreeMap m) {
        LinkedList t = new LinkedList();
        Set keys = m.keySet();
        int i = 0;
        for (Object o : keys) {
            TreeMap tm = null;
            if (t.isEmpty()) {
                tm = new TreeMap();
                t.add(tm);
            }
            if ((tm = (TreeMap)t.get(i)).size() == 9) {
                ++i;
                tm = new TreeMap();
                t.add(tm);
            }
            tm.put(o, m.get(o));
        }
        return t;
    }

    private StringBuffer getRegistro90(TreeMap counter, Empresa empresa) {
        TreeMap filter = this.filterHashMaior0(counter);
        List t = this.getObjetos(filter);
        filter.put("99", (Long)filter.get("99") + (long)t.size());
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < t.size(); ++i) {
            int brancos = 95;
            b.append("90");
            b.append(this.getFormatedNumero(Long.valueOf(this.getClearString(empresa.getPessoa().getComplemento().getCnpj())), 0, 14));
            b.append(this.getFormatedString(this.getClearString(empresa.getPessoa().getComplemento().getInscEst()), 14));
            Set keys = ((TreeMap)t.get(i)).keySet();
            ArrayList a = new ArrayList(keys);
            for (Object o : a) {
                if (o.toString().equals("10") || o.toString().equals("11")) continue;
                if (brancos - 10 < 0) break;
                brancos -= 10;
                Long value = (Long)filter.get(o);
                b.append(o.toString());
                b.append(this.getFormatedNumero(value, 0, 8));
                filter.remove(o);
            }
            b.append(this.getFormatedString("", brancos));
            b.append(t.size());
            b.append("\r\n");
        }
        return b;
    }

    public String getFormatedNumero(Number numero, int numCasasDecimais, int numCasasInteiras) {
        return ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)numero, (int)numCasasDecimais, (int)numCasasInteiras));
    }

    public String getFormatedDate(Date data) {
        return DateUtil.dateToStr(data, "yyyyMMdd");
    }

    private String getFinalLine() {
        return "\r\n";
    }

    public String getFormatedString(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if (st.length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaEspacos((String)st, (int)numeroCasas);
    }

    private String getClearString(String st) {
        return ToolString.refina((String)st);
    }

    private String getSituacaoDocumento(String codigo) throws ExceptionService {
        if (codigo.equals("00") || codigo.equals("06") || codigo.equals("08")) {
            return "N";
        }
        if (codigo.equals("02")) {
            return "S";
        }
        if (codigo.equals("01") || codigo.equals("07")) {
            return "E";
        }
        if (codigo.equals("03")) {
            return "X";
        }
        if (codigo.equals("04")) {
            return "2";
        }
        if (codigo.equals("INU")) {
            return "4";
        }
        throw new ExceptionService("C\u00f3digo de documento inv\u00e1lido para o sintegra. C\u00f3digo " + codigo);
    }

    private List<SaldoEstoqueGeral> getSaldosProprios(Date dataFinal, Empresa empresa) throws ExceptionDatabase, ExceptionService {
        return SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataFinal, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
    }

    private List<SaldoEstoqueGeralTerceiros> getSaldosTerceiros(Date dataFinal, Empresa empresa, Integer tipoEstoque, List<TipoMovimento> listNaoTipoMovimento) throws ExceptionDatabase {
        List l1 = CoreDAOFactory.getInstance().getDAOEstoqueTerceiros().findSaldoProdutoMaior0Terceiros(dataFinal, empresa, tipoEstoque, listNaoTipoMovimento);
        return l1;
    }

    private void putCount(TreeMap counter, String string, long count) {
        Long qtd = (Long)counter.get(string);
        if (qtd == null) {
            qtd = 0L;
        }
        qtd = qtd + count;
        counter.put(string, qtd);
    }

    public NotaFiscalPropria findNota(Long identificador) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "from NotaFiscalPropria n where n.identificador = :idNota";
        Query query = s.createQuery(q).setLong("idNota", identificador.longValue());
        return (NotaFiscalPropria)query.uniqueResult();
    }

    private void addProduto(Produto produto) {
        boolean achou = false;
        for (Object o : this.produtos) {
            Produto p = (Produto)o;
            if (p.getIdentificador().longValue() != produto.getIdentificador().longValue()) continue;
            achou = true;
            break;
        }
        if (!achou) {
            this.produtos.add(produto);
        }
    }

    private void addProduto(Long idProduto) {
        boolean achou = false;
        for (Object o : this.produtos) {
            Produto p = (Produto)o;
            if (p.getIdentificador().longValue() != idProduto.longValue()) continue;
            achou = true;
            break;
        }
        if (!achou) {
            Produto produto = this.findProduto((long)idProduto);
            this.produtos.add(produto);
        }
    }

    private Produto findProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "from Produto p where p.identificador = :idProduto";
        Query q = s.createQuery(query);
        q.setLong("idProduto", idProduto.longValue());
        return (Produto)q.uniqueResult();
    }

    private boolean validarModeloDocFiscal(String mod) {
        return mod.equalsIgnoreCase("1") || mod.equalsIgnoreCase("01") || mod.equalsIgnoreCase("4") || mod.equalsIgnoreCase("04") || mod.equalsIgnoreCase("6") || mod.equalsIgnoreCase("06") || mod.equals("21") || mod.equals("22") || mod.equals("55");
    }

    private List listarReg50Proprio(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro50(  n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst, n.dataEmissaoNota, n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla, n.modeloDocFiscal.codigo, n.serie, n.numeroNota,l.cfop.codigo,sum(l.valorTotal),sum(l.valorIcmsTributado),sum(l.valorIcms),sum(l.valorIcmsIsento),sum(l.valorIcmsOutros),l.aliquotaIcms,n.situacaoDocumento.codigo) from NotaFiscalPropria n  inner join n.livrosFiscais l where  n.empresa = :empresa  and n.dataEmissaoNota between :dataIn and :dataFim  and (n.modeloDocFiscal.codigo = :cod1  or n.modeloDocFiscal.codigo = :cod2  or n.modeloDocFiscal.codigo = :cod3  or n.modeloDocFiscal.codigo = :cod4  or n.modeloDocFiscal.codigo = :cod5  or n.modeloDocFiscal.codigo = :cod6)  group by  n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst, n.dataEmissaoNota, n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla, n.serie, n.numeroNota, n.modeloDocFiscal.codigo,  l.cfop.codigo, l.aliquotaIcms, n.situacaoDocumento.codigo order by  l.cfop.codigo, n.dataEmissaoNota";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cod1", "01").setString("cod2", "04").setString("cod3", "06").setString("cod4", "21").setString("cod5", "22").setString("cod6", "55").list();
        return l;
    }

    private List listarReg50Terceiros(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro50( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst, n.dataEntrada, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla, n.modeloDocFiscal.codigo, n.serie, n.numeroNota,l.cfop.codigo,sum(l.valorTotal),sum(l.valorIcmsTributado),sum(l.valorIcms),sum(l.valorIcmsIsento),sum(l.valorIcmsOutros),l.aliquotaIcms,n.situacaoDocumento.codigo) from NotaFiscalTerceiros n  inner join n.livrosFiscais l where  n.empresa = :empresa  and n.dataEntrada between :dataIn and :dataFim and (n.modeloDocFiscal.codigo = :cod1  or n.modeloDocFiscal.codigo = :cod2  or n.modeloDocFiscal.codigo = :cod3  or n.modeloDocFiscal.codigo = :cod4  or n.modeloDocFiscal.codigo = :cod5  or n.modeloDocFiscal.codigo = :cod6)  group by  n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst, n.dataEntrada, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla, n.serie, n.numeroNota, n.modeloDocFiscal.codigo,  l.cfop.codigo, l.aliquotaIcms, n.situacaoDocumento.codigo order by l.cfop.codigo, n.dataEntrada";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cod1", "01").setString("cod2", "04").setString("cod3", "06").setString("cod4", "21").setString("cod5", "22").setString("cod6", "55").list();
        return l;
    }

    private List listarReg50Inutilizacoes(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select n.numeroInicial as numeroInicial, n.numeroFinal as numeroFinal, n.dataCadastro as dataCadastro, n.modeloDocFiscal.codigo as modeloDocFiscal, n.serie as serie from InutilizacaoNumeracaoNFe n  where  n.empresa = :empresa  and n.dataCadastro between :dataIn and :dataFim  and n.status = 102";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<Registro50> dados = new ArrayList<Registro50>();
        for (Object o : l) {
            HashMap h = (HashMap)o;
            Integer numeroInicial = (Integer)h.get("numeroInicial");
            Integer numeroFinal = (Integer)h.get("numeroFinal");
            Date dataEmissao = (Date)h.get("dataCadastro");
            String modeloDocFiscal = (String)h.get("modeloDocFiscal");
            String serie = (String)h.get("serie");
            if (numeroInicial.equals(numeroFinal)) {
                Registro50 r = new Registro50();
                r.setNrNota(numeroInicial);
                r.setSerie(serie);
                r.setDataMovimento(dataEmissao);
                r.setSituacaoDoc("INU");
                r.setCodigoModeloDocFiscal(modeloDocFiscal);
                r.setAliquotaIcms(0.0);
                r.setCfop("0000");
                r.setCnpj("00000000000000");
                r.setInscEst("");
                r.setUf("");
                r.setValorIcms(0.0);
                r.setValorIcmsIsento(0.0);
                r.setValorIcmsOutra(0.0);
                r.setValorIcmsTributado(0.0);
                r.setValorTotal(0.0);
                dados.add(r);
                continue;
            }
            for (int i = numeroInicial.intValue(); i <= numeroFinal; ++i) {
                Registro50 r = new Registro50();
                r.setNrNota(i);
                r.setSerie(serie);
                r.setDataMovimento(dataEmissao);
                r.setSituacaoDoc("INU");
                r.setCodigoModeloDocFiscal(modeloDocFiscal);
                r.setAliquotaIcms(0.0);
                r.setCfop("0000");
                r.setCnpj("00000000000000");
                r.setInscEst("");
                r.setUf("");
                r.setValorIcms(0.0);
                r.setValorIcmsIsento(0.0);
                r.setValorIcmsOutra(0.0);
                r.setValorIcmsTributado(0.0);
                r.setValorTotal(0.0);
                dados.add(r);
            }
        }
        return dados;
    }

    private List listarReg51Proprio(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro51( n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst, n.dataEmissaoNota, n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla,n.serie,n.numeroNota,l.cfop.codigo,sum(l.valorTotal),sum(l.valorIpiIndustria+l.valorIpiComercio),sum(l.valorIpiIsento),sum(l.valorIpiOutros),n.situacaoDocumento.codigo, n.modeloDocFiscal.codigo) from NotaFiscalPropria n  inner join n.livrosFiscais l where n.empresa = :empresa and n.dataEmissaoNota between :dataIn and :dataFim group by n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst,n.dataEmissaoNota,n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla,n.numeroNota, l.cfop.codigo,n.serie,n.situacaoDocumento.codigo,n.modeloDocFiscal.codigo order by  l.cfop.codigo, n.dataEmissaoNota";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).list();
        return l;
    }

    private List listarReg51Terceiros(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro51( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst, n.dataEntrada, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.serie,n.numeroNota,l.cfop.codigo,sum(l.valorTotal),sum(l.valorIpiIndustria+l.valorIpiComercio),sum(l.valorIpiIsento),sum(l.valorIpiOutros),n.situacaoDocumento.codigo, n.modeloDocFiscal.codigo) from NotaFiscalTerceiros n  inner join n.livrosFiscais l where n.empresa = :empresa and n.dataEntrada between :dataIn and :dataFim group by n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj,n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst,n.dataEntrada,n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.numeroNota, l.cfop.codigo,n.serie,n.situacaoDocumento.codigo,n.modeloDocFiscal.codigo order by  l.cfop.codigo, n.dataEntrada";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).list();
        return l;
    }

    private List listarReg53Proprio(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro53( n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst, n.dataEmissaoNota, n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla,n.modeloDocFiscal.codigo,n.serie,n.numeroNota,l.cfop.codigo,sum(l.valorBCIcmsSt),sum(l.valorIcmsSt),sum(0d+0d+0d),n.situacaoDocumento.codigo,n.identificador) from NotaFiscalPropria n  inner join n.livrosFiscais l where n.empresa = :empresa and n.dataEmissaoNota between :dataIn and :dataFim group by n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.unidadeFatCliente.pessoa.complemento.inscEst,n.dataEmissaoNota,n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla,n.numeroNota, l.cfop.codigo,n.modeloDocFiscal.codigo,n.serie,n.situacaoDocumento.codigo, n.identificador order by  l.cfop.codigo, n.dataEmissaoNota";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).list();
        return l;
    }

    private List listarReg53Terceiros(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro53( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst, n.dataEntrada, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.modeloDocFiscal.codigo,n.serie,n.numeroNota,l.cfop.codigo,sum(l.valorBCIcmsSt),sum(l.valorIcmsSt),sum(0d+0d+0d),n.situacaoDocumento.codigo,n.identificador) from NotaFiscalTerceiros n  inner join n.livrosFiscais l where n.empresa = :empresa and n.dataEntrada between :dataIn and :dataFim group by n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj,n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst,n.dataEntrada,n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.numeroNota, l.cfop.codigo,n.modeloDocFiscal.codigo,n.serie,n.situacaoDocumento.codigo, n.identificador order by  l.cfop.codigo, n.dataEntrada";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).list();
        return l;
    }

    private List listarReg54Proprios(Empresa empresa, Date dataInicial, Date dataFinal, Short somarIpiOutros) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object q2 = "select new  mentorcore.service.impl.sintegra.Registro54(n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.modeloDocFiscal.codigo, n.serie, n.numeroNota, il.cfop.codigo, i.incidenciaIcms.codigo, i.incidenciaIcms.codigo, i.numeroItem, i.produto.identificador, i.quantidadeTotal, i.vrProduto + i.vrServico, i.valorDesconto, il.vrIcmsTributado, il.vrBcCalculoIcmsSt,";
        q2 = ToolMethods.isEquals((Object)somarIpiOutros, (Object)1) ? (String)q2 + " il.vrIpiIndustria + il.vrIpiComercio + il.vrIpiObservacao," : (String)q2 + " il.vrIpiIndustria + il.vrIpiComercio,";
        q2 = (String)q2 + " il.aliquotaIcms, i.valorFrete, i.valorDespAcessoria, i.vrSeguro, il.vrPis, il.vrCofins) from NotaFiscalPropria n inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal il where n.empresa = :empresa  and n.dataEmissaoNota between :dataIn and :dataFim and (n.situacaoDocumento.codigo <> :cancelado       and n.situacaoDocumento.codigo <> :canceladoExt       and n.situacaoDocumento.codigo <> :denegada) order by n.numeroNota, i.numeroItem";
        List l = s.createQuery((String)q2).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cancelado", "02").setString("canceladoExt", "03").setString("denegada", "04").list();
        return l;
    }

    private List listarReg54Terceiros(Empresa empresa, Date dataInicial, Date dataFinal, Short somarIpiOutros) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object q2 = "select new  mentorcore.service.impl.sintegra.Registro54( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.modeloDocFiscal.codigo, n.serie, n.numeroNota, il.cfop.codigo, i.incidenciaIcms.codigo, i.incidenciaIcms.codigo, i.numeroItem, i.produto.identificador, i.quantidadeTotal, i.vrProduto + i.vrServico, i.valorDesconto, il.vrIcmsTributado, il.vrBcCalculoIcmsSt,";
        q2 = ToolMethods.isEquals((Object)somarIpiOutros, (Object)1) ? (String)q2 + " il.vrIpiIndustria + il.vrIpiComercio + il.vrIpiObservacao," : (String)q2 + " il.vrIpiIndustria + il.vrIpiComercio,";
        q2 = (String)q2 + " il.aliquotaIcms, i.valorFrete, i.valorDespAcessoria, i.vrSeguro, il.vrPis, il.vrCofins) from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i inner join i.itemNotaLivroFiscal il where n.empresa = :empresa  and n.dataEntrada between :dataIn and :dataFim  and (n.modeloDocFiscal.codigo = :cod1  or n.modeloDocFiscal.codigo = :cod2  or n.modeloDocFiscal.codigo = :cod3  or n.modeloDocFiscal.codigo = :cod5) ";
        q2 = (String)q2 + " order by n.numeroNota, i.numeroItem";
        List l = s.createQuery((String)q2).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cod1", "01").setString("cod2", "04").setString("cod3", "26").setString("cod5", "55").list();
        return l;
    }

    private List listarReg54ProprioOpcional(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q2 = "select new  mentorcore.service.impl.sintegra.Registro54Opcional( n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, n.modeloDocFiscal.codigo, n.serie, n.numeroNota, i.itemNotaLivroFiscal.cfop.codigo, sum(i.valorFrete), sum(i.valorDespAcessoria), sum(i.vrSeguro),  sum(i.itemNotaLivroFiscal.vrPis + i.itemNotaLivroFiscal.vrCofins)) from NotaFiscalPropria n inner join n.livrosFiscais l inner join n.itensNotaPropria i  where n.empresa = :empresa  and n.dataEmissaoNota between :dataIn and :dataFim and n.modeloDocFiscal.geraLivroFiscal = :sim and ( i.valorFrete > 0 or i.valorDespAcessoria >0 or  i.vrSeguro > 0 or i.itemNotaLivroFiscal.vrPis + i.itemNotaLivroFiscal.vrCofins > 0) and (n.situacaoDocumento.codigo <> :cancelado       and n.situacaoDocumento.codigo <> :canceladoExt       and n.situacaoDocumento.codigo <> :denegada) group by n.unidadeFatCliente.cliente.pessoa.complemento.cnpj,  n.modeloDocFiscal.codigo, n.serie, n.numeroNota, i.itemNotaLivroFiscal.cfop.codigo";
        List l = s.createQuery(q2).setShort("sim", (short)1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cancelado", "02").setString("canceladoExt", "03").setString("denegada", "04").list();
        return l;
    }

    private List listarReg54TerceirosOpcional(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q2 = "select new  mentorcore.service.impl.sintegra.Registro54Opcional( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj, n.modeloDocFiscal.codigo, n.serie, n.numeroNota, i.itemNotaLivroFiscal.cfop.codigo, sum(i.valorFrete), sum(i.valorDespAcessoria), sum(i.vrSeguro),  sum(i.itemNotaLivroFiscal.vrPis + i.itemNotaLivroFiscal.vrCofins)) from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i  where n.empresa = :empresa  and n.dataEntrada between :dataIn and :dataFim and ( i.valorFrete > 0 or i.valorDespAcessoria >0 or  i.vrSeguro > 0 or i.itemNotaLivroFiscal.vrPis + i.itemNotaLivroFiscal.vrCofins> 0) and n.modeloDocFiscal.geraLivroFiscal = :sim group by  n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj,  n.modeloDocFiscal.codigo, n.serie, n.numeroNota, i.itemNotaLivroFiscal.cfop.codigo";
        List l = s.createQuery(q2).setShort("sim", (short)1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).list();
        return l;
    }

    private List listarReg61(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro61( n.dataEmissaoNota, n.modeloDocFiscal.codigo, n.serie, min(n.numeroNota), max(n.numeroNota), sum(l.valorTotal), sum(l.valorIcmsTributado), sum(l.valorIcms), sum(l.valorIcmsIsento), sum(l.valorIcmsOutros), l.aliquotaIcms)  from NotaFiscalPropria n  inner join n.livrosFiscais l where n.empresa = :empresa  and n.dataEmissaoNota between :dataIn and :dataFim  and (n.modeloDocFiscal.codigo  = :cod1 or n.modeloDocFiscal.codigo  = :cod2 or n.modeloDocFiscal.codigo  = :cod3 or n.modeloDocFiscal.codigo  = :cod4 or n.modeloDocFiscal.codigo  = :cod5) and n.situacaoDocumento.codigo <> :sit1 and n.situacaoDocumento.codigo <> :sit2 and n.situacaoDocumento.codigo <> :sit3 group by  n.dataEmissaoNota, n.modeloDocFiscal.codigo, n.serie, l.aliquotaIcms order by  n.dataEmissaoNota";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("cod1", "02").setString("cod2", "13").setString("cod3", "14").setString("cod4", "15").setString("cod5", "16").setString("sit1", "02").setString("sit2", "03").setString("sit3", "04").list();
        return l;
    }

    private void appendReg88EAN(TreeMap counter, PrintWriter p) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRegistro88EAN(counter));
        p.append(sb.toString());
    }

    private StringBuffer getRegistro88EAN(TreeMap counter) {
        StringBuffer sb = new StringBuffer();
        long count = 0L;
        for (Object o : this.produtos) {
            Produto pr = (Produto)o;
            if (pr.getCodigoBarras() == null || pr.getCodigoBarras().size() <= 0) continue;
            sb.append("88");
            sb.append("EAN");
            sb.append("EAN13");
            sb.append(this.getFormatedString(this.getClearString(pr.getIdentificador().toString()), 14));
            sb.append(this.getFormatedString(pr.getNome(), 53));
            sb.append(this.getFormatedString(pr.getUnidadeMedida().getSigla(), 6));
            sb.append(this.getFormatedString(((CodigoBarras)pr.getCodigoBarras().get(0)).getCodigoBarras(), 14));
            sb.append(this.getFormatedString("", 32));
            sb.append(this.getFinalLine());
            ++count;
        }
        this.putCount(counter, "88", count);
        return sb;
    }

    private List listarReg70Proprio(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select distinct  c.modeloDocFiscal.codigo as COD_MODELO_DOC_FISCAL, c.situacaoDocumento.codigo as COD_SITUACAO_DOCUMENTO, c.clienteTomador.cliente.pessoa.complemento.inscEst as INSC_EST, c.clienteTomador.cliente.pessoa.complemento.cnpj as CNPJ, c.clienteTomador.cliente.pessoa.endereco.cidade.uf.sigla as SIGLA_UF, c.serie as SERIE, c.numero as NUMERO_CTE, c.dataEmissao as DATA_EMISSAO, c.indicadorTipoFrete as TIPO_FRETE, c.cteVlrImpostos.vrReceber as VALOR_TOTAL, c.cteVlrImpostos.baseCalcIcms as BC_ICMS, c.cteVlrImpostos.vrIcms as VR_ICMS, c.cteVlrImpostos.vrIcmsIsento as VR_ICMS_ISENTO, c.cteVlrImpostos.vrIcmsOutros as VR_ICMS_OUTROS, lv.cfop.codigo as CFOP from Cte c  left join c.tipoCte tc left join c.livrosFiscais lv where  cast(c.dataEmissao as date) between :dataIn and :dataFim and c.empresa=:empresa";
        Query q = s.createQuery(q1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Registro70> toRet = new ArrayList<Registro70>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Registro70 r = new Registro70();
            r.setCnpj((String)h.get("CNPJ"));
            r.setInscEst((String)h.get("INSC_EST"));
            r.setDataMovimento((Date)h.get("DATA_EMISSAO"));
            r.setUf((String)h.get("SIGLA_UF"));
            r.setCodigoModeloDocFiscal((String)h.get("COD_MODELO_DOC_FISCAL"));
            r.setSerie((String)h.get("SERIE"));
            r.setNrNota(((Long)h.get("NUMERO_CTE")).intValue());
            r.setCfop((String)h.get("CFOP"));
            r.setValorTotal((Double)h.get("VALOR_TOTAL"));
            r.setBcIcms((Double)h.get("BC_ICMS"));
            r.setValorIcms((Double)h.get("VR_ICMS"));
            r.setValorIcmsIsento((Double)h.get("VR_ICMS_ISENTO"));
            r.setValorIcmsOutros((Double)h.get("VR_ICMS_OUTROS"));
            if ((Short)h.get("TIPO_FRETE") != null) {
                r.setTipoFrete((Short)h.get("TIPO_FRETE"));
            }
            r.setSituacaoDoc((String)h.get("COD_SITUACAO_DOCUMENTO"));
            toRet.add(r);
        }
        return toRet;
    }

    private List listarReg70Terceiros(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object q1 = "select new mentorcore.service.impl.sintegra.Registro70( n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj,n.unidadeFatFornecedor.pessoa.complemento.inscEst,n.dataEntrada,n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.modeloDocFiscal.codigo,n.serie,n.numeroNota,l.cfop.codigo,sum(l.valorTotal),sum(l.valorIcmsTributado),sum(l.valorIcms),sum(l.valorIcmsIsento),sum(l.valorIcmsOutros),n.situacaoDocumento.codigo, t.fretePorConta) from  NotaFiscalTerceiros n  left join n.tipoFrete t inner join n.livrosFiscais l where n.empresa = :empresa and n.dataEntrada between :dataIn and :dataFim and (n.modeloDocFiscal.codigo = :codModDocFiscal1 or       n.modeloDocFiscal.codigo = :codModDocFiscal2 or       n.modeloDocFiscal.codigo = :codModDocFiscal3 or       n.modeloDocFiscal.codigo = :codModDocFiscal4 or       n.modeloDocFiscal.codigo = :codModDocFiscal5 or       n.modeloDocFiscal.codigo = :codModDocFiscal6 )";
        q1 = (String)q1 + " group by n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj,n.unidadeFatFornecedor.pessoa.complemento.inscEst,n.dataEntrada,n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.sigla,n.numeroNota,n.modeloDocFiscal.codigo,l.cfop.codigo,n.serie,n.situacaoDocumento.codigo,t.fretePorConta";
        Query q = s.createQuery((String)q1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codModDocFiscal1", "07");
        q.setString("codModDocFiscal2", "08");
        q.setString("codModDocFiscal3", "09");
        q.setString("codModDocFiscal4", "10");
        q.setString("codModDocFiscal5", "11");
        q.setString("codModDocFiscal6", "57");
        List lista = q.list();
        return lista;
    }

    private List listarReg71CTeCTRC(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select distinct  ct.identificador as ID_CTRC, c.clienteTomador.cliente.pessoa.complemento.cnpj as CNPJ, c.clienteTomador.cliente.pessoa.complemento.inscEst as INSC_EST, c.dataEmissao as DATA_EMISSAO, c.clienteTomador.cliente.pessoa.endereco.cidade.uf.sigla as SIGLA_UF, c.modeloDocFiscal.codigo as COD_MODELO_DOC_FISCAL, c.serie as SERIE, c.numero as NUMERO_CTE from Ctrc ct  inner join ct.cte c where  c.dataEmissao between :dataIn and :dataFim and c.empresa=:empresa";
        Query q = s.createQuery(q1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Registro71> toRet = new ArrayList<Registro71>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idCTRC = (Long)h.get("ID_CTRC");
            List docFiscais = this.getDocFiscaisRegistro71(idCTRC);
            for (Object ob : docFiscais) {
                Registro71 r = (Registro71)ob;
                r.setCnpj((String)h.get("CNPJ"));
                r.setInscEst((String)h.get("INSC_EST"));
                r.setDataEmissao((Date)h.get("DATA_EMISSAO"));
                r.setUf((String)h.get("SIGLA_UF"));
                r.setCodigoModeloDocFiscal((String)h.get("COD_MODELO_DOC_FISCAL"));
                r.setSerieCTe((String)h.get("SERIE"));
                r.setNrCTe((Long)h.get("NUMERO_CTE"));
                toRet.add(r);
            }
        }
        return toRet;
    }

    private List getDocFiscaisRegistro71(Long idCTRC) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select distinct  ct.numeroDoc as NUMERO_NOTA, ct.serie as SERIE_NOTA, ct.dataEmissao as DATA_EMISSAO_NOTA, ct.codModeloDocFiscal as MODELO_DOC_FISCAL, ct.vrTotal as VALOR_TOTAL, ct.ctrcCargaTransportada.cnpjRemetente as CNPJ_REMETENTE, ct.ctrcCargaTransportada.cnpjDestinatario as CNPJ_DESTINATARIO, ct.ctrcCargaTransportada.inscEstRemetente as INSC_EST_REMETENTE, ct.ctrcCargaTransportada.inscEstDestinatario as INSC_EST_DESTINATARIO, ct.ctrcCargaTransportada.codMunOrigem as COD_MUN_REMETENTE, ct.ctrcCargaTransportada.codMunDestinatario as COD_MUN_DESTINATARIO from CtrcDocumentosFiscais ct  where  ct.ctrcCargaTransportada.ctrc.identificador = :idCTRC";
        Query q = s.createQuery(q1);
        q.setLong("idCTRC", idCTRC.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Registro71> docFiscais = new ArrayList<Registro71>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Registro71 r = new Registro71();
            r.setNrNotaFiscal((Long)h.get("NUMERO_NOTA"));
            r.setSerieNotaFiscal((String)h.get("SERIE_NOTA"));
            r.setDataEmissaoNotaFiscal((Date)h.get("DATA_EMISSAO_NOTA"));
            r.setCodigoModeloDocFiscalNotaFiscal(((Short)h.get("MODELO_DOC_FISCAL")).toString());
            r.setValorTotalNotaFiscal((Double)h.get("VALOR_TOTAL"));
            if ((String)h.get("CNPJ_REMETENTE") != null && (String)h.get("INSC_EST_REMETENTE") != null) {
                r.setCnpjRemetente((String)h.get("CNPJ_REMETENTE"));
                r.setInscEstRemetente((String)h.get("INSC_EST_REMETENTE"));
                r.setUfRemetenteDestinatario(this.getUFRemetenteDestinatarioNF((String)h.get("COD_MUN_REMETENTE")));
            } else {
                r.setCnpjRemetente((String)h.get("CNPJ_DESTINATARIO"));
                r.setInscEstRemetente((String)h.get("INSC_EST_DESTINATARIO"));
                r.setUfRemetenteDestinatario(this.getUFRemetenteDestinatarioNF((String)h.get("COD_MUN_DESTINATARIO")));
            }
            docFiscais.add(r);
        }
        return docFiscais;
    }

    private String getUFRemetenteDestinatarioNF(String codMunicipio) {
        String codUF = codMunicipio.substring(0, 2);
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = " select ct.sigla from UnidadeFederativa ct  where  ct.codIbge = :codigo";
        Query q = s.createQuery(q1);
        q.setString("codigo", codUF);
        String sigla = (String)q.uniqueResult();
        return sigla;
    }

    private Empresa getEmpresa(Long identificadorEmpresa) throws ExceptionService {
        Empresa emp = (Empresa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOEmpresa(), identificadorEmpresa);
        if (emp == null) {
            throw new ExceptionService("Nenhuma empresa encontrada pelo cnpj: " + identificadorEmpresa);
        }
        if (emp.getPessoa().getComplemento().getFone1() == null || emp.getPessoa().getComplemento().getFone1().isEmpty()) {
            throw new ExceptionService("Primeiro cadastre um telefone para a empresa logada!");
        }
        return emp;
    }

    private List listarReg61NFCe(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select new mentorcore.service.impl.sintegra.Registro61( n.dataEmissao, n.modeloDocFiscal.codigo, n.serie, min(cast(n.numero as int)), max(cast(n.numero as int)), sum(l.valorTotal), sum(l.valorIcmsTributado), sum(l.valorIcms), sum(l.valorIcmsIsento), sum(l.valorIcmsOutros), l.aliquotaIcms)  from NFCe n  inner join n.livrosFiscais l where n.empresa = :empresa  and n.dataEmissao between :dataIn and :dataFim  and n.situacaoDocumento.codigo <> :sit1 and n.situacaoDocumento.codigo <> :sit2 and n.situacaoDocumento.codigo <> :sit3 group by  n.dataEmissao, n.modeloDocFiscal.codigo, n.serie, l.aliquotaIcms order by  n.dataEmissao";
        List l = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("sit1", "02").setString("sit2", "03").setString("sit3", "04").list();
        for (Object object : l) {
            Registro61 r = (Registro61)object;
            String serie = r.getSerie();
            if (!ToolString.stringIsANumberInteger((String)serie).booleanValue()) continue;
            Integer serieInt = new Integer(serie);
            r.setSerie(serieInt.toString());
        }
        return l;
    }

    private List listarReg61R(Empresa empresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q1 = "select distinct i.produto.identificador as ID_PRODUTO, i.icms.aliquotaIcms as ALIQUOTA_ICMS, sum(i.quantidadeComercial) as QTDE_TOTAL, sum(i.valorTotalBruto) as VALOR_TOTAL, sum(i.icms.valorBcCalculoIcms) as VALOR_BC_ICMS, sum(i.icms.valorIcms) as VALOR_ICMS from NFCe n  inner join n.itens i where n.empresa = :empresa  and n.dataEmissao between :dataIn and :dataFim  and n.situacaoDocumento.codigo <> :sit1 and n.situacaoDocumento.codigo <> :sit2 and n.situacaoDocumento.codigo <> :sit3 group by  i.produto.identificador, i.icms.aliquotaIcms order by  i.produto.identificador";
        List lista = s.createQuery(q1).setDate("dataIn", dataInicial).setDate("dataFim", dataFinal).setEntity("empresa", (Object)empresa).setString("sit1", "02").setString("sit2", "03").setString("sit3", "04").setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<Registro61R> registros61R = new ArrayList<Registro61R>();
        for (Object ob : lista) {
            HashMap h = (HashMap)ob;
            Long idProduto = (Long)h.get("ID_PRODUTO");
            Double aliquotaIcms = (Double)h.get("ALIQUOTA_ICMS");
            Double qtdeTotal = (Double)h.get("QTDE_TOTAL");
            Double valorTotal = (Double)h.get("VALOR_TOTAL");
            Double valorBCICMS = (Double)h.get("VALOR_BC_ICMS");
            Double valorICMS = (Double)h.get("VALOR_ICMS");
            Registro61R r = new Registro61R();
            r.setCodProduto(idProduto.toString());
            r.setAliquotaIcms(aliquotaIcms);
            r.setQuantidadeTotal(qtdeTotal);
            r.setValorTotal(valorTotal);
            r.setValorBCIcms(valorBCICMS);
            r.setValorIcms(valorICMS);
            r.setPeriodo(dataFinal);
            registros61R.add(r);
            this.addProduto(idProduto);
        }
        return registros61R;
    }
}

