/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedcontabil.ano2016;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedcontabil.ano2016.SpedContabilBDConsult2016;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI050;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI051;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI052;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI150;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI155;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI200;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI250;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI350;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegI355;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegJ005;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegJ100;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegJ150;
import mentorcore.service.impl.spedcontabil.ano2016.model.RegJ800;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.file.UtilityFile;

public class SpedContabilWritter2016 {
    private static final String SPED_CONTABIL_FILE_NAME = "SPED_CONTABIL.TXT";
    LinkedHashMap counter;
    NumberFormat nf;
    SpedContabilBDConsult2016 cons = new SpedContabilBDConsult2016();
    String BANCO_CENTRAL = "01";
    String SUSEP = "02";
    String CVM = "03";
    String ANTT = "04";
    private static final TLogger logger = TLogger.get(SpedContabilWritter2016.class);

    public SpedContabilWritter2016() {
        this.counter = new LinkedHashMap();
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.cons = new SpedContabilBDConsult2016();
    }

    public void gerarArquivoSped(Integer ano, Integer mes, Integer numOrdem, String natOperacao, String diretorioArquivo, Date dataArquivamento, Integer situacao, List assinantes, Boolean gerarBalancete, Integer tipoDemBalancete, GrupoEmpresa grupoEmpresa, Short gerarBlocoJ800, List arquivosAnexos, Empresa empresa, Integer situacaoInicioPeriodo, Integer existenciaNIRE, Integer finalidadeEscrituracao, String substituicaoNIRE, Integer entidade, Integer tipoECD, String codigoSCP, Date dataEncerramentoExercicio, Short contasZeradasDRE, Short saldosComMovimentacoes) throws ExceptionService, IOException, ExceptionDatabase {
        PrintWriter pw = null;
        try {
            File f = new File(diretorioArquivo + File.separator + SPED_CONTABIL_FILE_NAME);
            FileOutputStream os = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());
            pw = new PrintWriter(osw);
            Date dataIn = this.getDataIn(ano, mes);
            Date dataFim = this.getDataFim(ano, mes);
            List rI150 = this.getRegI150(ano, mes);
            List regI050 = this.cons.getPlanoContas(dataIn, dataFim, grupoEmpresa);
            int cont = 0;
            for (Object o : rI150) {
                RegI150 r1 = (RegI150)o;
                List regi155 = this.cons.getSaldoContasSped(r1.getDataIn(), r1.getDataFim(), grupoEmpresa, saldosComMovimentacoes);
                r1.setDadosSaldos(regi155);
                System.out.println("\nMes: " + ++cont);
            }
            List regi200250 = this.cons.getLancamentosSpedContabil(dataIn, dataFim, grupoEmpresa);
            List reg350355 = this.cons.getSaldosContaAntesEnc(dataIn, dataFim, grupoEmpresa);
            List demonstracoesContabeis = new ArrayList();
            if (gerarBalancete.booleanValue()) {
                demonstracoesContabeis = this.cons.getDemonstracoesContabeis(dataIn, dataFim, tipoDemBalancete, grupoEmpresa);
                for (Iterator ob : demonstracoesContabeis) {
                    RegJ005 r1 = (RegJ005)((Object)ob);
                    r1.setRegJ100(this.cons.getBalancete(r1.getDataInicial(), r1.getDataFinal(), grupoEmpresa));
                    r1.setRegJ150(this.cons.getDemonstracaoResultadoExercicio(r1.getDataFinal(), grupoEmpresa, contasZeradasDRE));
                }
            }
            ArrayList<RegJ800> regJ800 = new ArrayList<RegJ800>();
            if (gerarBlocoJ800.equals((short)1)) {
                for (Object o : arquivosAnexos) {
                    String caminhoArquivo = (String)o;
                    RegJ800 r = new RegJ800();
                    r.setConteudoArquivo(new UtilityFile().getConteudoArquivo(caminhoArquivo));
                    regJ800.add(r);
                }
            }
            this.contarRegistros(regI050, rI150, regi200250, assinantes, demonstracoesContabeis, reg350355, gerarBalancete, gerarBlocoJ800, regJ800, empresa);
            long qtdLinhas0 = this.getCounter("0");
            long totalLinhas = this.getCounter(null);
            this.createRegister0000(dataIn, dataFim, situacao, pw, empresa, situacaoInicioPeriodo, existenciaNIRE, substituicaoNIRE, finalidadeEscrituracao, entidade, tipoECD, codigoSCP);
            this.createRegister0001(0, pw);
            this.createRegister0007(pw, empresa);
            this.createRegister0990(qtdLinhas0, pw);
            long qtdLinhasI = this.getCounter("I");
            this.createRegisterI001(qtdLinhasI - 1L > 0L ? 0 : 1, pw);
            this.createRegisterI010(pw);
            this.createRegisterI030(numOrdem, natOperacao, dataArquivamento, totalLinhas, pw, empresa, dataEncerramentoExercicio);
            this.createRegisterI050(pw, regI050);
            for (Object o : rI150) {
                RegI150 r1 = (RegI150)o;
                this.createRegisterI150(r1.getDataIn(), r1.getDataFim(), pw);
                this.createRegisterI155(r1.getDadosSaldos(), pw);
            }
            this.createRegisterI200(regi200250, pw);
            this.createRegisterI350(reg350355, pw);
            this.createRegisterI990(qtdLinhasI, pw);
            long qtdLinhasJ = this.getCounter("J");
            this.createRegisterJ001(qtdLinhasJ - 1L > 0L ? 0 : 1, pw);
            if (gerarBalancete.booleanValue()) {
                this.createRegisterJ005(demonstracoesContabeis, pw);
                this.createRegisterJ800(regJ800, pw);
            }
            this.createRegisterJ900(numOrdem, natOperacao, dataIn, dataFim, totalLinhas, pw, empresa);
            this.createRegisterJ930(assinantes, pw);
            this.createRegisterJ990(qtdLinhasJ, pw);
            long qtdLinhas9 = this.getCounter("9");
            this.createRegister9001(qtdLinhas9 - 1L > 0L ? 0 : 1, pw);
            this.createRegister9900(pw);
            this.createRegister9990(qtdLinhas9, pw);
            this.createRegister9999(totalLinhas, pw);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            throw new ExceptionService("Erro ao criar/escrever arquivo Sped Cont\u00e1bil!");
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
                this.clearFile(diretorioArquivo);
            }
        }
    }

    private void createRegister0000(Date dataIn, Date dataFim, Integer situacao, PrintWriter wr, Empresa empresa, Integer situacaoInicioPeriodo, Integer existenciaNire, String nireSubstituta, Integer finalidadeEscrituracao, Integer indicadorEntidade, Integer tipoECD, String codigoSCP) {
        wr.append("|0000");
        wr.append("|LECD");
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataIn)));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataFim)));
        wr.append("|" + empresa.getPessoa().getNome());
        wr.append("|" + ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getCnpj()));
        wr.append("|" + empresa.getPessoa().getEndereco().getCidade().getUf().getSigla());
        if (ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getInscEst()).equalsIgnoreCase("isento")) {
            wr.append("|");
        } else {
            wr.append("|" + ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getInscEst()));
        }
        wr.append("|" + empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + empresa.getPessoa().getEndereco().getCidade().getCodIbge());
        if (empresa.getPessoa().getComplemento().getInscricaoMunicipal() == null || ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getInscricaoMunicipal()).equalsIgnoreCase("isento")) {
            wr.append("|");
        } else {
            wr.append("|" + ClearUtil.refinaAll(ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getInscricaoMunicipal())));
        }
        if (situacao == null || situacao < 0 || situacao > 4) {
            wr.append("|");
        } else {
            wr.append("|" + situacao);
        }
        wr.append("|" + situacaoInicioPeriodo);
        wr.append("|" + existenciaNire);
        wr.append("|" + finalidadeEscrituracao);
        wr.append("|");
        wr.append("|" + nireSubstituta);
        wr.append("|" + indicadorEntidade);
        wr.append("|" + tipoECD);
        wr.append("|" + codigoSCP);
        wr.append("|N");
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister0001(Integer blocosDadosInf, PrintWriter wr) {
        wr.append("|0001");
        wr.append("|" + blocosDadosInf);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister0007(PrintWriter wr, Empresa emp) throws IOException, ExceptionService {
        int qtdReg = 0;
        if (emp.getEmpresaDados().getInscANTT() != null && emp.getEmpresaDados().getInscANTT().trim().length() > 0) {
            wr.append("|0007");
            wr.append("|" + this.ANTT);
            wr.append("|" + ClearUtil.refinaAll(emp.getEmpresaDados().getInscANTT()));
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscBancoCentral() != null && emp.getEmpresaDados().getInscBancoCentral().trim().length() > 0) {
            wr.append("|0007");
            wr.append("|" + this.BANCO_CENTRAL);
            wr.append("|" + ClearUtil.refinaAll(emp.getEmpresaDados().getInscBancoCentral()));
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscCVM() != null && emp.getEmpresaDados().getInscCVM().trim().length() > 0) {
            wr.append("|0007");
            wr.append("|" + this.CVM);
            wr.append("|" + ClearUtil.refinaAll(emp.getEmpresaDados().getInscCVM()));
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscSusep() != null && emp.getEmpresaDados().getInscSusep().trim().length() > 0) {
            wr.append("|0007");
            wr.append("|" + this.SUSEP);
            wr.append("|" + ClearUtil.refinaAll(emp.getEmpresaDados().getInscSusep()));
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
        if (emp.getPessoa().getComplemento().getInscEst() != null && !emp.getPessoa().getComplemento().getInscEst().equalsIgnoreCase("isento")) {
            wr.append("|0007");
            wr.append("|" + emp.getPessoa().getEndereco().getCidade().getUf().getSigla());
            wr.append("|" + ClearUtil.refinaAll(emp.getPessoa().getComplemento().getInscEst()));
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
        if (qtdReg == 0) {
            wr.append("|0007");
            wr.append("|00");
            wr.append("|");
            wr.append("|");
            wr.append("\r\n");
            ++qtdReg;
        }
    }

    private void createRegister0990(Long numberOfLines, PrintWriter wr) {
        wr.append("|0990");
        wr.append("|" + numberOfLines);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI001(Integer dadosInformados, PrintWriter wr) {
        wr.append("|I001");
        wr.append("|" + dadosInformados);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI010(PrintWriter wr) {
        wr.append("|I010");
        wr.append("|G");
        wr.append("|4.00");
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI050(PrintWriter wr, List regI050) {
        for (Object o : regI050) {
            RegI050 r = (RegI050)o;
            wr.append("|I050");
            wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(r.getDataInclusaoAlt())));
            if (r.getCodNatureza() != null) {
                wr.append("|" + ToolString.completaZeros((String)r.getCodNatureza().toString(), (int)2, (boolean)true));
            } else {
                wr.append("|");
            }
            wr.append("|" + r.getIndicadorConta());
            wr.append("|" + r.getNivelConta());
            wr.append("|" + r.getCodigoConta());
            wr.append("|" + r.getCodigoContaSuperior());
            wr.append("|" + r.getNomeDaConta().trim());
            wr.append("|");
            wr.append("\r\n");
            this.createRegisterI051(r.getPlanosReferenciados(), wr);
            this.createRegisterI052(r.getCodigosAglutinacao(), wr);
        }
    }

    private void createRegisterI051(List r, PrintWriter wr) {
        if (r != null) {
            for (Object ob : r) {
                RegI051 reg = (RegI051)ob;
                wr.append("|I051");
                wr.append("|" + reg.getCodEntResp());
                wr.append("|");
                wr.append("|" + reg.getCodConta());
                wr.append("|");
                wr.append("\r\n");
            }
        }
    }

    private void createRegisterI052(List r, PrintWriter wr) {
        if (r != null) {
            for (Object ob : r) {
                RegI052 reg = (RegI052)ob;
                wr.append("|I052");
                wr.append("|");
                wr.append("|" + reg.getCodConta());
                wr.append("|");
                wr.append("\r\n");
            }
        }
    }

    private void createRegisterI030(Integer numeroOrdem, String natOperacao, Date dataArquivamento, Long qtdLinhasArquivo, PrintWriter wr, Empresa empresa, Date dataEncerramentoExercicio) {
        wr.append("|I030");
        wr.append("|TERMO DE ABERTURA");
        wr.append("|" + numeroOrdem);
        wr.append("|" + natOperacao);
        wr.append("|" + qtdLinhasArquivo);
        wr.append("|" + empresa.getPessoa().getNome());
        wr.append("|" + ClearUtil.refinaAll(empresa.getEmpresaDados().getInscJuntaComercial()));
        wr.append("|" + ClearUtil.refinaAll(empresa.getPessoa().getComplemento().getCnpj()));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataArquivamento)));
        wr.append("|");
        wr.append("|" + String.valueOf(empresa.getPessoa().getEndereco().getCidade()));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataEncerramentoExercicio)));
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI150(Date dataIn, Date dataFim, PrintWriter wr) throws IOException {
        wr.append("|I150");
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataIn)));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataFim)));
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI155(List saldos, PrintWriter wr) throws ExceptionService, IOException {
        if (saldos != null) {
            for (Object o : saldos) {
                RegI155 saldo = (RegI155)o;
                wr.append("|I155");
                wr.append("|" + saldo.getCodConta());
                wr.append("|" + (saldo.getCodCC() != null ? saldo.getCodCC() : ""));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getSaldoInicial()));
                wr.append("|" + saldo.getIndSaldoInicial());
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getValorDebito()));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getValorCredito()));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getSaldoFinal()));
                wr.append("|" + saldo.getIndSaldoFinal());
                wr.append("|");
                wr.append("\r\n");
            }
        }
    }

    private void createRegisterI200(List lancamentos, PrintWriter pw) throws ExceptionService, IOException {
        for (Object obj : lancamentos) {
            RegI200 r = (RegI200)obj;
            pw.append("|I200");
            pw.append("|" + r.getNumero());
            pw.append("|" + DateUtil.dateToStr(r.getDataLancamento(), "ddMMyyyy"));
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorLancamento()));
            pw.append("|" + SpedContabilWritter2016.getIdentificacaoLancamentoSped((int)r.getIndicadorLancamento()));
            pw.append("|");
            pw.append("\r\n");
            this.createRegisterI250(r.getRegI250(), pw);
        }
    }

    private void createRegisterI250(List regI250, PrintWriter pw) {
        for (Object o : regI250) {
            RegI250 r = (RegI250)o;
            pw.append("|I250");
            pw.append("|" + r.getCodigoConta());
            pw.append("|");
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorPartida()));
            pw.append("|" + r.getIndDebCred());
            pw.append("|");
            pw.append("|");
            pw.append("|" + ToolString.substituiCaractereEspecial((String)r.getHistorico()).replaceAll("\\r\\n|\\r|\\n", " "));
            pw.append("|");
            pw.append("|");
            pw.append("\r\n");
        }
    }

    private void createRegisterI350(List lancamentos, PrintWriter pw) throws ExceptionService, IOException {
        for (Object obj : lancamentos) {
            RegI350 r = (RegI350)obj;
            pw.append("|I350");
            pw.append("|" + DateUtil.dateToStr(r.getDataResultado(), "ddMMyyyy"));
            pw.append("|");
            pw.append("\r\n");
            this.createRegisterI355(r.getRegI355(), pw);
        }
    }

    private void createRegisterI355(List regI355, PrintWriter pw) {
        for (Object o : regI355) {
            RegI355 r = (RegI355)o;
            pw.append("|I355");
            pw.append("|" + r.getCodConta());
            pw.append("|");
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorAntesEncerramento()));
            pw.append("|" + r.getIndicadorLancamento());
            pw.append("|");
            pw.append("\r\n");
        }
    }

    private void createRegisterI990(Long numLinhas, PrintWriter wr) {
        wr.append("|I990");
        wr.append("|" + numLinhas);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ001(int i, PrintWriter wr) {
        wr.append("|J001");
        wr.append("|" + i);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ005(List demonstracoesContabeis, PrintWriter wr) {
        for (Object o : demonstracoesContabeis) {
            RegJ005 r = (RegJ005)o;
            wr.append("|J005");
            wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(r.getDataInicial())));
            wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(r.getDataFinal())));
            wr.append("|" + r.getTipoDemBalancete());
            wr.append("|");
            wr.append("|");
            wr.append("\r\n");
            this.createRegisterJ100(r.getRegJ100(), wr);
            this.createRegisterJ150(r.getRegJ150(), wr);
        }
    }

    private void createRegisterJ100(List regj100, PrintWriter wr) {
        for (Object o : regj100) {
            RegJ100 r = (RegJ100)o;
            wr.append("|J100");
            wr.append("|" + r.getCodigoAglutinacao());
            wr.append("|" + r.getNivelAglutinacao());
            wr.append("|" + r.getIndicadorGrupoBalanco());
            wr.append("|" + r.getDescCodigoAglutinacao());
            wr.append("|" + this.formatValuesInSpedFormat(r.getValorTotal()));
            wr.append("|" + r.getIndicadorSaldo());
            wr.append("|" + this.formatValuesInSpedFormat(r.getValorTotalInicial()));
            wr.append("|" + r.getIndicadorSaldoInicial());
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ150(List regj150, PrintWriter wr) {
        for (Object o : regj150) {
            RegJ150 r = (RegJ150)o;
            wr.append("|J150");
            wr.append("|" + r.getCodigoAglutinacao());
            wr.append("|" + r.getNivelAglutinacao());
            wr.append("|" + r.getDescCodigoAglutinacao());
            wr.append("|" + this.formatValuesInSpedFormat(r.getValorTotal()));
            wr.append("|" + r.getIndicadorSaldo());
            wr.append("|");
            wr.append("|");
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ900(Integer numeroOrdem, String natOperacao, Date dataIn, Date dataFim, Long qtdLinhas, PrintWriter wr, Empresa empresa) {
        StringBuffer buffer = new StringBuffer();
        wr.append("|J900");
        wr.append("|TERMO DE ENCERRAMENTO");
        wr.append("|" + numeroOrdem);
        wr.append("|" + natOperacao);
        wr.append("|" + empresa.getPessoa().getNome());
        wr.append("|" + qtdLinhas);
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataIn)));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataFim)));
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ930(List assinantes, PrintWriter wr) {
        for (Object obj : assinantes) {
            HashMap h = (HashMap)obj;
            String crc = (String)h.get("CRC_ASSINANTE");
            String nome = (String)h.get("NOME_ASSINANTE");
            String cpf = (String)h.get("CPF_ASSINANTE");
            String funcao = (String)h.get("FUNCAO_ASSINANTE");
            String codFuncao = (String)h.get("COD_FUNCAO_ASSINANTE");
            String telefone = (String)h.get("TELEFONE_ASSINANTE");
            String email = (String)h.get("EMAIL_ASSINANTE");
            UnidadeFederativa uf = (UnidadeFederativa)h.get("UF_CRC_ASSINANTE");
            Date dataValidade = (Date)h.get("DATA_VAL_CRC_ASSINANTE");
            wr.append("|J930");
            wr.append("|" + nome);
            wr.append("|" + ClearUtil.refinaAll(cpf));
            wr.append("|" + funcao);
            wr.append("|" + codFuncao);
            if (codFuncao.equalsIgnoreCase("900") && crc != null) {
                wr.append("|" + ClearUtil.refinaAll(crc));
            } else {
                wr.append("|");
            }
            if (email != null && email.trim().length() > 0) {
                wr.append("|" + email);
            } else {
                wr.append("|");
            }
            if (telefone != null && telefone.trim().length() > 0) {
                wr.append("|" + telefone);
            } else {
                wr.append("|");
            }
            if (uf != null) {
                wr.append("|" + uf.getSigla());
            } else {
                wr.append("|");
            }
            wr.append("|");
            if (dataValidade != null) {
                wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataValidade)));
            } else {
                wr.append("|");
            }
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ990(long qtdLinhas, PrintWriter wr) {
        wr.append("|J990");
        wr.append("|" + qtdLinhas);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9001(int i, PrintWriter wr) {
        wr.append("|9001");
        wr.append("|" + i);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9900(PrintWriter wr) {
        Set keys = this.counter.keySet();
        for (Object obj : keys) {
            String reg = (String)obj;
            Long value = (Long)this.counter.get(obj);
            if (value <= 0L) continue;
            wr.append("|9900");
            wr.append("|" + reg);
            wr.append("|" + value);
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegister9990(long qtdLinhasBloco9, PrintWriter wr) {
        wr.append("|9990");
        wr.append("|" + qtdLinhasBloco9);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9999(long totalLinhasArquivo, PrintWriter wr) {
        wr.append("|9999");
        wr.append("|" + totalLinhasArquivo);
        wr.append("|");
        wr.append("\r\n");
    }

    private void contarRegistros(List contas, List saldos, List lancamentos, List assinantes, List regJ005, List reg350355, boolean gerarBalancete, Short gerarBlocoJ800, List<RegJ800> regJ800, Empresa empresa) {
        long count9900 = 0L;
        this.counter.put("0000", 1L);
        ++count9900;
        this.counter.put("0001", 1L);
        ++count9900;
        this.counter.put("0007", this.countOf0007(empresa));
        ++count9900;
        this.counter.put("0990", 1L);
        ++count9900;
        this.counter.put("I001", 1L);
        ++count9900;
        this.counter.put("I010", 1L);
        ++count9900;
        this.counter.put("I030", this.countOfI030(empresa));
        ++count9900;
        this.counter.put("I050", Long.valueOf(contas.size()));
        ++count9900;
        this.counter.put("I051", this.countOfI051(contas));
        ++count9900;
        this.counter.put("I052", this.countOfI052(contas));
        ++count9900;
        this.counter.put("I150", Long.valueOf(saldos.size()));
        ++count9900;
        this.counter.put("I155", this.countOfI155(saldos));
        ++count9900;
        this.counter.put("I200", Long.valueOf(lancamentos.size()));
        ++count9900;
        this.counter.put("I250", this.countOfI250(lancamentos));
        ++count9900;
        this.counter.put("I350", Long.valueOf(reg350355.size()));
        ++count9900;
        this.counter.put("I355", this.countOfI350(reg350355));
        ++count9900;
        this.counter.put("I990", 1L);
        ++count9900;
        this.counter.put("J001", 1L);
        ++count9900;
        if (gerarBalancete) {
            this.counter.put("J005", Long.valueOf(regJ005.size()));
            ++count9900;
            this.counter.put("J100", this.countOfJ100(regJ005));
            ++count9900;
            this.counter.put("J150", this.countOfJ150(regJ005));
            ++count9900;
            if (gerarBlocoJ800.equals((short)1)) {
                this.counter.put("J800", Long.valueOf(regJ800.size()));
                ++count9900;
            }
        }
        this.counter.put("J900", 1L);
        ++count9900;
        this.counter.put("J930", Long.valueOf(assinantes.size()));
        ++count9900;
        this.counter.put("J990", 1L);
        ++count9900;
        this.counter.put("9001", 1L);
        this.counter.put("9900", ++count9900 + 3L);
        this.counter.put("9990", 1L);
        this.counter.put("9999", 1L);
    }

    private Long countOf0007(Empresa emp) {
        long qtdReg = 0L;
        if (emp.getEmpresaDados().getInscANTT() != null && emp.getEmpresaDados().getInscANTT().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscBancoCentral() != null && emp.getEmpresaDados().getInscBancoCentral().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscCVM() != null && emp.getEmpresaDados().getInscCVM().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscBancoCentral() != null && emp.getEmpresaDados().getInscSusep().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getPessoa().getComplemento().getInscEst() != null && !emp.getPessoa().getComplemento().getInscEst().equalsIgnoreCase("isento")) {
            ++qtdReg;
        }
        if (qtdReg == 0L) {
            ++qtdReg;
        }
        return qtdReg;
    }

    private long countOfI030(Empresa empresa) {
        if (empresa.getEmpresaDados().getInscJuntaComercial() != null && empresa.getEmpresaDados().getInscJuntaComercial().trim().length() > 0) {
            return 1L;
        }
        return 0L;
    }

    private String formatValuesInSpedFormat(Double value) {
        Object cadastroRefinado = "";
        String valueStr = this.nf.format(value);
        for (int i = 0; i < valueStr.length(); ++i) {
            char carac = valueStr.charAt(i);
            if (carac == '.' || carac == '-' || carac == '+') continue;
            cadastroRefinado = (String)cadastroRefinado + String.valueOf(carac);
        }
        return cadastroRefinado;
    }

    private Long getCounter(String string) {
        Long sum = 0L;
        Set key = this.counter.keySet();
        for (Object o : key) {
            String k = (String)o;
            if (string != null && !k.startsWith(string)) continue;
            sum = sum + (Long)this.counter.get(o);
        }
        return sum;
    }

    private Object countOfI051(List contas) {
        long count = 0L;
        for (Object o : contas) {
            RegI050 r = (RegI050)o;
            if (r.getPlanosReferenciados() == null) continue;
            count += (long)r.getPlanosReferenciados().size();
        }
        return count;
    }

    private Object countOfI052(List contas) {
        long count = 0L;
        for (Object o : contas) {
            RegI050 r = (RegI050)o;
            if (r.getCodigosAglutinacao() == null) continue;
            count += (long)r.getCodigosAglutinacao().size();
        }
        return count;
    }

    private Object countOfI155(List saldos) {
        long count = 0L;
        for (Object o : saldos) {
            RegI150 r = (RegI150)o;
            if (r.getDadosSaldos() == null) continue;
            count += (long)r.getDadosSaldos().size();
        }
        return count;
    }

    private Object countOfI250(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegI200 r = (RegI200)o;
            if (r.getRegI250() == null) continue;
            count += (long)r.getRegI250().size();
        }
        return count;
    }

    private Object countOfI350(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegI350 r = (RegI350)o;
            if (r.getRegI355() == null) continue;
            count += (long)r.getRegI355().size();
        }
        return count;
    }

    private Object countOfJ100(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegJ005 r = (RegJ005)o;
            if (r.getRegJ100() == null) continue;
            count += (long)r.getRegJ100().size();
        }
        return count;
    }

    private Object countOfJ150(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegJ005 r = (RegJ005)o;
            if (r.getRegJ150() == null) continue;
            count += (long)r.getRegJ150().size();
        }
        return count;
    }

    private List getRegI150(Integer ano, Integer mes) {
        LinkedList<RegI150> l = new LinkedList<RegI150>();
        System.out.println("");
        if (mes != null) {
            l.add(this.getVoRegI150(mes, ano));
        } else {
            for (int i = 1; i <= 12; ++i) {
                l.add(this.getVoRegI150(i, ano));
            }
        }
        return l;
    }

    private RegI150 getVoRegI150(Integer mes, Integer ano) {
        RegI150 r = new RegI150();
        r.setDataIn(this.getDataIn(ano, mes));
        r.setDataFim(this.getDataFim(ano, mes));
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }

    private void clearFile(String diretorioArquivo) throws IOException {
        FileReader arquivo = null;
        PrintWriter pw = null;
        File novoArquivo = new File(diretorioArquivo + File.separator + SPED_CONTABIL_FILE_NAME);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            arquivo = new FileReader(novoArquivo);
            BufferedReader buffer = new BufferedReader(arquivo);
            while (buffer.ready()) {
                String line = buffer.readLine();
                if (line.isEmpty()) continue;
                stringBuffer.append(ToolString.substituiCaractereEspecial((String)line));
                stringBuffer.append("\r\n");
            }
            FileOutputStream os = new FileOutputStream(novoArquivo);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());
            pw = new PrintWriter(osw);
            pw.append(stringBuffer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("Erro ao remover caracteres especiais do arquivo Sped Cont\u00e1bil!");
        }
        finally {
            try {
                pw.flush();
                pw.close();
                arquivo.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new IOException("Erro ao remover caracteres especiais do arquivo Sped Cont\u00e1bil!");
            }
        }
    }

    private void createRegisterJ800(List<RegJ800> regJ800, PrintWriter pw) {
        Iterator<RegJ800> iterator = regJ800.iterator();
        while (iterator.hasNext()) {
            RegJ800 obj;
            RegJ800 r = obj = iterator.next();
            String conteudo = r.getConteudoArquivo();
            pw.append("|J800");
            pw.append("|" + conteudo);
            pw.append("|J800FIM|");
            pw.append("\r\n");
        }
    }

    public static String getIdentificacaoLancamentoSped(Integer flag) {
        if (flag != null && flag.equals(1)) {
            return "E";
        }
        return "N";
    }
}

