/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedcontabil.ano2020;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaSped;
import com.touchcomp.basementor.model.vo.SaldoContaAno;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoConta;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI050;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI051;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI052;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI155;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI200;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI250;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI350;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegI355;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegJ005;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegJ100;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegJ150;
import mentorcore.service.impl.spedcontabil.ano2020.model.RegJ210;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.planoconta.UtilityPlanoConta;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class SpedContabilBDConsult2020 {
    public List getPlanoContas(Date dataInicio, Date dataFim, GrupoEmpresa grupoEmpresa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct new " + RegI050.class.getCanonicalName() + "(pc.dataCadastro,  pc.naturezaOperacaoPC.codigo,  pc.marca as marca,  pc.codigo as codigo,  pc.descricao) from PlanoConta pc  where pc.dataCadastro<=:dataFim  order by pc.codigo ");
        q.setDate("dataFim", dataFim);
        List l = q.list();
        for (Object o : l) {
            RegI050 r = (RegI050)o;
            if (r.getIndicadorConta() != 'A') continue;
            r.setPlanosReferenciados(this.getPlanosReferenciados(r.getCodigoConta(), dataInicio, dataFim));
            r.setCodigosAglutinacao(this.getCodigosAglutinacao(r.getCodigoConta()));
        }
        return l;
    }

    private List<RegI051> getPlanosReferenciados(String codigoConta, Date dataInicial, Date dataFinal) {
        PlanoContaSped planoSped = CoreUtilityFactory.getUtilityPlanoConta().findPlanoContaSpedPorCodigoContaAndData(codigoConta, dataInicial, dataFinal);
        ArrayList<RegI051> lista = new ArrayList<RegI051>();
        if (planoSped != null) {
            RegI051 r = new RegI051(planoSped.getEntResponsavel().getCodigoResponsavel(), planoSped.getCodigo());
            lista.add(r);
        }
        return lista;
    }

    private List getCodigosAglutinacao(String codigoConta) {
        RegI052 r = new RegI052(codigoConta);
        ArrayList<RegI052> lista = new ArrayList<RegI052>();
        lista.add(r);
        return lista;
    }

    public List getSaldoContasSped(Date dataIn, Date dataFim, GrupoEmpresa gr, Short saldoComMovimentacoes) {
        List saldos = this.findSaldosContasAnaliticasPeriodoMaior0Sped(dataIn, dataFim, null, null, gr, saldoComMovimentacoes);
        ArrayList<RegI155> ret = new ArrayList<RegI155>();
        for (Object o : saldos) {
            SaldoContaContabil s = (SaldoContaContabil)o;
            RegI155 r = new RegI155();
            r.setCodConta(s.getCodigoPlanoConta());
            r.setSaldoFinal(s.getSaldoAtual());
            r.setSaldoInicial(s.getSaldoAnterior());
            r.setValorCredito(s.getValorCredito());
            r.setValorDebito(s.getValorDebito());
            ret.add(r);
            System.out.println("\nCONTA: " + s.getCodigoPlanoConta());
        }
        return ret;
    }

    public List findSaldosContasAnaliticasPeriodoMaior0Sped(Date dataIn, Date dataFim, Integer index, Integer salto, GrupoEmpresa gr, Short saldosComMovimentacoes) {
        if (saldosComMovimentacoes != null && saldosComMovimentacoes.equals((short)1)) {
            return new CoreDAOFactory().getDAOSaldoConta().findSaldoContaContabilGeral(null, null, dataIn, dataFim, gr.getIdentificador(), null, null, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsTipoSaldoRetorno.TODAS_COM_ALGUM_VALOR_OU_SALDO_DIF_0, EnumConstantsNivelContaRet.CONTAS_NIVEL_ANALITICO, EnumConstantsOrdenacao.ORDEM_NUMERICA);
        }
        return new CoreDAOFactory().getDAOSaldoConta().findSaldoContaContabilGeral(null, null, dataIn, dataFim, gr.getIdentificador(), null, null, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.CONTAS_NIVEL_ANALITICO, EnumConstantsOrdenacao.ORDEM_NUMERICA);
    }

    private char adicionarNivelDRE(char nivel) {
        if (nivel == '5') {
            return '6';
        }
        if (nivel == '4') {
            return '5';
        }
        if (nivel == '3') {
            return '4';
        }
        if (nivel == '2') {
            return '3';
        }
        return '2';
    }

    public List getLancamentosSpedContabil(Date dataIn, Date dataFim, GrupoEmpresa gr) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  pcCred.codigo as codigoContaCred,pcDeb.codigo as codigoContaDeb,p.valor as valor,hist.identificador as codHistorico,p.historico as historico,p.loteContabil.numeroLote as numeroLote,p.loteContabil.indicador as indicador,p.loteContabil.dataLote as dataLote from Lancamento p  left join p.planoContaCred pcCred left join p.planoContaDeb pcDeb left join p.historicoPadrao hist where p.loteContabil.dataLote between :dataIn and :dataFim  and p.loteContabil.grupoEmpresa = :grupoEmpresa  order by p.loteContabil.numeroLote");
        q.setDate("dataFim", dataFim);
        q.setDate("dataIn", dataIn);
        q.setEntity("grupoEmpresa", (Object)gr);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        ArrayList<RegI200> regI200 = new ArrayList<RegI200>();
        RegI200 r200 = null;
        for (Object ob : aux) {
            RegI250 r1;
            HashMap h1 = (HashMap)ob;
            String codContaDeb = (String)h1.get("codigoContaDeb");
            String codContaCred = (String)h1.get("codigoContaCred");
            Long codHist = (Long)h1.get("codHistorico");
            long nrLote = (Long)h1.get("numeroLote");
            String historico = (String)h1.get("historico");
            Date dataLote = (Date)h1.get("dataLote");
            double valor = (Double)h1.get("valor");
            int indicador = (Integer)h1.get("indicador");
            if (r200 == null || r200.getNumero() != nrLote) {
                r200 = new RegI200(nrLote, dataLote, 0.0, indicador);
                r200.setRegI250(new ArrayList());
                regI200.add(r200);
            }
            if (codContaDeb != null) {
                r1 = new RegI250();
                r1.setCodigoConta(codContaDeb);
                r1.setCodigoHistorico(codHist);
                r1.setHistorico(historico);
                r1.setIndDebCred('D');
                r1.setValorPartida(valor);
                r200.setValorLancamento(r200.getValorLancamento() + valor / 2.0);
                r200.getRegI250().add(r1);
            }
            if (codContaCred == null) continue;
            r1 = new RegI250();
            r1.setCodigoConta(codContaCred);
            r1.setCodigoHistorico(codHist);
            r1.setHistorico(historico);
            r1.setIndDebCred('C');
            r1.setValorPartida(valor);
            r200.getRegI250().add(r1);
            r200.setValorLancamento(r200.getValorLancamento() + valor / 2.0);
        }
        return regI200;
    }

    public List getSaldosContaAntesEnc(Date dataIn, Date dataFim, GrupoEmpresa gr) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct pc from EncerramentoContabil pc where pc.dataFinal between :dataIn and :dataFim and pc.empresa.empresaDados.grupoEmpresa = :grupoEmpresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)gr);
        List l = q.list();
        ArrayList<RegI350> aux = new ArrayList<RegI350>();
        for (EncerramentoContabil r : l) {
            RegI350 r1 = new RegI350(r.getDataFinal());
            r1.setRegI355(this.putI355(r, gr));
            aux.add(r1);
        }
        return aux;
    }

    private List putI355(EncerramentoContabil r, GrupoEmpresa gr) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct new " + RegI355.class.getCanonicalName() + "(s.conta.codigo,s.saldoAntesEnc) from SaldoContaAno s where s.dataBase between :dataIn and :dataFim and s.conta.naturezaOperacaoPC = :natOperacao and s.conta.marca = :marca and s.grupoEmpresa = :grupoEmpresa ");
        q.setDate("dataIn", r.getDataInicial());
        q.setDate("dataFim", r.getDataFinal());
        q.setInteger("natOperacao", 4);
        q.setInteger("marca", EnumConstSinteticoAnalitico.ANALITICO.getValueInt());
        q.setEntity("grupoEmpresa", (Object)gr);
        List l = q.list();
        return l;
    }

    public List getDemonstracoesContabeis(Date dataIn, Date dataFim, int tipoDemBalancete, GrupoEmpresa gr, String cabecalhoDemonstracao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct pc from EncerramentoContabil pc where pc.dataFinal between :dataIn and :dataFim and pc.empresa.empresaDados.grupoEmpresa = :grupoEmpresa order by pc.dataFinal");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)gr);
        List l = q.list();
        ArrayList<RegJ005> aux = new ArrayList<RegJ005>();
        for (EncerramentoContabil r : l) {
            RegJ005 r1 = new RegJ005();
            r1.setDataInicial(r.getDataInicial());
            r1.setDataFinal(r.getDataFinal());
            r1.setTipoDemBalancete(tipoDemBalancete);
            r1.setCabecalhoDemonstracao(cabecalhoDemonstracao);
            aux.add(r1);
        }
        return aux;
    }

    public List getBalancete(Date dataInicial, Date dataFim, GrupoEmpresa gr, Short gerarBalancoSintetico) throws ExceptionDatabase {
        List saldos = this.findSaldosContasBalanceteMaior0Sped(dataInicial, dataFim, gr);
        ArrayList<RegJ100> ret = new ArrayList<RegJ100>();
        int cont = 1;
        for (Object o : saldos) {
            SaldoConta s = (SaldoConta)o;
            PlanoConta pc = (PlanoConta)CoreDAOFactory.getInstance().getDAOPlanoConta().findByPrimaryKey(s.getIdPlanoConta());
            if (!pc.getDataCadastro().before(dataFim) && !pc.getDataCadastro().equals(dataFim) || pc.getNaturezaOperacaoPC() == null || !pc.getNaturezaOperacaoPC().getCodigo().equalsIgnoreCase("01") && !pc.getNaturezaOperacaoPC().getCodigo().equalsIgnoreCase("02") && !pc.getNaturezaOperacaoPC().getCodigo().equalsIgnoreCase("03")) continue;
            RegJ100 r = new RegJ100();
            if (!gerarBalancoSintetico.equals((short)0) && !((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isSintetica(pc)) continue;
            System.out.println("\nCONTA: " + s.getCodigo() + "CONTADOR: " + cont);
            ++cont;
            r.setCodigoAglutinacao(s.getCodigo());
            r.setDescCodigoAglutinacao(pc.getDescricao());
            if (((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(pc)) {
                r.setIndicadorCodigoAglutinacao('D');
            } else {
                r.setIndicadorCodigoAglutinacao('T');
            }
            if (pc.getNaturezaOperacaoPC() != null && pc.getNaturezaOperacaoPC().getCodigo().equalsIgnoreCase("01")) {
                r.setIndicadorGrupoBalanco('A');
            } else {
                r.setIndicadorGrupoBalanco('P');
            }
            r.setNivelAglutinacao(UtilityPlanoConta.getNivelPlanoContaChar(r.getCodigoAglutinacao()));
            if (r.getNivelAglutinacao() == '5') {
                r.setCodigoAglutinacaoSuperior(pc.getCodigo().substring(0, 5) + "00000");
            } else if (r.getNivelAglutinacao() == '4') {
                r.setCodigoAglutinacaoSuperior(pc.getCodigo().substring(0, 3) + "0000000");
                if (gerarBalancoSintetico.equals((short)1)) {
                    r.setIndicadorCodigoAglutinacao('D');
                }
            } else if (r.getNivelAglutinacao() == '3') {
                r.setCodigoAglutinacaoSuperior(pc.getCodigo().substring(0, 2) + "00000000");
            } else if (r.getNivelAglutinacao() == '2') {
                r.setCodigoAglutinacaoSuperior(pc.getCodigo().substring(0, 1) + "000000000");
            }
            r.setValorTotal(s.getSaldoAtual());
            if (r.getValorTotal() > 0.0) {
                r.setIndicadorSaldo('D');
            } else {
                r.setIndicadorSaldo('C');
            }
            r.setValorTotalInicial(s.getSaldoInicial());
            if (r.getValorTotalInicial() > 0.0) {
                r.setIndicadorSaldoInicial('D');
            } else {
                r.setIndicadorSaldoInicial('C');
            }
            ret.add(r);
        }
        return ret;
    }

    public List findSaldosContasBalanceteMaior0Sped(Date dataInicial, Date dataFim, GrupoEmpresa gr) {
        List principal = this.getDadosBalancete(dataInicial, dataFim, gr);
        Date dataAnterior = DateUtil.previousDays(dataInicial, 1);
        List old = this.getDadosBalancete(dataAnterior, dataAnterior, gr);
        ArrayList<SaldoConta> saldos = new ArrayList<SaldoConta>();
        for (HashMap h : principal) {
            Long idPlanoConta = (Long)h.get("ID_PLANO_CONTA");
            System.out.println("\nBALANCETE ID:" + idPlanoConta);
            for (HashMap hh : old) {
                Long idPlanoContaAnterior = (Long)hh.get("ID_PLANO_CONTA");
                if (!idPlanoConta.equals(idPlanoContaAnterior)) continue;
                h.put("SALDO_INICIAL", (Double)hh.get("SALDO_ATUAL"));
                break;
            }
            if (h.get("SALDO_INICIAL") == null) {
                h.put("SALDO_INICIAL", 0.0);
            }
            SaldoConta saldo = new SaldoConta(this);
            saldo.setIdPlanoConta(idPlanoConta);
            saldo.setCodigo((String)h.get("CODIGO_PLANO_CONTA"));
            saldo.setSaldoAnterior((Double)h.get("SALDO_ANTERIOR"));
            saldo.setValorDebito((Double)h.get("VALOR_DEBITO"));
            saldo.setValorCredito((Double)h.get("VALOR_CREDITO"));
            saldo.setSaldoAtual((Double)h.get("SALDO_ATUAL"));
            saldo.setSaldoInicial((Double)h.get("SALDO_INICIAL"));
            saldos.add(saldo);
        }
        return saldos;
    }

    private List getDadosBalancete(Date dataInicial, Date dataFim, GrupoEmpresa gr) {
        List<SaldoContaContabil> saldos = CoreDAOFactory.getInstance().getDAOSaldoConta().findSaldoContaContabilGeral(null, null, dataInicial, dataFim, gr.getIdentificador(), 0L, 999999L, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsTipoSaldoRetorno.TODAS_COM_ALGUM_VALOR_OU_SALDO_DIF_0, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA);
        ArrayList hash = new ArrayList();
        for (SaldoContaContabil s : saldos) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("ID_PLANO_CONTA", s.getIdPlanoConta());
            h.put("CODIGO_PLANO_CONTA", s.getCodigoPlanoConta());
            h.put("SALDO_ANTERIOR", s.getSaldoAnterior());
            h.put("SALDO_ATUAL", s.getSaldoAtual());
            h.put("VALOR_DEBITO", s.getValorDebito());
            h.put("VALOR_CREDITO", s.getValorCredito());
            hash.add(h);
        }
        return hash;
    }

    public List getDemonstracaoResultadoExercicio(Date dataFim, GrupoEmpresa gr, Short contasZeradasDRE, Short gerarLancamentoResultadoDRE, PlanoConta planoContaResultadoDRE, Short gerarDRESintetico, HashMap hashSaldoAnterior) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select distinct s from SaldoContaAno s where s.dataBase = :dataFim and s.conta.naturezaOperacaoPC = :natOperacao and s.grupoEmpresa = :grupoEmpresa ";
        if (contasZeradasDRE == 1) {
            query = (String)query + " and s.saldoAntesEnc <> 0";
        }
        Query q = s.createQuery((String)query);
        q.setDate("dataFim", dataFim);
        q.setInteger("natOperacao", 4);
        q.setEntity("grupoEmpresa", (Object)gr);
        List saldos = q.list();
        ArrayList<RegJ150> ret = new ArrayList<RegJ150>();
        Double valor = 0.0;
        for (Object o : saldos) {
            SaldoContaAno saldo = (SaldoContaAno)o;
            if (!gerarDRESintetico.equals((short)0) && !((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isSintetica(saldo.getConta())) continue;
            RegJ150 r = new RegJ150();
            r.setCodigoAglutinacao(saldo.getConta().getCodigo());
            r.setDescCodigoAglutinacao(saldo.getConta().getDescricao());
            char nivel = UtilityPlanoConta.getNivelPlanoContaChar(r.getCodigoAglutinacao());
            nivel = this.adicionarNivelDRE(nivel);
            r.setNivelAglutinacao(String.valueOf(nivel));
            r.setValorFinal(saldo.getSaldoAntesEnc());
            if (((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(saldo.getConta())) {
                r.setIndicadorCodigoAglutinacao('D');
            } else {
                r.setIndicadorCodigoAglutinacao('T');
            }
            if (nivel == '6') {
                r.setCodigoAglutinacaoSuperior(saldo.getConta().getCodigo().substring(0, 5) + "00000");
            } else if (nivel == '5') {
                r.setCodigoAglutinacaoSuperior(saldo.getConta().getCodigo().substring(0, 3) + "0000000");
                if (gerarDRESintetico.equals((short)1)) {
                    r.setIndicadorCodigoAglutinacao('D');
                }
            } else if (nivel == '4') {
                r.setCodigoAglutinacaoSuperior(saldo.getConta().getCodigo().substring(0, 2) + "00000000");
            } else if (nivel == '3') {
                r.setCodigoAglutinacaoSuperior(saldo.getConta().getCodigo().substring(0, 1) + "000000000");
            } else if (nivel == '2') {
                r.setCodigoAglutinacaoSuperior(planoContaResultadoDRE.getCodigo());
            }
            if (r.getValorFinal() > 0.0) {
                r.setIndicadorContaFinal('D');
            } else {
                r.setIndicadorContaFinal('C');
            }
            if (saldo.getConta().getClassificacaoPlanoConta() != null) {
                r.setIndicadorGrupo(saldo.getConta().getClassificacaoPlanoConta().getCodigo());
                if (r.getNivelAglutinacao().equals("2")) {
                    valor = valor + r.getValorFinal();
                }
            }
            if (hashSaldoAnterior.get(saldo.getConta().getCodigo()) != null) {
                Double valorInicial = (Double)hashSaldoAnterior.get(saldo.getConta().getCodigo());
                r.setValorInicial(valorInicial);
                if (r.getValorInicial() > 0.0) {
                    r.setIndicadorContaInicial('D');
                } else {
                    r.setIndicadorContaInicial('C');
                }
            }
            hashSaldoAnterior.put(saldo.getConta().getCodigo(), r.getValorFinal());
            ret.add(r);
        }
        if (gerarLancamentoResultadoDRE.equals((short)1)) {
            RegJ150 r = new RegJ150();
            r.setCodigoAglutinacao(planoContaResultadoDRE.getCodigo());
            r.setDescCodigoAglutinacao(planoContaResultadoDRE.getDescricao());
            r.setNivelAglutinacao("1");
            if (valor >= 0.0) {
                r.setValorFinal(valor);
                r.setIndicadorCodigoAglutinacao('T');
                r.setIndicadorContaFinal('D');
                r.setIndicadorGrupo("D");
            } else {
                r.setValorFinal(valor * -1.0);
                r.setIndicadorCodigoAglutinacao('T');
                r.setIndicadorContaFinal('C');
                r.setIndicadorGrupo("R");
            }
            if (hashSaldoAnterior.get(planoContaResultadoDRE.getCodigo()) != null) {
                Double valorInicial = (Double)hashSaldoAnterior.get(planoContaResultadoDRE.getCodigo());
                r.setValorInicial(valorInicial);
                if (r.getValorInicial() > 0.0) {
                    r.setIndicadorContaInicial('C');
                } else {
                    r.setIndicadorContaInicial('D');
                }
            }
            hashSaldoAnterior.put(planoContaResultadoDRE.getCodigo(), r.getValorFinal());
            ret.add(r);
        }
        return ret;
    }

    public List getDemonstracaoLucrosPrejuizos(Date dataInicial, Date dataFim, GrupoEmpresa gr) throws ExceptionDatabase {
        List saldos = this.findSaldosContasBalanceteMaior0Sped(dataInicial, dataFim, gr);
        ArrayList<RegJ210> ret = new ArrayList<RegJ210>();
        int cont = 1;
        for (Object o : saldos) {
            SaldoConta s = (SaldoConta)o;
            PlanoConta pc = (PlanoConta)CoreDAOFactory.getInstance().getDAOPlanoConta().findByPrimaryKey(s.getIdPlanoConta());
            if (!pc.getDataCadastro().before(dataFim) && !pc.getDataCadastro().equals(dataFim) || pc.getNaturezaOperacaoPC() == null || !pc.getNaturezaOperacaoPC().getCodigo().equalsIgnoreCase("03") || !((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(pc)) continue;
            RegJ210 r = new RegJ210();
            System.out.println("\nCONTA: " + s.getCodigo() + "CONTADOR: " + cont);
            ++cont;
            r.setCodigoAglutinacao(s.getCodigo());
            r.setDescCodigoAglutinacao(pc.getDescricao());
            r.setValorTotalInicial(s.getSaldoInicial());
            if (r.getValorTotalInicial() > 0.0) {
                r.setIndicadorSaldoInicial('D');
            } else {
                r.setIndicadorSaldoInicial('C');
            }
            r.setValorTotal(s.getSaldoAtual());
            if (r.getValorTotal() > 0.0) {
                r.setIndicadorSaldo('D');
            } else {
                r.setIndicadorSaldo('C');
            }
            ret.add(r);
        }
        return ret;
    }

    private class SaldoConta {
        private Long idPlanoConta;
        private String codigo;
        private Double saldoAnterior = 0.0;
        private Double valorDebito = 0.0;
        private Double valorCredito = 0.0;
        private Double saldoAtual = 0.0;
        private Date data;
        private String codigoPlanoSped;
        private Double saldoInicial;

        public SaldoConta(SpedContabilBDConsult2020 spedContabilBDConsult2020) {
        }

        public Long getIdPlanoConta() {
            return this.idPlanoConta;
        }

        public void setIdPlanoConta(Long idPlanoConta) {
            this.idPlanoConta = idPlanoConta;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public void setCodigo(String codigo) {
            this.codigo = codigo;
        }

        public Double getSaldoAnterior() {
            return this.saldoAnterior;
        }

        public void setSaldoAnterior(Double saldoAnterior) {
            this.saldoAnterior = saldoAnterior;
        }

        public Double getValorDebito() {
            return this.valorDebito;
        }

        public void setValorDebito(Double valorDebito) {
            this.valorDebito = valorDebito;
        }

        public Double getValorCredito() {
            return this.valorCredito;
        }

        public void setValorCredito(Double valorCredito) {
            this.valorCredito = valorCredito;
        }

        public Double getSaldoAtual() {
            return this.saldoAtual;
        }

        public void setSaldoAtual(Double saldoAtual) {
            this.saldoAtual = saldoAtual;
        }

        public void setDataCadastro(Date date) {
            if (date != null) {
                this.data = new Date(date.getTime());
            }
        }

        public Date getDataCadastro() {
            return this.data;
        }

        public String getCodigoPlanoSped() {
            return this.codigoPlanoSped;
        }

        public void setCodigoPlanoSped(String codigoPlanoSped) {
            this.codigoPlanoSped = codigoPlanoSped;
        }

        public Double getSaldoInicial() {
            return this.saldoInicial;
        }

        public void setSaldoInicial(Double saldoInicial) {
            this.saldoInicial = saldoInicial;
        }
    }
}

