/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf;

import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.PlanoContaLivroCaixa;
import com.touchcomp.basementor.model.vo.SecfLivroCaixa;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCalculoLivroCaixaQ100 {
    public Object calcularLivroCaixaQ100(SpedEcf vo) {
        ServiceSaldoContaImpl service = (ServiceSaldoContaImpl)ConfApplicationContext.getContext().getBean(ServiceSaldoContaImpl.class);
        List todosSaldos = service.findSaldosConta(Long.valueOf(0L), Long.valueOf(99999L), "1000000000", "9999999999", vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsNivelContaRet.CONTAS_NIVEL_ANALITICO, EnumConstantsOrdenacao.ORDEM_NUMERICA);
        ArrayList<SaldoContaContabil> saldos = new ArrayList<SaldoContaContabil>();
        block0: for (Object o : vo.getPlanoContaLivroCaixa()) {
            PlanoContaLivroCaixa p = (PlanoContaLivroCaixa)o;
            for (SaldoContaContabil s : todosSaldos) {
                if (!p.getPlanoConta().getIdentificador().equals(s.getIdPlanoConta())) continue;
                saldos.add(s);
                continue block0;
            }
        }
        Double saldoAnterior = 0.0;
        for (SaldoContaContabil s : saldos) {
            if (s.getSaldoAnterior() >= 0.0) {
                saldoAnterior = saldoAnterior + s.getSaldoAnterior();
                continue;
            }
            saldoAnterior = saldoAnterior - s.getSaldoAnterior() * -1.0;
        }
        List<SecfLivroCaixa> livros = new ArrayList<SecfLivroCaixa>();
        this.createRegistroSaldoAnterior(saldoAnterior, vo.getDataInicial(), livros);
        livros = this.createOutrosRegistros(saldos, vo, livros);
        return livros;
    }

    private void createRegistroSaldoAnterior(Double saldoAnterior, Date data, List<SecfLivroCaixa> livros) {
        SecfLivroCaixa s = new SecfLivroCaixa();
        s.setIndice(Integer.valueOf(0));
        s.setHistorico("SALDO ANTERIOR");
        s.setData(data);
        if (saldoAnterior > 0.0) {
            s.setValorEntrada(saldoAnterior);
        } else {
            s.setValorSaida(saldoAnterior);
        }
        s.setSaldoFinal(saldoAnterior);
        livros.add(s);
    }

    private List<SecfLivroCaixa> createOutrosRegistros(List<SaldoContaContabil> saldos, SpedEcf vo, List<SecfLivroCaixa> livros) {
        Integer n;
        SecfLivroCaixa s;
        Double valor;
        String historico;
        Date data;
        Long idLanc;
        List<HashMap> lancamentos = new ArrayList<HashMap>();
        for (SaldoContaContabil s2 : saldos) {
            lancamentos.addAll(this.getLancamentos(s2.getIdPlanoConta(), vo));
        }
        lancamentos = this.ordenarLancamentos(lancamentos);
        Integer indice = 1;
        for (HashMap h : lancamentos) {
            idLanc = (Long)h.get("F_ID_LANCAMENTO");
            data = (Date)h.get("F_DATA_LOTE");
            historico = (String)h.get("F_HISTORICO");
            String contaDeb = (String)h.get("F_CODIGO_DEB");
            valor = (Double)h.get("F_VALOR_LANCAMENTO");
            if (contaDeb == null || contaDeb.isEmpty() || !this.existeContaNosSaldos(contaDeb, saldos)) continue;
            s = new SecfLivroCaixa();
            s.setData(data);
            s.setNrDoc(idLanc.toString());
            s.setHistorico(contaDeb + " - " + historico);
            s.setValorEntrada(valor);
            s.setIndice(indice);
            n = indice;
            indice = indice + 1;
            livros.add(s);
        }
        for (HashMap h : lancamentos) {
            idLanc = (Long)h.get("F_ID_LANCAMENTO");
            data = (Date)h.get("F_DATA_LOTE");
            historico = (String)h.get("F_HISTORICO");
            String contaCred = (String)h.get("F_CODIGO_CRED");
            valor = (Double)h.get("F_VALOR_LANCAMENTO");
            if (contaCred == null || contaCred.isEmpty() || !this.existeContaNosSaldos(contaCred, saldos)) continue;
            s = new SecfLivroCaixa();
            s.setData(data);
            s.setNrDoc(idLanc.toString());
            s.setHistorico(contaCred + " - " + historico);
            s.setValorSaida(valor);
            s.setIndice(indice);
            n = indice;
            indice = indice + 1;
            livros.add(s);
        }
        livros = this.ordenarLivros(livros);
        livros = this.setarIndice(livros);
        return livros;
    }

    private List getLancamentos(Long idPlanoConta, SpedEcf vo) {
        Criteria c = this.criteria(Lancamento.class);
        c.createAlias("loteContabil", "l");
        c.createAlias("l.grupoEmpresa", "gr");
        c.createAlias("centroResultadoContFin", "centro", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("planoContaDeb", "pcDeb", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("planoContaCred", "pcCred", JoinType.LEFT_OUTER_JOIN);
        ProjectionList fields = Projections.projectionList();
        fields.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"F_ID_LANCAMENTO"));
        fields.add(Projections.alias((Projection)Projections.property((String)"valor"), (String)"F_VALOR_LANCAMENTO"));
        fields.add(Projections.alias((Projection)Projections.property((String)"historico"), (String)"F_HISTORICO"));
        fields.add(Projections.alias((Projection)Projections.property((String)"pcCred.codigo"), (String)"F_CODIGO_CRED"));
        fields.add(Projections.alias((Projection)Projections.property((String)"pcDeb.codigo"), (String)"F_CODIGO_DEB"));
        fields.add(Projections.alias((Projection)Projections.property((String)"l.dataLote"), (String)"F_DATA_LOTE"));
        fields.add(Projections.alias((Projection)Projections.property((String)"l.numeroLote"), (String)"F_NUMERO_LOTE"));
        fields.add(Projections.alias((Projection)Projections.property((String)"centro.descricao"), (String)"F_CENTRO_RESULTADO"));
        c.setProjection((Projection)fields);
        c.add(Restrictions.between((String)"l.dataLote", (Object)vo.getDataInicial(), (Object)vo.getDataFinal()));
        c.add((Criterion)Restrictions.eq((String)"gr.identificador", (Object)vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador()));
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"pcDeb.identificador", (Object)idPlanoConta), (Criterion)Restrictions.eq((String)"pcCred.identificador", (Object)idPlanoConta)));
        c.addOrder(Order.asc((String)"l.dataLote"));
        c.addOrder(Order.asc((String)"pcDeb.codigo"));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private Criteria criteria(Class voClass) {
        Session session = CoreBdUtil.getInstance().getSession();
        return session.createCriteria(voClass);
    }

    private List<HashMap> ordenarLancamentos(List<HashMap> lancamentos) {
        if (lancamentos != null) {
            Collections.sort(lancamentos, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    Map item1 = (Map)o1;
                    Map item2 = (Map)o2;
                    Date data1 = (Date)item1.get("F_DATA_LOTE");
                    Date data2 = (Date)item2.get("F_DATA_LOTE");
                    return data1.compareTo(data2);
                }
            });
            return lancamentos;
        }
        return new ArrayList<HashMap>();
    }

    private boolean existeContaNosSaldos(String codigoConta, List<SaldoContaContabil> saldos) {
        for (SaldoContaContabil s : saldos) {
            if (!s.getCodigoPlanoConta().equals(codigoConta)) continue;
            return true;
        }
        return false;
    }

    private List<SecfLivroCaixa> ordenarLivros(List<SecfLivroCaixa> livros) {
        if (livros != null) {
            Collections.sort(livros, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    SecfLivroCaixa item1 = (SecfLivroCaixa)o1;
                    SecfLivroCaixa item2 = (SecfLivroCaixa)o2;
                    Date data1 = item1.getData();
                    Date data2 = item2.getData();
                    return data1.compareTo(data2);
                }
            });
            return livros;
        }
        return new ArrayList<SecfLivroCaixa>();
    }

    private List<SecfLivroCaixa> setarIndice(List<SecfLivroCaixa> livros) {
        Integer indice = 0;
        for (SecfLivroCaixa livro : livros) {
            livro.setIndice(indice);
            Integer n = indice;
            indice = indice + 1;
        }
        return livros;
    }
}

