/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.SecfReceitaVendaCnae;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCalculoReceitaVendasCnaeY540 {
    public Object calcularReceitaVendaCnaeY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal) {
        HashMap hash = new HashMap();
        HashMap hashDevolucao = new HashMap();
        this.getRegistrosNotasPropriasY540(grupoEmpresa, dataInicial, dataFinal, hash);
        this.getRegistrosNFCeY540(grupoEmpresa, dataInicial, dataFinal, hash);
        this.getRegistrosCuponsFiscaisY540(grupoEmpresa, dataInicial, dataFinal, hash);
        this.getRegistrosCTeY540(grupoEmpresa, dataInicial, dataFinal, hash);
        this.getRegistrosRpsY540(grupoEmpresa, dataInicial, dataFinal, hash);
        this.getRegistrosNotasPropriasDevolucaoY540(grupoEmpresa, dataInicial, dataFinal, hashDevolucao);
        this.getRegistrosNotasTerceirosDevolucaoY540(grupoEmpresa, dataInicial, dataFinal, hashDevolucao);
        ArrayList<SecfReceitaVendaCnae> lista = new ArrayList<SecfReceitaVendaCnae>();
        List empresas = CoreDAOFactory.getInstance().getDAOEmpresa().findListaEmpresa();
        for (Empresa emp : empresas) {
            Double valor;
            SecfReceitaVendaCnae r = new SecfReceitaVendaCnae();
            r.setCnae(emp.getEmpresaDados().getCnae());
            r.setEmpresa(emp);
            if (hash.get(emp.getIdentificador()) != null) {
                valor = (Double)hash.get(emp.getIdentificador());
                r.setValorReceitaBruta(valor);
            }
            if (hashDevolucao.get(emp.getIdentificador()) != null) {
                valor = (Double)hashDevolucao.get(emp.getIdentificador());
                r.setValorDevolucao(valor);
            }
            r.setValor(Double.valueOf(r.getValorReceitaBruta() - r.getValorDevolucao()));
            lista.add(r);
        }
        return lista;
    }

    private void getRegistrosNotasPropriasY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR, i.notaFiscalPropria.empresa.identificador as ID_EMPRESA from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVenda = :cfopReceitaVenda  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and i.notaFiscalPropria.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by i.notaFiscalPropria.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVenda", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (valor == null) continue;
            hash.put(idEmpresa, valor);
        }
    }

    private void getRegistrosNFCeY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.valorTotal) as VALOR, i.nfce.empresa.identificador as ID_EMPRESA from NFCe n  inner join n.itens i   where      i.cfop.cfopReceitaVenda = :cfopReceitaVenda  and i.cfop.codigo.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.status = :ativo and i.nfce.dataEmissao between :dataIn and :dataFim  and (   i.nfce.situacaoDocumento.codigo = :codSitDoc1       or i.nfce.situacaoDocumento.codigo = :codSitDoc2       or i.nfce.situacaoDocumento.codigo = :codSitDoc3       or i.nfce.situacaoDocumento.codigo = :codSitDoc4       or i.nfce.situacaoDocumento.codigo = :codSitDoc5) and i.nfce.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by i.nfce.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVenda", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setShort("ativo", (short)1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (valor == null) continue;
            hash.put(idEmpresa, valor);
        }
    }

    private void getRegistrosCuponsFiscaisY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.valorTotal) as VALOR, c.cupom.empresa.identificador as ID_EMPRESA from CupomFiscal c  where      c.cancelado = :nao and c.cupom.dataMovimentacao between :dataIn and :dataFim  and c.cupom.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by c.cupom.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (hash.get(idEmpresa) != null) {
                Double valorHash = (Double)hash.get(idEmpresa);
                hash.put(idEmpresa, valorHash + valor);
                continue;
            }
            hash.put(idEmpresa, valor);
        }
    }

    private void getRegistrosCTeY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.cteVlrImpostos.vrReceber) as VALOR, c.empresa.identificador as ID_EMPRESA from Cte c  where      c.dataEmissao between :dataIn and :dataFim  and (c.situacaoDocumento.codigo = :codSitDoc1       or c.situacaoDocumento.codigo = :codSitDoc2       or c.situacaoDocumento.codigo = :codSitDoc3       or c.situacaoDocumento.codigo = :codSitDoc4       or c.situacaoDocumento.codigo = :codSitDoc5) and c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by c.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (hash.get(idEmpresa) != null) {
                Double valorHash = (Double)hash.get(idEmpresa);
                hash.put(idEmpresa, valorHash + valor);
                continue;
            }
            hash.put(idEmpresa, valor);
        }
    }

    private void getRegistrosRpsY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.valorServico) as VALOR, c.empresa.identificador as ID_EMPRESA from Rps c  where      c.dataEmissao between :dataIn and :dataFim  and c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by c.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (hash.get(idEmpresa) != null) {
                Double valorHash = (Double)hash.get(idEmpresa);
                hash.put(idEmpresa, valorHash + valor);
                continue;
            }
            hash.put(idEmpresa, valor);
        }
    }

    private void getRegistrosNotasPropriasDevolucaoY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hashDevolucao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR, i.notaFiscalPropria.empresa.identificador as ID_EMPRESA from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVenda = :nao  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :sim and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and i.notaFiscalPropria.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by i.notaFiscalPropria.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (valor == null) continue;
            hashDevolucao.put(idEmpresa, valor);
        }
    }

    private void getRegistrosNotasTerceirosDevolucaoY540(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, HashMap hashDevolucao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR, i.notaFiscalTerceiros.empresa.identificador as ID_EMPRESA from ItemNotaTerceiros i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVenda = :nao  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :sim and i.notaFiscalTerceiros.dataEntrada between :dataIn and :dataFim  and i.notaFiscalTerceiros.empresa.empresaDados.grupoEmpresa = :grupoEmpresa group by i.notaFiscalTerceiros.empresa.identificador";
        Query q = s.createQuery(hql);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            if (valor == null) continue;
            hashDevolucao.put(idEmpresa, valor);
        }
    }
}

