/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao002.util.blocoj;

import com.touchcomp.basementor.model.vo.PlanoContaSped;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedecf.versao002.model.blocoj.BlocoJ;
import mentorcore.service.impl.spedecf.versao002.model.blocoj.RegJ050;
import mentorcore.service.impl.spedecf.versao002.model.blocoj.RegJ051;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilBDConsultBlocoJ {
    public BlocoJ gerarBlocoJ(Date dataInicial, Date dataFim) throws ExceptionDatabase {
        BlocoJ blocoJ = new BlocoJ();
        blocoJ.setPlanoContas(this.getPlanoContas(dataInicial, dataFim));
        return blocoJ;
    }

    private List getPlanoContas(Date dataInicial, Date dataFim) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct new " + RegJ050.class.getCanonicalName() + "(pc.dataCadastro,  pc.naturezaOperacaoPC.codigo,  pc.marca as marca,  pc.codigo as codigo,  pc.descricao) from PlanoConta pc  where pc.dataCadastro<=:dataFim  order by pc.codigo ");
        q.setDate("dataFim", dataFim);
        List l = q.list();
        for (Object o : l) {
            RegJ050 r = (RegJ050)o;
            if (r.getIndicadorConta() != 'A') continue;
            r.setPlanosReferenciados(this.getPlanosReferenciados(r.getCodigoConta(), dataInicial, dataFim));
        }
        return l;
    }

    private List<RegJ051> getPlanosReferenciados(String codigoConta, Date dataInicial, Date dataFinal) {
        PlanoContaSped planoSped = CoreUtilityFactory.getUtilityPlanoConta().findPlanoContaSpedPorCodigoContaAndData(codigoConta, dataInicial, dataFinal);
        ArrayList<RegJ051> lista = new ArrayList<RegJ051>();
        if (planoSped != null) {
            RegJ051 r = new RegJ051(planoSped.getEntResponsavel().getCodigoResponsavel(), planoSped.getCodigo());
            lista.add(r);
        }
        return lista;
    }
}

