/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao002.util.blocol;

import java.io.PrintWriter;
import java.util.List;
import mentorcore.service.impl.spedecf.versao002.SpedEcfFormat002;
import mentorcore.service.impl.spedecf.versao002.model.ContadorRegistros;
import mentorcore.service.impl.spedecf.versao002.model.blocol.RegL030;
import mentorcore.service.impl.spedecf.versao002.model.blocol.RegL100;
import mentorcore.service.impl.spedecf.versao002.model.blocol.RegL200;
import mentorcore.service.impl.spedecf.versao002.model.blocol.RegL210;
import mentorcore.service.impl.spedecf.versao002.model.blocol.RegL300;

public class UtilWritterBlocoL {
    private SpedEcfFormat002 form = new SpedEcfFormat002();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;

    public void writterRegisterL001(Integer blocosDadosInf, PrintWriter wr, ContadorRegistros cont) {
        wr.append(this.separator + "L001");
        wr.append(this.separator + blocosDadosInf.toString());
        wr.append(this.separator + this.endOfRegister);
        cont.soma1("L001");
    }

    public void writterRegisterL990(PrintWriter wr, ContadorRegistros cont) {
        cont.soma1("L990");
        wr.append(this.separator + "L990");
        wr.append(this.separator + this.form.formatNumberLong(cont.getNrLinhas('L')));
        wr.append(this.separator + this.endOfRegister);
    }

    public void writterRegisterL030(List<RegL030> registrosL030, PrintWriter wr, ContadorRegistros cont) {
        for (RegL030 r : registrosL030) {
            wr.append(this.separator + "L030");
            wr.append(this.separator + this.form.formatDate(r.getDataInicial()));
            wr.append(this.separator + this.form.formatDate(r.getDataFinal()));
            wr.append(this.separator + this.form.formatString(r.getPeriodoApuracao()));
            wr.append(this.separator + this.endOfRegister);
            cont.soma1("L030");
            this.writterRegisterL100(r.getRegistrosL100(), wr, cont);
            this.writterRegisterL200(r.getRegistrosL200(), wr, cont);
            this.writterRegisterL300(r.getRegistrosL300(), wr, cont);
        }
    }

    private void writterRegisterL200(List<RegL200> registrosL200, PrintWriter wr, ContadorRegistros cont) {
        if (registrosL200 != null) {
            for (RegL200 r : registrosL200) {
                wr.append(this.separator + "L200");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("L200");
                this.writterRegisterL210(r.getRegistrosL210(), wr, cont);
            }
        }
    }

    private void writterRegisterL100(List<RegL100> registrosL100, PrintWriter wr, ContadorRegistros cont) {
        if (registrosL100 != null) {
            for (RegL100 r : registrosL100) {
                wr.append(this.separator + "L100");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + r.getDescricao());
                wr.append(this.separator + r.getTipo());
                if (r.getNivel() != null) {
                    wr.append(this.separator + r.getNivel().toString());
                } else {
                    wr.append(this.separator);
                }
                if (r.getCodigoNatureza() != null) {
                    wr.append(this.separator + r.getCodigoNatureza());
                } else {
                    wr.append(this.separator);
                }
                if (r.getCodigoContaSuperior() != null) {
                    wr.append(this.separator + r.getCodigoContaSuperior());
                } else {
                    wr.append(this.separator);
                }
                wr.append(this.separator + this.form.formatNumber(r.getSaldoInicial(), 2));
                wr.append(this.separator + r.getIndicadorSaldoInicial());
                wr.append(this.separator + this.form.formatNumber(r.getSaldoFinal(), 2));
                wr.append(this.separator + r.getIndicadorSaldoFinal());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("L100");
            }
        }
    }

    private void writterRegisterL210(List<RegL210> registrosL210, PrintWriter wr, ContadorRegistros cont) {
        if (registrosL210 != null) {
            for (RegL210 r : registrosL210) {
                wr.append(this.separator + "L210");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + r.getDescricao());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("L210");
            }
        }
    }

    private void writterRegisterL300(List<RegL300> registrosL300, PrintWriter wr, ContadorRegistros cont) {
        if (registrosL300 != null) {
            for (RegL300 r : registrosL300) {
                wr.append(this.separator + "L300");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + r.getDescricao());
                wr.append(this.separator + String.valueOf(r.getTipo()));
                wr.append(this.separator + String.valueOf(r.getNivel()));
                wr.append(this.separator + r.getCodigoNatureza());
                wr.append(this.separator + r.getCodContaSuperior());
                wr.append(this.separator + this.form.formatNumber(r.getValor()));
                wr.append(this.separator + String.valueOf(r.getIndicadorValor()));
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("L300");
            }
        }
    }
}

