/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao003;

import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.text.DecimalFormat;
import java.util.Date;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;

public class SpedEcfFormat003 {
    private DecimalFormat staticDecimal = new DecimalFormat();
    private DecimalFormat variableDecimal;

    public SpedEcfFormat003() {
        this.staticDecimal.setMaximumFractionDigits(2);
        this.staticDecimal.setMinimumFractionDigits(2);
        this.staticDecimal.setMinimumIntegerDigits(1);
        this.variableDecimal = new DecimalFormat();
        this.variableDecimal.setMinimumIntegerDigits(1);
    }

    public static SpedEcfFormat003 getInstance() {
        return new SpedEcfFormat003();
    }

    public String formatNumber(Number n) {
        Number number = n = n == null ? (Number)0.0 : (Number)n;
        if (n instanceof Double) {
            Double nr = (Double)n;
            n = Math.abs(nr);
        }
        String st = this.staticDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    public String formatNumber(Number n, int fractionDigits) {
        this.variableDecimal.setMaximumFractionDigits(fractionDigits);
        this.variableDecimal.setMinimumFractionDigits(fractionDigits);
        if (n instanceof Double) {
            Double nr = (Double)n;
            n = Math.abs(nr);
        }
        String st = this.variableDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    public String formatString(String n) {
        return ContatoFormatUtil.clearStringXml((String)n);
    }

    public String formatDate(Date dataIn) {
        return DateUtil.dateToStr(dataIn, "ddMMyyyy");
    }

    public String formatString(String nome, int i) {
        if (nome == null) {
            return "";
        }
        if ((nome = this.formatString(nome)).length() > i) {
            return nome.substring(0, i);
        }
        return nome;
    }

    public String formatStringClear(String cnpj, int i) {
        cnpj = ClearUtil.refina(cnpj);
        return this.formatString(cnpj, i);
    }

    public String clearString(String cnpjCpf) {
        return ClearUtil.refina(cnpjCpf);
    }

    public String formatNumberInt(Integer codIbge) {
        if (codIbge == null) {
            return "";
        }
        return this.clearString(codIbge.toString());
    }

    public String formatNumberLong(Long codIbge) {
        if (codIbge == null) {
            return "";
        }
        return this.clearString(codIbge.toString());
    }

    public String formatStringClear(String inscricaoMunicipal) {
        String clean = this.clearString(inscricaoMunicipal);
        return this.formatString(clean);
    }

    public String formatClearStringComp0Direita(String fone1, int i) {
        fone1 = this.clearString(fone1);
        return this.completa0(fone1, i, false);
    }

    private String completa0(String fone1, int i, boolean esquerda) {
        return ToolString.completaZeros((String)fone1, (int)i, (boolean)esquerda);
    }

    String formatDate(Date periodo, String string) {
        return DateUtil.dateToStr(periodo, string);
    }

    public String formatClearStringComp0Esquerda(String toString, int i) {
        toString = this.clearString(toString);
        return this.completa0(toString, i, true);
    }
}

