/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao003.util.blocot;

import com.touchcomp.basementor.model.vo.SpedEcf;
import java.util.Date;
import java.util.GregorianCalendar;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedecf.versao003.SpedEcfFormat003;
import mentorcore.service.impl.spedecf.versao003.model.blocot.BlocoT;
import mentorcore.service.impl.spedecf.versao003.model.blocot.RegT030;
import mentorcore.tools.DateUtil;

public class UtilBDConsultBlocoT {
    SpedEcfFormat003 form = new SpedEcfFormat003();

    public BlocoT gerarBlocoT030(SpedEcf vo) throws ExceptionService {
        BlocoT blocoT = new BlocoT();
        if (vo.getTipoApuracao().equals((short)0)) {
            throw new ExceptionService("Para essa forma de tributa\u00e7\u00e3o no per\u00edodo, a apura\u00e7\u00e3o deve ser trimestral!");
        }
        blocoT.getRegistrosT030().add(this.getRegT030Trimestral(vo.getDataInicial1(), vo.getDataFinal1(), "T01"));
        blocoT.getRegistrosT030().add(this.getRegT030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
        blocoT.getRegistrosT030().add(this.getRegT030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
        blocoT.getRegistrosT030().add(this.getRegT030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        return blocoT;
    }

    private RegT030 getRegT030Anual(Date dataInicial, Date dataFinal) {
        RegT030 r = new RegT030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao("A00");
        return r;
    }

    private RegT030 getRegT030Trimestral(Date dataInicial, Date dataFinal, String periodoApuracao) {
        RegT030 r = new RegT030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao(periodoApuracao);
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }
}

