/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao005.util.blocok;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SpedEcf;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedecf.versao005.SpedEcfFormat005;
import mentorcore.service.impl.spedecf.versao005.model.blocok.BlocoK;
import mentorcore.service.impl.spedecf.versao005.model.blocok.RegK030;
import mentorcore.service.impl.spedecf.versao005.model.blocok.RegK155;
import mentorcore.service.impl.spedecf.versao005.model.blocok.RegK355;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilBDConsultBlocoK {
    SpedEcfFormat005 form = new SpedEcfFormat005();

    public BlocoK gerarBlocoK030(SpedEcf vo) throws ExceptionService {
        BlocoK blocoK = new BlocoK();
        if (vo.getTipoApuracao().equals((short)0)) {
            Integer ano = DateUtil.yearFromDate(vo.getDataFinal());
            blocoK.getRegistrosK030().add(this.getRegK030AnualPadrao(vo.getDataInicial(), vo.getDataFinal()));
            Short indFormaApuracaoEstimativa = vo.getIndicadorFormaApuracaoEstimativa();
            for (int i = 0; i < 12; ++i) {
                if (!indFormaApuracaoEstimativa.equals(Short.valueOf("2"))) continue;
                blocoK.getRegistrosK030().add(this.getRegK030Anual(i + 1, ano, vo.getDataInicial()));
            }
        } else if (vo.getIndicadorInicioPeriodo().getCodigo().equals("0")) {
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial1(), vo.getDataFinal1(), "T01"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial1(), vo.getDataFinal1())) {
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal1(), "T01"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial2(), vo.getDataFinal2())) {
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal2(), "T02"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial3(), vo.getDataFinal3())) {
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal3(), "T03"));
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial4(), vo.getDataFinal4())) {
            blocoK.getRegistrosK030().add(this.getRegK030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal4(), "T04"));
        }
        this.gerarBlocoK155AndK355(blocoK.getRegistrosK030(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa());
        return blocoK;
    }

    private RegK030 getRegK030AnualPadrao(Date dataInicial, Date dataFinal) {
        RegK030 r = new RegK030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao("A00");
        return r;
    }

    private RegK030 getRegK030Anual(Integer mes, Integer ano, Date dataInicial) {
        RegK030 r = new RegK030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(this.getDataFim(ano, mes));
        r.setPeriodoApuracao("A" + this.form.formatClearStringComp0Esquerda(String.valueOf(mes), 2));
        return r;
    }

    private RegK030 getRegK030Trimestral(Date dataInicial, Date dataFinal, String periodoApuracao) {
        RegK030 r = new RegK030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao(periodoApuracao);
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }

    private void gerarBlocoK155AndK355(List<RegK030> registrosK030, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        for (RegK030 r : registrosK030) {
            r.setRegistrosK155(this.getSaldoContasSpedAposEncerramento(r.getDataInicial(), r.getDataFinal(), grupoEmpresa));
            r.setRegistrosK355(this.getSaldoContasSpedAntesEncerramento(r.getDataInicial(), r.getDataFinal(), grupoEmpresa));
        }
    }

    private List getSaldoContasSpedAposEncerramento(Date dataIn, Date dataFim, GrupoEmpresa gr) throws ExceptionService {
        List<SaldoContaContabil> saldos = this.findSaldosContasAnaliticasPeriodoMaior0Sped(dataIn, dataFim, null, null, gr);
        ArrayList<RegK155> ret = new ArrayList<RegK155>();
        for (SaldoContaContabil o : saldos) {
            SaldoContaContabil s = o;
            PlanoConta planoConta = this.getPlanoContaPorIdentificador(s.getIdPlanoConta());
            if (planoConta.getNaturezaOperacaoPC() == null || !planoConta.getNaturezaOperacaoPC().getCodigo().equals("01") && !planoConta.getNaturezaOperacaoPC().getCodigo().equals("02") && !planoConta.getNaturezaOperacaoPC().getCodigo().equals("03")) continue;
            RegK155 r = new RegK155();
            r.setCodConta(s.getCodigoPlanoConta());
            r.setSaldoFinal(s.getSaldoAtual());
            r.setSaldoInicial(s.getSaldoAnterior());
            r.setValorCredito(s.getValorCredito());
            r.setValorDebito(s.getValorDebito());
            r.setPlanoConta(planoConta);
            ret.add(r);
        }
        return ret;
    }

    private List<SaldoContaContabil> findSaldosContasAnaliticasPeriodoMaior0Sped(Date dataIn, Date dataFim, Integer index, Integer salto, GrupoEmpresa gr) {
        return new CoreDAOFactory().getDAOSaldoConta().findSaldoContaContabilGeral(null, null, dataIn, dataFim, gr.getIdentificador(), null, null, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsTipoSaldoRetorno.TODAS_COM_ALGUM_VALOR_OU_SALDO_DIF_0, EnumConstantsNivelContaRet.CONTAS_NIVEL_ANALITICO, EnumConstantsOrdenacao.ORDEM_NUMERICA);
    }

    private List getSaldoContasSpedAntesEncerramento(Date dataInicial, Date dataFinal, GrupoEmpresa gr) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct new " + RegK355.class.getCanonicalName() + "(s.conta.codigo,s.saldoAntesEnc) from SaldoContaAno s where s.dataBase between :dataIn and :dataFim and s.conta.naturezaOperacaoPC = :natOperacao and s.conta.marca = :marca and s.grupoEmpresa = :grupoEmpresa ");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setInteger("natOperacao", 4);
        q.setInteger("marca", EnumConstSinteticoAnalitico.ANALITICO.getValueInt());
        q.setEntity("grupoEmpresa", (Object)gr);
        List l = q.list();
        return l;
    }

    private PlanoConta getPlanoContaPorIdentificador(Long idPlanoConta) throws ExceptionService {
        PlanoConta planoConta = (PlanoConta)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPlanoConta(), idPlanoConta);
        return planoConta;
    }

    private boolean verificarDataObrigacao(Date dataInicialObrigatoriedade, Date dataInicial, Date dataFinal) {
        return !(!dataInicialObrigatoriedade.equals(dataInicial) && !dataInicialObrigatoriedade.after(dataInicial) || !dataInicialObrigatoriedade.equals(dataFinal) && !dataInicialObrigatoriedade.before(dataFinal));
    }
}

