/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao005.util.blocom;

import com.touchcomp.basementor.model.vo.SecfContaParteBLacs;
import com.touchcomp.basementor.model.vo.SecfContaParteBLalur;
import com.touchcomp.basementor.model.vo.SecfContabilParteALacs;
import com.touchcomp.basementor.model.vo.SecfContabilParteALalur;
import com.touchcomp.basementor.model.vo.SecfLancContaParteB;
import com.touchcomp.basementor.model.vo.SecfLancParteALacs;
import com.touchcomp.basementor.model.vo.SecfLancParteALalur;
import com.touchcomp.basementor.model.vo.SecfParteBLalurLacs;
import com.touchcomp.basementor.model.vo.SecfSaldoContaParteB;
import com.touchcomp.basementor.model.vo.SpedEcf;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.service.impl.spedecf.versao005.SpedEcfFormat005;
import mentorcore.service.impl.spedecf.versao005.model.blocom.BlocoM;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM010;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM030;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM300;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM305;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM310;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM350;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM355;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM360;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM410;
import mentorcore.service.impl.spedecf.versao005.model.blocom.RegM500;
import mentorcore.tools.DateUtil;

public class UtilBDConsultBlocoM {
    SpedEcfFormat005 form = new SpedEcfFormat005();

    public BlocoM gerarBlocoM(SpedEcf vo) {
        BlocoM blocoM = new BlocoM();
        if (vo.getTipoApuracao().equals((short)0)) {
            Integer ano = DateUtil.yearFromDate(vo.getDataFinal());
            blocoM.getRegistrosM030().add(this.getRegM030AnualPadrao(vo.getDataInicial(), vo.getDataFinal()));
            Short indFormaApuracaoEstimativa = vo.getIndicadorFormaApuracaoEstimativa();
            for (int i = 0; i < 12; ++i) {
                if (!indFormaApuracaoEstimativa.equals(Short.valueOf("2"))) continue;
                blocoM.getRegistrosM030().add(this.getRegM030Anual(i + 1, ano, vo.getDataInicial()));
            }
        } else if (vo.getIndicadorInicioPeriodo().getCodigo().equals("0")) {
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial1(), vo.getDataFinal1(), "T01"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial1(), vo.getDataFinal1())) {
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal1(), "T01"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial2(), vo.getDataFinal2())) {
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal2(), "T02"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial3(), vo.getDataFinal3())) {
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal3(), "T03"));
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial4(), vo.getDataFinal4())) {
            blocoM.getRegistrosM030().add(this.getRegM030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal4(), "T04"));
        }
        this.gerarBlocoM300(blocoM.getRegistrosM030(), vo.getRegistrosM300(), vo.getTipoApuracao());
        this.gerarBlocoM350(blocoM.getRegistrosM030(), vo.getRegistrosM350(), vo.getTipoApuracao());
        this.gerarBlocoM410(blocoM.getRegistrosM030(), vo.getRegistrosM410(), vo.getTipoApuracao());
        this.gerarBlocoM500(blocoM.getRegistrosM030(), vo.getRegistrosM500(), vo.getTipoApuracao());
        this.gerarBlocoM010(blocoM, vo.getRegistrosM010());
        return blocoM;
    }

    private RegM030 getRegM030AnualPadrao(Date dataInicial, Date dataFinal) {
        RegM030 r = new RegM030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao("A00");
        return r;
    }

    private RegM030 getRegM030Anual(Integer mes, Integer ano, Date dataInicial) {
        RegM030 r = new RegM030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(this.getDataFim(ano, mes));
        if (mes < 10) {
            r.setPeriodoApuracao("A" + this.form.formatString("0" + String.valueOf(mes), 2));
        } else {
            r.setPeriodoApuracao("A" + this.form.formatString(String.valueOf(mes), 2));
        }
        return r;
    }

    private RegM030 getRegM030Trimestral(Date dataInicial, Date dataFinal, String periodoApuracao) {
        RegM030 r = new RegM030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao(periodoApuracao);
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }

    private void gerarBlocoM300(List<RegM030> registrosM030, List<SecfLancParteALalur> registrosM300, Short tipoApuracao) {
        for (RegM030 r : registrosM030) {
            for (SecfLancParteALalur s : registrosM300) {
                Integer mes = null;
                if (s.getPeriodo() != null) {
                    mes = DateUtil.getMonthFromDate(s.getPeriodo());
                }
                if (tipoApuracao.equals((short)0)) {
                    if (s.getTipo().equals((short)0) && r.getPeriodoApuracao().equals("A00")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 1 && r.getPeriodoApuracao().equals("A01")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 2 && r.getPeriodoApuracao().equals("A02")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 3 && r.getPeriodoApuracao().equals("A03")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 4 && r.getPeriodoApuracao().equals("A04")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 5 && r.getPeriodoApuracao().equals("A05")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 6 && r.getPeriodoApuracao().equals("A06")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 7 && r.getPeriodoApuracao().equals("A07")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 8 && r.getPeriodoApuracao().equals("A08")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 9 && r.getPeriodoApuracao().equals("A09")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 10 && r.getPeriodoApuracao().equals("A10")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes != null && mes == 11 && r.getPeriodoApuracao().equals("A11")) {
                        r.getRegistrosM300().add(this.getRegistroM300(s));
                        continue;
                    }
                    if (mes == null || mes != 12 || !r.getPeriodoApuracao().equals("A12")) continue;
                    r.getRegistrosM300().add(this.getRegistroM300(s));
                    continue;
                }
                if (mes != null && (mes == 1 || mes == 2 || mes == 3) && r.getPeriodoApuracao().equals("T01")) {
                    r.getRegistrosM300().add(this.getRegistroM300(s));
                    continue;
                }
                if (mes != null && (mes == 4 || mes == 5 || mes == 6) && r.getPeriodoApuracao().equals("T02")) {
                    r.getRegistrosM300().add(this.getRegistroM300(s));
                    continue;
                }
                if (mes != null && (mes == 7 || mes == 8 || mes == 9) && r.getPeriodoApuracao().equals("T03")) {
                    r.getRegistrosM300().add(this.getRegistroM300(s));
                    continue;
                }
                if (mes == null || mes != 10 && mes != 11 && mes != 12 || !r.getPeriodoApuracao().equals("T04")) continue;
                r.getRegistrosM300().add(this.getRegistroM300(s));
            }
        }
    }

    private RegM300 getRegistroM300(SecfLancParteALalur s) {
        RegM300 rr = new RegM300();
        rr.setCodigo(s.getTabelaDinamica().getCodigo());
        rr.setDescricao(s.getTabelaDinamica().getDescricao());
        rr.setValor(s.getValor());
        rr.setHistorico(s.getHistorico());
        rr.setTipoLancamento(this.getTipoLancamento(s.getTipoLancamento()));
        rr.setIndRelacao(s.getIndicadorRelacao());
        rr.setRegistrosM305(this.getRegistroM305(s.getRegistrosM305()));
        rr.setRegistrosM310(this.getRegistroM310(s.getRegistrosM310()));
        return rr;
    }

    private List<RegM305> getRegistroM305(List<SecfContaParteBLalur> registrosM305) {
        ArrayList<RegM305> lista = new ArrayList<RegM305>();
        if (registrosM305 != null) {
            for (SecfContaParteBLalur s : registrosM305) {
                RegM305 r = new RegM305();
                r.setCodigoConta(s.getCodigoConta());
                r.setValor(s.getValor());
                r.setIndicadorDebCred(this.getIndicadorDebitoCredito(s.getIndicadorDebitoCredito()));
                lista.add(r);
            }
        }
        return lista;
    }

    private List<RegM310> getRegistroM310(List<SecfContabilParteALalur> registrosM310) {
        ArrayList<RegM310> lista = new ArrayList<RegM310>();
        if (registrosM310 != null) {
            for (SecfContabilParteALalur s : registrosM310) {
                RegM310 r = new RegM310();
                r.setCodigoConta(s.getPlanoConta().getCodigo());
                r.setValor(s.getValor());
                r.setIndicadorDebCred(this.getIndicadorDebitoCredito(s.getIndicadorDebitoCredito()));
                lista.add(r);
            }
        }
        return lista;
    }

    private String getTipoLancamento(Short tipoLancamento) {
        if (tipoLancamento.equals((short)1)) {
            return "A";
        }
        if (tipoLancamento.equals((short)2)) {
            return "E";
        }
        if (tipoLancamento.equals((short)3)) {
            return "P";
        }
        return "L";
    }

    private String getIndicadorDebitoCredito(Short indicadorDebitoCredito) {
        if (indicadorDebitoCredito.equals((short)0)) {
            return "D";
        }
        return "C";
    }

    private void gerarBlocoM350(List<RegM030> registrosM030, List<SecfLancParteALacs> registrosM350, Short tipoApuracao) {
        for (RegM030 r : registrosM030) {
            for (SecfLancParteALacs s : registrosM350) {
                Integer mes = null;
                if (s.getPeriodo() != null) {
                    mes = DateUtil.getMonthFromDate(s.getPeriodo());
                }
                if (tipoApuracao.equals((short)0)) {
                    if (s.getTipo().equals((short)0) && r.getPeriodoApuracao().equals("A00")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 1 && r.getPeriodoApuracao().equals("A01")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 2 && r.getPeriodoApuracao().equals("A02")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 3 && r.getPeriodoApuracao().equals("A03")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 4 && r.getPeriodoApuracao().equals("A04")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 5 && r.getPeriodoApuracao().equals("A05")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 6 && r.getPeriodoApuracao().equals("A06")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 7 && r.getPeriodoApuracao().equals("A07")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 8 && r.getPeriodoApuracao().equals("A08")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 9 && r.getPeriodoApuracao().equals("A09")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 10 && r.getPeriodoApuracao().equals("A10")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes != null && mes == 11 && r.getPeriodoApuracao().equals("A11")) {
                        r.getRegistrosM350().add(this.getRegistroM350(s));
                        continue;
                    }
                    if (mes == null || mes != 12 || !r.getPeriodoApuracao().equals("A12")) continue;
                    r.getRegistrosM350().add(this.getRegistroM350(s));
                    continue;
                }
                if (mes != null && (mes == 1 || mes == 2 || mes == 3) && r.getPeriodoApuracao().equals("T01")) {
                    r.getRegistrosM350().add(this.getRegistroM350(s));
                    continue;
                }
                if (mes != null && (mes == 4 || mes == 5 || mes == 6) && r.getPeriodoApuracao().equals("T02")) {
                    r.getRegistrosM350().add(this.getRegistroM350(s));
                    continue;
                }
                if (mes != null && (mes == 7 || mes == 8 || mes == 9) && r.getPeriodoApuracao().equals("T03")) {
                    r.getRegistrosM350().add(this.getRegistroM350(s));
                    continue;
                }
                if (mes == null || mes != 10 && mes != 11 && mes != 12 || !r.getPeriodoApuracao().equals("T04")) continue;
                r.getRegistrosM350().add(this.getRegistroM350(s));
            }
        }
    }

    private RegM350 getRegistroM350(SecfLancParteALacs s) {
        RegM350 rr = new RegM350();
        rr.setCodigo(s.getTabelaDinamica().getCodigo());
        rr.setDescricao(s.getTabelaDinamica().getDescricao());
        rr.setValor(s.getValor());
        rr.setHistorico(s.getHistorico());
        rr.setTipoLancamento(this.getTipoLancamento(s.getTipoLancamento()));
        rr.setIndRelacao(s.getIndicadorRelacao());
        rr.setRegistrosM355(this.getRegistroM355(s.getRegistrosM355()));
        rr.setRegistrosM360(this.getRegistroM360(s.getRegistrosM360()));
        return rr;
    }

    private List<RegM355> getRegistroM355(List<SecfContaParteBLacs> registrosM355) {
        ArrayList<RegM355> lista = new ArrayList<RegM355>();
        if (registrosM355 != null) {
            for (SecfContaParteBLacs s : registrosM355) {
                RegM355 r = new RegM355();
                r.setCodigoConta(s.getCodigoConta());
                r.setValor(s.getValor());
                r.setIndicadorDebCred(this.getIndicadorDebitoCredito(s.getIndicadorDebitoCredito()));
                lista.add(r);
            }
        }
        return lista;
    }

    private List<RegM360> getRegistroM360(List<SecfContabilParteALacs> registrosM360) {
        ArrayList<RegM360> lista = new ArrayList<RegM360>();
        if (registrosM360 != null) {
            for (SecfContabilParteALacs s : registrosM360) {
                RegM360 r = new RegM360();
                r.setCodigoConta(s.getPlanoConta().getCodigo());
                r.setValor(s.getValor());
                r.setIndicadorDebCred(this.getIndicadorDebitoCredito(s.getIndicadorDebitoCredito()));
                lista.add(r);
            }
        }
        return lista;
    }

    private void gerarBlocoM410(List<RegM030> registrosM030, List<SecfLancContaParteB> registrosM350, Short tipoApuracao) {
        for (RegM030 r : registrosM030) {
            for (SecfLancContaParteB s : registrosM350) {
                Integer mes = null;
                if (s.getPeriodo() != null) {
                    mes = DateUtil.getMonthFromDate(s.getPeriodo());
                }
                if (tipoApuracao.equals((short)0)) {
                    if (s.getTipo().equals((short)0) && r.getPeriodoApuracao().equals("A00")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 1 && r.getPeriodoApuracao().equals("A01")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 2 && r.getPeriodoApuracao().equals("A02")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 3 && r.getPeriodoApuracao().equals("A03")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 4 && r.getPeriodoApuracao().equals("A04")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 5 && r.getPeriodoApuracao().equals("A05")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 6 && r.getPeriodoApuracao().equals("A06")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 7 && r.getPeriodoApuracao().equals("A07")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 8 && r.getPeriodoApuracao().equals("A08")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 9 && r.getPeriodoApuracao().equals("A09")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 10 && r.getPeriodoApuracao().equals("A10")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes != null && mes == 11 && r.getPeriodoApuracao().equals("A11")) {
                        r.getRegistrosM410().add(this.getRegistroM410(s));
                        continue;
                    }
                    if (mes == null || mes != 12 || !r.getPeriodoApuracao().equals("A12")) continue;
                    r.getRegistrosM410().add(this.getRegistroM410(s));
                    continue;
                }
                if (mes != null && (mes == 1 || mes == 2 || mes == 3) && r.getPeriodoApuracao().equals("T01")) {
                    r.getRegistrosM410().add(this.getRegistroM410(s));
                    continue;
                }
                if (mes != null && (mes == 4 || mes == 5 || mes == 6) && r.getPeriodoApuracao().equals("T02")) {
                    r.getRegistrosM410().add(this.getRegistroM410(s));
                    continue;
                }
                if (mes != null && (mes == 7 || mes == 8 || mes == 9) && r.getPeriodoApuracao().equals("T03")) {
                    r.getRegistrosM410().add(this.getRegistroM410(s));
                    continue;
                }
                if (mes == null || mes != 10 && mes != 11 && mes != 12 || !r.getPeriodoApuracao().equals("T04")) continue;
                r.getRegistrosM410().add(this.getRegistroM410(s));
            }
        }
    }

    private RegM410 getRegistroM410(SecfLancContaParteB s) {
        RegM410 rr = new RegM410();
        rr.setCodigoConta(s.getCodigoConta());
        rr.setCodigoContraPartida(s.getCodigoContraPartida());
        rr.setHistorico(s.getHistorico());
        rr.setValorLancamento(s.getValor());
        if (s.getIndicadorLancamentoAnterior() == 1) {
            rr.setIndicadorLancamentoAnt("S");
        } else {
            rr.setIndicadorLancamentoAnt("N");
        }
        if (s.getIndicadorLancamento().equals((short)2)) {
            rr.setIndicadorLancamento("DB");
        } else if (s.getIndicadorLancamento().equals((short)1)) {
            rr.setIndicadorLancamento("CR");
        } else if (s.getIndicadorLancamento().equals((short)3)) {
            rr.setIndicadorLancamento("PF");
        } else {
            rr.setIndicadorLancamento("BC");
        }
        if (s.getCodigoTributo().equals((short)0)) {
            rr.setCodigoTributo("I");
        } else {
            rr.setCodigoTributo("C");
        }
        return rr;
    }

    private void gerarBlocoM500(List<RegM030> registrosM030, List<SecfSaldoContaParteB> registrosM500, Short tipoApuracao) {
        for (RegM030 r : registrosM030) {
            for (SecfSaldoContaParteB s : registrosM500) {
                Integer mes = DateUtil.getMonthFromDate(s.getPeriodo());
                if (tipoApuracao.equals((short)0)) {
                    if (!r.getPeriodoApuracao().equals("A00")) continue;
                    r.getRegistrosM500().add(this.getRegistroM500(s));
                    continue;
                }
                if (mes != null && (mes == 1 || mes == 2 || mes == 3) && r.getPeriodoApuracao().equals("T01")) {
                    r.getRegistrosM500().add(this.getRegistroM500(s));
                    continue;
                }
                if (mes != null && (mes == 4 || mes == 5 || mes == 6) && r.getPeriodoApuracao().equals("T02")) {
                    r.getRegistrosM500().add(this.getRegistroM500(s));
                    continue;
                }
                if (mes != null && (mes == 7 || mes == 8 || mes == 9) && r.getPeriodoApuracao().equals("T03")) {
                    r.getRegistrosM500().add(this.getRegistroM500(s));
                    continue;
                }
                if (mes == null || mes != 10 && mes != 11 && mes != 12 || !r.getPeriodoApuracao().equals("T04")) continue;
                r.getRegistrosM500().add(this.getRegistroM500(s));
            }
        }
    }

    private RegM500 getRegistroM500(SecfSaldoContaParteB s) {
        RegM500 rr = new RegM500();
        rr.setCodigoConta(s.getCodigoConta());
        if (s.getCodigoTributo().equals((short)0)) {
            rr.setCodigoTributo("I");
        } else {
            rr.setCodigoTributo("C");
        }
        rr.setValorLancamentoParteA(s.getValorLancParteA());
        rr.setValorLancamentoParteB(s.getValorLancParteB());
        rr.setSaldoInicial(s.getSaldoInicial());
        rr.setSaldoFinal(s.getSaldoFinal());
        rr.setIndicadorLancamentoParteA(this.getDebitoCredito(s.getIndicadorValorLancParteA()));
        rr.setIndicadorLancamentoParteB(this.getDebitoCredito(s.getIndicadorValorLancParteB()));
        rr.setIndicadorSaldoInicial(this.getDebitoCredito(s.getIndicadorSaldoInicial()));
        rr.setIndicadorSaldoFinal(this.getDebitoCredito(s.getIndicadorSaldoFinal()));
        return rr;
    }

    private String getDebitoCredito(Short indicador) {
        if (indicador.equals((short)0)) {
            return "D";
        }
        return "C";
    }

    private void gerarBlocoM010(BlocoM blocoM, List<SecfParteBLalurLacs> registrosM010) {
        if (registrosM010 != null) {
            for (SecfParteBLalurLacs s : registrosM010) {
                RegM010 r = new RegM010();
                r.setCodigoConta(s.getCodigoConta());
                r.setDescricaoConta(s.getDescricaoConta());
                r.setDataAplicacao(s.getDataFinalApuracao());
                r.setCodigoLancOrigem(s.getCodigoLancamentoOrigem());
                r.setDescricaoLancOrigem(s.getDescricaoLancamentoOrigem());
                r.setDataLimite(s.getDataLimite());
                if (s.getCodigoTributo().equals((short)0)) {
                    r.setCodigoTributo("I");
                } else {
                    r.setCodigoTributo("C");
                }
                r.setValorSaldoInicial(s.getValorSaldoInicial());
                if (s.getIndicadorSaldoInicial().equals((short)0)) {
                    r.setIndicadorSaldoInicial("D");
                } else if (s.getIndicadorSaldoInicial().equals((short)1)) {
                    r.setIndicadorSaldoInicial("C");
                }
                r.setCnpj(s.getCnpjSituacaoEspecial());
                blocoM.getRegistrosM010().add(r);
            }
        }
    }

    private boolean verificarDataObrigacao(Date dataInicialObrigatoriedade, Date dataInicial, Date dataFinal) {
        return !(!dataInicialObrigatoriedade.equals(dataInicial) && !dataInicialObrigatoriedade.after(dataInicial) || !dataInicialObrigatoriedade.equals(dataFinal) && !dataInicialObrigatoriedade.before(dataFinal));
    }
}

