/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao005.util.blocoy;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.SpedEcf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedecf.versao005.SpedEcfFormat005;
import mentorcore.service.impl.spedecf.versao005.model.blocoy.RegY540;
import mentorcore.service.impl.spedecf.versao005.model.blocoy.RegY550;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDConsultBlocoY {
    SpedEcfFormat005 form = new SpedEcfFormat005();

    public List<RegY550> getRegistroY550(SpedEcf vo) {
        String query = "select n.unidadeFatCliente.cliente.pessoa.complemento.cnpj as CNPJ_CLIENTE, i.produto.ncm.codigo as NCM, sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_TOTAL from NotaFiscalPropria n inner join n.itensNotaPropria i where n.dataEmissaoNota between :dataInicial and :dataFinal and n.status IN(:nfeAutorizada) and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and n.naturezaOperacao.entradaSaida = :saida and i.itemNotaLivroFiscal.cfop.cfopComercialExportadora = :sim group by n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, i.produto.ncm.codigo ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setDate("dataInicial", vo.getDataInicial());
        q.setDate("dataFinal", vo.getDataFinal());
        q.setEntity("grupoEmpresa", (Object)vo.getEmpresa().getEmpresaDados().getGrupoEmpresa());
        q.setParameter("nfeAutorizada", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("saida", (short)1);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegY550> registrosY550 = new ArrayList<RegY550>();
        if (lista != null) {
            for (HashMap h : lista) {
                RegY550 r = new RegY550();
                r.setCnpj((String)h.get("CNPJ_CLIENTE"));
                r.setNcm((String)h.get("NCM"));
                r.setValor((Double)h.get("VALOR"));
                registrosY550.add(r);
            }
        }
        return registrosY550;
    }

    public List<RegY540> getRegistrosY540(SpedEcf vo) {
        ArrayList<RegY540> lista = new ArrayList<RegY540>();
        Double valorTotal = 0.0;
        valorTotal = valorTotal + this.getRegistrosNotasPropriasY540(vo);
        valorTotal = valorTotal + this.getRegistrosCuponsFiscaisY540(vo);
        valorTotal = valorTotal + this.getRegistrosCTeY540(vo);
        if ((valorTotal = Double.valueOf(valorTotal + this.getRegistrosRpsY540(vo))) > 0.0) {
            RegY540 r = new RegY540();
            r.setCnae(vo.getEmpresa().getEmpresaDados().getCnae().getCodigo());
            r.setCnpj(vo.getEmpresa().getPessoa().getComplemento().getCnpj());
            r.setValor(valorTotal);
            lista.add(r);
        }
        return lista;
    }

    private Double getRegistrosNotasPropriasY540(SpedEcf vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR from ItemNotaFiscalPropria i  where      i.itemNotaLivroFiscal.cfop.cfopReceitaVenda = :cfopReceitaVenda  and i.itemNotaLivroFiscal.cfop.codigo.cfopDevolucaoVenda = :naoCfopDevolucaoVenda and i.notaFiscalPropria.dataEmissaoNota between :dataIn and :dataFim  and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and i.notaFiscalPropria.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVenda", (short)1);
        q.setShort("naoCfopDevolucaoVenda", (short)0);
        q.setDate("dataIn", vo.getDataInicial());
        q.setDate("dataFim", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Double valorTotal = 0.0;
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            if (valor == null) continue;
            valorTotal = valorTotal + valor;
        }
        return valorTotal;
    }

    private Double getRegistrosCuponsFiscaisY540(SpedEcf vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.valorTotal) as VALOR from CupomFiscal c  where      c.cancelado = :nao and c.cupom.dataMovimentacao between :dataIn and :dataFim  and c.cupom.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", vo.getDataInicial());
        q.setDate("dataFim", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Double valorTotal = 0.0;
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            if (valor == null) continue;
            valorTotal = valorTotal + valor;
        }
        return valorTotal;
    }

    private Double getRegistrosCTeY540(SpedEcf vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.cteVlrImpostos.vrReceber) as VALOR from Cte c  where      c.dataEmissao between :dataIn and :dataFim  and (c.situacaoDocumento.codigo = :codSitDoc1       or c.situacaoDocumento.codigo = :codSitDoc2       or c.situacaoDocumento.codigo = :codSitDoc3       or c.situacaoDocumento.codigo = :codSitDoc4       or c.situacaoDocumento.codigo = :codSitDoc5) and c.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", vo.getDataInicial());
        q.setDate("dataFim", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Double valorTotal = 0.0;
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            if (valor == null) continue;
            valorTotal = valorTotal + valor;
        }
        return valorTotal;
    }

    private Double getRegistrosRpsY540(SpedEcf vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(c.valorServico) as VALOR from Rps c  where      c.dataEmissao between :dataIn and :dataFim  and c.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", vo.getDataInicial());
        q.setDate("dataFim", vo.getDataFinal());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Double valorTotal = 0.0;
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Double valor = (Double)h.get("VALOR");
            if (valor == null) continue;
            valorTotal = valorTotal + valor;
        }
        return valorTotal;
    }
}

