/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao006;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SecfDemonstrativoIrrfCsll;
import com.touchcomp.basementor.model.vo.SecfInfOptantePaes;
import com.touchcomp.basementor.model.vo.SecfInfOptanteRefis;
import com.touchcomp.basementor.model.vo.SecfInfPeriodoAnterior;
import com.touchcomp.basementor.model.vo.SecfOutrasInformacoesLucroPresumido;
import com.touchcomp.basementor.model.vo.SecfOutrasInformacoesLucroReal;
import com.touchcomp.basementor.model.vo.SecfPagRecExterior;
import com.touchcomp.basementor.model.vo.SecfParticipacaoPatrimonial;
import com.touchcomp.basementor.model.vo.SecfSociosTitularEmpresa;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedecf.versao006.SpedEcfFormat006;
import mentorcore.service.impl.spedecf.versao006.model.ContadorRegistros;
import mentorcore.service.impl.spedecf.versao006.model.RegI050;
import mentorcore.service.impl.spedecf.versao006.model.RegI150;
import mentorcore.service.impl.spedecf.versao006.model.RegI155;
import mentorcore.service.impl.spedecf.versao006.model.RegI200;
import mentorcore.service.impl.spedecf.versao006.model.RegI250;
import mentorcore.service.impl.spedecf.versao006.model.RegI350;
import mentorcore.service.impl.spedecf.versao006.model.RegI355;
import mentorcore.service.impl.spedecf.versao006.model.RegJ005;
import mentorcore.service.impl.spedecf.versao006.model.RegJ100;
import mentorcore.service.impl.spedecf.versao006.model.RegJ150;
import mentorcore.service.impl.spedecf.versao006.model.RegJ800;
import mentorcore.service.impl.spedecf.versao006.model.blocoj.BlocoJ;
import mentorcore.service.impl.spedecf.versao006.model.blocok.BlocoK;
import mentorcore.service.impl.spedecf.versao006.model.blocok.RegK030;
import mentorcore.service.impl.spedecf.versao006.model.blocol.BlocoL;
import mentorcore.service.impl.spedecf.versao006.model.blocom.BlocoM;
import mentorcore.service.impl.spedecf.versao006.model.blocon.BlocoN;
import mentorcore.service.impl.spedecf.versao006.model.blocop.BlocoP;
import mentorcore.service.impl.spedecf.versao006.model.blocot.BlocoT;
import mentorcore.service.impl.spedecf.versao006.model.blocou.BlocoU;
import mentorcore.service.impl.spedecf.versao006.model.blocox.BlocoX;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.BlocoY;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY520;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY570;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY600;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY612;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY620;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY671;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY672;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY680;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY681;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY690;
import mentorcore.service.impl.spedecf.versao006.model.blocoy.RegY720;
import mentorcore.service.impl.spedecf.versao006.util.bloco0.UtilWritterBloco0;
import mentorcore.service.impl.spedecf.versao006.util.bloco9.UtilWritterBloco9;
import mentorcore.service.impl.spedecf.versao006.util.blococ.UtilWritterBlocoC;
import mentorcore.service.impl.spedecf.versao006.util.blocoe.UtilWritterBlocoE;
import mentorcore.service.impl.spedecf.versao006.util.blocoj.UtilBDConsultBlocoJ;
import mentorcore.service.impl.spedecf.versao006.util.blocoj.UtilWritterBlocoJ;
import mentorcore.service.impl.spedecf.versao006.util.blocok.UtilBDConsultBlocoK;
import mentorcore.service.impl.spedecf.versao006.util.blocok.UtilWritterBlocoK;
import mentorcore.service.impl.spedecf.versao006.util.blocol.UtilBDConsultBlocoL;
import mentorcore.service.impl.spedecf.versao006.util.blocol.UtilWritterBlocoL;
import mentorcore.service.impl.spedecf.versao006.util.blocom.UtilBDConsultBlocoM;
import mentorcore.service.impl.spedecf.versao006.util.blocom.UtilWritterBlocoM;
import mentorcore.service.impl.spedecf.versao006.util.blocon.UtilBDConsultBlocoN;
import mentorcore.service.impl.spedecf.versao006.util.blocon.UtilWritterBlocoN;
import mentorcore.service.impl.spedecf.versao006.util.blocop.UtilBDConsultBlocoP;
import mentorcore.service.impl.spedecf.versao006.util.blocop.UtilWritterBlocoP;
import mentorcore.service.impl.spedecf.versao006.util.blocoq.UtilWritterBlocoQ;
import mentorcore.service.impl.spedecf.versao006.util.blocot.UtilBDConsultBlocoT;
import mentorcore.service.impl.spedecf.versao006.util.blocot.UtilWritterBlocoT;
import mentorcore.service.impl.spedecf.versao006.util.blocou.UtilBDConsultBlocoU;
import mentorcore.service.impl.spedecf.versao006.util.blocou.UtilWritterBlocoU;
import mentorcore.service.impl.spedecf.versao006.util.blocox.UtilBDConsultBlocoX;
import mentorcore.service.impl.spedecf.versao006.util.blocox.UtilWritterBlocoX;
import mentorcore.service.impl.spedecf.versao006.util.blocoy.UtilBDConsultBlocoY;
import mentorcore.service.impl.spedecf.versao006.util.blocoy.UtilWritterBlocoY;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;

public class SpedEcfWritter006 {
    private static final String SPED_ECF = "SPED_ECF.TXT";
    LinkedHashMap counter;
    NumberFormat nf;
    String BANCO_CENTRAL = "01";
    String SUSEP = "02";
    String CVM = "03";
    String ANTT = "04";
    private static final TLogger logger = TLogger.get(SpedEcfWritter006.class);
    private SpedEcfFormat006 form = new SpedEcfFormat006();
    private final String endOfRegister = "\r\n";
    private final char separator = (char)124;
    private ContadorRegistros cont = new ContadorRegistros();
    private static final Integer BLOCO_DADOS_INF = 0;
    private static final Integer BLOCO_DADOS_NAO_INF = 1;

    public SpedEcfWritter006() {
        this.counter = new LinkedHashMap();
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
    }

    public void gerarArquivoSped(File file, SpedEcf vo) throws ExceptionService, IOException {
        PrintWriter pw = null;
        try {
            File bloco0 = this.createWritterBloco0(vo);
            File blocoC = this.createWritterBlocoC(vo);
            File blocoE = this.createWritterBlocoE(vo);
            File blocoJ = this.createWritterBlocoJ(vo);
            HashMap hashK = this.createWritterBlocoK(vo);
            File blocoK = (File)hashK.get("file");
            List registrosK030 = (List)hashK.get("regK030");
            File blocoL = this.createWritterBlocoL(vo, registrosK030);
            File blocoM = this.createWritterBlocoM(vo);
            File blocoN = this.createWritterBlocoN(vo);
            File blocoP = this.createWritterBlocoP(vo, registrosK030);
            File blocoQ = this.createWritterBlocoQ(vo);
            File blocoT = this.createWritterBlocoT(vo);
            File blocoU = this.createWritterBlocoU(vo);
            File blocoX = this.createWritterBlocoX(vo);
            File blocoY = this.createWritterBlocoY(vo);
            File bloco9 = this.createWritterBloco9(vo);
            this.apendToSomeFile(file, bloco0, blocoC, blocoE, blocoJ, blocoK, blocoL, blocoM, blocoN, blocoP, blocoT, blocoU, blocoX, blocoY, bloco9, blocoQ);
        }
        catch (ExceptionDatabase ex) {
            logger.error(ex.getMessage());
            throw new ExceptionService(ex.getMessage());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            throw new ExceptionService("Erro ao criar/escrever arquivo Sped Cont\u00e1bil!");
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
                this.clearFile(file.getAbsolutePath());
            }
        }
    }

    private void createRegisterI001(Integer dadosInformados, PrintWriter wr) {
        wr.append("|I001");
        wr.append("|" + dadosInformados);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI010(PrintWriter wr) {
        wr.append("|I010");
        wr.append("|G");
        wr.append("|3.00");
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI150(Date dataIn, Date dataFim, PrintWriter wr) throws IOException {
        wr.append("|I150");
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataIn)));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataFim)));
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterI155(List saldos, PrintWriter wr) throws ExceptionService, IOException {
        if (saldos != null) {
            for (Object o : saldos) {
                RegI155 saldo = (RegI155)o;
                wr.append("|I155");
                wr.append("|" + saldo.getCodConta());
                wr.append("|" + (saldo.getCodCC() != null ? saldo.getCodCC() : ""));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getSaldoInicial()));
                wr.append("|" + saldo.getIndSaldoInicial());
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getValorDebito()));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getValorCredito()));
                wr.append("|" + this.formatValuesInSpedFormat(saldo.getSaldoFinal()));
                wr.append("|" + saldo.getIndSaldoFinal());
                wr.append("|");
                wr.append("\r\n");
            }
        }
    }

    private void createRegisterI200(List lancamentos, PrintWriter pw) throws ExceptionService, IOException {
        for (Object obj : lancamentos) {
            RegI200 r = (RegI200)obj;
            pw.append("|I200");
            pw.append("|" + r.getNumero());
            pw.append("|" + DateUtil.dateToStr(r.getDataLancamento(), "ddMMyyyy"));
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorLancamento()));
            pw.append("|" + SpedEcfWritter006.getIdentificacaoLancamentoSped((int)r.getIndicadorLancamento()));
            pw.append("|");
            pw.append("\r\n");
            this.createRegisterI250(r.getRegI250(), pw);
        }
    }

    private void createRegisterI250(List regI250, PrintWriter pw) {
        for (Object o : regI250) {
            RegI250 r = (RegI250)o;
            pw.append("|I250");
            pw.append("|" + r.getCodigoConta());
            pw.append("|");
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorPartida()));
            pw.append("|" + r.getIndDebCred());
            pw.append("|");
            pw.append("|");
            pw.append("|" + ToolString.substituiCaractereEspecial((String)r.getHistorico()).replaceAll("\\r\\n|\\r|\\n", " "));
            pw.append("|");
            pw.append("|");
            pw.append("\r\n");
        }
    }

    private void createRegisterI350(List lancamentos, PrintWriter pw) throws ExceptionService, IOException {
        for (Object obj : lancamentos) {
            RegI350 r = (RegI350)obj;
            pw.append("|I350");
            pw.append("|" + DateUtil.dateToStr(r.getDataResultado(), "ddMMyyyy"));
            pw.append("|");
            pw.append("\r\n");
            this.createRegisterI355(r.getRegI355(), pw);
        }
    }

    private void createRegisterI355(List regI355, PrintWriter pw) {
        for (Object o : regI355) {
            RegI355 r = (RegI355)o;
            pw.append("|I355");
            pw.append("|" + r.getCodConta());
            pw.append("|");
            pw.append("|" + this.formatValuesInSpedFormat(r.getValorAntesEncerramento()));
            pw.append("|" + r.getIndicadorLancamento());
            pw.append("|");
            pw.append("\r\n");
        }
    }

    private void createRegisterI990(Long numLinhas, PrintWriter wr) {
        wr.append("|I990");
        wr.append("|" + numLinhas);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ001(int i, PrintWriter wr) {
        wr.append("|J001");
        wr.append("|" + i);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ005(List demonstracoesContabeis, PrintWriter wr) {
        for (Object o : demonstracoesContabeis) {
            RegJ005 r = (RegJ005)o;
            wr.append("|J005");
            wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(r.getDataInicial())));
            wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(r.getDataFinal())));
            wr.append("|" + r.getTipoDemBalancete());
            wr.append("|");
            wr.append("|");
            wr.append("\r\n");
            this.createRegisterJ100(r.getRegJ100(), wr);
            this.createRegisterJ150(r.getRegJ150(), wr);
        }
    }

    private void createRegisterJ100(List regj100, PrintWriter wr) {
        for (Object o : regj100) {
            RegJ100 r = (RegJ100)o;
            wr.append("|J100");
            wr.append("|" + r.getCodigoAglutinacao());
            wr.append("|" + r.getNivelAglutinacao());
            wr.append("|" + r.getIndicadorGrupoBalanco());
            wr.append("|" + r.getDescCodigoAglutinacao());
            wr.append("|" + this.formatValuesInSpedFormat(r.getValorTotal()));
            wr.append("|" + r.getIndicadorSaldo());
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ150(List regj150, PrintWriter wr) {
        for (Object o : regj150) {
            RegJ150 r = (RegJ150)o;
            wr.append("|J150");
            wr.append("|" + r.getCodigoAglutinacao());
            wr.append("|" + r.getNivelAglutinacao());
            wr.append("|" + r.getDescCodigoAglutinacao());
            wr.append("|" + this.formatValuesInSpedFormat(r.getValorTotal()));
            wr.append("|" + r.getIndicadorSaldo());
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ900(Integer numeroOrdem, String natOperacao, Date dataIn, Date dataFim, Long qtdLinhas, PrintWriter wr, Empresa empresa) {
        StringBuffer buffer = new StringBuffer();
        wr.append("|J900");
        wr.append("|TERMO DE ENCERRAMENTO");
        wr.append("|" + numeroOrdem);
        wr.append("|" + natOperacao);
        wr.append("|" + empresa.getPessoa().getNome());
        wr.append("|" + qtdLinhas);
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataIn)));
        wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataFim)));
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegisterJ930(List assinantes, PrintWriter wr) {
        for (Object obj : assinantes) {
            HashMap h = (HashMap)obj;
            String crc = (String)h.get("CRC_ASSINANTE");
            String nome = (String)h.get("NOME_ASSINANTE");
            String cpf = (String)h.get("CPF_ASSINANTE");
            String funcao = (String)h.get("FUNCAO_ASSINANTE");
            String codFuncao = (String)h.get("COD_FUNCAO_ASSINANTE");
            String telefone = (String)h.get("TELEFONE_ASSINANTE");
            String email = (String)h.get("EMAIL_ASSINANTE");
            UnidadeFederativa uf = (UnidadeFederativa)h.get("UF_CRC_ASSINANTE");
            Date dataValidade = (Date)h.get("DATA_VAL_CRC_ASSINANTE");
            wr.append("|J930");
            wr.append("|" + nome);
            wr.append("|" + ClearUtil.refinaAll(cpf));
            wr.append("|" + funcao);
            wr.append("|" + codFuncao);
            if (codFuncao.equalsIgnoreCase("900") && crc != null) {
                wr.append("|" + ClearUtil.refinaAll(crc));
            } else {
                wr.append("|");
            }
            if (email != null && email.trim().length() > 0) {
                wr.append("|" + email);
            } else {
                wr.append("|");
            }
            if (telefone != null && telefone.trim().length() > 0) {
                wr.append("|" + telefone);
            } else {
                wr.append("|");
            }
            if (uf != null) {
                wr.append("|" + uf.getSigla());
            } else {
                wr.append("|");
            }
            wr.append("|");
            if (dataValidade != null) {
                wr.append("|" + ClearUtil.refinaAll(DateUtil.dateToStr(dataValidade)));
            } else {
                wr.append("|");
            }
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegisterJ990(long qtdLinhas, PrintWriter wr) {
        wr.append("|J990");
        wr.append("|" + qtdLinhas);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9001(int i, PrintWriter wr) {
        wr.append("|9001");
        wr.append("|" + i);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9900(PrintWriter wr) {
        Set keys = this.counter.keySet();
        for (Object obj : keys) {
            String reg = (String)obj;
            Long value = (Long)this.counter.get(obj);
            if (value <= 0L) continue;
            wr.append("|9900");
            wr.append("|" + reg);
            wr.append("|" + value);
            wr.append("|");
            wr.append("\r\n");
        }
    }

    private void createRegister9990(long qtdLinhasBloco9, PrintWriter wr) {
        wr.append("|9990");
        wr.append("|" + qtdLinhasBloco9);
        wr.append("|");
        wr.append("\r\n");
    }

    private void createRegister9999(long totalLinhasArquivo, PrintWriter wr) {
        wr.append("|9999");
        wr.append("|" + totalLinhasArquivo);
        wr.append("|");
        wr.append("\r\n");
    }

    private void contarRegistros(List contas, List saldos, List lancamentos, List assinantes, List regJ005, List reg350355, boolean gerarBalancete, Short gerarBlocoJ800, List<RegJ800> regJ800, Empresa empresa) {
        long count9900 = 0L;
        this.counter.put("0000", 1L);
        ++count9900;
        this.counter.put("0001", 1L);
        ++count9900;
        this.counter.put("0007", this.countOf0007(empresa));
        ++count9900;
        this.counter.put("0990", 1L);
        ++count9900;
        this.counter.put("I001", 1L);
        ++count9900;
        this.counter.put("I010", 1L);
        ++count9900;
        this.counter.put("I030", this.countOfI030(empresa));
        ++count9900;
        this.counter.put("I050", new Long(contas.size()));
        ++count9900;
        this.counter.put("I051", this.countOfI051(contas));
        ++count9900;
        this.counter.put("I052", this.countOfI052(contas));
        ++count9900;
        this.counter.put("I150", new Long(saldos.size()));
        ++count9900;
        this.counter.put("I155", this.countOfI155(saldos));
        ++count9900;
        this.counter.put("I200", new Long(lancamentos.size()));
        ++count9900;
        this.counter.put("I250", this.countOfI250(lancamentos));
        ++count9900;
        this.counter.put("I350", new Long(reg350355.size()));
        ++count9900;
        this.counter.put("I355", this.countOfI350(reg350355));
        ++count9900;
        this.counter.put("I990", 1L);
        ++count9900;
        this.counter.put("J001", 1L);
        ++count9900;
        if (gerarBalancete) {
            this.counter.put("J005", new Long(regJ005.size()));
            ++count9900;
            this.counter.put("J100", this.countOfJ100(regJ005));
            ++count9900;
            this.counter.put("J150", this.countOfJ150(regJ005));
            ++count9900;
            if (gerarBlocoJ800.equals((short)1)) {
                this.counter.put("J800", new Long(regJ800.size()));
                ++count9900;
            }
        }
        this.counter.put("J900", 1L);
        ++count9900;
        this.counter.put("J930", new Long(assinantes.size()));
        ++count9900;
        this.counter.put("J990", 1L);
        ++count9900;
        this.counter.put("9001", 1L);
        this.counter.put("9900", ++count9900 + 3L);
        this.counter.put("9990", 1L);
        this.counter.put("9999", 1L);
    }

    private Long countOf0007(Empresa emp) {
        long qtdReg = 0L;
        if (emp.getEmpresaDados().getInscANTT() != null && emp.getEmpresaDados().getInscANTT().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscBancoCentral() != null && emp.getEmpresaDados().getInscBancoCentral().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscCVM() != null && emp.getEmpresaDados().getInscCVM().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getEmpresaDados().getInscBancoCentral() != null && emp.getEmpresaDados().getInscSusep().trim().length() > 0) {
            ++qtdReg;
        }
        if (emp.getPessoa().getComplemento().getInscEst() != null && !emp.getPessoa().getComplemento().getInscEst().equalsIgnoreCase("isento")) {
            ++qtdReg;
        }
        return qtdReg;
    }

    private long countOfI030(Empresa empresa) {
        if (empresa.getEmpresaDados().getInscJuntaComercial() != null && empresa.getEmpresaDados().getInscJuntaComercial().trim().length() > 0) {
            return 1L;
        }
        return 0L;
    }

    private String formatValuesInSpedFormat(Double value) {
        Object cadastroRefinado = "";
        String valueStr = this.nf.format(value);
        for (int i = 0; i < valueStr.length(); ++i) {
            char carac = valueStr.charAt(i);
            if (carac == '.' || carac == '-' || carac == '+') continue;
            cadastroRefinado = (String)cadastroRefinado + String.valueOf(carac);
        }
        return cadastroRefinado;
    }

    private Long getCounter(String string) {
        Long sum = 0L;
        Set key = this.counter.keySet();
        for (Object o : key) {
            String k = (String)o;
            if (string != null && !k.startsWith(string)) continue;
            sum = sum + (Long)this.counter.get(o);
        }
        return sum;
    }

    private Object countOfI051(List contas) {
        long count = 0L;
        for (Object o : contas) {
            RegI050 r = (RegI050)o;
            if (r.getPlanosReferenciados() == null) continue;
            count += (long)r.getPlanosReferenciados().size();
        }
        return count;
    }

    private Object countOfI052(List contas) {
        long count = 0L;
        for (Object o : contas) {
            RegI050 r = (RegI050)o;
            if (r.getCodigosAglutinacao() == null) continue;
            count += (long)r.getCodigosAglutinacao().size();
        }
        return count;
    }

    private Object countOfI155(List saldos) {
        long count = 0L;
        for (Object o : saldos) {
            RegI150 r = (RegI150)o;
            if (r.getDadosSaldos() == null) continue;
            count += (long)r.getDadosSaldos().size();
        }
        return count;
    }

    private Object countOfI250(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegI200 r = (RegI200)o;
            if (r.getRegI250() == null) continue;
            count += (long)r.getRegI250().size();
        }
        return count;
    }

    private Object countOfI350(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegI350 r = (RegI350)o;
            if (r.getRegI355() == null) continue;
            count += (long)r.getRegI355().size();
        }
        return count;
    }

    private Object countOfJ100(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegJ005 r = (RegJ005)o;
            if (r.getRegJ100() == null) continue;
            count += (long)r.getRegJ100().size();
        }
        return count;
    }

    private Object countOfJ150(List lancamentos) {
        long count = 0L;
        for (Object o : lancamentos) {
            RegJ005 r = (RegJ005)o;
            if (r.getRegJ150() == null) continue;
            count += (long)r.getRegJ150().size();
        }
        return count;
    }

    private List getRegI150(Integer ano, Integer mes) {
        LinkedList<RegI150> l = new LinkedList<RegI150>();
        System.out.println("");
        if (mes != null) {
            l.add(this.getVoRegI150(mes, ano));
        } else {
            for (int i = 1; i <= 12; ++i) {
                l.add(this.getVoRegI150(i, ano));
            }
        }
        return l;
    }

    private RegI150 getVoRegI150(Integer mes, Integer ano) {
        RegI150 r = new RegI150();
        r.setDataIn(this.getDataIn(ano, mes));
        r.setDataFim(this.getDataFim(ano, mes));
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }

    private void clearFile(String diretorioArquivo) throws IOException {
        FileReader arquivo = null;
        PrintWriter pw = null;
        File novoArquivo = new File(diretorioArquivo + File.separator + SPED_ECF);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            arquivo = new FileReader(novoArquivo);
            BufferedReader buffer = new BufferedReader(arquivo);
            while (buffer.ready()) {
                String line = buffer.readLine();
                if (line.isEmpty()) continue;
                stringBuffer.append(ToolString.substituiCaractereEspecial((String)line));
                stringBuffer.append("\r\n");
            }
            FileOutputStream os = new FileOutputStream(novoArquivo);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());
            pw = new PrintWriter(osw);
            pw.append(stringBuffer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("Erro ao remover caracteres especiais do arquivo Sped Cont\u00e1bil!");
        }
        finally {
            try {
                pw.flush();
                pw.close();
                arquivo.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new IOException("Erro ao remover caracteres especiais do arquivo Sped Cont\u00e1bil!");
            }
        }
    }

    private void createRegisterJ800(List<RegJ800> regJ800, PrintWriter pw) {
        Iterator<RegJ800> iterator = regJ800.iterator();
        while (iterator.hasNext()) {
            RegJ800 obj;
            RegJ800 r = obj = iterator.next();
            String conteudo = r.getConteudoArquivo();
            pw.append("|J800");
            pw.append("|" + conteudo);
            pw.append("|J800FIM|");
            pw.append("\r\n");
        }
    }

    public static String getIdentificacaoLancamentoSped(Integer flag) {
        if (flag != null && flag.equals(1)) {
            return "E";
        }
        return "N";
    }

    private String getSimOrNao(Short valor) {
        if (valor == 1) {
            return "S";
        }
        return "N";
    }

    private File createWritterBloco0(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco0 w = new UtilWritterBloco0();
        w.writterRegister0000(vo, p, this.cont);
        w.writterRegister0001(BLOCO_DADOS_INF, p, this.cont);
        w.writterRegister0010(vo, p, this.cont);
        w.writterRegister0020(vo, p, this.cont);
        w.writterRegister0030(vo, p, this.cont);
        w.writterRegister0035(vo, p, this.cont);
        w.writterRegister0930(vo.getAssinanteArqSpedEcf(), p, this.cont);
        w.writterRegister0990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoC(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_c", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoC w = new UtilWritterBlocoC();
        w.writterRegisterC001(BLOCO_DADOS_NAO_INF, p, this.cont);
        w.writterRegisterC990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoE(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_e", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoE w = new UtilWritterBlocoE();
        w.writterRegisterE001(BLOCO_DADOS_NAO_INF, p, this.cont);
        w.writterRegisterE990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File createWritterBlocoJ(SpedEcf vo) throws IOException, ExceptionService, ExceptionDatabase {
        File f = File.createTempFile("sped_bloco_j", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoJ w = new UtilWritterBlocoJ();
        if (this.validarFormasTributacao(vo)) {
            UtilBDConsultBlocoJ consulta = new UtilBDConsultBlocoJ();
            BlocoJ blocoJ = consulta.gerarBlocoJ(vo.getDataInicial(), vo.getDataFinal());
            if (blocoJ.getPlanoContas() == null || blocoJ.getPlanoContas().isEmpty()) throw new ExceptionService("Primeiro verifique se existe Plano de Contas cadastrados, e se a data de cadastros dos planos \u00e9 inferior a data final do arquivo!");
            w.writterRegisterJ001(BLOCO_DADOS_INF, p, this.cont);
            w.writterRegisterJ050(p, blocoJ.getPlanoContas(), this.cont);
        } else {
            w.writterRegisterJ001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterJ990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private HashMap createWritterBlocoK(SpedEcf vo) throws IOException, ExceptionService {
        HashMap<String, Object> h = new HashMap<String, Object>();
        File f = File.createTempFile("sped_bloco_k", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoK w = new UtilWritterBlocoK();
        if (this.validarFormasTributacao(vo)) {
            UtilBDConsultBlocoK consulta = new UtilBDConsultBlocoK();
            BlocoK blocoK = consulta.gerarBlocoK030(vo);
            if (blocoK.getRegistrosK030() != null && !blocoK.getRegistrosK030().isEmpty()) {
                w.writterRegisterK001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterK030(blocoK.getRegistrosK030(), p, this.cont);
                h.put("regK030", blocoK.getRegistrosK030());
            }
        } else {
            w.writterRegisterK001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterK990(p, this.cont);
        p.flush();
        p.close();
        h.put("file", f);
        return h;
    }

    private File createWritterBlocoL(SpedEcf vo, List<RegK030> registrosK030) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_l", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoL w = new UtilWritterBlocoL();
        if (this.gerarBlocoL(vo).booleanValue()) {
            UtilBDConsultBlocoL consulta = new UtilBDConsultBlocoL();
            BlocoL blocoL = consulta.gerarBlocoL030(vo, registrosK030);
            if (blocoL.getRegistrosL030() != null && !blocoL.getRegistrosL030().isEmpty()) {
                w.writterRegisterL001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterL030(blocoL.getRegistrosL030(), p, this.cont);
            }
        } else {
            w.writterRegisterL001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterL990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoM(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_m", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoM w = new UtilWritterBlocoM();
        if (this.gerarBlocoM(vo).booleanValue()) {
            UtilBDConsultBlocoM consulta = new UtilBDConsultBlocoM();
            BlocoM blocoM = consulta.gerarBlocoM(vo);
            if (blocoM.getRegistrosM030() != null && !blocoM.getRegistrosM030().isEmpty() || blocoM.getRegistrosM010() != null && !blocoM.getRegistrosM010().isEmpty()) {
                w.writterRegisterM001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterM010(blocoM.getRegistrosM010(), p, this.cont);
                w.writterRegisterM030(blocoM.getRegistrosM030(), p, this.cont);
            }
        } else {
            w.writterRegisterM001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterM990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoN(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_n", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoN w = new UtilWritterBlocoN();
        if (this.gerarBlocoN(vo).booleanValue()) {
            UtilBDConsultBlocoN consulta = new UtilBDConsultBlocoN();
            BlocoN blocoN = consulta.gerarBlocoN(vo);
            if (blocoN.getRegistrosN030() != null && !blocoN.getRegistrosN030().isEmpty()) {
                w.writterRegisterN001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterN030(blocoN.getRegistrosN030(), p, this.cont);
            }
        } else {
            w.writterRegisterN001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterN990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoP(SpedEcf vo, List<RegK030> registrosK030) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_p", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoP w = new UtilWritterBlocoP();
        if (this.gerarBlocoP(vo).booleanValue()) {
            UtilBDConsultBlocoP consulta = new UtilBDConsultBlocoP();
            BlocoP blocoP = consulta.gerarBlocoP(vo, registrosK030);
            if (blocoP.getRegistrosP030() != null && !blocoP.getRegistrosP030().isEmpty()) {
                w.writterRegisterP001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterP030(blocoP.getRegistrosP030(), p, this.cont);
            }
        } else {
            w.writterRegisterP001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterP990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoQ(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_q", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoQ w = new UtilWritterBlocoQ();
        if (this.gerarBlocoQ(vo).booleanValue()) {
            if (vo.getLivroCaixa() != null && !vo.getLivroCaixa().isEmpty()) {
                w.writterRegisterQ001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterQ100(vo.getLivroCaixa(), p, this.cont);
            }
        } else {
            w.writterRegisterQ001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterQ990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoT(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_t", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoT w = new UtilWritterBlocoT();
        if (this.gerarBlocoT(vo).booleanValue()) {
            UtilBDConsultBlocoT consulta = new UtilBDConsultBlocoT();
            BlocoT blocoT = consulta.gerarBlocoT030(vo);
            if (blocoT.getRegistrosT030() != null && !blocoT.getRegistrosT030().isEmpty()) {
                w.writterRegisterT001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterT030(blocoT.getRegistrosT030(), p, this.cont);
            }
        } else {
            w.writterRegisterT001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterT990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoU(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_u", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoU w = new UtilWritterBlocoU();
        if (this.gerarBlocoU(vo).booleanValue()) {
            UtilBDConsultBlocoU consulta = new UtilBDConsultBlocoU();
            BlocoU blocoU = consulta.gerarBlocoU030(vo);
            if (blocoU.getRegistrosU030() != null && !blocoU.getRegistrosU030().isEmpty()) {
                w.writterRegisterU001(BLOCO_DADOS_INF, p, this.cont);
                w.writterRegisterU030(blocoU.getRegistrosU030(), p, this.cont);
            }
        } else {
            w.writterRegisterU001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterU990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoX(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_x", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoX w = new UtilWritterBlocoX();
        UtilBDConsultBlocoX consulta = new UtilBDConsultBlocoX();
        BlocoX blocoX = new BlocoX();
        this.criarRegisterX280(vo, blocoX, consulta);
        this.criarRegisterX291(vo, blocoX, consulta);
        this.criarRegisterX292(vo, blocoX, consulta);
        this.criarRegisterX300(vo, blocoX, consulta);
        this.criarRegisterX320(vo, blocoX, consulta);
        this.criarRegisterX340(vo, blocoX, consulta);
        this.criarRegisterX352(vo, blocoX, consulta);
        this.criarRegisterX353(vo, blocoX, consulta);
        this.criarRegisterX354(vo, blocoX, consulta);
        this.criarRegisterX355(vo, blocoX, consulta);
        this.criarRegisterX356(vo, blocoX, consulta);
        this.criarRegisterX366(vo, blocoX, consulta);
        this.criarRegisterX390(vo, blocoX, consulta);
        this.criarRegisterX400(vo, blocoX, consulta);
        this.criarRegisterX410(vo, blocoX, consulta);
        this.criarRegisterX420(vo, blocoX, consulta);
        this.criarRegisterX430(vo, blocoX, consulta);
        this.criarRegisterX450(vo, blocoX, consulta);
        this.criarRegisterX460(vo, blocoX, consulta);
        this.criarRegisterX470(vo, blocoX, consulta);
        this.criarRegisterX480(vo, blocoX, consulta);
        this.criarRegisterX490(vo, blocoX, consulta);
        this.criarRegisterX500(vo, blocoX, consulta);
        this.criarRegisterX510(vo, blocoX, consulta);
        if (!(blocoX.getRegistrosX280().isEmpty() && blocoX.getRegistrosX291().isEmpty() && blocoX.getRegistrosX292().isEmpty() && blocoX.getRegistrosX300().isEmpty() && blocoX.getRegistrosX320().isEmpty() && blocoX.getRegistrosX340().isEmpty())) {
            w.writterRegisterX001(BLOCO_DADOS_INF, p, this.cont);
            w.writterRegisterX280(blocoX.getRegistrosX280(), p, this.cont);
            w.writterRegisterX291(blocoX.getRegistrosX291(), p, this.cont);
            w.writterRegisterX292(blocoX.getRegistrosX292(), p, this.cont);
            w.writterRegisterX300(blocoX.getRegistrosX300(), p, this.cont);
            w.writterRegisterX320(blocoX.getRegistrosX320(), p, this.cont);
            w.writterRegisterX340(blocoX.getRegistrosX340(), p, this.cont);
        } else {
            w.writterRegisterX001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterX990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlocoY(SpedEcf vo) throws IOException, ExceptionService {
        File f = File.createTempFile("sped_bloco_y", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBlocoY w = new UtilWritterBlocoY();
        UtilBDConsultBlocoY consulta = new UtilBDConsultBlocoY();
        BlocoY blocoY = new BlocoY();
        this.criarRegisterY520(vo, blocoY, consulta);
        this.criarRegisterY540(vo, blocoY, consulta);
        this.criarRegisterY550(vo, blocoY, consulta);
        this.criarRegisterY560(vo, blocoY, consulta);
        this.criarRegisterY570(vo, blocoY, consulta);
        this.criarRegisterY580(vo, blocoY, consulta);
        this.criarRegisterY590(vo, blocoY, consulta);
        this.criarRegisterY600(vo, blocoY, consulta);
        this.criarRegisterY612(vo, blocoY, consulta);
        this.criarRegisterY620(vo, blocoY, consulta);
        this.criarRegisterY630(vo, blocoY, consulta);
        this.criarRegisterY640(vo, blocoY, consulta);
        this.criarRegisterY660(vo, blocoY, consulta);
        this.criarRegisterY665(vo, blocoY, consulta);
        this.criarRegisterY671(vo, blocoY, consulta);
        this.criarRegisterY672(vo, blocoY, consulta);
        this.criarRegisterY680(vo, blocoY, consulta);
        this.criarRegisterY682(vo, blocoY, consulta);
        this.criarRegisterY690(vo, blocoY, consulta);
        this.criarRegisterY720(vo, blocoY, consulta);
        if (blocoY.getRegistrosY520() != null && !blocoY.getRegistrosY520().isEmpty() || blocoY.getRegistrosY540() != null && !blocoY.getRegistrosY540().isEmpty() || blocoY.getRegistrosY550() != null && !blocoY.getRegistrosY550().isEmpty() || blocoY.getRegistrosY570() != null && !blocoY.getRegistrosY570().isEmpty() || blocoY.getRegistrosY600() != null && !blocoY.getRegistrosY600().isEmpty() || blocoY.getRegistrosY612() != null && !blocoY.getRegistrosY612().isEmpty() || blocoY.getRegistrosY620() != null && !blocoY.getRegistrosY620().isEmpty() || blocoY.getRegistrosY671() != null && !blocoY.getRegistrosY671().isEmpty() || blocoY.getRegistrosY672() != null && !blocoY.getRegistrosY672().isEmpty() || blocoY.getRegistrosY680() != null && !blocoY.getRegistrosY680().isEmpty() || blocoY.getRegistrosY690() != null && !blocoY.getRegistrosY690().isEmpty() || blocoY.getRegistrosY720() != null && !blocoY.getRegistrosY720().isEmpty()) {
            w.writterRegisterY001(BLOCO_DADOS_INF, p, this.cont);
            w.writterRegisterY520(blocoY.getRegistrosY520(), p, this.cont);
            w.writterRegisterY540(blocoY.getRegistrosY540(), p, this.cont);
            w.writterRegisterY550(blocoY.getRegistrosY550(), p, this.cont);
            w.writterRegisterY570(blocoY.getRegistrosY570(), p, this.cont);
            w.writterRegisterY600(blocoY.getRegistrosY600(), p, this.cont);
            w.writterRegisterY612(blocoY.getRegistrosY612(), p, this.cont);
            w.writterRegisterY620(blocoY.getRegistrosY620(), p, this.cont);
            w.writterRegisterY671(blocoY.getRegistrosY671(), p, this.cont);
            w.writterRegisterY672(blocoY.getRegistrosY672(), p, this.cont);
            w.writterRegisterY680And681(blocoY.getRegistrosY680(), p, this.cont);
            w.writterRegisterY690(blocoY.getRegistrosY690(), p, this.cont);
            w.writterRegisterY720(blocoY.getRegistrosY720(), p, this.cont);
        } else {
            w.writterRegisterY001(BLOCO_DADOS_NAO_INF, p, this.cont);
        }
        w.writterRegisterY990(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBloco9(SpedEcf vo) throws IOException {
        File f = File.createTempFile("sped_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f);
        UtilWritterBloco9 w = new UtilWritterBloco9();
        w.writterReg9001(p, this.cont);
        w.writterReg9900(vo.getVersao(), p, this.cont);
        w.writterReg9099(p, this.cont);
        w.writterReg9999(p, this.cont);
        p.flush();
        p.close();
        return f;
    }

    private void apendToSomeFile(File file, File bloco0, File blocoC, File blocoE, File blocoJ, File blocoK, File blocoL, File blocoM, File blocoN, File blocoP, File blocoT, File blocoU, File blocoX, File blocoY, File bloco9, File blocoQ) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(bloco0, out);
        this.copy(blocoC, out);
        this.copy(blocoE, out);
        this.copy(blocoJ, out);
        this.copy(blocoK, out);
        this.copy(blocoL, out);
        this.copy(blocoM, out);
        this.copy(blocoN, out);
        this.copy(blocoP, out);
        this.copy(blocoQ, out);
        this.copy(blocoT, out);
        this.copy(blocoU, out);
        this.copy(blocoX, out);
        this.copy(blocoY, out);
        this.copy(bloco9, out);
        bloco0.delete();
        blocoC.delete();
        bloco9.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private boolean validarFormasTributacao(SpedEcf vo) {
        if (vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4")) {
            return true;
        }
        return (vo.getFormaTributacaoLucro().getCodigo().equals("5") || vo.getFormaTributacaoLucro().getCodigo().equals("7") || vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9")) && vo.getTipoEscrituracao() != null && vo.getTipoEscrituracao().getCodigo().equals("C");
    }

    private Boolean gerarBlocoL(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4");
    }

    private Boolean gerarBlocoM(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4");
    }

    private Boolean gerarBlocoN(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4");
    }

    private Boolean gerarBlocoP(SpedEcf vo) {
        return (vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4") || vo.getFormaTributacaoLucro().getCodigo().equals("5") || vo.getFormaTributacaoLucro().getCodigo().equals("7")) && vo.getFormaTributacaoPeriodo().getCodigo().equals("P");
    }

    private Boolean gerarBlocoQ(SpedEcf vo) {
        return vo.getTipoEscrituracao() != null && vo.getTipoEscrituracao().getCodigo().equalsIgnoreCase("L");
    }

    private Boolean gerarBlocoT(SpedEcf vo) {
        return (vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("4") || vo.getFormaTributacaoLucro().getCodigo().equals("6") || vo.getFormaTributacaoLucro().getCodigo().equals("7")) && vo.getFormaTributacaoPeriodo().getCodigo().equals("A");
    }

    private Boolean gerarBlocoU(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX280(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX280(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX280(SpedEcf vo) {
        return (vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4")) && vo.getIndicadorLucroExploracao() == 1 || (vo.getFormaTributacaoLucro().getCodigo().equals("5") || vo.getFormaTributacaoLucro().getCodigo().equals("7")) && vo.getOptanteRefis() == 1 && vo.getIndicadorReducaoIsencaoImposto() == 1;
    }

    private void criarRegisterX291(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX291(vo)) {
            blocoX.setRegistrosX291(consulta.getRegistrosX291(vo));
        }
    }

    private boolean gerarBlocoX291(SpedEcf vo) {
        return vo.getIndicadorOperacoesExterior() == 1 && vo.getIndicadorOperacaoVinculada() == 1;
    }

    private void criarRegisterX292(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX292(vo)) {
            blocoX.setRegistrosX292(consulta.getRegistrosX292(vo));
        }
    }

    private boolean gerarBlocoX292(SpedEcf vo) {
        return vo.getIndicadorOperacoesExterior() == 1;
    }

    private void criarRegisterX300(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX300(vo)) {
            blocoX.setRegistrosX300(consulta.getRegistrosX300(vo));
        }
    }

    private boolean gerarBlocoX300(SpedEcf vo) {
        return vo.getIndicadorOperacoesExterior() == 1 && vo.getIndicadorOperacaoVinculada() == 1;
    }

    private void criarRegisterX320(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX320(vo)) {
            blocoX.setRegistrosX320(consulta.getRegistrosX320(vo));
        }
    }

    private boolean gerarBlocoX320(SpedEcf vo) {
        return vo.getIndicadorOperacoesExterior() == 1 && vo.getIndicadorOperacaoVinculada() == 1;
    }

    private void criarRegisterX340(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX340(vo)) {
            blocoX.setRegistrosX340(consulta.getRegistrosX340(vo));
        }
    }

    private boolean gerarBlocoX340(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1;
    }

    private void criarRegisterX352(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX352(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX352(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX353(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX353(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX353(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX354(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX354(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX354(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX355(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX355(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX355(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX356(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX356(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX356(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX366(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX366(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX366(SpedEcf vo) {
        return vo.getIndicadorParticipacoesExterior() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("5") && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX390(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX390(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX390(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX400(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX400(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX400(SpedEcf vo) {
        return vo.getIndicadorComercioEletronico() == 1;
    }

    private void criarRegisterX410(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX410(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX410(SpedEcf vo) {
        return vo.getIndicadorComercioEletronico() == 1;
    }

    private void criarRegisterX420(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX420(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX420(SpedEcf vo) {
        return vo.getIndicadorRoyaltiesPagos() == 1 || vo.getIndicadorRoyaltiesRecebidos() == 1;
    }

    private void criarRegisterX430(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX430(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX430(SpedEcf vo) {
        return vo.getIndicadorRendimentosServicos() == 1;
    }

    private void criarRegisterX450(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX450(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX450(SpedEcf vo) {
        return vo.getIndicadorPagamentosRemessas() == 1;
    }

    private void criarRegisterX460(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX460(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX460(SpedEcf vo) {
        return vo.getIndicadorInovacaoTecnologica() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX470(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX470(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX470(SpedEcf vo) {
        return vo.getIndicadorCapacitacaoInformatica() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX480(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX480(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX480(SpedEcf vo) {
        return vo.getIndicadorPessoaJuridicaHabilitada() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX490(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX490(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX490(SpedEcf vo) {
        return vo.getIndicadorPoloIndustrial() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX500(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX500(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX500(SpedEcf vo) {
        return vo.getIndicadorZonaProcExportacao() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterX510(SpedEcf vo, BlocoX blocoX, UtilBDConsultBlocoX consulta) {
        if (this.gerarBlocoX510(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoX510(SpedEcf vo) {
        return vo.getIndicadorAreaLivreComercio() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY520(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY520(vo) && vo.getRegistrosY520() != null) {
            ArrayList<RegY520> registrosY520 = new ArrayList<RegY520>();
            for (SecfPagRecExterior s : vo.getRegistrosY520()) {
                RegY520 r = new RegY520();
                if (s.getTipoPagRec() == 0) {
                    r.setTipo("P");
                } else {
                    r.setTipo("R");
                }
                r.setPais(s.getPais().getCodigo());
                r.setNaturezaOperacao(s.getNaturezaOperacao().getCodigo());
                r.setForma(String.valueOf(s.getFormaPagRec()));
                r.setValor(s.getValor());
                registrosY520.add(r);
            }
            blocoY.setRegistrosY520(registrosY520);
        }
    }

    private boolean gerarBlocoY520(SpedEcf vo) {
        return vo.getIndicadorRecebimentosExterior() == 1 || vo.getIndicadorPagtoExterior() == 1;
    }

    private void criarRegisterY540(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        blocoY.setRegistrosY540(consulta.getRegistrosY540(vo));
    }

    private void criarRegisterY550(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY550(vo)) {
            blocoY.setRegistrosY550(consulta.getRegistroY550(vo));
        }
    }

    private boolean gerarBlocoY550(SpedEcf vo) {
        return vo.getIndicadorVendasExportacao() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY560(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY560(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY560(SpedEcf vo) {
        return vo.getIndicadorComercialExportadora() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY570(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY570(vo)) {
            ArrayList<RegY570> lista = new ArrayList<RegY570>();
            for (SecfDemonstrativoIrrfCsll s : vo.getRegistrosY570()) {
                RegY570 r = new RegY570();
                r.setCnpjEmpresa(s.getPessoa().getComplemento().getCnpj());
                r.setNomeEmpresa(s.getPessoa().getNome());
                r.setCodigoRetencaoFonte(s.getCodigoRetencaoFonte().getCodigo());
                r.setValorCsll(s.getValorCSLL());
                r.setValorIrff(s.getValorIRRF());
                r.setValorRendimentoBruto(s.getValorRendimentoBruto());
                if (s.getIndicadorOrgaoPublico() == 1) {
                    r.setIndicadorOrgaoPublico("S");
                } else {
                    r.setIndicadorOrgaoPublico("N");
                }
                lista.add(r);
            }
            blocoY.setRegistrosY570(lista);
        }
    }

    private boolean gerarBlocoY570(SpedEcf vo) {
        return !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY580(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY580(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY580(SpedEcf vo) {
        return vo.getIndicadorDoacoesCampanhas() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY590(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY590(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY590(SpedEcf vo) {
        return vo.getIndicadorAtivosExterior() == 1;
    }

    private void criarRegisterY600(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (!(vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9") || vo.getRegistrosY600() == null || vo.getRegistrosY600().isEmpty())) {
            for (SecfSociosTitularEmpresa s : vo.getRegistrosY600()) {
                RegY600 r = new RegY600();
                r.setDataAlteracaoSoc(s.getDataAlteracaoQuadroSocietario());
                r.setDataSaidaSoc(s.getDataSaidaQuadroSocietario());
                r.setPais(s.getPais().getCodigo());
                r.setCpfCnpj(s.getPessoa().getComplemento().getCnpj());
                r.setNome(s.getPessoa().getNome());
                r.setCodQualificacao(s.getQualificacaoSocioTitular().getCodigo());
                r.setPercCapitalTotal(s.getPercentualCapitalTotal());
                r.setPercCapitalVotante(s.getPercentualCapitalVotante());
                if (s.getIndicadorQualificacaoSocio().equals(Short.valueOf("0"))) {
                    r.setIndicadorQualificacaoSoc("PF");
                } else if (s.getIndicadorQualificacaoSocio().equals(Short.valueOf("1"))) {
                    r.setIndicadorQualificacaoSoc("PJ");
                } else {
                    r.setIndicadorQualificacaoSoc("FI");
                }
                r.setValorDemaisRendimentos(s.getValorDemaisRendimentos());
                r.setValorJurosCapital(s.getValorJurosCapital());
                r.setValorRemuneracaoTrabalho(s.getValorRemuneracaoTrabalho());
                r.setValorIRRF(s.getValorIRRF());
                r.setValorLucrosDividendos(s.getValorLucroDividendos());
                blocoY.getRegistrosY600().add(r);
            }
        }
    }

    private void criarRegisterY612(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY612(vo) && vo.getRegistrosY600() != null && !vo.getRegistrosY600().isEmpty()) {
            for (SecfSociosTitularEmpresa s : vo.getRegistrosY600()) {
                RegY612 r = new RegY612();
                r.setCpfCnpj(s.getPessoa().getComplemento().getCnpj());
                r.setNome(s.getPessoa().getNome());
                r.setCodQualificacao(s.getQualificacaoSocioTitular().getCodigo());
                r.setValorDemaisRendimentos(s.getValorDemaisRendimentos());
                r.setValorRemuneracaoTrabalho(s.getValorRemuneracaoTrabalho());
                r.setValorIRRF(s.getValorIRRF());
                blocoY.getRegistrosY612().add(r);
            }
        }
    }

    private boolean gerarBlocoY612(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY620(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY620(vo)) {
            for (SecfParticipacaoPatrimonial s : vo.getRegistrosY620()) {
                RegY620 r = new RegY620();
                r.setTipoRelacionamento(s.getTipoRelacionamento());
                r.setDataEvento(s.getDataEvento());
                r.setDataAquisicao(s.getDataAquisicao());
                r.setNomeEmpresa(s.getPessoa().getNome());
                r.setCnpjEmpresa(s.getPessoa().getComplemento().getCnpj());
                r.setCodPais(s.getPais().getCodigo());
                r.setValorTotalReal(s.getValorTotal());
                r.setValorTotalMoedaExt(s.getValorTotalMoedaExterior());
                r.setResultadoEquivalencia(s.getValorEquivalenciaPatrimonial());
                r.setPercCapitalTotal(s.getPercentualCapitalTotal());
                r.setPercCapitalVotante(s.getPercentualCapitalVotante());
                r.setIndicadorProcessoCartorio(ToolMethods.isEquals((Object)s.getIndicadorProcessoCartorio(), (Object)1) ? "S" : "N");
                r.setNumeroProcessoCartorio(s.getNumeroProcessoCartorio());
                r.setNomeCartorio(s.getNomeCartorio());
                r.setIndicadorProcessoRFB(ToolMethods.isEquals((Object)s.getIndicadorProcessoRFB(), (Object)1) ? "S" : "N");
                r.setNumeroProcessRFB(s.getNumeroProcessoRFB());
                blocoY.getRegistrosY620().add(r);
            }
        }
    }

    private boolean gerarBlocoY620(SpedEcf vo) {
        return true;
    }

    private void criarRegisterY630(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY630(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY630(SpedEcf vo) {
        return vo.getIndicadorAdministradoraFundos() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY640(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY640(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY640(SpedEcf vo) {
        return vo.getIndicadorParticipacaoConsorcios() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") && !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY660(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY660(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY660(SpedEcf vo) {
        return vo.getIndicadorSituacaoEspecial().getCodigo().equals("2") || vo.getIndicadorSituacaoEspecial().getCodigo().equals("3") || vo.getIndicadorSituacaoEspecial().getCodigo().equals("5") || vo.getIndicadorSituacaoEspecial().getCodigo().equals("6");
    }

    private void criarRegisterY665(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY665(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY665(SpedEcf vo) {
        return vo.getDiferencaContabilidade() != null && vo.getDiferencaContabilidade() == 1 && (vo.getFormaTributacaoLucro().getCodigo().equals("8") || vo.getFormaTributacaoLucro().getCodigo().equals("9"));
    }

    private void criarRegisterY671(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY671(vo)) {
            SecfOutrasInformacoesLucroReal inf = vo.getOutrasInformacoesLucroReal();
            RegY671 r = new RegY671();
            r.setValorAliquotaReduzida(inf.getValorAliquotaReduzida());
            r.setValorAquisicaoImobilizado(inf.getValorAquisicaoImobilizado());
            r.setValorAquisicaoMaquina(inf.getValorAquisicaoMaquina());
            r.setValorBaixaImobilizado(inf.getValorBaixaImobilizado());
            r.setValorCambioIsencaoIof(inf.getValorCambioIsencaoIof());
            r.setValorCsllDepreciacaoInicio(inf.getValorCsllDepreciacaoInicio());
            r.setValorDoacaoCrianca(inf.getValorDoacaoCrianca());
            r.setValorDoacaoIdoso(inf.getValorDoacaoIdoso());
            r.setValorFolhaAliquotaReduzida(inf.getValorFolhaAliquotaReduzida());
            r.setValorIncentivoFimPeriodo(inf.getValorIncentivoFimPeriodo());
            r.setValorIncentivoInicioPeriodo(inf.getValorIncentivoInicioPeriodo());
            r.setIndicadorAlteracaoCapital(inf.getIndicadorAlteracaoCapital());
            r.setIndicadorBCNegativaCsll(inf.getIndicadorBCNegativaCsll());
            blocoY.getRegistrosY671().add(r);
        }
    }

    private boolean gerarBlocoY671(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("1") || vo.getFormaTributacaoLucro().getCodigo().equals("2") || vo.getFormaTributacaoLucro().getCodigo().equals("3") || vo.getFormaTributacaoLucro().getCodigo().equals("4");
    }

    private void criarRegisterY672(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY672(vo)) {
            SecfOutrasInformacoesLucroPresumido inf = vo.getOutrasInformacoesLucroPresumido();
            RegY672 r = new RegY672();
            r.setValorAliquotaReduzida(inf.getValorAliquotaReduzida());
            r.setValorAplicFinanceira(inf.getValorAplicFinanceira());
            r.setValorAplicFinanceiraAnterior(inf.getValorAplicFinanceiraAnterior());
            r.setValorCaixa(inf.getValorCaixa());
            r.setValorCaixaAnterior(inf.getValorCaixaAnterior());
            r.setValorCapital(inf.getValorCapital());
            r.setValorCapitalAnterior(inf.getValorCapitalAnterior());
            r.setValorCompraAtivo(inf.getValorCompraAtivo());
            r.setValorCompraMercadoria(inf.getValorCompraMercadoria());
            r.setValorContasPagar(inf.getValorContasPagar());
            r.setValorContasPagarAnterior(inf.getValorContasPagarAnterior());
            r.setValorContasReceber(inf.getValorContasReceber());
            r.setValorContasReceberAnterior(inf.getValorContasReceberAnterior());
            r.setValorEstoque(inf.getValorEstoque());
            r.setValorEstoqueAnterior(inf.getValorEstoqueAnterior());
            r.setValorFolhaAliquotaReduzida(inf.getValorFolhaAliquotaReduzida());
            r.setValorReceitas(inf.getValorReceitas());
            r.setValorTotalAtivo(inf.getValorTotalAtivo());
            r.setIndicadorAvaliacaoEstoque(inf.getIndicadorAvaliacaoEstoque());
            r.setIndicadorRegimeApuracao(inf.getIndicadorRegimeApuracao());
            blocoY.getRegistrosY672().add(r);
        }
    }

    private boolean gerarBlocoY672(SpedEcf vo) {
        return vo.getFormaTributacaoLucro().getCodigo().equals("6") || (vo.getFormaTributacaoLucro().getCodigo().equals("5") || vo.getFormaTributacaoLucro().getCodigo().equals("7")) && vo.getTipoEscrituracao().getCodigo().equals("L");
    }

    private void criarRegisterY680(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY680(vo) && vo.getRegistrosY680() != null) {
            for (SecfInfOptanteRefis s : vo.getRegistrosY680()) {
                RegY680 r = new RegY680();
                Integer mes = DateUtil.monthFromDate(s.getPeriodo());
                r.setMes(mes.toString());
                RegY681 rr = new RegY681();
                rr.setCodigo(s.getTabelaDinamica().getCodigo());
                rr.setDescricao(s.getTabelaDinamica().getDescricao());
                rr.setValor(s.getValor());
                r.getRegistrosY681().add(rr);
                blocoY.getRegistrosY680().add(r);
            }
        }
    }

    private boolean gerarBlocoY680(SpedEcf vo) {
        return vo.getOptanteRefis() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") & !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY682(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY682(vo)) {
            // empty if block
        }
    }

    private boolean gerarBlocoY682(SpedEcf vo) {
        return vo.getOptanteRefis() == 1 && !vo.getFormaTributacaoLucro().getCodigo().equals("8") & !vo.getFormaTributacaoLucro().getCodigo().equals("9");
    }

    private void criarRegisterY690(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY690(vo) && vo.getRegistrosY690() != null) {
            for (SecfInfOptantePaes s : vo.getRegistrosY690()) {
                RegY690 r = new RegY690();
                Integer mes = DateUtil.monthFromDate(s.getPeriodo());
                r.setMes(mes.toString());
                r.setValorReceitaBruta(s.getValor());
                blocoY.getRegistrosY690().add(r);
            }
        }
    }

    private boolean gerarBlocoY690(SpedEcf vo) {
        return vo.getOptantePaes() == 1;
    }

    private void criarRegisterY720(SpedEcf vo, BlocoY blocoY, UtilBDConsultBlocoY consulta) {
        if (this.gerarBlocoY720(vo) && vo.getRegistrosY720() != null) {
            for (SecfInfPeriodoAnterior s : vo.getRegistrosY720()) {
                RegY720 r = new RegY720();
                r.setDataLucroLiquido(s.getDataLucroLiquido());
                r.setValorLucroLiquido(s.getValorLucroLiquido());
                r.setValorReceitaAnterior(s.getValorReceitaBrutaAnterior());
                blocoY.getRegistrosY720().add(r);
            }
        }
    }

    private boolean gerarBlocoY720(SpedEcf vo) {
        return true;
    }
}

