/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao008.util.blocol;

import com.touchcomp.basementor.model.vo.PlanoContaSped;
import com.touchcomp.basementor.model.vo.SecfInfComposicaoCustosLucroReal;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.service.impl.spedecf.versao008.SpedEcfFormat008;
import mentorcore.service.impl.spedecf.versao008.model.blocok.RegK030;
import mentorcore.service.impl.spedecf.versao008.model.blocok.RegK155;
import mentorcore.service.impl.spedecf.versao008.model.blocol.BlocoL;
import mentorcore.service.impl.spedecf.versao008.model.blocol.RegL030;
import mentorcore.service.impl.spedecf.versao008.model.blocol.RegL100;
import mentorcore.service.impl.spedecf.versao008.model.blocol.RegL200;
import mentorcore.service.impl.spedecf.versao008.model.blocol.RegL210;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

public class UtilBDConsultBlocoL {
    SpedEcfFormat008 form = new SpedEcfFormat008();

    public BlocoL gerarBlocoL030(SpedEcf vo, List<RegK030> registrosK030) {
        BlocoL blocoL = new BlocoL();
        if (vo.getTipoApuracao().equals((short)0)) {
            Integer ano = DateUtil.yearFromDate(vo.getDataFinal());
            blocoL.getRegistrosL030().add(this.getRegL030AnualPadrao(vo.getDataInicial(), vo.getDataFinal()));
            if (ToolMethods.isStrWithData((String)vo.getIndicadorFormaApuracaoEstimativaDetalhado())) {
                String indicador = vo.getIndicadorFormaApuracaoEstimativaDetalhado().trim();
                int cont = 0;
                do {
                    int contAux;
                    String aux;
                    if (!(aux = indicador.substring(cont, contAux = cont + 1)).equalsIgnoreCase("B")) continue;
                    blocoL.getRegistrosL030().add(this.getRegL030Anual(contAux, ano, vo.getDataInicial()));
                } while (++cont < 12);
            } else {
                Short indFormaApuracaoEstimativa = vo.getIndicadorFormaApuracaoEstimativa();
                for (int i = 0; i < 12; ++i) {
                    if (!indFormaApuracaoEstimativa.equals(Short.valueOf("2"))) continue;
                    blocoL.getRegistrosL030().add(this.getRegL030Anual(i + 1, ano, vo.getDataInicial()));
                }
            }
        } else if (vo.getIndicadorInicioPeriodo().getCodigo().equals("0")) {
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial1(), vo.getDataFinal1(), "T01"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial1(), vo.getDataFinal1())) {
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal1(), "T01"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial2(), vo.getDataFinal2(), "T02"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial2(), vo.getDataFinal2())) {
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal2(), "T02"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial3(), vo.getDataFinal3(), "T03"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial3(), vo.getDataFinal3())) {
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal3(), "T03"));
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicial4(), vo.getDataFinal4(), "T04"));
        } else if (this.verificarDataObrigacao(vo.getDataInicialObrigatoriedade(), vo.getDataInicial4(), vo.getDataFinal4())) {
            blocoL.getRegistrosL030().add(this.getRegL030Trimestral(vo.getDataInicialObrigatoriedade(), vo.getDataFinal4(), "T04"));
        }
        this.gerarBlocoL100(blocoL.getRegistrosL030(), registrosK030);
        this.gerarBlocoL200(blocoL.getRegistrosL030(), vo.getRegistrosL210(), vo.getTipoApuracao(), vo);
        return blocoL;
    }

    private RegL030 getRegL030AnualPadrao(Date dataInicial, Date dataFinal) {
        RegL030 r = new RegL030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao("A00");
        return r;
    }

    private RegL030 getRegL030Anual(Integer mes, Integer ano, Date dataInicial) {
        RegL030 r = new RegL030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(this.getDataFim(ano, mes));
        if (mes < 10) {
            r.setPeriodoApuracao("A" + this.form.formatString("0" + String.valueOf(mes), 2));
        } else {
            r.setPeriodoApuracao("A" + this.form.formatString(String.valueOf(mes), 2));
        }
        return r;
    }

    private RegL030 getRegL030Trimestral(Date dataInicial, Date dataFinal, String periodoApuracao) {
        RegL030 r = new RegL030();
        r.setDataInicial(dataInicial);
        r.setDataFinal(dataFinal);
        r.setPeriodoApuracao(periodoApuracao);
        return r;
    }

    private Date getDataIn(Integer ano, Integer mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, ano);
        if (mes == null) {
            mes = 1;
        }
        g.set(2, mes - 1);
        g.set(5, 1);
        return g.getTime();
    }

    private Date getDataFim(Integer ano, Integer mes) {
        if (mes == null) {
            mes = 12;
        }
        int day = 0;
        switch (mes) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                if (new GregorianCalendar().isLeapYear(ano)) {
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        Object mesCorreto = mes < 10 ? "0" + mes : mes.toString();
        return DateUtil.strToDate(day + "/" + (String)mesCorreto + "/" + ano);
    }

    private void gerarBlocoL100(List<RegL030> registrosL030, List<RegK030> registrosK030) {
        for (RegL030 l : registrosL030) {
            for (RegK030 k : registrosK030) {
                if (!l.getPeriodoApuracao().equalsIgnoreCase(k.getPeriodoApuracao())) continue;
                l.setRegistrosL100(this.getRegistrosL100(k.getRegistrosK155(), l.getDataInicial(), l.getDataFinal()));
            }
        }
    }

    private List<RegL100> getRegistrosL100(List<RegK155> registrosK155, Date dataInicial, Date dataFinal) {
        ArrayList<RegL100> registrosL100 = new ArrayList<RegL100>();
        if (registrosK155 != null) {
            for (RegK155 k : registrosK155) {
                PlanoContaSped planoSped = CoreUtilityFactory.getUtilityPlanoConta().findPlanoContaSpedPorPlanoContaAndData(k.getPlanoConta(), dataInicial, dataFinal);
                if (planoSped == null) continue;
                RegL100 r = new RegL100();
                r.setCodigo(planoSped.getCodigo());
                r.setDescricao(planoSped.getDescricao());
                r.setTipo(this.getSinteticoAnalitico(planoSped.getMarca()));
                r.setSaldoInicial(k.getSaldoInicial());
                r.setIndicadorSaldoInicial(k.getIndSaldoInicial());
                r.setSaldoFinal(k.getSaldoFinal());
                r.setIndicadorSaldoFinal(k.getIndSaldoFinal());
                r.setValorDebitos(k.getValorDebito());
                r.setValorCreditos(k.getValorCredito());
                registrosL100.add(r);
            }
        }
        return registrosL100;
    }

    private String getSinteticoAnalitico(Short marca) {
        if (marca.equals(Short.valueOf("0"))) {
            return "S";
        }
        return "A";
    }

    private void gerarBlocoL200(List<RegL030> registrosL030, List<SecfInfComposicaoCustosLucroReal> registrosL210, Short tipoApuracao, SpedEcf vo) {
        if (vo.getQualificaoPessoaJuridica().getCodigo().equals("01") || vo.getTipoApuracao() == 0 && vo.getIndicadorFormaApuracaoEstimativa().equals(Short.valueOf("2"))) {
            for (RegL030 l : registrosL030) {
                RegL200 r = new RegL200();
                r.setCodigo("1");
                l.getRegistrosL200().add(r);
                for (SecfInfComposicaoCustosLucroReal s : registrosL210) {
                    Integer mes = DateUtil.getMonthFromDate(s.getPeriodo());
                    if (tipoApuracao.equals((short)0)) {
                        if (!l.getPeriodoApuracao().equals("A00")) continue;
                        r.getRegistrosL210().add(this.getRegistroL210(s));
                        continue;
                    }
                    if (mes != null && (mes == 1 || mes == 2 || mes == 3) && l.getPeriodoApuracao().equals("T01")) {
                        r.getRegistrosL210().add(this.getRegistroL210(s));
                        continue;
                    }
                    if (mes != null && (mes == 4 || mes == 5 || mes == 6) && l.getPeriodoApuracao().equals("T02")) {
                        r.getRegistrosL210().add(this.getRegistroL210(s));
                        continue;
                    }
                    if (mes != null && (mes == 7 || mes == 8 || mes == 9) && l.getPeriodoApuracao().equals("T03")) {
                        r.getRegistrosL210().add(this.getRegistroL210(s));
                        continue;
                    }
                    if (mes == null || mes != 10 && mes != 11 && mes != 12 || !l.getPeriodoApuracao().equals("T04")) continue;
                    r.getRegistrosL210().add(this.getRegistroL210(s));
                }
            }
        }
    }

    private RegL210 getRegistroL210(SecfInfComposicaoCustosLucroReal s) {
        RegL210 rr = new RegL210();
        rr.setCodigo(s.getTabelaDinamica().getCodigo());
        rr.setDescricao(s.getTabelaDinamica().getDescricao());
        rr.setValor(s.getValor());
        return rr;
    }

    private boolean verificarDataObrigacao(Date dataInicialObrigatoriedade, Date dataInicial, Date dataFinal) {
        return !(!dataInicialObrigatoriedade.equals(dataInicial) && !dataInicialObrigatoriedade.after(dataInicial) || !dataInicialObrigatoriedade.equals(dataFinal) && !dataInicialObrigatoriedade.before(dataFinal));
    }
}

