/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao008.util.blocom;

import java.io.PrintWriter;
import java.util.List;
import mentorcore.service.impl.spedecf.versao008.SpedEcfFormat008;
import mentorcore.service.impl.spedecf.versao008.model.ContadorRegistros;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM010;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM030;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM300;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM305;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM310;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM312;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM350;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM355;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM360;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM362;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM410;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM500;
import mentorcore.service.impl.spedecf.versao008.model.blocom.RegM510;

public class UtilWritterBlocoM {
    private SpedEcfFormat008 form = new SpedEcfFormat008();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;

    public void writterRegisterM001(Integer blocosDadosInf, PrintWriter wr, ContadorRegistros cont) {
        wr.append(this.separator + "M001");
        wr.append(this.separator + blocosDadosInf.toString());
        wr.append(this.separator + this.endOfRegister);
        cont.soma1("M001");
    }

    public void writterRegisterM990(PrintWriter wr, ContadorRegistros cont) {
        cont.soma1("M990");
        wr.append(this.separator + "M990");
        wr.append(this.separator + this.form.formatNumberLong(cont.getNrLinhas('M')));
        wr.append(this.separator + this.endOfRegister);
    }

    public void writterRegisterM010(List<RegM010> registrosM010, PrintWriter wr, ContadorRegistros cont) {
        for (RegM010 r : registrosM010) {
            wr.append(this.separator + "M010");
            wr.append(this.separator + r.getCodigoConta());
            wr.append(this.separator + r.getDescricaoConta());
            wr.append(this.separator + this.form.formatDate(r.getDataAplicacao()));
            if (r.getCodigoLancOrigem() != null) {
                wr.append(this.separator + r.getCodigoLancOrigem());
            } else {
                wr.append(this.separator);
            }
            if (r.getDataLimite() != null) {
                wr.append(this.separator + this.form.formatDate(r.getDataLimite()));
            } else {
                wr.append(this.separator);
            }
            wr.append(this.separator + r.getCodigoTributo());
            wr.append(this.separator + this.form.formatNumber(r.getValorSaldoInicial()));
            wr.append(this.separator + r.getIndicadorSaldoInicial());
            if (r.getCnpj() != null) {
                wr.append(this.separator + r.getCnpj());
            } else {
                wr.append(this.separator);
            }
            wr.append(this.separator + this.endOfRegister);
            cont.soma1("M010");
        }
    }

    public void writterRegisterM030(List<RegM030> registrosM030, PrintWriter wr, ContadorRegistros cont) {
        for (RegM030 r : registrosM030) {
            wr.append(this.separator + "M030");
            wr.append(this.separator + this.form.formatDate(r.getDataInicial()));
            wr.append(this.separator + this.form.formatDate(r.getDataFinal()));
            wr.append(this.separator + this.form.formatString(r.getPeriodoApuracao()));
            wr.append(this.separator + this.endOfRegister);
            cont.soma1("M030");
            this.writterRegisterM300(r.getRegistrosM300(), wr, cont);
            this.writterRegisterM350(r.getRegistrosM350(), wr, cont);
            this.writterRegisterM410(r.getRegistrosM410(), wr, cont);
            this.writterRegisterM500(r.getRegistrosM500(), wr, cont);
            this.writterRegisterM510(r.getRegistrosM510(), wr, cont);
        }
    }

    public void writterRegisterM300(List<RegM300> registrosM300, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM300 != null) {
            for (RegM300 r : registrosM300) {
                wr.append(this.separator + "M300");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + r.getDescricao());
                wr.append(this.separator + r.getTipoLancamento());
                wr.append(this.separator + r.getIndRelacao().toString());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + r.getHistorico());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M300");
                this.writterRegisterM305(r.getRegistrosM305(), wr, cont);
                this.writterRegisterM310(r.getRegistrosM310(), wr, cont);
                this.writterRegisterM312(r.getRegistrosM312(), wr, cont);
            }
        }
    }

    public void writterRegisterM305(List<RegM305> registrosM305, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM305 != null) {
            for (RegM305 r : registrosM305) {
                wr.append(this.separator + "M305");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + r.getIndicadorDebCred());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M305");
            }
        }
    }

    public void writterRegisterM310(List<RegM310> registrosM310, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM310 != null) {
            for (RegM310 r : registrosM310) {
                wr.append(this.separator + "M310");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + r.getIndicadorDebCred());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M310");
            }
        }
    }

    public void writterRegisterM312(List<RegM312> registrosM312, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM312 != null) {
            for (RegM312 r : registrosM312) {
                wr.append(this.separator + "M312");
                wr.append(this.separator + this.form.formatString(r.getNrLancamento(), 50));
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M312");
            }
        }
    }

    public void writterRegisterM350(List<RegM350> registrosM350, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM350 != null) {
            for (RegM350 r : registrosM350) {
                wr.append(this.separator + "M350");
                wr.append(this.separator + r.getCodigo());
                wr.append(this.separator + r.getDescricao());
                wr.append(this.separator + r.getTipoLancamento());
                wr.append(this.separator + r.getIndRelacao().toString());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + this.form.formatString(r.getHistorico(), 500));
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M350");
                this.writterRegisterM355(r.getRegistrosM355(), wr, cont);
                this.writterRegisterM360(r.getRegistrosM360(), wr, cont);
                this.writterRegisterM362(r.getRegistrosM362(), wr, cont);
            }
        }
    }

    public void writterRegisterM355(List<RegM355> registrosM355, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM355 != null) {
            for (RegM355 r : registrosM355) {
                wr.append(this.separator + "M355");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + r.getIndicadorDebCred());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M355");
            }
        }
    }

    public void writterRegisterM360(List<RegM360> registrosM360, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM360 != null) {
            for (RegM360 r : registrosM360) {
                wr.append(this.separator + "M360");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                wr.append(this.separator + r.getIndicadorDebCred());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M360");
            }
        }
    }

    public void writterRegisterM362(List<RegM362> registrosM362, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM362 != null) {
            for (RegM362 r : registrosM362) {
                wr.append(this.separator + "M362");
                wr.append(this.separator + this.form.formatString(r.getNrLancamento(), 50));
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M362");
            }
        }
    }

    public void writterRegisterM410(List<RegM410> registrosM410, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM410 != null) {
            for (RegM410 r : registrosM410) {
                wr.append(this.separator + "M410");
                if (r.getCodigoConta() != null) {
                    wr.append(this.separator + r.getCodigoConta());
                } else {
                    wr.append(this.separator);
                }
                wr.append(this.separator + r.getCodigoTributo());
                wr.append(this.separator + this.form.formatNumber(r.getValorLancamento(), 2));
                wr.append(this.separator + r.getIndicadorLancamento());
                if (r.getCodigoContraPartida() != null) {
                    wr.append(this.separator + r.getCodigoContraPartida());
                } else {
                    wr.append(this.separator);
                }
                wr.append(this.separator + r.getHistorico());
                wr.append(this.separator + r.getIndicadorLancamentoAnt());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M410");
            }
        }
    }

    public void writterRegisterM500(List<RegM500> registrosM500, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM500 != null) {
            for (RegM500 r : registrosM500) {
                wr.append(this.separator + "M500");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + r.getCodigoTributo());
                wr.append(this.separator + this.form.formatNumber(r.getSaldoInicial(), 2));
                wr.append(this.separator + r.getIndicadorSaldoInicial());
                wr.append(this.separator + this.form.formatNumber(r.getValorLancamentoParteA(), 2));
                wr.append(this.separator + r.getIndicadorLancamentoParteA());
                wr.append(this.separator + this.form.formatNumber(r.getValorLancamentoParteB(), 2));
                wr.append(this.separator + r.getIndicadorLancamentoParteB());
                wr.append(this.separator + this.form.formatNumber(r.getSaldoFinal(), 2));
                wr.append(this.separator + r.getIndicadorSaldoFinal());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M500");
            }
        }
    }

    public void writterRegisterM510(List<RegM510> registrosM510, PrintWriter wr, ContadorRegistros cont) {
        if (registrosM510 != null) {
            for (RegM510 r : registrosM510) {
                wr.append(this.separator + "M510");
                wr.append(this.separator + r.getCodigoConta());
                wr.append(this.separator + r.getDescricaoConta());
                wr.append(this.separator + r.getCodigoTributo());
                wr.append(this.separator + this.form.formatNumber(r.getSaldoInicial(), 2));
                wr.append(this.separator + r.getIndicadorSaldoInicial());
                wr.append(this.separator + this.form.formatNumber(r.getValorLancamentoParteA(), 2));
                wr.append(this.separator + r.getIndicadorLancamentoParteA());
                wr.append(this.separator + this.form.formatNumber(r.getValorLancamentoParteB(), 2));
                wr.append(this.separator + r.getIndicadorLancamentoParteB());
                wr.append(this.separator + this.form.formatNumber(r.getSaldoFinal(), 2));
                wr.append(this.separator + r.getIndicadorSaldoFinal());
                wr.append(this.separator + this.endOfRegister);
                cont.soma1("M510");
            }
        }
    }
}

