/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao008.util.blocoy;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.SecfReceitaVendaCnae;
import com.touchcomp.basementor.model.vo.SpedEcf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.spedecf.versao008.SpedEcfFormat008;
import mentorcore.service.impl.spedecf.versao008.model.blocoy.RegY540;
import mentorcore.service.impl.spedecf.versao008.model.blocoy.RegY550;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDConsultBlocoY {
    SpedEcfFormat008 form = new SpedEcfFormat008();

    public List<RegY550> getRegistroY550(SpedEcf vo) {
        String query = "select n.unidadeFatCliente.cliente.pessoa.complemento.cnpj as CNPJ_CLIENTE, i.produto.ncm.codigo as NCM, sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_TOTAL from NotaFiscalPropria n inner join n.itensNotaPropria i where n.dataEmissaoNota between :dataInicial and :dataFinal and n.status IN(:nfeAutorizada) and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and n.naturezaOperacao.entradaSaida = :saida and i.itemNotaLivroFiscal.cfop.cfopComercialExportadora = :sim group by n.unidadeFatCliente.cliente.pessoa.complemento.cnpj, i.produto.ncm.codigo ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setDate("dataInicial", vo.getDataInicial());
        q.setDate("dataFinal", vo.getDataFinal());
        q.setEntity("grupoEmpresa", (Object)vo.getEmpresa().getEmpresaDados().getGrupoEmpresa());
        q.setParameter("nfeAutorizada", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("saida", (short)1);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegY550> registrosY550 = new ArrayList<RegY550>();
        if (lista != null) {
            for (HashMap h : lista) {
                RegY550 r = new RegY550();
                r.setCnpj((String)h.get("CNPJ_CLIENTE"));
                r.setNcm((String)h.get("NCM"));
                r.setValor((Double)h.get("VALOR"));
                registrosY550.add(r);
            }
        }
        return registrosY550;
    }

    public List<RegY540> getRegistrosY540(SpedEcf vo) {
        ArrayList<RegY540> lista = new ArrayList<RegY540>();
        for (SecfReceitaVendaCnae rec : vo.getRegistrosY540()) {
            if (!(rec.getValor() > 0.0)) continue;
            RegY540 r = new RegY540();
            r.setCnae(rec.getCnae().getCodigo());
            r.setCnpj(rec.getEmpresa().getPessoa().getComplemento().getCnpj());
            r.setValor(rec.getValor());
            lista.add(r);
        }
        return lista;
    }
}

