/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedecf.versao009.util.blocoq;

import com.touchcomp.basementor.model.vo.SecfLivroCaixa;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mentorcore.service.impl.spedecf.versao009.SpedEcfFormat009;
import mentorcore.service.impl.spedecf.versao009.model.ContadorRegistros;

public class UtilWritterBlocoQ {
    private SpedEcfFormat009 form = new SpedEcfFormat009();
    private String endOfRegister = "\r\n";
    private char separator = (char)124;

    public void writterRegisterQ001(Integer blocosDadosInf, PrintWriter wr, ContadorRegistros cont) {
        wr.append(this.separator + "Q001");
        wr.append(this.separator + blocosDadosInf.toString());
        wr.append(this.separator + this.endOfRegister);
        cont.soma1("Q001");
    }

    public void writterRegisterQ990(PrintWriter wr, ContadorRegistros cont) {
        cont.soma1("Q990");
        wr.append(this.separator + "Q990");
        wr.append(this.separator + this.form.formatNumberLong(cont.getNrLinhas('Q')));
        wr.append(this.separator + this.endOfRegister);
    }

    public void writterRegisterQ100(List<SecfLivroCaixa> livrosCaixa, PrintWriter wr, ContadorRegistros cont) {
        livrosCaixa = this.ordenarRegistrosQ100(livrosCaixa);
        for (SecfLivroCaixa r : livrosCaixa) {
            wr.append(this.separator + "Q100");
            wr.append(this.separator + this.form.formatDate(r.getData()));
            wr.append(this.separator + this.form.formatString(r.getNrDoc()));
            wr.append(this.separator + this.form.formatString(r.getHistorico()));
            wr.append(this.separator + this.form.formatNumber(r.getValorEntrada()));
            wr.append(this.separator + this.form.formatNumber(r.getValorSaida()));
            wr.append(this.separator + this.form.formatNumber(r.getSaldoFinal()));
            wr.append(this.separator + this.endOfRegister);
            cont.soma1("Q100");
        }
    }

    private List<SecfLivroCaixa> ordenarRegistrosQ100(List<SecfLivroCaixa> lancamentos) {
        if (lancamentos != null) {
            Collections.sort(lancamentos, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    SecfLivroCaixa item1 = (SecfLivroCaixa)o1;
                    SecfLivroCaixa item2 = (SecfLivroCaixa)o2;
                    Integer indice1 = item1.getIndice();
                    Integer indice2 = item2.getIndice();
                    return indice1.compareTo(indice2);
                }
            });
            return lancamentos;
        }
        return new ArrayList<SecfLivroCaixa>();
    }
}

