/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InventarioSped;
import com.touchcomp.basementor.model.vo.MotInventarioSped;
import com.touchcomp.basementor.model.vo.OutrasInfSpedFiscal;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementor.model.vo.SpedFiscalTipoMovimento;
import com.touchcomp.basementor.model.vo.VersaoSpedFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.spedfiscal.ServiceSped;
import mentorcore.service.impl.spedfiscal.SpedFiscalConstants;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

class UtilSpedFiscal {
    UtilSpedFiscal() {
    }

    Object getRegistroSpedParametros(Date dataInicial, Date dataFinal, Long versaoSped, Short tipoArquivo, Date dataInventario, Short gerarInventario, Short tipoInventario, Long motivoInventario, Long idEmpresa) throws ExceptionService, ExceptionDatabase, SpedWritterException {
        Empresa empresa = this.getEmpresa(idEmpresa);
        SpedFiscal sped = this.criarSped(empresa, dataInicial, dataFinal, versaoSped, tipoArquivo, dataInventario, gerarInventario, tipoInventario, motivoInventario);
        if (sped.getTipoInventario() == SpedFiscalConstants.INVENTARIO_REAL || sped.getTipoInventario() == SpedFiscalConstants.INVENTARIO_REAL) {
            sped.setInventarioSped(this.getDadosInventario(sped));
        }
        sped = (SpedFiscal)CoreDAOFactory.getInstance().getDAOSpedFiscal().saveOrUpdate(sped);
        return sped;
    }

    private Empresa getEmpresa(Long idEmpresa) throws ExceptionService {
        return (Empresa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOEmpresa(), idEmpresa);
    }

    private SpedFiscal getSped(Empresa empresa, Date dataInicial, Date dataFinal) {
        Criteria crit = CoreBdUtil.getInstance().getSession().createCriteria(SpedFiscal.class);
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        crit.add((Criterion)Restrictions.eq((String)"dataInicial", (Object)dataInicial));
        crit.add((Criterion)Restrictions.eq((String)"dataFinal", (Object)dataFinal));
        return (SpedFiscal)crit.uniqueResult();
    }

    private SpedFiscal criarSped(Empresa empresa, Date dataInicial, Date dataFinal, Long versaoSped, Short tipoArquivo, Date dataInventario, Short gerarInventario, Short tipoInventario, Long motivoInventario) throws ExceptionDatabase, ExceptionService, SpedWritterException {
        SpedFiscal vo = this.getSped(empresa, dataInicial, dataFinal);
        if (vo == null) {
            vo = new SpedFiscal();
        }
        vo.setDataFinal(dataFinal);
        vo.setDataInicial(dataInicial);
        vo.setEmpresa(empresa);
        vo.setTipoArquivo(tipoArquivo);
        vo.setTipoInventario(tipoInventario);
        vo.setVersaoSpedFiscal(this.getVersaoSped(versaoSped));
        vo.setMotInventarioSped(this.getMotivoInventarioSped(motivoInventario));
        OutrasInfSpedFiscal outras = new OutrasInfSpedFiscal();
        outras.setReg1100(Short.valueOf((short)0));
        outras.setReg1200(Short.valueOf((short)0));
        outras.setReg1300(Short.valueOf((short)0));
        outras.setReg1390(Short.valueOf((short)0));
        outras.setReg1400(Short.valueOf((short)0));
        outras.setReg1500(Short.valueOf((short)0));
        outras.setReg1600(Short.valueOf((short)0));
        outras.setReg1700(Short.valueOf((short)0));
        outras.setReg1800(Short.valueOf((short)0));
        outras.setSpedFiscal(vo);
        vo.setOutrasInfSped(outras);
        return vo;
    }

    private VersaoSpedFiscal getVersaoSped(Long versaoSped) throws ExceptionDatabase, ExceptionService {
        VersaoSpedFiscal found = (VersaoSpedFiscal)CoreDAOFactory.getInstance().getDAOVersaoSpedFiscal().findByPrimaryKey(versaoSped);
        if (found == null) {
            throw new ExceptionService("Versao Sped nao encontrada com o identificador " + versaoSped);
        }
        return found;
    }

    private MotInventarioSped getMotivoInventarioSped(Long motivoInventario) throws ExceptionDatabase, ExceptionService {
        if (motivoInventario == null || motivoInventario <= 0L) {
            return null;
        }
        MotInventarioSped motivo = (MotInventarioSped)CoreDAOFactory.getInstance().getDAOMotInventarioSped().findByPrimaryKey(motivoInventario);
        if (motivo == null) {
            throw new ExceptionService("Motivo do inventario nao encontrado com o identificador " + motivoInventario);
        }
        return motivo;
    }

    private List<InventarioSped> getDadosInventario(SpedFiscal vo) throws ExceptionService, SpedWritterException {
        List inventario = ((ServiceSped)CoreServiceFactory.getServiceSped()).getDadosInventario(vo.getDataInventario(), vo.getEmpresa(), vo.getVersaoSpedFiscal().getCodigo(), vo.getTipoBusca(), new ArrayList<SpedFiscalTipoMovimento>());
        for (InventarioSped inv : inventario) {
            inv.setSpedFiscal(vo);
        }
        return inventario;
    }

    public Boolean isStatusFinalDocumentos(Date dataInicial, Date dataFinal, Empresa empresa) {
        Boolean achou = false;
        achou = this.isStatusFinalNotaPropria(dataInicial, dataFinal, empresa);
        if (!achou.booleanValue()) {
            return false;
        }
        achou = this.isStatusFinalNFCe(dataInicial, dataFinal, empresa);
        if (!achou.booleanValue()) {
            return false;
        }
        achou = this.isStatusFinalCTe(dataInicial, dataFinal, empresa);
        if (!achou.booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalNotaPropria(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from NotaFiscalPropria n where n.dataEmissaoNota  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.status <> :status1     and n.status <> :status2    and n.status <> :status3    and n.status <> :status4    and n.status <> :status5    and n.status <> :status6    and n.status <> :status7    and n.status <> :status8    and n.status <> :status9    and n.status <> :status10    and n.status <> :status11)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("modDocFiscal", "55");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        q.setShort("status10", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().shortValue());
        q.setShort("status11", EnumConstNFeStatus.REJ_NFE_INUTILIZADA_SEFAZ.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalNFCe(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from NFCe n where n.dataEmissao  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.status <> :status1     and n.status <> :status2    and n.status <> :status3    and n.status <> :status4    and n.status <> :status5    and n.status <> :status6    and n.status <> :status7    and n.status <> :status8    and n.status <> :status9    and n.status <> :status10    and n.status <> :status11)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("modDocFiscal", "65");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        q.setShort("status10", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().shortValue());
        q.setShort("status11", EnumConstNFeStatus.REJ_NFE_INUTILIZADA_SEFAZ.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }

    private Boolean isStatusFinalCTe(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select count(n.identificador)  from Cte n where n.dataEmissao  between :dataInicial and :dataFinal and n.empresa = :empresa and n.modeloDocFiscal.codigo = :modDocFiscal and ( n.cteInfo.status <> :status1     and n.cteInfo.status <> :status2    and n.cteInfo.status <> :status3    and n.cteInfo.status <> :status4    and n.cteInfo.status <> :status5    and n.cteInfo.status <> :status6    and n.cteInfo.status <> :status7    and n.cteInfo.status <> :status8    and n.cteInfo.status <> :status9    and n.cteInfo.status <> :status10    and n.cteInfo.status <> :status11)";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("modDocFiscal", "57");
        q.setShort("status1", EnumConstNFeStatus.DENEGADA.getValue().shortValue());
        q.setShort("status2", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_CANCELAMENTO_EMITENTE.getValue().shortValue());
        q.setShort("status3", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_DESTINATARIO.getValue().shortValue());
        q.setShort("status4", EnumConstNFeStatus.DENEGADA_IRREGULARIDADE_EMITENTE.getValue().shortValue());
        q.setShort("status5", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("status6", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        q.setShort("status7", EnumConstNFeStatus.CANCELADA.getValue().shortValue());
        q.setShort("status8", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().shortValue());
        q.setShort("status9", EnumConstNFeStatus.INUTILIZADA.getValue().shortValue());
        q.setShort("status10", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().shortValue());
        q.setShort("status11", EnumConstNFeStatus.REJ_NFE_INUTILIZADA_SEFAZ.getValue().shortValue());
        Long count = (Long)q.uniqueResult();
        if (count != null && count > 0L) {
            return false;
        }
        return true;
    }
}

