/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao004;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.AgrupamentoValorIpi;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIcms;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIpi;
import com.touchcomp.basementor.model.vo.ApuracaoICMS;
import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CiapBem;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CtrcCargaTransportada;
import com.touchcomp.basementor.model.vo.CtrcColetaEntrega;
import com.touchcomp.basementor.model.vo.CtrcComplConhecimento;
import com.touchcomp.basementor.model.vo.CtrcDocumentosFiscais;
import com.touchcomp.basementor.model.vo.DepreciacaoCiap;
import com.touchcomp.basementor.model.vo.DocFiscalBem;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.InventarioSped;
import com.touchcomp.basementor.model.vo.ItemAPIcmsDoc;
import com.touchcomp.basementor.model.vo.ItemAPIcmsProc;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemObrigIcmsRecolher;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LogPessoa;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.TokenObsLivroFiscal;
import com.touchcomp.basementor.model.vo.ValoresDecAPIcms;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.spedfiscal.SpedFiscalConstants;
import mentorcore.service.impl.spedfiscal.exceptions.SpedStructureException;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.service.impl.spedfiscal.versao004.SpedBDConsult004;
import mentorcore.service.impl.spedfiscal.versao004.SpedFormat004;
import mentorcore.service.impl.spedfiscal.versao004.model.ContadorRegistros;
import mentorcore.service.impl.spedfiscal.versao004.model.Reg0015;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg205;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg220;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg400;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg450;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg460;
import mentorcore.service.impl.spedfiscal.versao004.model2.Reg500;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC110;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC111;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC112;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC113;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC114;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC140;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC141;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC170;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC197;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC300;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC310;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC320;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC321;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC400;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC405;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC410;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC420;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC425;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC460;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC470;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC490;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC500;
import mentorcore.service.impl.spedfiscal.versao004.model2.blococ.RegC590;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.BlocoD;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD100;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD130;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD160;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD161;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD162;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD190;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD500;
import mentorcore.service.impl.spedfiscal.versao004.model2.blocod.RegD590;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.planoconta.UtilityPlanoConta;

public class SpedWritter004 {
    private SpedFormat004 form = new SpedFormat004();
    private SpedBDConsult004 cons = new SpedBDConsult004();
    private String versao = "004";
    private String endOfRegister = "\r\n";
    private char separator = (char)124;
    private final TLogger logger = TLogger.get(this.getClass());
    private HashSet participantes = new HashSet();
    private HashSet itensServicos = new HashSet();
    private HashSet naturezas = new HashSet();
    private HashSet observacoesLancFiscal = new HashSet();
    private HashSet bens = new HashSet();
    private HashSet centroCusto = new HashSet();
    private String VALOR_TOTAL = "valorTotal";
    private String VALOR_DESCONTO = "desconto";
    private String valor_ = "vlrAbatTrib";
    private String VALOR_PROD_SERV = "prodServ";
    private String VALOR_FRETE = "frete";
    private String VALOR_SEGURO = "seguro";
    private String VALOR_DESP_ACESS = "despAcess";
    private String VALOR_BC_ICMS = "bcIcms";
    private String VALOR_ICMS = "icms";
    private String VALOR_BC_ICMSST = "bcIcmsST";
    private String VALOR_ICMSST = "icmsST";
    private String VALOR_IPI = "ipi";
    private String VALOR_PIS = "pis";
    private String VALOR_COFINS = "cofins";
    private String VALOR_PISST = "pisSt";
    private String VALOR_COFINSST = "cofinsST";
    private Object VALOR_INSS = "inss";
    private Object VALOR_ISS = "iss";
    private Object VALOR_IRRF = "irrf";
    private Object VALOR_BC_GERAL = "bcGeral";
    private Object VALOR_BC_IRRF = "bcIrrf";
    private Object VALOR_BC_ISS = "bcIss";
    private Object VALOR_BC_INSS = "bcInss";
    private ContadorRegistros cont = new ContadorRegistros();
    private String VERSAO_003 = "003";
    private String VERSAO_004 = "004";
    private char PERFIL_A = (char)65;
    private char PERFIL_B = (char)66;
    private HashMap hashPessoas = new HashMap();
    private List pessoas = new ArrayList();
    private HashMap hashObservacoes = new HashMap();
    private List observacoes = new ArrayList();
    private HashMap hashPlanoContas = new HashMap();
    private List planoContas = new ArrayList();
    private HashMap hashProdutos = new HashMap();
    private List produtos = new ArrayList();
    private HashMap hashNatOperacao = new HashMap();
    private List natOperacao = new ArrayList();
    private HashMap hashUnidMedidas = new HashMap();
    private List unidMedidas = new ArrayList();

    public File spedWritter(SpedFiscal vo, File f) throws SpedWritterException, ExceptionDatabase, ExceptionService, SpedStructureException {
        try {
            Date dataIn = vo.getDataInicial();
            Date dataFim = vo.getDataFinal();
            EmpresaContabilidade empContabil = this.cons.getEmpresaContabilidade(vo.getEmpresa());
            short listarInventario = vo.getTipoInventario();
            Integer finalidade = vo.getTipoArquivo().intValue();
            Empresa emp = vo.getEmpresa();
            Integer indicadorAtividade = 1;
            if (listarInventario == 1 && empContabil == null) {
                throw new SpedWritterException("Primeiro cadastre Empresa Cont\u00e1bil");
            }
            if (listarInventario == 1 && empContabil.getPlanoContaEstProprio() == null) {
                throw new SpedWritterException("Primeiro cadastre uma Conta Cont\u00e1bil de Estoque Pr\u00f3prio em Empresa Contabilidade!");
            }
            String perfil = vo.getEmpresa().getEmpresaDados().getPerfilSpedFiscal().getCodigo();
            File blocoG = this.createWritterBlockG(dataIn, dataFim, emp);
            File blocoC = this.createWritterBlockC(dataIn, dataFim, emp, perfil.charAt(0));
            File blocoH = this.createWritterBlockH(vo);
            File blocoE = this.createWritterBlockE(dataIn, dataFim, emp);
            File blocoD = this.createWritterBlockD(dataIn, dataFim, emp, perfil.charAt(0));
            File bloco1 = this.createWritterBlock1(dataIn, dataFim, emp);
            File bloco0 = this.createWritterBlock0(dataIn, dataFim, emp, perfil, finalidade, indicadorAtividade);
            File bloco9 = this.createWritterBlock9();
            return this.apendToSomeFile(f, dataIn, dataFim, bloco0, blocoC, blocoD, blocoE, blocoG, blocoH, bloco1, bloco9);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new SpedWritterException("Diret\u00f3rio n\u00e3o encontrado");
        }
    }

    private void writterReg0000(PrintWriter p, Date dataIn, Date dataFim, Integer finalidade, Empresa emp, String perfil, Integer indicadorAtividade) {
        p.append(this.separator + "0000");
        p.append(this.separator + this.versao);
        p.append(this.separator + String.valueOf(finalidade));
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
        String cnpjCpf = emp.getPessoa().getComplemento().getCnpj();
        cnpjCpf = this.form.clearString(cnpjCpf);
        if (cnpjCpf.trim().length() == 14) {
            p.append(this.separator + cnpjCpf);
            p.append(this.separator);
        } else {
            p.append(this.separator);
            p.append(this.separator + cnpjCpf);
        }
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscEst(), 14));
        p.append(this.separator + emp.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + emp.getPessoa().getEndereco().getCidade().getCodIbge());
        p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getInscricaoMunicipal()));
        p.append(this.separator + this.form.formatStringClear(emp.getPessoa().getComplemento().getSuframa(), 9));
        p.append(this.separator + String.valueOf(perfil));
        p.append(this.separator + String.valueOf(indicadorAtividade));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0000");
    }

    private void writterReg0001(PrintWriter p, int blocoDadosInformados) {
        p.append(this.separator + "0001");
        p.append(this.separator + String.valueOf(0));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0001");
    }

    private void writterReg0005(PrintWriter p, Empresa emp) {
        Endereco end = emp.getPessoa().getEndereco();
        p.append(this.separator + "0005");
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNomeFantasia(), 60));
        p.append(this.separator + this.form.formatStringClear(end.getCep(), 8));
        p.append(this.separator + this.form.formatString(end.getLogradouro(), 60));
        p.append(this.separator + this.form.formatString(end.getNumero(), 10));
        p.append(this.separator + this.form.formatString(end.getComplemento(), 60));
        p.append(this.separator + this.form.formatString(end.getBairro(), 60));
        if (emp.getPessoa().getComplemento().getFone1() != null && emp.getPessoa().getComplemento().getFone1().trim().length() > 0) {
            p.append(this.separator + this.form.formatClearStringComp0(emp.getPessoa().getComplemento().getFone1(), 10));
        } else {
            p.append(this.separator);
        }
        if (emp.getPessoa().getComplemento().getFax1() != null && emp.getPessoa().getComplemento().getFax1().trim().length() > 0) {
            p.append(this.separator + this.form.formatClearStringComp0(emp.getPessoa().getComplemento().getFax1(), 10));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatString(this.getEmailAtivo(emp.getPessoa().getComplemento().getEmails())));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0005");
    }

    private String getEmailAtivo(List<EmailPessoa> emails) {
        String firstEmail = "";
        String activeEmail = "";
        boolean count = false;
        for (EmailPessoa e : emails) {
            if (!count) {
                firstEmail = e.getEmail();
            }
            if (e.getAtivo() == null || e.getAtivo() != 1) continue;
            activeEmail = e.getEmail();
            break;
        }
        if (activeEmail == null) {
            return firstEmail;
        }
        return activeEmail;
    }

    private void writterReg0015(PrintWriter p, Empresa emp) {
        List l = this.cons.getAliquotasSTIncrito(emp);
        for (Object o : l) {
            Reg0015 r = (Reg0015)o;
            p.append(this.separator + "0015");
            p.append(this.separator + r.getSiglaUf());
            p.append(this.separator + this.form.formatString(r.getInscricaoUf(), 14));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0015");
        }
    }

    private void writterReg0100(PrintWriter p, Empresa emp) throws SpedWritterException, ExceptionService {
        EmpresaContabilidade contabilidade = this.cons.getEmpresaContabilidade(emp);
        Pessoa contador = contabilidade.getPessoa();
        if (contador == null) {
            throw new SpedWritterException("Informe o Contador respons\u00e1vel pela empresa.");
        }
        p.append(this.separator + "0100");
        p.append(this.separator + this.form.formatString(contador.getNome(), 100));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getCnpj(), 11));
        p.append(this.separator + this.form.formatStringClear(contabilidade.getCrc(), 15));
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCep(), 8));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getLogradouro(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getNumero(), 10));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getComplemento(), 60));
        p.append(this.separator + this.form.formatString(contador.getEndereco().getBairro(), 60));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFone1(), 10));
        p.append(this.separator + this.form.formatStringClear(contador.getComplemento().getFax1(), 10));
        p.append(this.separator + this.form.formatString(this.getEmailAtivo(contador.getComplemento().getEmails())));
        p.append(this.separator + this.form.formatStringClear(contador.getEndereco().getCidade().getUf().getCodIbge() + contador.getEndereco().getCidade().getCodIbge(), 7));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0100");
    }

    private void writterReg0150(PrintWriter p, Date dataIn, Date dataFim) {
        for (Object o : this.pessoas) {
            Long idPessoa = (Long)o;
            Reg150 r = (Reg150)this.hashPessoas.get(idPessoa);
            p.append(this.separator + "0150");
            p.append(this.separator + this.form.formatString(r.getIdPessoa().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getNomePessoa(), 100));
            p.append(this.separator + this.form.formatStringClear(r.getCodPais(), 5));
            String cnpjCpf = r.getCnpj();
            cnpjCpf = this.form.clearString(cnpjCpf);
            if (cnpjCpf.trim().length() > 11) {
                p.append(this.separator + cnpjCpf);
                p.append(this.separator);
            } else {
                p.append(this.separator);
                p.append(this.separator + cnpjCpf);
            }
            if (r.getInscricaoEstadual() != null && r.getInscricaoEstadual().trim().length() > 0 && !r.getInscricaoEstadual().trim().equalsIgnoreCase("isento")) {
                p.append(this.separator + this.form.formatStringClear(r.getInscricaoEstadual(), 14));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatStringClear(r.getCodUf() + r.getCodigoMunicipio(), 7));
            if (r.getSuframa() != null && r.getSuframa().trim().length() > 0) {
                p.append(this.separator + this.form.formatStringClear(r.getSuframa(), 9));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatString(r.getEndereco(), 60));
            p.append(this.separator + this.form.formatString(r.getNumero(), 10));
            p.append(this.separator + this.form.formatString(r.getComplemento(), 60));
            p.append(this.separator + this.form.formatString(r.getBairro(), 60));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0150");
            this.writterReg0175(p, r.getIdPessoa(), dataIn, dataFim);
        }
    }

    private void writterReg0175(PrintWriter p, Long idPessoa, Date dataIn, Date dataFim) {
        List mod = this.cons.getAlteracoesParticipante(idPessoa, dataIn, dataFim);
        for (Object o : mod) {
            LogPessoa l = (LogPessoa)o;
            if (l.getConteudoAnterior() == null || l.getConteudoAnterior().trim().length() <= 0) continue;
            p.append(this.separator + "0175");
            p.append(this.separator + this.form.formatDate(l.getDataAlteracao()));
            p.append(this.separator + this.form.formatClearStringComp0Esquerda(l.getCodCampo().toString(), 2));
            p.append(this.separator + this.form.formatString(l.getConteudoAnterior(), 100));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0175");
        }
    }

    private void writterReg0190(PrintWriter p) {
        for (Object o : this.unidMedidas) {
            Long idUnidMedida = (Long)o;
            Reg190 r = (Reg190)this.hashUnidMedidas.get(idUnidMedida);
            p.append(this.separator + "0190");
            p.append(this.separator + this.form.formatStringClear(r.getCodUnidMedida(), 6));
            p.append(this.separator + this.form.formatString(r.getDescUnidMedida()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0190");
        }
    }

    private void writterReg0200(PrintWriter p, Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        for (Object o : this.produtos) {
            Long idProduto = (Long)o;
            Reg200 pr = (Reg200)this.hashProdutos.get(idProduto);
            p.append(this.separator + "0200");
            p.append(this.separator + this.form.formatStringClear(idProduto.toString()));
            p.append(this.separator + this.form.formatString(pr.getDescricao()));
            p.append("" + this.separator);
            p.append("" + this.separator);
            p.append(this.separator + this.form.formatString(pr.getUnidadeMedida(), 6));
            if (pr.getTipoItem() != null) {
                p.append(this.separator + pr.getTipoItem());
            } else {
                p.append(this.separator);
            }
            if (pr.getCodNcm() != null) {
                p.append(this.separator + pr.getCodNcm());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            if (pr.getCodGenero() != null && !pr.getCodGenero().equalsIgnoreCase("0")) {
                p.append(this.separator + pr.getCodGenero());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(pr.getAliquotaIcms(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0200");
            this.writterReg0205(p, pr.getIdProduto(), dataIn, dataFim);
            this.writterReg0220(p, pr.getUnidadeMedida(), pr.getIdProduto(), dataIn, dataFim, emp);
        }
    }

    private File createWritterBlockC(Date dataIn, Date dataFim, Empresa emp, char perfil) throws IOException, ExceptionDatabase, ExceptionService {
        File f = File.createTempFile("sped_bloco_c", ".txt");
        PrintWriter p = new PrintWriter(f);
        BlocoC notasProprias = this.cons.getBlocoC100NotasProprias(dataIn, dataFim, emp);
        BlocoC notasTerceiros = this.cons.getBlocoC100NotasTerceiros(dataIn, dataFim, emp);
        BlocoC notasSerieD = this.cons.getBlocoC300NotasProprias(dataIn, dataFim, emp);
        BlocoC notasTerceirosC500 = this.cons.getBlocoC500NotasTerceiros(dataIn, dataFim, emp);
        BlocoC cuponsFiscais = this.cons.getBlocoC400CuponsFiscais(emp, dataIn, dataFim, perfil);
        boolean comDados = notasProprias != null || notasTerceiros != null || notasSerieD != null || notasTerceirosC500 != null || cuponsFiscais != null && cuponsFiscais.getRegistrosC100() != null && !cuponsFiscais.getRegistrosC100().isEmpty();
        this.writerC001(p, comDados);
        if (comDados) {
            this.observacoesLancFiscal.addAll(this.getObsNotasC100(notasProprias.getRegistrosC100()));
            this.observacoesLancFiscal.addAll(this.getObsNotasC100(notasTerceiros.getRegistrosC100()));
            this.observacoesLancFiscal.addAll(this.getObsCuponsC400(cuponsFiscais.getRegistrosC400()));
            this.observacoesLancFiscal.addAll(this.getObsNotasC500(notasTerceirosC500.getRegistrosC500()));
            this.gerarBlocoC100(p, notasProprias, notasTerceiros, emp);
            this.gerarBlocoC300(p, notasSerieD, emp);
            this.gerarBlocoC400(p, emp, dataIn, dataFim, cuponsFiscais);
            this.gerarBlocoC500(p, notasTerceirosC500);
        }
        this.writterC990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterRegC300(PrintWriter p, RegC300 r) {
        p.append(this.separator + "C300");
        p.append(this.separator + r.getCodModeloDocFiscal());
        p.append(this.separator + this.form.formatStringClear(r.getSerie()));
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberInt(r.getNumDocInicial()));
        p.append(this.separator + this.form.formatNumberInt(r.getNumDocFinal()));
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatNumber(r.getValorTotal(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        p.append(this.separator);
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C300");
        if (r.getRegistrosC310() != null && !r.getRegistrosC310().isEmpty()) {
            this.writterRegC310(p, r.getRegistrosC310());
        }
        this.writterRegC320(p, r.getRegistrosC320());
        this.writterRegC321(p, r.getRegistrosC321());
    }

    private void writterRegC310(PrintWriter p, List<RegC310> registrosC310) {
        Iterator<RegC310> iterator = registrosC310.iterator();
        while (iterator.hasNext()) {
            RegC310 o;
            RegC310 r = o = iterator.next();
            p.append(this.separator + "C310");
            p.append(this.separator + this.form.formatNumberInt(r.getNumDocCanc()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C310");
        }
    }

    private void writterRegC320(PrintWriter p, List<RegC320> registrosC320) {
        Iterator<RegC320> iterator = registrosC320.iterator();
        while (iterator.hasNext()) {
            RegC320 o;
            RegC320 r = o = iterator.next();
            p.append(this.separator + "C320");
            p.append(this.separator + r.getCodIncidenciaIcms());
            p.append(this.separator + this.form.formatStringClear(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTributado(), 2));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C320");
        }
    }

    private void writterRegC321(PrintWriter p, List<RegC321> registrosC321) {
        Iterator<RegC321> iterator = registrosC321.iterator();
        while (iterator.hasNext()) {
            RegC321 o;
            RegC321 r = o = iterator.next();
            p.append(this.separator + "C321");
            p.append(this.separator + r.getCodProduto().toString());
            p.append(this.separator + this.form.formatNumber(r.getQuantidade(), 3));
            p.append(this.separator + r.getUnidMedida());
            p.append(this.separator + this.form.formatNumber(r.getValorItem(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C321");
        }
    }

    private void writterRegC500(PrintWriter p, RegC500 r) {
        p.append(this.separator + "C500");
        p.append(this.separator + "0");
        p.append(this.separator + "1");
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        if (r.getCodConsumoEnergia() != null) {
            p.append(this.separator + r.getCodConsumoEnergia());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumberInt(r.getNumeroDoc()));
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBCIcmsST(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorIcmsST(), 2));
        if (r.getObsFaturamento() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
            if (!this.hashObservacoes.containsKey(r.getObsFaturamento().getIdentificador())) {
                Reg450 reg450 = new Reg450();
                reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
                reg450.setDescricao(r.getObsFaturamento().getNome());
                this.hashObservacoes.put(reg450.getIdObservacao(), reg450);
                this.observacoes.add(reg450.getIdObservacao());
            }
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
        if (r.getTipoLigacao() != null) {
            p.append(this.separator + r.getTipoLigacao());
        } else {
            p.append(this.separator);
        }
        if (r.getGrupoTensao() != null) {
            p.append(this.separator + r.getGrupoTensao());
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C500");
        this.writterRegC590(p, r.getRegC590());
    }

    private void writterRegC590(PrintWriter p, List<RegC590> livrosFiscais) {
        Iterator<RegC590> iterator = livrosFiscais.iterator();
        while (iterator.hasNext()) {
            RegC590 o;
            RegC590 r = o = iterator.next();
            p.append(this.separator + "C590");
            p.append(this.separator + r.getIncidenciaIcms());
            p.append(this.separator + this.form.formatStringClear(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(0, 2));
            p.append(this.separator + this.form.formatNumber(0, 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTribIcms(), 2));
            if (r.getObservacoesLv() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getObservacoesLv()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C590");
        }
    }

    private void writerC001(PrintWriter p, boolean dadosInformados) {
        int dadosInf = dadosInformados ? 0 : 1;
        p.append(this.separator + "C001");
        p.append(this.separator + String.valueOf(dadosInf));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C001");
    }

    private String getTipoFrete(TipoFrete tp) {
        Short tpFrete = null;
        if (tp != null) {
            tpFrete = tp.getFretePorConta();
        }
        Short tpFreteNf = null;
        if (tpFrete == null) {
            tpFreteNf = 9;
        } else if (tpFrete == 0) {
            tpFreteNf = 0;
        } else if (tpFrete == 1) {
            tpFreteNf = 1;
        } else if (tpFrete == 2) {
            tpFreteNf = 2;
        }
        return String.valueOf(tpFreteNf);
    }

    private void writerC100NFProprias(PrintWriter p, NotaFiscalPropria n, HashMap tot, boolean docCancInut) {
        p.append(this.separator + "C100");
        int indOp = n.getNaturezaOperacao().getEntradaSaida() == 1 ? 1 : 0;
        p.append(this.separator + String.valueOf(indOp));
        p.append(this.separator + String.valueOf(0));
        if (!docCancInut) {
            Pessoa pes = n.getUnidadeFatCliente().getCliente().getPessoa();
            this.getParticipantes().add(pes);
            p.append(this.separator + this.form.formatNumberLong(pes.getIdentificador()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(n.getModeloDocFiscal().getCodigo(), 2));
        p.append(this.separator + this.form.formatStringClear(n.getSituacaoDocumento().getCodigo(), 2));
        p.append(this.separator + this.form.formatStringClear(n.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(n.getNumeroNota().toString(), 9));
        if (this.versao.equalsIgnoreCase(this.VERSAO_004) && n.getSituacaoDocumento().getCodigo().equalsIgnoreCase("02") && n.getSituacaoDocumento().getCodigo().equalsIgnoreCase("03")) {
            p.append(this.separator + this.form.formatStringClear(n.getChaveNFE(), 44));
        } else if (!docCancInut) {
            p.append(this.separator + this.form.formatStringClear(n.getChaveNFE(), 44));
        } else {
            p.append(this.separator);
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(n.getDataEmissaoNota()));
            p.append(this.separator + this.form.formatDate(n.getDataEntradaSaida()));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_TOTAL)));
            if (n.getCondicaoPagamento() == null) {
                p.append(this.separator + String.valueOf(9));
            } else if (n.getCondicaoPagamento().isAvista()) {
                p.append(this.separator + String.valueOf(0));
            } else {
                p.append(this.separator + String.valueOf(1));
            }
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_DESCONTO)));
            p.append(this.separator + this.form.formatNumber(0.0));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PROD_SERV)));
            p.append(this.separator + this.getTipoFrete(n.getDadosTransNfPropria().getTipoFrete()));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_FRETE)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_SEGURO)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_DESP_ACESS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_BC_ICMS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_ICMS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_BC_ICMSST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_ICMSST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_IPI)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PIS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_COFINS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PISST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_COFINSST)));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void writerC100NFTerceiros(PrintWriter p, NotaFiscalTerceiros n, HashMap tot, boolean docCancInut) {
        p.append(this.separator + "C100");
        int indOp = 0;
        p.append(this.separator + String.valueOf(indOp));
        p.append(this.separator + String.valueOf(1));
        if (!docCancInut) {
            Pessoa pes = n.getUnidadeFatFornecedor().getFornecedor().getPessoa();
            this.getParticipantes().add(pes);
            p.append(this.separator + this.form.formatNumberLong(pes.getIdentificador()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(n.getModeloDocFiscal().getCodigo(), 2));
        p.append(this.separator + this.form.formatStringClear(n.getSituacaoDocumento().getCodigo(), 2));
        p.append(this.separator + this.form.formatStringClear(n.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(n.getNumeroNota().toString(), 9));
        if (!this.versao.equalsIgnoreCase(this.VERSAO_004) && docCancInut) {
            p.append(this.separator);
        } else {
            p.append(this.separator + this.form.formatStringClear(n.getChaveNFE(), 44));
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(n.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(n.getDataEntrada()));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_TOTAL)));
            if (n.getCondicoesPagamento() == null) {
                p.append(this.separator + String.valueOf(9));
            } else if (n.getCondicoesPagamento().isAvista()) {
                p.append(this.separator + String.valueOf(0));
            } else {
                p.append(this.separator + String.valueOf(1));
            }
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_DESCONTO)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.valor_)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PROD_SERV)));
            p.append(this.separator + this.getTipoFrete(n.getTipoFrete()));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_FRETE)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_SEGURO)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_DESP_ACESS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_BC_ICMS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_ICMS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_BC_ICMSST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_ICMSST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_IPI)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PIS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_COFINS)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_PISST)));
            p.append(this.separator + this.form.formatNumber((Number)tot.get(this.VALOR_COFINSST)));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void writterC111(PrintWriter p, List<RegC111> regC111) {
        if (regC111 != null && !regC111.isEmpty()) {
            Iterator<RegC111> iterator = regC111.iterator();
            while (iterator.hasNext()) {
                RegC111 o;
                RegC111 r = o = iterator.next();
                p.append(this.separator + "C111");
                p.append(this.separator + this.form.formatString(r.getNumeroProcesso(), 15));
                p.append(this.separator + String.valueOf(r.getCodOrigem()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C111");
            }
        }
    }

    private void writterC112(PrintWriter p, List<RegC112> regC112) {
        if (regC112 != null && !regC112.isEmpty()) {
            Iterator<RegC112> iterator = regC112.iterator();
            while (iterator.hasNext()) {
                RegC112 o;
                RegC112 ob = o = iterator.next();
                p.append(this.separator + "C112");
                p.append(this.separator + String.valueOf(ob.getCodigoProc()));
                p.append(this.separator + ob.getUf());
                p.append(this.separator + this.form.formatString(ob.getNrDocArrecadacao()));
                p.append(this.separator + this.form.formatString(ob.getCodAutenticacao()));
                p.append(this.separator + this.form.formatNumber(ob.getValorDoc(), 2));
                p.append(this.separator + this.form.formatDate(ob.getDataVencimento()));
                p.append(this.separator + this.form.formatDate(ob.getDataPagamento()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C112");
            }
        }
    }

    private void writterC114(PrintWriter p, List<RegC114> regC114) {
        if (regC114 != null && !regC114.isEmpty()) {
            Iterator<RegC114> iterator = regC114.iterator();
            while (iterator.hasNext()) {
                RegC114 o;
                RegC114 ob = o = iterator.next();
                p.append(this.separator + "C114");
                p.append(this.separator + ob.getCodModeloDocFiscal());
                p.append(this.separator + ob.getNrSerieFabECF());
                p.append(this.separator + this.form.formatNumber(ob.getNrCaixa(), 3));
                p.append(this.separator + this.form.formatNumber(ob.getNrDocumento(), 6));
                p.append(this.separator + this.form.formatDate(ob.getDataEmissao()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C114");
            }
        }
    }

    private void writterC113(PrintWriter p, List<RegC113> regC113) {
        if (regC113 != null && !regC113.isEmpty()) {
            Iterator<RegC113> iterator = regC113.iterator();
            while (iterator.hasNext()) {
                RegC113 o;
                RegC113 ob = o = iterator.next();
                p.append(this.separator + "C113");
                p.append(this.separator + "0");
                p.append(this.separator + "1");
                p.append(this.separator + this.form.formatString(ob.getSerie(), 4));
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(ob.getNumDocumento()));
                p.append(this.separator + this.form.formatDate(ob.getDataEmissao()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C113");
            }
        }
    }

    private void writterC140(PrintWriter p, RegC140 regC140) {
        Double valorTotalTit;
        if (regC140 != null && (valorTotalTit = regC140.getValorTitulos()) > 0.0) {
            p.append(this.separator + "C140");
            p.append(this.separator + "1");
            p.append(this.separator + "00");
            p.append(this.separator);
            p.append(this.separator + this.form.formatString(regC140.getNumeroTitulo().toString()));
            p.append(this.separator + String.valueOf(regC140.getNumeroParcelas()));
            p.append(this.separator + this.form.formatNumber(valorTotalTit, 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C140");
            this.writterC141(p, regC140.getRegC141());
        }
    }

    private void writterC141(PrintWriter p, List<RegC141> regC141) {
        Iterator<RegC141> iterator = regC141.iterator();
        while (iterator.hasNext()) {
            RegC141 o;
            RegC141 t = o = iterator.next();
            p.append(this.separator + "C141");
            p.append(this.separator + this.form.formatNumberInt(t.getNumParcela().intValue()));
            p.append(this.separator + this.form.formatDate(t.getDataVencimento()));
            p.append(this.separator + this.form.formatNumber(t.getValorTitulo(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C141");
        }
    }

    private void writterC170(PrintWriter p, List<RegC170> regC170, Empresa empresa) {
        if (regC170 != null && !regC170.isEmpty()) {
            Iterator<RegC170> iterator = regC170.iterator();
            while (iterator.hasNext()) {
                RegC170 o;
                RegC170 in = o = iterator.next();
                p.append(this.separator + "C170");
                if (in.getNumeroItem() != null) {
                    p.append(this.separator + this.form.formatNumberInt((int)in.getNumeroItem()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.form.formatString(in.getCodigoItem().toString(), 60));
                p.append(this.separator + this.form.formatString(in.getDescricaoComp()));
                p.append(this.separator + this.form.formatNumber(in.getQuantidade(), 5));
                p.append(this.separator + this.form.formatString(in.getUnidadeMedida(), 6));
                p.append(this.separator + this.form.formatNumber(in.getValorItem(), 2));
                p.append(this.separator + this.form.formatNumber(in.getValorDesconto(), 2));
                p.append(this.separator + String.valueOf(in.getMovimentacaoFisica()));
                p.append(this.separator + in.getCstIcms());
                p.append(this.separator + this.form.formatStringClear(in.getCfop()));
                p.append(this.separator + this.form.formatStringClear(in.getCodNatOperacao().toString()));
                p.append(this.separator + this.form.formatNumber(in.getValorBCIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIcms(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrBCIcmsST(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliquotaST(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIcmsSt(), 2));
                if (empresa.getEmpresaDados().getIndicadorApuracaoIpi() != null && empresa.getEmpresaDados().getIndicadorApuracaoIpi() >= 0 && empresa.getEmpresaDados().getIndicadorApuracaoIpi() <= 1) {
                    p.append(this.separator + String.valueOf(empresa.getEmpresaDados().getIndicadorApuracaoIpi()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + in.getCstIpi());
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrBCIpi(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqIpi(), 2));
                p.append(this.separator + this.form.formatNumber(in.getVlrIpi(), 2));
                p.append(this.separator + in.getCstPis());
                p.append(this.separator + this.form.formatNumber(in.getVlrBCPis(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqPis(), 2));
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrPis(), 2));
                p.append(this.separator + in.getCstCofins());
                p.append(this.separator + this.form.formatNumber(in.getBcCofins(), 2));
                p.append(this.separator + this.form.formatNumber(in.getAliqCofins(), 2));
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumber(in.getVlrCofins(), 2));
                if (in.getEntSaiNatOperacao() == 1) {
                    if (in.getPlanoCred() != null && in.getPlanoCred() > 0L) {
                        p.append(this.separator + this.form.formatStringClear(in.getPlanoCred().toString()));
                    } else {
                        p.append(this.separator);
                    }
                } else if (in.getPlanoDeb() != null && in.getPlanoDeb() > 0L) {
                    p.append(this.separator + this.form.formatStringClear(in.getPlanoDeb().toString()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C170");
            }
        }
    }

    private void writterReg0205(PrintWriter p, Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        List log = this.cons.getAlteracoesProduto(idProduto, dataIn, dataFim);
        for (Object o : log) {
            Reg205 l = (Reg205)o;
            if (l.getDataFinal() == null) {
                l.setDataFinal(dataFim);
            }
            p.append(this.separator + "0205");
            p.append(this.separator + this.form.formatString(l.getDescricaoAnterior()));
            p.append(this.separator + this.form.formatDate(l.getDataInicial()));
            p.append(this.separator + this.form.formatDate(l.getDataFinal()));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0205");
        }
    }

    private void writterReg0220(PrintWriter p, String unidadeMedida, Long idProduto, Date dataIn, Date dataFim, Empresa emp) {
        List fatores = this.cons.getFatoresConversao(unidadeMedida, idProduto, dataIn, dataFim, emp);
        for (Object o : fatores) {
            Reg220 r = (Reg220)o;
            p.append(this.separator + "0220");
            p.append(this.separator + this.form.formatString(r.getUnidadeMedida()));
            p.append(this.separator + this.form.formatNumber(r.getFatorConversao(), 6));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0220");
        }
    }

    private void writterReg0300(PrintWriter p) {
        for (Object o : this.getBens()) {
            Bem u = (Bem)o;
            p.append(this.separator + "0300");
            p.append(this.separator + this.form.formatStringClear(u.getIdentificador().toString()));
            if (u.getBemPrincipal() != null) {
                p.append(this.separator + String.valueOf(2));
            } else {
                p.append(this.separator + String.valueOf(1));
            }
            p.append(this.separator + this.form.formatString(u.getDescricao()));
            if (u.getBemPrincipal() != null) {
                p.append(this.separator + this.form.formatStringClear(u.getBemPrincipal().getIdentificador().toString()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatStringClear(u.getTipoBem().getPlanoContaBem().getCodigo()));
            if (!this.hashPlanoContas.containsKey(u.getTipoBem().getPlanoContaBem().getIdentificador())) {
                Reg500 r = this.createReg500(u.getTipoBem().getPlanoContaBem());
                this.hashPlanoContas.put(r.getIdPlanoContas(), r);
                this.planoContas.add(r.getIdPlanoContas());
            }
            p.append(this.separator + this.form.formatString(u.getNrParcelasIcms().toString()));
            p.append(this.separator + this.endOfRegister);
            this.writterReg0305(p, u);
            this.cont.soma1("0300");
        }
    }

    private File createWritterBlock0(Date dataIn, Date dataFim, Empresa emp, String perfil, Integer finalidade, Integer indicadorAtividade) throws IOException, ExceptionDatabase, SpedWritterException, ExceptionService {
        File f = File.createTempFile("sped_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterReg0000(p, dataIn, dataFim, finalidade, emp, perfil, indicadorAtividade);
        this.writterReg0001(p, 1);
        this.writterReg0005(p, emp);
        this.writterReg0015(p, emp);
        this.writterReg0100(p, emp);
        this.writterReg0150(p, dataIn, dataFim);
        this.writterReg0190(p);
        this.writterReg0200(p, dataIn, dataFim, emp);
        this.writterReg0300(p);
        this.writterReg0400(p);
        this.writterReg0450(p);
        this.writterReg0460(p);
        this.writterReg0500(p);
        this.writterReg0600(p);
        this.writterReg0990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg0305(PrintWriter p, Bem u) {
        CentroCusto cc = u.getCentroCusto();
        this.getCentroCusto().add(cc);
        p.append(this.separator + "0305");
        p.append(this.separator + this.form.formatStringClear(cc.getCodigo(), 60));
        p.append(this.separator + this.form.formatString(u.getDescricaoFuncional()));
        p.append(this.separator + this.form.formatString(u.getNrMesesVidaUtil().toString()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("0305");
    }

    private void writterReg0400(PrintWriter p) {
        for (Object o : this.natOperacao) {
            Long idNatureza = (Long)o;
            Reg400 r = (Reg400)this.hashNatOperacao.get(idNatureza);
            p.append(this.separator + "0400");
            p.append(this.separator + this.form.formatStringClear(r.getIdNatOperacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricaoNatOperacao()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0400");
        }
    }

    private void writterReg0450(PrintWriter p) {
        for (Object o : this.observacoes) {
            Long idObservacao = (Long)o;
            Reg450 r = (Reg450)this.hashObservacoes.get(idObservacao);
            p.append(this.separator + "0450");
            p.append(this.separator + this.form.formatStringClear(r.getIdObservacao().toString(), 60));
            p.append(this.separator + this.form.formatString(r.getDescricao()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0450");
        }
    }

    private void writterReg0460(PrintWriter p) {
        for (Object o : this.observacoesLancFiscal) {
            Long idObservacao = (Long)o;
            Reg460 r = this.cons.getObsLancFiscal(idObservacao);
            if (r == null) continue;
            p.append(this.separator + "0460");
            p.append(this.separator + this.form.formatNumberLong(r.getIdObservacao()));
            p.append(this.separator + this.form.formatString(r.getDescricao()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0460");
        }
    }

    private void writterReg0500(PrintWriter p) {
        for (Object o : this.planoContas) {
            Long idPlanoConta = (Long)o;
            Reg500 pc = (Reg500)this.hashPlanoContas.get(idPlanoConta);
            p.append(this.separator + "0500");
            p.append(this.separator + this.form.formatDate(pc.getDataInclusao()));
            p.append(this.separator + pc.getCodNatBc());
            if (pc.getMarca().intValue() == EnumConstSinteticoAnalitico.SINTETICO.getValueInt()) {
                p.append(this.separator + "S");
            } else {
                p.append(this.separator + "A");
            }
            CoreUtilityFactory.getUtilityPlanoConta();
            p.append(this.separator + UtilityPlanoConta.getNivelPlanoConta(pc.getCodigo()).toString());
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getDescricao(), 60));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0500");
        }
    }

    private void writterReg0600(PrintWriter p) {
        for (Object o : this.getCentroCusto()) {
            CentroCusto pc = (CentroCusto)o;
            p.append(this.separator + "0600");
            p.append(this.separator + this.form.formatDate(pc.getDataCadastro()));
            p.append(this.separator + this.form.formatStringClear(pc.getCodigo()));
            p.append(this.separator + this.form.formatString(pc.getNome()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("0600");
        }
    }

    private void writterReg0990(PrintWriter p) {
        this.cont.soma1("0990");
        p.append(this.separator + "0990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('0')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlock9() throws FileNotFoundException, IOException {
        File f = File.createTempFile("sped_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterReg9001(p);
        this.writterReg9900(p);
        this.writterReg9990(p);
        this.writterReg9999(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg9001(PrintWriter p) {
        p.append(this.separator + "9001");
        p.append(this.separator + String.valueOf(0));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("9001");
    }

    private void writterReg9900(PrintWriter p) {
        Set keys = this.cont.getContador().keySet();
        int contador = 0;
        for (Object o : keys) {
            String tk = (String)o;
            Long value = (Long)this.cont.getContador().get(tk);
            this.writterReg9900Aux(p, tk, value);
            ++contador;
        }
        this.cont.somaVarios("9900", contador);
        this.cont.soma1("9900");
        this.cont.soma1("9900");
        this.cont.soma1("9900");
        this.cont.soma1("9990");
        this.cont.soma1("9999");
        this.writterReg9900Aux(p, "9900", this.cont.getNrLinhas("9900"));
        this.writterReg9900Aux(p, "9990", this.cont.getNrLinhas("9990"));
        this.writterReg9900Aux(p, "9999", this.cont.getNrLinhas("9999"));
    }

    private void writterReg9999(PrintWriter p) {
        p.append(this.separator + "9999");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhasTotal()));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterReg9900Aux(PrintWriter p, String tk, Long value) {
        p.append(this.separator + "9900");
        p.append(this.separator + tk);
        p.append(this.separator + String.valueOf(this.form.formatNumberInt(value.intValue())));
        p.append(this.separator + this.endOfRegister);
    }

    private File apendToSomeFile(File file, Date dataIn, Date dataFim, File bloco0, File blocoC, File blocoD, File blocoE, File blocoG, File blocoH, File bloco1, File bloco9) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(bloco0, out);
        this.copy(blocoC, out);
        this.copy(blocoD, out);
        this.copy(blocoE, out);
        this.copy(blocoG, out);
        this.copy(blocoH, out);
        this.copy(bloco1, out);
        this.copy(bloco9, out);
        bloco0.delete();
        blocoC.delete();
        bloco9.delete();
        ((OutputStream)out).close();
        return file;
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private File createWritterBlockG(Date dataIn, Date dataFim, Empresa emp) throws IOException {
        File f = File.createTempFile("sped_bloco_g", ".txt");
        PrintWriter p = new PrintWriter(f);
        List movCiap = this.cons.getMovimentoCiap(dataIn, dataFim, emp);
        boolean comDados = movCiap != null && !movCiap.isEmpty();
        this.writterRegG001(p, comDados);
        for (Object o : movCiap) {
            DepreciacaoCiap v = (DepreciacaoCiap)o;
            this.writterRegG110(p, v);
            this.writterRegG125(p, v);
        }
        this.writterRegG990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterRegG001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "G001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("G001");
    }

    private void writterRegG110(PrintWriter p, DepreciacaoCiap v) {
        double saldoInIcms = 0.0;
        double valorPassivelApropriacao = 0.0;
        for (ItemCiapDepreciacaoBaixaBem i : v.getItemCiapDepreciacaoBaixaBem()) {
            for (Object o : i.getCiapBem()) {
                CiapBem c = (CiapBem)o;
                String codigo = c.getTpMovimentacaoDeprBem().getCodigo();
                if (codigo.equalsIgnoreCase("SI")) {
                    saldoInIcms += c.getBem().getValorIcms() + c.getBem().getValorIcmsSt() + c.getBem().getValorIcmsFrete() + c.getBem().getValorIcmsDifAliquota();
                }
                valorPassivelApropriacao += c.getVrIcmsNaoApropriado() + c.getVrIcms() + c.getVrIcmsDifAliqNaoApropriado() + c.getVrIcmsDifAliq() + c.getVrIcmsFreteNaoApropriado() + c.getVrIcmsFrete() + c.getVrIcmsStNaoApropriado() + c.getVrIcmsSt();
            }
        }
        double indice = v.getValorTribExportacao() / v.getTotalSaidas();
        p.append(this.separator + "G110");
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(v.getPeriodo());
        g.set(5, 1);
        p.append(this.separator + this.form.formatDate(g.getTime()));
        p.append(this.separator + this.form.formatDate(v.getPeriodo()));
        p.append(this.separator + this.form.formatNumber(saldoInIcms));
        p.append(this.separator + this.form.formatNumber(valorPassivelApropriacao));
        p.append(this.separator + this.form.formatNumber(v.getValorTribExportacao()));
        p.append(this.separator + this.form.formatNumber(v.getTotalSaidas()));
        p.append(this.separator + this.form.formatNumber(indice, 8));
        p.append(this.separator + this.form.formatNumber(valorPassivelApropriacao * indice));
        p.append(this.separator + this.form.formatNumber(0.0));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("G110");
    }

    private void writterRegG125(PrintWriter p, DepreciacaoCiap v) {
        for (ItemCiapDepreciacaoBaixaBem i : v.getItemCiapDepreciacaoBaixaBem()) {
            for (Object o : i.getCiapBem()) {
                boolean isEnd;
                CiapBem c = (CiapBem)o;
                p.append(this.separator + "G125");
                this.getBens().add(c.getBem());
                p.append(this.separator + c.getBem().getIdentificador().toString());
                GregorianCalendar g = new GregorianCalendar();
                g.setTime(c.getItemCiapDepreciacaoBaixaBem().getDepreciacaoCiap().getPeriodo());
                g.set(5, 1);
                p.append(this.separator + this.form.formatDate(g.getTime()));
                p.append(this.separator + c.getTpMovimentacaoDeprBem().getCodigo());
                boolean bl = isEnd = c.getTpMovimentacaoDeprBem().getCodigo().equalsIgnoreCase("AT") || c.getTpMovimentacaoDeprBem().getCodigo().equalsIgnoreCase("PE") || c.getTpMovimentacaoDeprBem().getCodigo().equalsIgnoreCase("BA") || c.getTpMovimentacaoDeprBem().getCodigo().equalsIgnoreCase("OT");
                if (!isEnd) {
                    p.append(this.separator + this.form.formatNumber(c.getBem().getValorIcms(), 2));
                    p.append(this.separator + this.form.formatNumber(c.getBem().getValorIcmsSt(), 2));
                    p.append(this.separator + this.form.formatNumber(c.getBem().getValorIcmsFrete(), 2));
                    p.append(this.separator + this.form.formatNumber(c.getBem().getValorIcmsDifAliquota(), 2));
                    p.append(this.separator + this.form.formatString(c.getNumeroParcela() != null ? c.getNumeroParcela().toString() : "", 3));
                    p.append(this.separator + this.form.formatNumber(c.getVrIcmsNaoApropriado() + c.getVrIcms() + c.getVrIcmsDifAliqNaoApropriado() + c.getVrIcmsDifAliq() + c.getVrIcmsFreteNaoApropriado() + c.getVrIcmsFrete() + c.getVrIcmsStNaoApropriado() + c.getVrIcmsSt(), 2));
                } else {
                    p.append(this.separator + this.form.formatNumber(0, 2));
                    p.append(this.separator + this.form.formatNumber(0, 2));
                    p.append(this.separator + this.form.formatNumber(0, 2));
                    p.append(this.separator + this.form.formatNumber(0, 2));
                    p.append(this.separator);
                    p.append(this.separator + this.form.formatNumber(0, 2));
                }
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("G125");
                this.writterRegG130(p, c);
            }
        }
    }

    private void writterRegG130(PrintWriter p, CiapBem c) {
        if (c.getBem().getDocFiscaisBem() != null) {
            for (Object o : c.getBem().getDocFiscaisBem()) {
                DocFiscalBem vo = (DocFiscalBem)o;
                String codigo = c.getTpMovimentacaoDeprBem().getCodigo();
                if (!codigo.equalsIgnoreCase("MC") && !codigo.equalsIgnoreCase("IM") && !codigo.equalsIgnoreCase("IA") && !codigo.equalsIgnoreCase("AT")) continue;
                p.append(this.separator + "G130");
                p.append(this.separator + vo.getIndicadorEmitente().toString());
                p.append(this.separator + this.form.formatNumberLong(vo.getPessoa().getIdentificador()));
                p.append(this.separator + this.form.formatStringClear(vo.getModeloDocFiscal().getCodigo()));
                p.append(this.separator + this.form.formatStringClear(vo.getSerie()));
                p.append(this.separator + this.form.formatNumberInt(vo.getNumeroNota()));
                p.append(this.separator + this.form.formatStringClear(vo.getChaveNFe()));
                p.append(this.separator + this.form.formatDate(vo.getDataEmissao()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("G130");
                if (!this.hashPessoas.containsKey(vo.getPessoa().getIdentificador())) {
                    Reg150 r = this.cons.createReg150dromPessoa(vo.getPessoa());
                    this.hashPessoas.put(r.getIdPessoa(), r);
                    this.pessoas.add(r.getIdPessoa());
                }
                this.writterRegG140(p, vo.getProdutos());
            }
        }
    }

    private void writterRegG140(PrintWriter p, List<Produto> prodDocFiscal) {
        if (prodDocFiscal != null) {
            int numItem = 1;
            Iterator<Produto> iterator = prodDocFiscal.iterator();
            while (iterator.hasNext()) {
                Produto o;
                Produto vo = o = iterator.next();
                p.append(this.separator + "G140");
                p.append(this.separator + this.form.formatNumberInt(numItem));
                ++numItem;
                p.append(this.separator + this.form.formatNumberLong(vo.getIdentificador()));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("G140");
                if (this.hashProdutos.containsKey(vo.getIdentificador())) continue;
                Reg200 r = this.cons.createReg200FromProduto(vo);
                this.hashProdutos.put(vo.getIdentificador(), r);
                this.produtos.add(vo.getIdentificador());
            }
        }
    }

    private File createWritterBlockH(SpedFiscal vo) throws IOException, ExceptionService, SpedWritterException {
        File f = File.createTempFile("sped_bloco_h", ".txt");
        PrintWriter p = new PrintWriter(f);
        if (vo.getTipoInventario() == SpedFiscalConstants.INVENTARIO_NAO_GERAR) {
            this.writterRegH001(p, false);
        } else if (vo.getTipoInventario() == SpedFiscalConstants.INVENTARIO_REAL) {
            Double valorTotalEstoque = this.getValorTotalEstoque(vo.getInventarioSped());
            boolean comDados = vo.getInventarioSped() != null && !vo.getInventarioSped().isEmpty();
            comDados = comDados && valorTotalEstoque > 0.0;
            this.writterRegH001(p, comDados);
            if (comDados) {
                this.writterRegH005(p, vo.getDataInventario(), valorTotalEstoque);
                for (Object o : vo.getInventarioSped()) {
                    InventarioSped v = (InventarioSped)o;
                    this.writterRegH010(p, v);
                }
            }
        } else {
            this.writterRegH001(p, true);
            this.writterRegH005(p, vo.getDataInventario(), 0.0);
        }
        this.writterRegH990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterRegH001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "H001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("H001");
    }

    private void writterRegH010(PrintWriter p, InventarioSped v) {
        p.append(this.separator + "H010");
        p.append(this.separator + this.form.formatNumberLong(v.getProduto().getIdentificador()));
        if (!this.hashProdutos.containsKey(v.getProduto().getIdentificador())) {
            this.hashProdutos.put(v.getProduto().getIdentificador(), this.cons.createReg200FromProduto(v.getProduto()));
            this.produtos.add(v.getProduto().getIdentificador());
        }
        p.append(this.separator + this.form.formatString(v.getProduto().getUnidadeMedida().getSigla(), 6));
        if (!this.hashUnidMedidas.containsKey(v.getProduto().getUnidadeMedida().getIdentificador())) {
            this.hashUnidMedidas.put(v.getProduto().getUnidadeMedida().getIdentificador(), this.cons.createReg190FromUnidMedida(v.getProduto().getUnidadeMedida()));
            this.unidMedidas.add(v.getProduto().getUnidadeMedida().getIdentificador());
        }
        p.append(this.separator + this.form.formatNumber(v.getQuantidade(), 2));
        p.append(this.separator + this.form.formatNumber(v.getVlrUnitario(), 2));
        p.append(this.separator + this.form.formatNumber(v.getVlrItem(), 2));
        p.append(this.separator + String.valueOf(v.getIndicadorPropriedade()));
        if (v.getPessoa() != null) {
            p.append(this.separator + this.form.formatNumberLong(v.getPessoa().getIdentificador()));
            if (!this.hashPessoas.containsKey(v.getPessoa().getIdentificador())) {
                this.hashPessoas.put(v.getPessoa().getIdentificador(), this.cons.createReg150dromPessoa(v.getPessoa()));
                this.pessoas.add(v.getPessoa().getIdentificador());
            }
        } else {
            p.append(this.separator);
        }
        p.append(this.separator);
        p.append(this.separator + this.form.formatStringClear(v.getPlanoConta().getCodigo()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("H010");
    }

    private Double getValorTotalEstoque(List saldoEstoque) {
        Double valorTot = 0.0;
        for (Object o : saldoEstoque) {
            InventarioSped r = (InventarioSped)o;
            valorTot = valorTot + r.getVlrItem();
        }
        return valorTot;
    }

    private void writterRegH005(PrintWriter p, Date dataInventario, Double valorTotalEstoque) {
        p.append(this.separator + "H005");
        p.append(this.separator + this.form.formatDate(dataInventario));
        p.append(this.separator + this.form.formatNumber(valorTotalEstoque, 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("H005");
    }

    private void writterRegH990(PrintWriter p) {
        this.cont.soma1("H990");
        p.append(this.separator + "H990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('H')));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterC173(PrintWriter p, ItemNotaFiscalPropria in, Empresa emp) {
        if (in.getProduto().getTipoMedicamento() != null) {
            for (Object o : in.getGradesNotaFiscalPropria()) {
                GradeItemNotaFiscalPropria g = (GradeItemNotaFiscalPropria)o;
                p.append(this.separator + "C173");
                p.append(this.separator + g.getLoteFabricacao().getLoteFabricacao());
                p.append(this.separator + this.form.formatNumber(g.getQuantidade(), 2));
                p.append(this.separator + this.form.formatDate(g.getLoteFabricacao().getDataFabricacao()));
                p.append(this.separator + this.form.formatDate(g.getLoteFabricacao().getDataValidade()));
                if (in.getModalidadeIcmsSt() != null) {
                    p.append(this.separator + String.valueOf(in.getModalidadeIcmsSt().getCodigo()));
                }
                p.append(this.separator + String.valueOf(in.getProduto().getTipoMedicamento().getCodigo()));
                p.append(this.separator + this.form.formatNumber(in.getProduto().getValorMaximoConsumo(), 2));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C173");
            }
        }
    }

    private void writterC100NotasProprias(PrintWriter p, RegC100 r, boolean docCancInut) {
        p.append(this.separator + "C100");
        if (r.getEntSaiNatOP() == 2) {
            p.append(this.separator + String.valueOf(0));
        } else {
            p.append(this.separator + String.valueOf(r.getEntSaiNatOP()));
        }
        p.append(this.separator + String.valueOf(0));
        if (!docCancInut) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(r.getCodModDocFiscal(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getCodSituacaoDoc(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroDoc())));
        if (this.versao.equalsIgnoreCase(this.VERSAO_004) && r.getCodSituacaoDoc().equalsIgnoreCase("02") && r.getCodSituacaoDoc().equalsIgnoreCase("03")) {
            p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
        } else if (!docCancInut) {
            p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
        } else {
            p.append(this.separator);
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            if (r.getDataEntSaida() != null) {
                p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndTipoPagamento()));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
            p.append(this.separator + this.form.formatNumber(0.0));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorSeguro()));
            p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms()));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIpi()));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorPisSt()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofinsSt()));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void gerarBlocoC100(PrintWriter p, BlocoC notasProprias, BlocoC notasTerceiros, Empresa emp) throws ExceptionService {
        boolean docCancInut;
        String sitDoc;
        Object r;
        if (notasProprias != null) {
            for (RegC100 regC100 : notasProprias.getRegistrosC100()) {
                r = regC100;
                try {
                    sitDoc = ((RegC100)r).getCodSituacaoDoc();
                    docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
                    this.writterC100NotasProprias(p, (RegC100)r, docCancInut);
                    if (docCancInut) continue;
                    this.writterC170(p, ((RegC100)r).getRegC170(), emp);
                    this.writterC190(p, ((RegC100)r).getRegC190());
                    this.writterC195(p, ((RegC100)r).getRegC190());
                }
                catch (Throwable ex) {
                    throw new ExceptionService("Existem problemas com a nota pr\u00f3pria nr:" + ((RegC100)r).getNumeroDoc());
                }
            }
            for (Object object : notasProprias.getParticipantes()) {
                r = (Reg150)object;
                if (this.hashPessoas.containsKey(((Reg150)r).getIdPessoa())) continue;
                this.hashPessoas.put(((Reg150)r).getIdPessoa(), r);
                this.pessoas.add(((Reg150)r).getIdPessoa());
            }
            for (Object object : notasProprias.getProdutos()) {
                r = (Reg200)object;
                if (this.hashProdutos.containsKey(((Reg200)r).getIdProduto())) continue;
                this.hashProdutos.put(((Reg200)r).getIdProduto(), r);
                this.produtos.add(((Reg200)r).getIdProduto());
            }
            for (Object object : notasProprias.getNaturezaOperacao()) {
                r = (Reg400)object;
                if (this.hashNatOperacao.containsKey(((Reg400)r).getIdNatOperacao())) continue;
                this.hashNatOperacao.put(((Reg400)r).getIdNatOperacao(), r);
                this.natOperacao.add(((Reg400)r).getIdNatOperacao());
            }
            for (Object object : notasProprias.getPlanoContas()) {
                r = (Reg500)object;
                if (this.hashPlanoContas.containsKey(((Reg500)r).getIdPlanoContas())) continue;
                this.hashPlanoContas.put(((Reg500)r).getIdPlanoContas(), r);
                this.planoContas.add(((Reg500)r).getIdPlanoContas());
            }
            for (Object object : notasProprias.getUnidMedidas()) {
                r = (Reg190)object;
                if (this.hashUnidMedidas.containsKey(((Reg190)r).getIdUnidMedida())) continue;
                this.hashUnidMedidas.put(((Reg190)r).getIdUnidMedida(), r);
                this.unidMedidas.add(((Reg190)r).getIdUnidMedida());
            }
        }
        if (notasTerceiros != null) {
            for (RegC100 regC100 : notasTerceiros.getRegistrosC100()) {
                r = regC100;
                try {
                    sitDoc = ((RegC100)r).getCodSituacaoDoc();
                    docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
                    this.writterC100NotasTerceiros(p, (RegC100)r, docCancInut);
                    if (docCancInut) continue;
                    this.writterC110(p, ((RegC100)r).getRegC110());
                    if (((RegC100)r).getRegC110() != null && ((RegC100)r).getRegC110().isEmpty()) {
                        this.writterC111(p, ((RegC100)r).getRegC111());
                        this.writterC112(p, ((RegC100)r).getRegC112());
                        this.writterC113(p, ((RegC100)r).getRegC113());
                        this.writterC114(p, ((RegC100)r).getRegC114());
                    }
                    this.writterC140(p, ((RegC100)r).getRegC140());
                    this.writterC170(p, ((RegC100)r).getRegC170(), emp);
                    this.writterC190(p, ((RegC100)r).getRegC190());
                    this.writterC195(p, ((RegC100)r).getRegC190());
                }
                catch (Throwable ex) {
                    this.logger.error(ex.getClass(), ex);
                    throw new ExceptionService("Existem problemas com a nota terceiros nr:" + ((RegC100)r).getNumeroDoc());
                }
            }
            for (Object object : notasTerceiros.getParticipantes()) {
                r = (Reg150)object;
                if (this.hashPessoas.containsKey(((Reg150)r).getIdPessoa())) continue;
                this.hashPessoas.put(((Reg150)r).getIdPessoa(), r);
                this.pessoas.add(((Reg150)r).getIdPessoa());
            }
            for (Object object : notasTerceiros.getObservacoes()) {
                r = (Reg450)object;
                if (this.hashObservacoes.containsKey(((Reg450)r).getIdObservacao())) continue;
                this.hashObservacoes.put(((Reg450)r).getIdObservacao(), r);
                this.observacoes.add(((Reg450)r).getIdObservacao());
            }
            for (Object object : notasTerceiros.getProdutos()) {
                r = (Reg200)object;
                if (this.hashProdutos.containsKey(((Reg200)r).getIdProduto())) continue;
                this.hashProdutos.put(((Reg200)r).getIdProduto(), r);
                this.produtos.add(((Reg200)r).getIdProduto());
            }
            for (Object object : notasTerceiros.getNaturezaOperacao()) {
                r = (Reg400)object;
                if (this.hashNatOperacao.containsKey(((Reg400)r).getIdNatOperacao())) continue;
                this.hashNatOperacao.put(((Reg400)r).getIdNatOperacao(), r);
                this.natOperacao.add(((Reg400)r).getIdNatOperacao());
            }
            for (Object object : notasTerceiros.getPlanoContas()) {
                r = (Reg500)object;
                if (this.hashPlanoContas.containsKey(((Reg500)r).getIdPlanoContas())) continue;
                this.hashPlanoContas.put(((Reg500)r).getIdPlanoContas(), r);
                this.planoContas.add(((Reg500)r).getIdPlanoContas());
            }
            for (Object object : notasTerceiros.getUnidMedidas()) {
                r = (Reg190)object;
                if (this.hashUnidMedidas.containsKey(((Reg190)r).getIdUnidMedida())) continue;
                this.hashUnidMedidas.put(((Reg190)r).getIdUnidMedida(), r);
                this.unidMedidas.add(((Reg190)r).getIdUnidMedida());
            }
        }
    }

    private void gerarBlocoC500(PrintWriter p, BlocoC notasTerceiros) {
        if (notasTerceiros != null) {
            Iterator<Object> iterator = notasTerceiros.getRegistrosC500().iterator();
            while (iterator.hasNext()) {
                RegC500 regC500;
                RegC500 regC5002 = regC500 = iterator.next();
                this.writterRegC500(p, regC5002);
            }
            for (Object object : notasTerceiros.getParticipantes()) {
                Reg150 r = (Reg150)object;
                if (this.hashPessoas.containsKey(r.getIdPessoa())) continue;
                this.hashPessoas.put(r.getIdPessoa(), r);
                this.pessoas.add(r.getIdPessoa());
            }
        }
    }

    private void gerarBlocoC300(PrintWriter p, BlocoC notasSerieD, Empresa emp) {
        Object r;
        if (notasSerieD != null) {
            for (Object object : notasSerieD.getRegistrosC300()) {
                RegC300 regC300 = (RegC300)object;
                this.writterRegC300(p, regC300);
            }
        }
        for (Object object : notasSerieD.getProdutos()) {
            r = (Reg200)object;
            if (this.hashProdutos.containsKey(((Reg200)r).getIdProduto())) continue;
            this.hashProdutos.put(((Reg200)r).getIdProduto(), r);
            this.produtos.add(((Reg200)r).getIdProduto());
        }
        for (Object object : notasSerieD.getUnidMedidas()) {
            r = (Reg190)object;
            if (this.hashUnidMedidas.containsKey(((Reg190)r).getIdUnidMedida())) continue;
            this.hashUnidMedidas.put(((Reg190)r).getIdUnidMedida(), r);
            this.unidMedidas.add(((Reg190)r).getIdUnidMedida());
        }
    }

    private void gerarBlocoC400(PrintWriter p, Empresa emp, Date dataIn, Date dataFim, BlocoC cuponsFiscais) {
        if (cuponsFiscais != null) {
            Object r;
            Iterator<Object> iterator = cuponsFiscais.getRegistrosC400().iterator();
            while (iterator.hasNext()) {
                RegC400 regC400;
                RegC400 regC4002 = regC400 = iterator.next();
                this.writterRegC400(p, regC4002);
                this.writterRegC405(p, regC4002.getReducoes());
            }
            if (cuponsFiscais.getProdutos() != null) {
                for (Object object : cuponsFiscais.getProdutos()) {
                    r = (Reg200)object;
                    if (this.hashProdutos.containsKey(((Reg200)r).getIdProduto())) continue;
                    this.hashProdutos.put(((Reg200)r).getIdProduto(), r);
                    this.produtos.add(((Reg200)r).getIdProduto());
                }
            }
            if (cuponsFiscais.getUnidMedidas() != null) {
                for (Object object : cuponsFiscais.getUnidMedidas()) {
                    r = (Reg190)object;
                    if (this.hashUnidMedidas.containsKey(((Reg190)r).getIdUnidMedida())) continue;
                    this.hashUnidMedidas.put(((Reg190)r).getIdUnidMedida(), r);
                    this.unidMedidas.add(((Reg190)r).getIdUnidMedida());
                }
            }
        }
    }

    private File createWritterBlockD(Date dataIn, Date dataFim, Empresa emp, char perfil) throws IOException {
        File f = File.createTempFile("sped_bloco_d", ".txt");
        PrintWriter p = new PrintWriter(f);
        BlocoD ctrcEnt = this.cons.getBlocoD100NotasTerceirosTransporte(emp, dataIn, dataFim);
        BlocoD ctrcSai = this.cons.getBlocoD100ConhecimentosSaidaTransporte(emp, dataIn, dataFim);
        BlocoD nfComunic = this.cons.getBlocoD500NotasTerceirosTelecomunicacao(dataIn, dataFim, emp);
        boolean comDados = ctrcEnt != null && ctrcEnt.getRegistrosD100() != null && !ctrcEnt.getRegistrosD100().isEmpty() || nfComunic != null && nfComunic.getRegistrosD500() != null && !nfComunic.getRegistrosD500().isEmpty() || ctrcSai != null && ctrcSai.getRegistrosD100() != null && !ctrcSai.getRegistrosD100().isEmpty();
        this.writterRegD001(p, comDados);
        if (comDados) {
            this.observacoesLancFiscal.addAll(this.getObsNotasD100(ctrcEnt.getRegistrosD100()));
            this.observacoesLancFiscal.addAll(this.getObsNotasD500(nfComunic.getRegistrosD500()));
            this.gerarBlocoD100(p, ctrcEnt, ctrcSai, perfil);
            this.gerarBlocoD500(p, nfComunic);
        }
        this.writterD990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterRegD001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "D001");
        p.append(this.separator + String.valueOf(comDados ? 0 : 1));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D001");
    }

    private void writterRegD100(PrintWriter p, RegD100 r) {
        p.append(this.separator + "D100");
        p.append(this.separator + "0");
        p.append(this.separator + "1");
        p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        p.append(this.separator + r.getCodModDocFiscal());
        p.append(this.separator + r.getCodSituacaoDoc());
        p.append(this.separator + r.getSerie());
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumberLong(r.getNumeroDoc()));
        if (r.getChaveNfe() != null) {
            p.append(this.separator + r.getChaveNfe());
        }
        p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
        p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
        if (r.getCodTipoCTe() != null) {
            p.append(this.separator + String.valueOf(r.getCodTipoCTe()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator);
        p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
        p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
        p.append(this.separator + this.form.formatNumber(r.getValorTotMercadorias(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
        p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        if (r.getObsFaturamento() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
            if (!this.hashObservacoes.containsKey(r.getObsFaturamento().getIdentificador())) {
                Reg450 reg450 = new Reg450();
                reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
                reg450.setDescricao(r.getObsFaturamento().getNome());
                this.hashObservacoes.put(reg450.getIdObservacao(), reg450);
                this.observacoes.add(reg450.getIdObservacao());
            }
        } else {
            p.append(this.separator);
        }
        if (r.getPlanoConta() != null) {
            p.append(this.separator + this.form.formatNumberLong(r.getPlanoConta()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("D100");
    }

    private void writterRegD100Saida(PrintWriter p, RegD100 r, char perfil) {
        if (r.getCodSituacaoDoc().equals("02") || r.getCodSituacaoDoc().equals("2") || r.getCodSituacaoDoc().equals("03") || r.getCodSituacaoDoc().equals("3")) {
            p.append(this.separator + "D100");
            p.append(this.separator + "1");
            p.append(this.separator + "0");
            p.append(this.separator);
            p.append(this.separator + r.getCodModDocFiscal());
            p.append(this.separator + r.getCodSituacaoDoc());
            p.append(this.separator + r.getSerie());
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumberLong(r.getNumeroDoc()));
            if (r.getChaveNfe() != null) {
                p.append(this.separator + r.getChaveNfe());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D100");
        } else {
            p.append(this.separator + "D100");
            p.append(this.separator + "1");
            p.append(this.separator + "0");
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
            p.append(this.separator + r.getCodModDocFiscal());
            p.append(this.separator + r.getCodSituacaoDoc());
            p.append(this.separator + r.getSerie());
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumberLong(r.getNumeroDoc()));
            if (r.getChaveNfe() != null) {
                p.append(this.separator + r.getChaveNfe());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            if (r.getCodTipoCTe() != null) {
                p.append(this.separator + r.getCodTipoCTe());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
            p.append(this.separator + r.getIndicadorTipoFrete().toString());
            p.append(this.separator + this.form.formatNumber(r.getValorTotMercadorias(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
            p.append(this.separator + this.form.formatNumber(0.0, 2));
            p.append(this.separator);
            if (r.getPlanoConta() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getPlanoConta()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D100");
            this.writterRegD130Saida(p, r.getRegistrosD130());
            this.writterRegD160Saida(p, r.getRegistrosD160(), perfil);
            this.writterRegD190Saida(p, r.getLivrosFiscais());
        }
    }

    private void writterRegD130Saida(PrintWriter p, List<RegD130> registrosD130) {
        if (registrosD130 != null) {
            Iterator<RegD130> iterator = registrosD130.iterator();
            while (iterator.hasNext()) {
                RegD130 o;
                RegD130 r = o = iterator.next();
                CtrcComplConhecimento c = r.getComplConhecimento();
                p.append(this.separator + "D130");
                p.append(this.separator + c.getCodPartcipanteConsignatario());
                p.append(this.separator + c.getCodPartcipanteRedespacho());
                p.append(this.separator + c.getTipoFrete().toString());
                p.append(this.separator + c.getCodMunOrigem());
                p.append(this.separator + c.getCodMunDestino());
                p.append(this.separator + c.getPlacaVeiculo());
                p.append(this.separator + this.form.formatNumber(c.getVrLiqFrete(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrSecSat(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrDespacho(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrPedagio(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrOutros(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrTotalFrete(), 2));
                p.append(this.separator + c.getUf());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("D130");
            }
        }
    }

    private void writterRegD160Saida(PrintWriter p, List<RegD160> registrosD160, char perfil) {
        if (registrosD160 != null) {
            Iterator<RegD160> iterator = registrosD160.iterator();
            while (iterator.hasNext()) {
                RegD160 o;
                RegD160 r = o = iterator.next();
                CtrcCargaTransportada c = r.getCargaTransportada();
                p.append(this.separator + "D160");
                p.append(this.separator + c.getDespacho());
                p.append(this.separator + c.getCnpjRemetente());
                if (c.getInscEstRemetente() != null && !c.getInscEstRemetente().equalsIgnoreCase("ISENTO")) {
                    p.append(this.separator + c.getInscEstRemetente());
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + c.getCodMunOrigem());
                if (c.getCnpjDestinatario() != null) {
                    p.append(this.separator + c.getCnpjDestinatario());
                } else {
                    p.append(this.separator);
                }
                if (c.getInscEstDestinatario() != null && !c.getInscEstDestinatario().equalsIgnoreCase("ISENTO")) {
                    p.append(this.separator + c.getInscEstDestinatario());
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + c.getCodMunDestinatario());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("D160");
                this.writterRegD161Saida(p, r.getRegistroD161(), perfil);
                this.writterRegD162Saida(p, r.getRegistrosD162());
            }
        }
    }

    private void writterRegD161Saida(PrintWriter p, RegD161 r, char perfil) {
        if (perfil == this.PERFIL_A && r != null) {
            CtrcColetaEntrega c = r.getColetaEntrega();
            p.append(this.separator + "D161");
            p.append(this.separator + c.getTipoTransporte().toString());
            if (c.getCnpjColeta() != null) {
                p.append(this.separator + c.getCnpjColeta());
            } else {
                p.append(this.separator);
            }
            if (c.getInscEstColeta() != null && !c.getInscEstColeta().equalsIgnoreCase("ISENTO")) {
                p.append(this.separator + c.getInscEstColeta());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + c.getCodMunColeta());
            if (c.getCnpjEntrega() != null) {
                p.append(this.separator + c.getCnpjEntrega());
            } else {
                p.append(this.separator);
            }
            if (c.getInscEstEntrega() != null && !c.getInscEstEntrega().equalsIgnoreCase("ISENTO")) {
                p.append(this.separator + c.getInscEstEntrega());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + c.getCodMunEntrega());
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D161");
        }
    }

    private void writterRegD162Saida(PrintWriter p, List<RegD162> registrosD162) {
        if (registrosD162 != null) {
            Iterator<RegD162> iterator = registrosD162.iterator();
            while (iterator.hasNext()) {
                RegD162 o;
                RegD162 r = o = iterator.next();
                CtrcDocumentosFiscais c = r.getDocFiscais();
                p.append(this.separator + "D162");
                if (c.getCodModeloDocFiscal() != null) {
                    String codModDocFiscal = c.getCodModeloDocFiscal().toString();
                    if (codModDocFiscal.trim().length() == 2) {
                        p.append(this.separator + c.getCodModeloDocFiscal().toString());
                    } else {
                        p.append(this.separator + "0" + c.getCodModeloDocFiscal().toString());
                    }
                }
                if (c.getSerie() != null) {
                    p.append(this.separator + c.getSerie());
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + c.getNumeroDoc().toString());
                if (c.getDataEmissao() != null) {
                    p.append(this.separator + this.form.formatDate(c.getDataEmissao()));
                }
                p.append(this.separator + this.form.formatNumber(c.getVrTotal(), 2));
                p.append(this.separator + this.form.formatNumber(c.getVrMercadorias(), 2));
                p.append(this.separator + this.form.formatNumber(c.getQuantidade(), 0));
                p.append(this.separator + this.form.formatNumber(c.getPesoBruto(), 2));
                p.append(this.separator + this.form.formatNumber(c.getPesoLiquido(), 2));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("D162");
            }
        }
    }

    private void writterRegD190(PrintWriter p, List<RegD190> registrosD190) {
        Iterator<RegD190> iterator = registrosD190.iterator();
        while (iterator.hasNext()) {
            RegD190 o;
            RegD190 r = o = iterator.next();
            p.append(this.separator + "D190");
            p.append(this.separator + r.getIncidenciaIcms());
            p.append(this.separator + this.form.clearString(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTribIcms(), 2));
            if (r.getObservacoesLv() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getObservacoesLv()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D190");
        }
    }

    private void writterRegD190Saida(PrintWriter p, List<RegD190> livrosFiscais) {
        Iterator<RegD190> iterator = livrosFiscais.iterator();
        while (iterator.hasNext()) {
            RegD190 o;
            RegD190 r = o = iterator.next();
            p.append(this.separator + "D190");
            p.append(this.separator + r.getIncidenciaIcms());
            p.append(this.separator + this.form.clearString(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTribIcms(), 2));
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D190");
        }
    }

    private void writterRegD590(PrintWriter p, List<RegD590> livrosFiscais) {
        Iterator<RegD590> iterator = livrosFiscais.iterator();
        while (iterator.hasNext()) {
            RegD590 o;
            RegD590 r = o = iterator.next();
            p.append(this.separator + "D590");
            p.append(this.separator + r.getIncidenciaIcms());
            p.append(this.separator + this.form.clearString(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcmsSt(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTribIcms(), 2));
            if (r.getObservacoesLv() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getObservacoesLv()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("D590");
        }
    }

    private void writterRegD500(PrintWriter p, RegD500 r) {
        if (r.getCodSituacaoDoc().equalsIgnoreCase("02") || r.getCodSituacaoDoc().equalsIgnoreCase("03")) {
            p.append(this.separator + "D500");
            p.append(this.separator + "0");
            p.append(this.separator + "1");
            p.append(this.separator);
            p.append(this.separator + r.getCodModDocFiscal());
            p.append(this.separator + r.getCodSituacaoDoc());
            p.append(this.separator + r.getSerie());
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumberInt(r.getNumeroDoc()));
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator + this.endOfRegister);
        } else {
            p.append(this.separator + "D500");
            p.append(this.separator + "0");
            p.append(this.separator + "1");
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
            p.append(this.separator + r.getCodModDocFiscal());
            p.append(this.separator + r.getCodSituacaoDoc());
            p.append(this.separator + r.getSerie());
            p.append(this.separator);
            p.append(this.separator + this.form.formatNumberInt(r.getNumeroDoc()));
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorTotMercadorias(), 2));
            p.append(this.separator + this.form.formatNumber(0.0, 2));
            p.append(this.separator + this.form.formatNumber(0.0, 2));
            p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS(), 2));
            if (r.getObsFaturamento() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getObsFaturamento().getIdentificador()));
                if (!this.hashObservacoes.containsKey(r.getObsFaturamento().getIdentificador())) {
                    Reg450 reg450 = new Reg450();
                    reg450.setIdObservacao(r.getObsFaturamento().getIdentificador());
                    reg450.setDescricao(r.getObsFaturamento().getNome());
                    this.hashObservacoes.put(r.getObsFaturamento().getIdentificador(), reg450);
                    this.observacoes.add(r.getObsFaturamento().getIdentificador());
                }
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
            if (r.getPlanoConta() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getPlanoConta()));
            } else {
                p.append(this.separator);
            }
            if (r.getCodTipoAssinante() != null) {
                p.append(this.separator + r.getCodTipoAssinante());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.writterRegD590(p, r.getLivrosFiscais());
        }
        this.cont.soma1("D500");
    }

    private void writterC990(PrintWriter p) {
        this.cont.soma1("C990");
        p.append(this.separator + "C990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('C')));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterD990(PrintWriter p) {
        this.cont.soma1("D990");
        p.append(this.separator + "D990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('D')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlockE(Date dataIn, Date dataFim, Empresa empresa) throws IOException, SpedStructureException {
        ApuracaoICMS ap;
        File f = File.createTempFile("sped_bloco_e", ".txt");
        List apuracoesIcms = this.cons.getApuracoesIcms(dataIn, dataFim, empresa);
        List apuracoesIcmsST = this.cons.getApuracoesIcmsST(dataIn, dataFim, empresa);
        if (apuracoesIcms == null || apuracoesIcms.isEmpty()) {
            throw new SpedStructureException("Primeiro, fa\u00e7a a apura\u00e7\u00e3o de ICMS.");
        }
        PrintWriter p = new PrintWriter(f);
        boolean comDados = true;
        this.writterE001(p, comDados);
        for (Object o : apuracoesIcms) {
            ap = (ApuracaoICMS)o;
            this.writterE100(p, dataIn, dataFim);
            this.writterE110(p, ap);
            this.writterE111(p, ap);
            this.writterE112(p, ap);
            this.writterE113(p, ap);
            this.writterE115(p, ap);
            this.writterE116(p, ap);
        }
        for (Object o : apuracoesIcmsST) {
            ap = (ApuracaoICMS)o;
            this.writterE200(p, dataIn, dataFim, ap.getUnidadeFederativa().getSigla());
            this.writterE210(p, ap);
            this.writterE220(p, ap);
            this.writterE230(p, ap);
            this.writterE240(p, ap);
            this.writterE250(p, ap);
        }
        if (empresa.getEmpresaDados().getTipoEmpresa().getCodigo() == 2) {
            List apuracoesIpi = this.cons.getApuracoesIpi(dataIn, dataFim, empresa);
            for (Object o : apuracoesIpi) {
                ApuracaoIPI ap2 = (ApuracaoIPI)o;
                this.writterE500(p, dataIn, dataFim, ap2);
                this.writterE510(p, ap2);
                this.writterE520(p, ap2);
                this.writterE530(p, ap2);
            }
        }
        this.writterE990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterE100(PrintWriter p, Date dataIn, Date dataFim) {
        p.append(this.separator + "E100");
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E100");
    }

    private void writterE510(PrintWriter p, ApuracaoIPI apuracaoIpi) {
        for (Object o : apuracaoIpi.getAgrupamentoValorIpi()) {
            AgrupamentoValorIpi a = (AgrupamentoValorIpi)o;
            p.append(this.separator + "E510");
            p.append(this.separator + this.form.clearString(a.getCfop().getCodigo()));
            p.append(this.separator + this.form.clearString(a.getIncidenciaIpi().getCodigo()));
            p.append(this.separator + this.form.formatNumber(a.getValorContabil()));
            p.append(this.separator + this.form.formatNumber(a.getBaseCalculo()));
            p.append(this.separator + this.form.formatNumber(a.getValorIpi()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E510");
        }
    }

    private void writterE520(PrintWriter p, ApuracaoIPI a) {
        p.append(this.separator + "E520");
        p.append(this.separator + this.form.formatNumber(a.getSaldoCreditoAnterior()));
        p.append(this.separator + this.form.formatNumber(a.getVrDebito()));
        p.append(this.separator + this.form.formatNumber(a.getVrCredito()));
        p.append(this.separator + this.form.formatNumber(a.getVrOutroDebito()));
        p.append(this.separator + this.form.formatNumber(a.getVrOutroCredito()));
        p.append(this.separator + this.form.formatNumber(a.getSaldoCredor()));
        p.append(this.separator + this.form.formatNumber(a.getSaldoDevedor()));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E520");
    }

    private void writterE530(PrintWriter p, ApuracaoIPI a) {
        for (AjusteApuracaoIpi ap : a.getAjustesApuracaoIpi()) {
            p.append(this.separator + "E530");
            p.append(this.separator + ap.getTipoAjuste().toString());
            p.append(this.separator + this.form.formatNumber(ap.getValorAjuste()));
            p.append(this.separator + this.form.clearString(ap.getCodigoAjusteIpi().getCodigo()));
            if (ap.getIndicadorOrigemIpi() != null) {
                p.append(this.separator + ap.getIndicadorOrigemIpi().getCodigo());
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + ap.getNumeroDoc());
            p.append(this.separator + ap.getDescricao());
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E530");
        }
    }

    private void writterE500(PrintWriter p, Date dataIn, Date dataFim, ApuracaoIPI ap) {
        p.append(this.separator + "E500");
        if (ap.getTipoApuracao() == 3) {
            p.append(this.separator + "0");
        } else {
            p.append(this.separator + "1");
        }
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E500");
    }

    private void writterE200(PrintWriter p, Date dataIn, Date dataFim, String uf) {
        p.append(this.separator + "E200");
        p.append(this.separator + this.form.formatStringClear(uf));
        p.append(this.separator + this.form.formatDate(dataIn));
        p.append(this.separator + this.form.formatDate(dataFim));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E200");
    }

    private void writterE220(PrintWriter p, ApuracaoICMS ap) {
        for (AjusteApuracaoIcms a : ap.getAjustesApuracao()) {
            p.append(this.separator + "E220");
            p.append(this.separator + a.getTipoAjusteApIcms().getCodigo());
            p.append(this.separator + a.getDescricaoCompl());
            p.append(this.separator + this.form.formatNumber(a.getValorAjuste()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E220");
        }
    }

    private void writterE210(PrintWriter p, ApuracaoICMS ap) {
        p.append(this.separator + "E210");
        p.append(this.separator + String.valueOf(1));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoCredorAnterior(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrIcmsStDevolucao(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrRessarcimentoST(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrOutroCredito(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrDebito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrOutroDebito() + ap.getVrEstornoCredito(), 2));
        p.append(this.separator + this.form.formatNumber(0.0, 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoDevedor(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrDeducoes(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoDevedor() - ap.getVrDeducoes(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoCredor(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getDebEspecial(), 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E210");
    }

    private void writterE001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "E001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E001");
    }

    private void writterE112(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getAjustesApuracao()) {
            AjusteApuracaoIcms a = (AjusteApuracaoIcms)o;
            for (Object ob : a.getItemApIcmsProc()) {
                ItemAPIcmsProc it = (ItemAPIcmsProc)ob;
                p.append(this.separator + "E112");
                p.append(this.separator + it.getProcessoFiscal().getNrDocArrecadacao());
                p.append(this.separator + it.getProcessoFiscal().getNrProcesso());
                p.append(this.separator + String.valueOf(it.getProcessoFiscal().getTipoProcesso().getCodigo()));
                p.append(this.separator + it.getProcessoFiscal().getDescricao());
                p.append(this.separator + it.getProcessoFiscal().getDescricaoComp());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("E112");
            }
        }
    }

    private void writterE111(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getAjustesApuracao()) {
            AjusteApuracaoIcms a = (AjusteApuracaoIcms)o;
            p.append(this.separator + "E111");
            p.append(this.separator + a.getTipoAjusteApIcms().getCodigo());
            p.append(this.separator + a.getDescricaoCompl());
            p.append(this.separator + this.form.formatNumber(a.getValorAjuste(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E111");
        }
    }

    private void writterE230(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getAjustesApuracao()) {
            AjusteApuracaoIcms a = (AjusteApuracaoIcms)o;
            for (Object ob : a.getItemApIcmsProc()) {
                ItemAPIcmsProc it = (ItemAPIcmsProc)ob;
                p.append(this.separator + "E230");
                p.append(this.separator + it.getProcessoFiscal().getNrDocArrecadacao());
                p.append(this.separator + it.getProcessoFiscal().getNrProcesso());
                p.append(this.separator + String.valueOf(it.getProcessoFiscal().getTipoProcesso().getCodigo()));
                p.append(this.separator + it.getProcessoFiscal().getDescricao());
                p.append(this.separator + it.getProcessoFiscal().getDescricaoComp());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("E230");
            }
        }
    }

    private void writterE115(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getValoresDeclaratorios()) {
            ValoresDecAPIcms a = (ValoresDecAPIcms)o;
            p.append(this.separator + "E115");
            p.append(this.separator + a.getValoresDeclaratorios().getCodigo());
            p.append(this.separator + this.form.formatNumber(a.getValor(), 2));
            p.append(this.separator + a.getValoresDeclaratorios().getDescricao());
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E115");
        }
    }

    private void writterE116(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getItensObrigIcms()) {
            ItemObrigIcmsRecolher a = (ItemObrigIcmsRecolher)o;
            p.append(this.separator + "E116");
            p.append(this.separator + a.getObriIcmsRecolher().getCodigo());
            p.append(this.separator + this.form.formatNumber(a.getValor(), 2));
            p.append(this.separator + this.form.formatDate(a.getDataVencimento()));
            p.append(this.separator + a.getCodigoRecolhimento());
            if (a.getProcessoFiscal() != null) {
                p.append(this.separator + a.getProcessoFiscal().getNrProcesso());
                p.append(this.separator + String.valueOf(a.getProcessoFiscal().getTipoProcesso().getCodigo()));
                p.append(this.separator + a.getProcessoFiscal().getDescricao());
                p.append(this.separator + a.getProcessoFiscal().getDescricaoComp());
            } else {
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatDate(a.getPeriodo(), "MMyyyy"));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E116");
        }
    }

    private void writterE250(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getItensObrigIcms()) {
            ItemObrigIcmsRecolher a = (ItemObrigIcmsRecolher)o;
            p.append(this.separator + "E250");
            p.append(this.separator + a.getObriIcmsRecolher().getCodigo());
            p.append(this.separator + this.form.formatNumber(a.getValor(), 2));
            p.append(this.separator + this.form.formatDate(a.getDataVencimento()));
            p.append(this.separator + a.getCodigoRecolhimento());
            if (a.getProcessoFiscal() != null) {
                p.append(this.separator + a.getProcessoFiscal().getNrProcesso());
                p.append(this.separator + String.valueOf(a.getProcessoFiscal().getTipoProcesso().getCodigo()));
                p.append(this.separator + a.getProcessoFiscal().getDescricao());
                p.append(this.separator + a.getProcessoFiscal().getDescricaoComp());
            } else {
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator);
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatDate(a.getPeriodo(), "MMyyyy"));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("E250");
        }
    }

    private void writterE113(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getAjustesApuracao()) {
            AjusteApuracaoIcms a = (AjusteApuracaoIcms)o;
            for (Object ob : a.getItemApIcmsDoc()) {
                ItemAPIcmsDoc it = (ItemAPIcmsDoc)ob;
                p.append(this.separator + "E113");
                Pessoa pes = null;
                ModeloDocFiscal mod = null;
                String serie = null;
                Integer numeroDoc = null;
                Date dataDocumento = null;
                Object prod = null;
                if (it.getItemNotaPropria() != null) {
                    h = this.cons.findDadosNotaPropria(it.getItemNotaPropria().getNotaFiscalPropria().getIdentificador());
                    pes = (Pessoa)h.get("PESSOA");
                    serie = (String)h.get("SERIE");
                    mod = (ModeloDocFiscal)h.get("MOD_DOC_FISCAL");
                    numeroDoc = (Integer)h.get("NUMERO_NOTA");
                    dataDocumento = (Date)h.get("DATA_EMISSAO");
                } else if (it.getItemNotaTerceiros() != null) {
                    h = this.cons.findDadosNotaTerceiros(it.getItemNotaTerceiros().getNotaFiscalTerceiros().getIdentificador());
                    pes = (Pessoa)h.get("PESSOA");
                    serie = (String)h.get("SERIE");
                    mod = (ModeloDocFiscal)h.get("MOD_DOC_FISCAL");
                    numeroDoc = (Integer)h.get("NUMERO_NOTA");
                    dataDocumento = (Date)h.get("DATA_EMISSAO");
                } else {
                    Cte ct = it.getCte();
                    pes = it.getCte().getClienteTomador().getCliente().getPessoa();
                    serie = ct.getSerie();
                    mod = ct.getModeloFiscalCte().getNaturezaOperacao().getModeloDocFiscal();
                    numeroDoc = ct.getNumero().intValue();
                    dataDocumento = ct.getDataEmissao();
                }
                this.participantes.add(pes);
                p.append(this.separator + this.form.formatStringClear(pes.getIdentificador().toString()));
                p.append(this.separator + mod.getCodigo());
                p.append(this.separator + serie);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumberInt(numeroDoc));
                p.append(this.separator + this.form.formatDate(dataDocumento));
                if (prod != null) {
                    p.append(this.separator + this.form.formatString(prod.getIdentificador().toString()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.form.formatNumber(it.getValorAjuste(), 2));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("E113");
            }
        }
    }

    private void writterE240(PrintWriter p, ApuracaoICMS ap) {
        for (Object o : ap.getAjustesApuracao()) {
            AjusteApuracaoIcms a = (AjusteApuracaoIcms)o;
            for (Object ob : a.getItemApIcmsDoc()) {
                ItemAPIcmsDoc it = (ItemAPIcmsDoc)ob;
                p.append(this.separator + "E240");
                Pessoa pes = null;
                ModeloDocFiscal mod = null;
                String serie = null;
                Integer numeroDoc = null;
                Date dataDocumento = null;
                Object prod = null;
                if (it.getItemNotaTerceiros() != null || it.getItemNotaPropria() != null) {
                    if (it.getItemNotaPropria() != null) {
                        nf = it.getItemNotaPropria().getNotaFiscalPropria();
                        pes = nf.getUnidadeFatCliente().getCliente().getPessoa();
                        serie = nf.getSerie();
                        mod = nf.getModeloDocFiscal();
                        numeroDoc = nf.getNumeroNota();
                        dataDocumento = nf.getDataEmissaoNota();
                    } else {
                        nf = it.getItemNotaTerceiros().getNotaFiscalTerceiros();
                        pes = nf.getUnidadeFatFornecedor().getFornecedor().getPessoa();
                        serie = nf.getSerie();
                        mod = nf.getModeloDocFiscal();
                        numeroDoc = nf.getNumeroNota();
                        dataDocumento = nf.getDataEmissao();
                    }
                } else {
                    Cte ct = it.getCte();
                    pes = it.getCte().getClienteTomador().getCliente().getPessoa();
                    serie = ct.getSerie();
                    mod = ct.getModeloFiscalCte().getNaturezaOperacao().getModeloDocFiscal();
                    numeroDoc = ct.getNumero().intValue();
                    dataDocumento = ct.getDataEmissao();
                }
                this.participantes.add(pes);
                p.append(this.separator + this.form.formatStringClear(pes.getIdentificador().toString()));
                p.append(this.separator + mod.getCodigo());
                p.append(this.separator + serie);
                p.append(this.separator);
                p.append(this.separator + this.form.formatNumberInt(numeroDoc));
                p.append(this.separator + this.form.formatDate(dataDocumento));
                if (prod != null) {
                    p.append(this.separator + this.form.formatString(prod.getIdentificador().toString()));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.form.formatNumber(it.getValorAjuste(), 2));
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("E240");
            }
        }
    }

    private void writterE110(PrintWriter p, ApuracaoICMS ap) {
        p.append(this.separator + "E110");
        p.append(this.separator + this.form.formatNumber(ap.getVrDebito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getValorAjusteDebito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrOutroDebito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrEstornoCredito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrCredito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getValorAjusteCredito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrOutroCredito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrEstornoDebito(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoCredorAnterior(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoDevedor(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getVrDeducoes(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoDevedor() - ap.getVrDeducoes(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getSaldoCredor(), 2));
        p.append(this.separator + this.form.formatNumber(ap.getDebEspecial(), 2));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("E110");
    }

    private void writterE990(PrintWriter p) {
        this.cont.soma1("E990");
        p.append(this.separator + "E990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('E')));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterRegG990(PrintWriter p) {
        this.cont.soma1("G990");
        p.append(this.separator + "G990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('G')));
        p.append(this.separator + this.endOfRegister);
    }

    private File createWritterBlock1(Date dataIn, Date dataFim, Empresa emp) throws IOException {
        File f = File.createTempFile("sped_bloco_1", ".txt");
        PrintWriter p = new PrintWriter(f);
        boolean comDados = false;
        this.writter1001(p, comDados);
        this.writter1990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writter1001(PrintWriter p, boolean comDados) {
        p.append(this.separator + "1001");
        p.append(this.separator + (comDados ? "0" : "1"));
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("1001");
    }

    private void writter1990(PrintWriter p) {
        this.cont.soma1("1990");
        p.append(this.separator + "1990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('1')));
        p.append(this.separator + this.endOfRegister);
    }

    private void writterReg9990(PrintWriter p) {
        p.append(this.separator + "9990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('9')));
        p.append(this.separator + this.endOfRegister);
    }

    public HashSet getParticipantes() {
        return this.participantes;
    }

    public void setParticipantes(HashSet participantes) {
        this.participantes = participantes;
    }

    public HashSet getItensServicos() {
        return this.itensServicos;
    }

    public void setItensServicos(HashSet itensServicos) {
        this.itensServicos = itensServicos;
    }

    public HashSet getNaturezas() {
        return this.naturezas;
    }

    public void setNaturezas(HashSet naturezas) {
        this.naturezas = naturezas;
    }

    public HashSet getObservacoesLancFiscal() {
        return this.observacoesLancFiscal;
    }

    public void setObservacoesLancFiscal(HashSet observacoesLancFiscal) {
        this.observacoesLancFiscal = observacoesLancFiscal;
    }

    public HashSet getBens() {
        return this.bens;
    }

    public void setBens(HashSet bens) {
        this.bens = bens;
    }

    public HashSet getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(HashSet centroCusto) {
        this.centroCusto = centroCusto;
    }

    private HashMap getTotalizadoresCTe(Cte cte) {
        Double valorDocumento = 0.0;
        Double valorDesconto = 0.0;
        Double valorServico = 0.0;
        Double valorBcIcms = 0.0;
        Double valorIcms = 0.0;
        Double valorNaoTributado = 0.0;
        for (Object o : cte.getLivrosFiscais()) {
            LivroFiscal vo = (LivroFiscal)o;
            valorDocumento = valorDocumento + vo.getValorTotal();
            valorServico = valorServico + vo.getValorTotal();
            valorIcms = valorIcms + vo.getValorIcms();
            valorNaoTributado = valorNaoTributado + vo.getValorIcmsTributado();
        }
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(this.VALOR_TOTAL, valorDocumento);
        h.put(this.VALOR_DESCONTO, valorDesconto);
        h.put(this.VALOR_PROD_SERV, valorServico);
        h.put(this.VALOR_BC_ICMS, valorBcIcms);
        h.put(this.VALOR_ICMS, valorIcms);
        return h;
    }

    private void writterRegC400(PrintWriter p, RegC400 r) {
        p.append(this.separator + "C400");
        p.append(this.separator + r.getModeloDocFiscal());
        p.append(this.separator + r.getModeloECF());
        p.append(this.separator + r.getSerieECF());
        p.append(this.separator + r.getIdImpressora().toString());
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C400");
    }

    private void writterRegC405(PrintWriter p, List<RegC405> reducoes) {
        Iterator<RegC405> iterator = reducoes.iterator();
        while (iterator.hasNext()) {
            RegC405 o;
            RegC405 r = o = iterator.next();
            p.append(this.separator + "C405");
            p.append(this.separator + this.form.formatDate(r.getDataMovimento()));
            p.append(this.separator + this.form.formatNumberLong(r.getContadorReinicio()));
            p.append(this.separator + this.form.formatNumberLong(r.getContadorCRZ()));
            p.append(this.separator + this.form.formatNumberLong(r.getUltimoCOO()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotalGeral(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorVendaBruta(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C405");
            this.writterRegC410(p, r.getPisCofins());
            this.writterRegC420(p, r.getTotalizadoresParciais());
            this.writterRegC460(p, r.getCuponsFiscais());
            this.writterRegC490(p, r.getLivrosFiscais());
        }
    }

    private void writterRegC410(PrintWriter p, RegC410 r) {
        if (r != null) {
            p.append(this.separator + "C410");
            if (r.getVrPis() != null) {
                p.append(this.separator + this.form.formatNumber(r.getVrPis(), 2));
            } else {
                p.append(this.separator + this.form.formatNumber(0.0, 2));
            }
            if (r.getVrCofins() != null) {
                p.append(this.separator + this.form.formatNumber(r.getVrCofins(), 2));
            } else {
                p.append(this.separator + this.form.formatNumber(0.0, 2));
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C410");
        }
    }

    private void writterRegC420(PrintWriter p, List<RegC420> totalizadores) {
        if (totalizadores != null) {
            Iterator<RegC420> iterator = totalizadores.iterator();
            while (iterator.hasNext()) {
                RegC420 o;
                RegC420 r = o = iterator.next();
                p.append(this.separator + "C420");
                p.append(this.separator + r.getCodigoTotalizador());
                p.append(this.separator + this.form.formatNumber(r.getValor(), 2));
                if (r.getNrTotalizador() != null) {
                    p.append(this.separator + r.getNrTotalizador());
                } else {
                    p.append(this.separator);
                }
                if (r.getDescricao() != null) {
                    p.append(this.separator + r.getDescricao());
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C420");
                if (r.getItens() == null) continue;
                this.writterRegC425(p, r.getItens());
            }
        }
    }

    private void writterRegC425(PrintWriter p, List<RegC425> itens) {
        Iterator<RegC425> iterator = itens.iterator();
        while (iterator.hasNext()) {
            RegC425 o;
            RegC425 r = o = iterator.next();
            p.append(this.separator + "C425");
            p.append(this.separator + this.form.formatNumberLong(r.getIdProduto()));
            p.append(this.separator + this.form.formatNumber(r.getQuantidade(), 3));
            p.append(this.separator + this.form.formatStringClear(r.getUnidadeMedida()));
            p.append(this.separator + this.form.formatNumber(r.getValorTotal()));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C425");
        }
    }

    private void writterRegC460(PrintWriter p, List<RegC460> cupons) {
        if (cupons != null) {
            Iterator<RegC460> iterator = cupons.iterator();
            while (iterator.hasNext()) {
                RegC460 o;
                RegC460 c = o = iterator.next();
                p.append(this.separator + "C460");
                p.append(this.separator + c.getCodModDocFiscal());
                if (c.getCancelado() == 0) {
                    p.append(this.separator + "00");
                    p.append(this.separator + c.getNumeroDoc().toString());
                    p.append(this.separator + this.form.formatDate(c.getDataEmissao()));
                    p.append(this.separator + this.form.formatNumber(c.getValorTotal(), 2));
                    if (c.getValorPis() != null) {
                        p.append(this.separator + this.form.formatNumber(c.getValorPis(), 2));
                    } else {
                        p.append(this.separator + this.form.formatNumber(0.0, 2));
                    }
                    if (c.getValorCofins() != null) {
                        p.append(this.separator + this.form.formatNumber(c.getValorCofins(), 2));
                    } else {
                        p.append(this.separator + this.form.formatNumber(0.0, 2));
                    }
                    if (!(c.getCpfCnpj() == null || c.getCpfCnpj().trim().length() != 14 && c.getCpfCnpj().trim().length() != 11 || c.getCpfCnpj().equals("00000000000") && c.getCpfCnpj().equals("00000000000000"))) {
                        p.append(this.separator + c.getCpfCnpj());
                    } else {
                        p.append(this.separator);
                    }
                    if (c.getNomeCliente() != null) {
                        p.append(this.separator + this.form.formatString(c.getNomeCliente(), 60));
                    } else {
                        p.append(this.separator);
                    }
                    p.append(this.separator + this.endOfRegister);
                    this.writterReg470(p, c.getItensCupom());
                } else {
                    p.append(this.separator + "02");
                    p.append(this.separator + c.getNumeroDoc().toString());
                    p.append(this.separator);
                    p.append(this.separator);
                    p.append(this.separator);
                    p.append(this.separator);
                    p.append(this.separator);
                    p.append(this.separator);
                    p.append(this.separator + this.endOfRegister);
                }
                this.cont.soma1("C460");
            }
        }
    }

    private void writterReg470(PrintWriter p, List<RegC470> itens) {
        if (itens != null) {
            Iterator<RegC470> iterator = itens.iterator();
            while (iterator.hasNext()) {
                RegC470 o;
                RegC470 r = o = iterator.next();
                p.append(this.separator + "C470");
                p.append(this.separator + r.getCodItem().toString());
                p.append(this.separator + this.form.formatNumber(r.getQuantidade(), 3));
                p.append(this.separator);
                p.append(this.separator + r.getUnidMedida());
                p.append(this.separator + this.form.formatNumber(r.getValorItem(), 2));
                p.append(this.separator + r.getIncidenciaIcms());
                p.append(this.separator + this.form.formatStringClear(r.getCfop()));
                if (r.getAliquotaIcms() != null && r.getAliquotaIcms() > 0.0) {
                    p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
                } else {
                    p.append(this.separator + "0");
                }
                if (r.getValorPis() != null && r.getValorPis() > 0.0) {
                    p.append(this.separator + this.form.formatNumber(r.getValorPis(), 2));
                } else {
                    p.append(this.separator);
                }
                if (r.getValorCofins() != null && r.getValorCofins() > 0.0) {
                    p.append(this.separator + this.form.formatNumber(r.getValorCofins(), 2));
                } else {
                    p.append(this.separator);
                }
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C470");
            }
        }
    }

    private void writterRegC490(PrintWriter p, List<RegC490> livrosFiscais) {
        if (livrosFiscais != null) {
            Iterator<RegC490> iterator = livrosFiscais.iterator();
            while (iterator.hasNext()) {
                RegC490 o;
                RegC490 r = o = iterator.next();
                p.append(this.separator + "C490");
                p.append(this.separator + r.getIncidenciaIcms());
                p.append(this.separator + this.form.formatStringClear(r.getCfop()));
                if (r.getIncidenciaIcms().equals("030") || r.getIncidenciaIcms().equals("130") || r.getIncidenciaIcms().equals("230") || r.getIncidenciaIcms().equals("040") || r.getIncidenciaIcms().equals("140") || r.getIncidenciaIcms().equals("240") || r.getIncidenciaIcms().equals("041") || r.getIncidenciaIcms().equals("141") || r.getIncidenciaIcms().equals("241") || r.getIncidenciaIcms().equals("050") || r.getIncidenciaIcms().equals("150") || r.getIncidenciaIcms().equals("250") || r.getIncidenciaIcms().equals("060") || r.getIncidenciaIcms().equals("160") || r.getIncidenciaIcms().equals("260")) {
                    p.append(this.separator + "0");
                    p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
                    p.append(this.separator + "0");
                    p.append(this.separator + "0");
                } else {
                    p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
                    p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
                    p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
                    p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
                }
                p.append(this.separator);
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C490");
            }
        }
    }

    private String getCodigoIncidenciaIcms(IncidenciaIcms incidenciaIcms) {
        String codigo = incidenciaIcms.getCodigo();
        if (codigo.length() > 3) {
            codigo = codigo.substring(1);
        }
        return codigo;
    }

    private void writterC190(PrintWriter p, List<RegC190> regC190) {
        Iterator<RegC190> iterator = regC190.iterator();
        while (iterator.hasNext()) {
            RegC190 o;
            RegC190 r = o = iterator.next();
            p.append(this.separator + "C190");
            p.append(this.separator + this.form.clearString(r.getIncidenciaIcms()));
            p.append(this.separator + this.form.clearString(r.getCfop()));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorOperacao(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getBcCalculoIcmsSt(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorNaoTribIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getValorIpi(), 2));
            if (r.getObservacoesLv() != null) {
                p.append(this.separator + this.form.formatNumberLong(r.getObservacoesLv()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C190");
        }
    }

    private void writterC195(PrintWriter p, List<RegC190> regC190) {
        for (RegC190 o : regC190) {
            RegC190 r = o;
            Long idObsLancFiscal = r.getIdObsRegC195();
            if (idObsLancFiscal == null || idObsLancFiscal <= 0L) continue;
            ObservacaoLivroFiscal os = this.cons.getObservacaoLivroFiscal(idObsLancFiscal);
            Object comp = "";
            if (os == null) continue;
            if (os.getTokens() != null) {
                for (Object ob : os.getTokens()) {
                    TokenObsLivroFiscal t = (TokenObsLivroFiscal)ob;
                    comp = (String)comp + t.getChave() + ": " + t.getValor() + ".";
                }
            }
            p.append(this.separator + "C195");
            p.append(this.separator + this.form.formatStringClear(os.getObsFaturamento().getIdentificador().toString()));
            p.append(this.separator + (String)comp);
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C195");
            this.writterC197(p, idObsLancFiscal);
        }
    }

    private void writterC197(PrintWriter p, Long idObsLancFiscal) {
        List c197 = this.cons.getOutrasObrigLvFiscal(idObsLancFiscal);
        for (Object o : c197) {
            RegC197 r = (RegC197)o;
            p.append(this.separator + "C197");
            p.append(this.separator + r.getCodTipoAjusteApIcms());
            p.append(this.separator + r.getDescricaoComp());
            if (r.getIdProduto() != null) {
                p.append(this.separator + this.form.clearString(r.getIdProduto().toString()));
            } else {
                p.append(this.separator);
            }
            p.append(this.separator + this.form.formatNumber(r.getVlrBCIcmsIcmsST(), 2));
            p.append(this.separator + this.form.formatNumber(r.getAliquotaIcms(), 2));
            p.append(this.separator + this.form.formatNumber(r.getVlrIcmsIcmsST(), 2));
            p.append(this.separator + this.form.formatNumber(r.getVlrOutros(), 2));
            p.append(this.separator + this.endOfRegister);
            this.cont.soma1("C197");
        }
    }

    private void writterC100NotasTerceiros(PrintWriter p, RegC100 r, boolean docCancInut) {
        p.append(this.separator + "C100");
        p.append(this.separator + String.valueOf(r.getEntSaiNatOP()));
        p.append(this.separator + String.valueOf(1));
        if (!docCancInut) {
            p.append(this.separator + this.form.formatNumberLong(r.getIdParticipante()));
        } else {
            p.append(this.separator);
        }
        p.append(this.separator + this.form.formatStringClear(r.getCodModDocFiscal(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getCodSituacaoDoc(), 2));
        p.append(this.separator + this.form.formatStringClear(r.getSerie(), 3));
        p.append(this.separator + this.form.formatStringClear(String.valueOf(r.getNumeroDoc())));
        if (this.versao.equalsIgnoreCase(this.VERSAO_004) && r.getCodSituacaoDoc().equalsIgnoreCase("02") && r.getCodSituacaoDoc().equalsIgnoreCase("03")) {
            if (r.getChaveNFe().length() == 44) {
                p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
            } else {
                p.append(this.separator);
            }
        } else if (!docCancInut) {
            if (r.getChaveNFe().length() == 44) {
                p.append(this.separator + this.form.formatStringClear(r.getChaveNFe(), 44));
            } else {
                p.append(this.separator);
            }
        } else {
            p.append(this.separator);
        }
        if (!docCancInut) {
            p.append(this.separator + this.form.formatDate(r.getDataEmissao()));
            p.append(this.separator + this.form.formatDate(r.getDataEntSaida()));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndTipoPagamento()));
            p.append(this.separator + this.form.formatNumber(r.getValorDesconto()));
            p.append(this.separator + this.form.formatNumber(0.0));
            p.append(this.separator + this.form.formatNumber(r.getValorDoc()));
            p.append(this.separator + String.valueOf(r.getIndicadorTipoFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorFrete()));
            p.append(this.separator + this.form.formatNumber(r.getValorSeguro()));
            p.append(this.separator + this.form.formatNumber(r.getValorDespAcessorias()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcms()));
            p.append(this.separator + this.form.formatNumber(r.getValorICMS()));
            p.append(this.separator + this.form.formatNumber(r.getValorBCIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIcmsST()));
            p.append(this.separator + this.form.formatNumber(r.getValorIpi()));
            p.append(this.separator + this.form.formatNumber(r.getValorPis()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofins()));
            p.append(this.separator + this.form.formatNumber(r.getValorPisSt()));
            p.append(this.separator + this.form.formatNumber(r.getValorCofinsSt()));
        } else {
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
            p.append(this.separator);
        }
        p.append(this.separator + this.endOfRegister);
        this.cont.soma1("C100");
    }

    private void writterC110(PrintWriter p, List<RegC110> regC110) {
        if (regC110 != null && !regC110.isEmpty()) {
            ObservacaoNotaTerceiros obs;
            RegC110 r = regC110.get(0);
            ArrayList<Long> dados = new ArrayList<Long>();
            for (ObservacaoNotaTerceiros observacaoNotaTerceiros : r.getObsNotaTerceiros()) {
                obs = observacaoNotaTerceiros;
                if (dados.contains(obs.getObsFaturamento().getIdentificador())) continue;
                p.append(this.separator + "C110");
                p.append(this.separator + this.form.formatNumberLong(obs.getObsFaturamento().getIdentificador()));
                p.append(this.separator + obs.getObsFaturamento().getNome());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C110");
                dados.add(obs.getObsFaturamento().getIdentificador());
            }
            for (ObservacaoNotaTerceiros observacaoNotaTerceiros : r.getObsIntFiscoNFTerceiros()) {
                obs = (ObservacaoIntFiscoNFTerceiros)observacaoNotaTerceiros;
                if (dados.contains(obs.getObsFaturamento().getIdentificador())) continue;
                p.append(this.separator + "C110");
                p.append(this.separator + this.form.formatNumberLong(obs.getObsFaturamento().getIdentificador()));
                p.append(this.separator + obs.getObsFaturamento().getNome());
                p.append(this.separator + this.endOfRegister);
                this.cont.soma1("C110");
                dados.add(obs.getObsFaturamento().getIdentificador());
            }
        }
    }

    private void gerarBlocoD100(PrintWriter p, BlocoD ctrcEnt, BlocoD ctrcSai, char perfil) {
        Object r;
        if (ctrcEnt != null) {
            Iterator<Object> iterator = ctrcEnt.getRegistrosD100().iterator();
            while (iterator.hasNext()) {
                RegD100 regD100;
                RegD100 regD1002 = regD100 = iterator.next();
                this.writterRegD100(p, regD1002);
                this.writterRegD190(p, regD1002.getLivrosFiscais());
            }
            for (Object object : ctrcEnt.getParticipantes()) {
                r = (Reg150)object;
                if (this.hashPessoas.containsKey(((Reg150)r).getIdPessoa())) continue;
                this.hashPessoas.put(((Reg150)r).getIdPessoa(), r);
                this.pessoas.add(((Reg150)r).getIdPessoa());
            }
        }
        if (ctrcSai != null) {
            for (RegD100 regD100 : ctrcSai.getRegistrosD100()) {
                r = regD100;
                if (((RegD100)r).getCodModDocFiscal().equalsIgnoreCase("57")) {
                    this.writterRegD100Saida(p, (RegD100)r, perfil);
                    this.writterRegD190Saida(p, ((RegD100)r).getLivrosFiscais());
                    continue;
                }
                this.writterRegD100Saida(p, (RegD100)r, perfil);
            }
            for (Object object : ctrcSai.getParticipantes()) {
                r = (Reg150)object;
                if (this.hashPessoas.containsKey(((Reg150)r).getIdPessoa())) continue;
                this.hashPessoas.put(((Reg150)r).getIdPessoa(), r);
                this.pessoas.add(((Reg150)r).getIdPessoa());
            }
        }
    }

    private void gerarBlocoD500(PrintWriter p, BlocoD nfComunic) {
        if (nfComunic != null) {
            Object r;
            for (RegD500 regD500 : nfComunic.getRegistrosD500()) {
                r = regD500;
                this.writterRegD500(p, (RegD500)r);
            }
            for (Object object : nfComunic.getParticipantes()) {
                r = (Reg150)object;
                if (this.hashPessoas.containsKey(((Reg150)r).getIdPessoa())) continue;
                this.hashPessoas.put(((Reg150)r).getIdPessoa(), r);
                this.pessoas.add(((Reg150)r).getIdPessoa());
            }
        }
    }

    private Reg500 createReg500(PlanoConta pc) {
        Reg500 r = new Reg500();
        r.setIdPlanoContas(pc.getIdentificador());
        r.setCodigo(pc.getCodigo());
        r.setDescricao(pc.getDescricao());
        r.setMarca(pc.getMarca());
        r.setDataInclusao(pc.getDataCadastro());
        return r;
    }

    private List getObsNotasC100(List<RegC100> regC100) {
        ArrayList<Long> dados = new ArrayList<Long>();
        for (RegC100 o : regC100) {
            RegC100 reg = o;
            if (reg.getRegC190() == null) continue;
            for (RegC190 ob : reg.getRegC190()) {
                RegC190 r = ob;
                if (r.getObservacoesLv() == null) continue;
                dados.add(r.getObservacoesLv());
            }
        }
        return dados;
    }

    private List getObsCuponsC400(List<RegC400> regC400) {
        ArrayList<Long> dados = new ArrayList<Long>();
        Iterator<RegC400> iterator = regC400.iterator();
        while (iterator.hasNext()) {
            RegC400 o;
            RegC400 reg = o = iterator.next();
            for (RegC405 ob : reg.getReducoes()) {
                RegC405 r = ob;
                if (r.getLivrosFiscais() == null) continue;
                for (RegC490 obj : r.getLivrosFiscais()) {
                    RegC490 lv = obj;
                    if (lv.getObservacoesLv() == null) continue;
                    dados.add(lv.getObservacoesLv());
                }
            }
        }
        return dados;
    }

    private List getObsNotasC500(List<RegC500> regC500) {
        ArrayList<Long> dados = new ArrayList<Long>();
        for (RegC500 o : regC500) {
            RegC500 reg = o;
            if (reg.getRegC590() == null) continue;
            for (RegC590 ob : reg.getRegC590()) {
                RegC590 r = ob;
                if (r.getObservacoesLv() == null) continue;
                dados.add(r.getObservacoesLv());
            }
        }
        return dados;
    }

    private List getObsNotasD100(List<RegD100> regD100) {
        ArrayList<Long> dados = new ArrayList<Long>();
        for (RegD100 o : regD100) {
            RegD100 reg = o;
            if (reg.getLivrosFiscais() == null) continue;
            for (RegD190 ob : reg.getLivrosFiscais()) {
                RegD190 r = ob;
                if (r.getObservacoesLv() == null) continue;
                dados.add(r.getObservacoesLv());
            }
        }
        return dados;
    }

    private List getObsNotasD500(List<RegD500> regD500) {
        ArrayList<Long> dados = new ArrayList<Long>();
        for (RegD500 o : regD500) {
            RegD500 reg = o;
            if (reg.getLivrosFiscais() == null) continue;
            for (RegD590 ob : reg.getLivrosFiscais()) {
                RegD590 r = ob;
                if (r.getObservacoesLv() == null) continue;
                dados.add(r.getObservacoesLv());
            }
        }
        return dados;
    }
}

