/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao006;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.spedfiscal.EnumConstSpedFiscalTpPropEstoque;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Ctrc;
import com.touchcomp.basementor.model.vo.CtrcCargaTransportada;
import com.touchcomp.basementor.model.vo.CtrcColetaEntrega;
import com.touchcomp.basementor.model.vo.CtrcComplConhecimento;
import com.touchcomp.basementor.model.vo.CtrcDocumentosFiscais;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.InventarioSped;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LogProduto;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoEstNota;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.spedfiscal.exceptions.SpedWritterException;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg205;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg220;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg400;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg450;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg460;
import mentorcore.service.impl.spedfiscal.versao006.model2.Reg500;
import mentorcore.service.impl.spedfiscal.versao006.model2.bloco1.Bloco1;
import mentorcore.service.impl.spedfiscal.versao006.model2.bloco1.Reg1600;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC110;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC111;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC112;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC113;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC114;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC140;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC141;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC170;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC195;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC197;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC300;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC310;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC320;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC321;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC400;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC405;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC410;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC420;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC425;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC460;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC470;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC490;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC500;
import mentorcore.service.impl.spedfiscal.versao006.model2.blococ.RegC590;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.BlocoD;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD100;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD130;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD160;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD161;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD162;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD190;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD195;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD197;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD500;
import mentorcore.service.impl.spedfiscal.versao006.model2.blocod.RegD590;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class SpedBDConsult006 {
    public List getAliquotasSTIncrito(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select new mentorcore.service.impl.spedfical.versao006.model.Reg0015(u.uf.sigla, u.inscricaoEstadual) from DadosFiscaisUF u  where u.inscritoEstado=:sim and u.empresa = :empresa");
        q.setShort("sim", (short)1);
        q.setEntity("empresa", (Object)emp);
        q.setMaxResults(1);
        return q.list();
    }

    public EmpresaContabilidade getEmpresaContabilidade(Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getEmpresaContabilidadeDAO().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.setMaxResults(1);
        return (EmpresaContabilidade)c.uniqueResult();
    }

    BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBloco011B0455(dataIn, dataFim, emp));
        this.getLivrosFiscaisNotasPropriasBloco011B0455(b.getRegistrosC100());
        b.setParticipantes(this.getParticipantesNotasFiscaisPropriasBloco011B0455(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotaPropriaBloco011b0455(dataIn, dataFim, emp));
        b.setNaturezaOperacao(this.getNatOperacaoNotaPropriaBloco011B0455(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaPropriaBloco011B0455(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasNotaPropriaBloco011B0455(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC100NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisTerceirosBloco011B0455(dataIn, dataFim, emp));
        this.getLivrosFiscaisNotasTerceirosBloco011B0455(b.getRegistrosC100());
        b.setParticipantes(this.getParticipantesNotasTerceirosBloco011B0455(dataIn, dataFim, emp));
        b.setObservacoes(this.getInfComplNotasTerceirosBloco011B0455(b.getRegistrosC100()));
        b.setProdutos(this.getProdutosNotaTerceirosBloco011b0455(dataIn, dataFim, emp));
        b.setNaturezaOperacao(this.getNatOperacaoNotaTerceirosBloco011B0455(dataIn, dataFim, emp));
        b.setPlanoContas(this.getPlanoContasNotaTerceirosBloco011B0455(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasNotaTerceirosBloco011B0455(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC300NotasProprias(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        BlocoC b = new BlocoC();
        b.setRegistrosC300(this.getNotasFiscaisPropriasBlocoC300(dataIn, dataFim, emp));
        b.setProdutos(this.getProdutosNotaPropriaBlocoC300(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasNotaPropriaBlocoC300(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC500NotasTerceiros(Date dataIn, Date dataFim, Empresa emp) {
        BlocoC b = new BlocoC();
        b.setRegistrosC500(this.getNotasFiscaisTerceirosBloco062928(dataIn, dataFim, emp));
        this.getLivrosFiscaisNotasTerceirosBloco062928(b.getRegistrosC500());
        b.setParticipantes(this.getParticipantesNotasTerceirosBloco062928(dataIn, dataFim, emp));
        return b;
    }

    BlocoC getBlocoC400CuponsFiscais(Empresa emp, Date dataIn, Date dataFim, char perfil) {
        BlocoC b = new BlocoC();
        b.setRegistrosC400(this.getEquipamentosFiscaisBlocoC400(dataIn, dataFim, emp));
        this.getReducoesZBlocoC405(b.getRegistrosC400(), dataIn, dataFim, emp, perfil);
        b.setProdutos(this.getProdutosCuponsFiscaisBlocoC400(dataIn, dataFim, emp));
        b.setUnidMedidas(this.getUnidMedidasCuponsFiscaisBlocoC400(dataIn, dataFim, emp));
        return b;
    }

    BlocoD getBlocoD100NotasTerceirosTransporte(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getNotasFiscaisTerceirosTransporteD100(dataIn, dataFim, emp));
        this.getLivrosFiscaisNotasTerceirosD100(b.getRegistrosD100());
        b.setParticipantes(this.getParticipantesNotasTerceirosTransporteD100(dataIn, dataFim, emp));
        return b;
    }

    BlocoD getBlocoD100ConhecimentosSaidaTransporte(Empresa emp, Date dataIn, Date dataFim) {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getConhecimentosSaidaTransporteD100(dataIn, dataFim, emp));
        this.getLivrosFiscaisConhecimentosSaidaD100(b.getRegistrosD100());
        b.setParticipantes(this.getParticipantesConhecimentosSaidaTransporteD100(dataIn, dataFim, emp));
        b.setObsLancFiscal(new ArrayList<Reg460>());
        return b;
    }

    BlocoD getBlocoD500NotasTerceirosTelecomunicacao(Date dataIn, Date dataFim, Empresa emp) {
        BlocoD b = new BlocoD();
        b.setRegistrosD500(this.getNotasTerceirosTelecomD500(dataIn, dataFim, emp));
        this.getLivrosFiscaisNotasTerceirosTelecomD500(b.getRegistrosD500());
        b.setParticipantes(this.getParticipantesNotasTerceirosTelecomD500(dataIn, dataFim, emp));
        return b;
    }

    private List<RegC400> getEquipamentosFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c.modeloDocFiscal.codigo as codModDocFiscal, c.cupom.impressoraFiscal.modeloEcf as modeloImpressora, c.cupom.impressoraFiscal.serie as serieImpressora, c.cupom.impressoraFiscal.identificador as idImpressora from CupomFiscal c where c.cupom.dataEmissao between :dataIn and :dataFim  and (c.modeloDocFiscal.codigo = :cod1 or c.modeloDocFiscal.codigo = :cod2) and c.cupom.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC400> toRet = new ArrayList<RegC400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC400 r = new RegC400();
            r.setModeloDocFiscal((String)h.get("codModDocFiscal"));
            r.setModeloECF((String)h.get("modeloImpressora"));
            r.setSerieECF((String)h.get("serieImpressora"));
            r.setIdImpressora((Long)h.get("idImpressora"));
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesNotasFiscaisPropriasBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      p.identificador                     as idPessoa,     p.endereco.numero                   as numero,     p.endereco.logradouro               as logradouro,     p.endereco.complemento              as complemento,     p.endereco.bairro                   as bairro,     p.complemento.cnpj                  as cnpj,     p.complemento.inscEst               as inscEst,     p.complemento.suframa               as suframa,     p.nome                              as nome,     p.endereco.cidade.uf.pais.codIbge   as codPais,     p.endereco.cidade.uf.codIbge        as codUf,     p.endereco.cidade.codIbge           as codCidade from NotaFiscalPropria n inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa p where     (   n.modeloDocFiscal.codigo=:cod1      or n.modeloDocFiscal.codigo=:cod2      or n.modeloDocFiscal.codigo=:cod3      or n.modeloDocFiscal.codigo=:cod4      )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (  n.situacaoDocumento.codigo = :codSitDoc1         or n.situacaoDocumento.codigo = :codSitDoc2         or n.situacaoDocumento.codigo = :codSitDoc3         or n.situacaoDocumento.codigo = :codSitDoc4         or n.situacaoDocumento.codigo = :codSitDoc5         )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesNotasTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getParticipantesNotasTerceirosBloco062928(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "06");
        q.setString("cod2", "28");
        q.setString("cod3", "29");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    List getNotasFiscaisPropriasBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida           as entSai,     n.modeloDocFiscal.codigo                  as codModFiscal,     n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa,     tf.opcao                                  as codTpFrete,     n.situacaoDocumento.codigo                as sitDoc,     n.serie                                   as serie,     n.numeroNota                              as numNota,     n.chaveNFE                                as chaveNfe,     n.dataEmissaoNota                         as dataEmissao,     n.dataEntradaSaida                        as dataEntSai,     n.valoresNfPropria.valorTotal             as valorTotal,     n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ,     cp.tpCondicao                             as tpCond,     n.valoresNfPropria.valorFrete             as vlrFrete,     n.valoresNfPropria.valorSeguro            as vlrSeguro,     n.valoresNfPropria.valorDesconto          as vlrDesconto,     n.valoresNfPropria.valorDespAcess         as vlrDespAcess,     n.valoresNfPropria.valorIcmsTributado     as bcIcms,     n.valoresNfPropria.valorIcms              as vlrIcms,     n.valoresNfPropria.valorIcmsSt            as vlrIcmsSt,     n.valoresNfPropria.bcIcmsSt               as bcIcmsSt,     n.valoresNfPropria.valorIpiIndustria      as vlrIpi,     n.valoresNfPropria.valorPis               as vlrPis,     n.valoresNfPropria.valorCofins            as vlrCofins,     n.valoresNfPropria.valorCofinsSt          as vlrCofinsST,     n.valoresNfPropria.valorPisSt             as vlrPisST,     n.identificador                           as identificador from NotaFiscalPropria n  left join n.dadosTransNfPropria.tipoFrete tf left join n.condicaoPagamento cp where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(((Short)h.get("entSai")).shortValue());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            if (!this.isDocCancelado(r.getCodSituacaoDoc()) && (r.getCodModDocFiscal().equals("01") || r.getCodModDocFiscal().equals("1B") || r.getCodModDocFiscal().equals("04"))) {
                this.getItensDocumentoNotaPropria(r);
            }
            toRet.add(r);
        }
        return toRet;
    }

    List getNotasFiscaisPropriasBlocoC300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select      n.modeloDocFiscal.codigo            as codModFiscal,     n.serie                             as serie,     n.numeroNota                        as numeroNota,     n.dataEmissaoNota                   as dataEmissao,     sum(n.valoresNfPropria.valorTotal)  as valorTotal,     sum(n.valoresNfPropria.valorPis)    as valorPis,     sum(n.valoresNfPropria.valorCofins) as valorCofins from NotaFiscalPropria n  where       n.modeloDocFiscal.codigo=:cod1  and n.dataEmissaoNota between :dataIn and :dataFim  and n.empresa=:empresa group by      n.modeloDocFiscal.codigo,     n.serie,     n.dataEmissaoNota,      n.numeroNota");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC300> toRet = new ArrayList<RegC300>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC300 r = new RegC300();
            r.setCodModeloDocFiscal((String)h.get("codModFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocInicial((Integer)h.get("numeroNota"));
            r.setNumDocFinal((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorCofins((Double)h.get("valorCofins"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setRegistrosC310(this.getRegistrosC310(r.getDataEmissao(), emp));
            r.setRegistrosC320(this.getRegistrosC320(r.getDataEmissao(), r.getNumDocInicial(), emp));
            r.setRegistrosC321(this.getRegistrosC321(r.getDataEmissao(), r.getNumDocInicial(), emp));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC310> getRegistrosC310(Date dataEmissao, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.numeroNota as numeroNota from NotaFiscalPropria n  where          n.modeloDocFiscal.codigo=:cod1     and n.situacaoDocumento.codigo = :codSitDoc     and n.dataEmissaoNota  = :data     and n.empresa=:empresa");
        q.setString("cod1", "02");
        q.setString("codSitDoc", "02");
        q.setDate("data", dataEmissao);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC310> toRet = new ArrayList<RegC310>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC310 r = new RegC310();
            r.setNumDocCanc((Integer)h.get("numeroNota"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC320> getRegistrosC320(Date dataEmissao, Integer numeroNota, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  lv.incidenciaIcms.codigo   as incidenciaIcms,      lv.cfop.codigo             as cfop,     lv.aliquotaIcms            as aliquotaIcms,     sum(lv.valorTotal)         as valorTotal,     sum(lv.valorIcmsTributado) as valorIcmsTributado,      sum(lv.valorIcms)          as valorIcms,     sum(lv.vrNaoTribIcms)      as valorNaoTribIcms  from NotaFiscalPropria n inner join n.livrosFiscais lv where        n.dataEmissaoNota = :data   and n.empresa         = :empresa   and n.numeroNota      = :numeroNota group by      lv.incidenciaIcms.codigo,      lv.cfop.codigo,     lv.aliquotaIcms");
        q.setDate("data", dataEmissao);
        q.setEntity("empresa", (Object)emp);
        q.setInteger("numeroNota", numeroNota.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC320> toRet = new ArrayList<RegC320>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC320 r = new RegC320();
            r.setCodIncidenciaIcms((String)h.get("incidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorBCIcms((Double)h.get("valorIcmsTributado"));
            r.setValorIcms((Double)h.get("valorIcms"));
            r.setValorNaoTributado((Double)h.get("valorNaoTribIcms"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegC321> getRegistrosC321(Date dataEmissao, Integer numerNota, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("select      p.id_produto                as ID_PRODUTO,     um.sigla                    as SIGLA,     sum(g.quantidade)           as QTDE,     sum(i.valor_desconto)       as VR_DESCONTO,     sum(ilv.vr_total)           as VR_TOTAL,     sum(ilv.vr_pis)             as VR_PIS,     sum(ilv.vr_cofins)          as VR_COFINS,     sum(ilv.vr_icms)            as VR_ICMS,     sum(ilv.VR_icms_tributado)  as VR_BC_ICMS from ITEM_NOTA_PROPRIA i inner join item_nota_livro_fiscal  ilv on (i.ID_ITEM_NOTA_PROPRIA        = ilv.ID_ITEM_NOTA_FISCAL_PROPRIA) inner join nota_propria              c on (i.ID_NOTA_FISCAL_PROPRIA      = c.ID_NOTA_PROPRIA) inner join situacao_documento        s on (s.id_situacao_documento       = c.id_situacao_documento) inner join produto                   p on (p.id_produto                  = i.id_produto) inner join GRADE_ITEM_NOTA_PROPRIA   g on (g.ID_ITEM_NOTA_FISCAL_PROPRIA = i.ID_ITEM_NOTA_PROPRIA) inner join unidade_medida           um on (um.id_unidade_medida          = i.id_unidade_medida) where         c.data_emissao = :data      and c.id_empresa = :empresa     and c.numero_Nota = :numero group by     p.id_produto,     um.sigla;");
        q.setDate("data", dataEmissao);
        q.setInteger("empresa", emp.getIdentificador().intValue());
        q.setInteger("numero", numerNota.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC321> toRet = new ArrayList<RegC321>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC321 r = new RegC321();
            r.setCodProduto(((Integer)h.get("ID_PRODUTO")).longValue());
            r.setUnidMedida((String)h.get("SIGLA"));
            r.setQuantidade(((BigDecimal)h.get("QTDE")).doubleValue());
            r.setValorItem(((BigDecimal)h.get("VR_TOTAL")).doubleValue());
            r.setValorDesconto(((BigDecimal)h.get("VR_DESCONTO")).doubleValue());
            r.setValorBCIcms(((BigDecimal)h.get("VR_BC_ICMS")).doubleValue());
            r.setValorIcms(((BigDecimal)h.get("VR_ICMS")).doubleValue());
            r.setValorPis(((BigDecimal)h.get("VR_PIS")).doubleValue());
            r.setValorCofins(((BigDecimal)h.get("VR_COFINS")).doubleValue());
            toRet.add(r);
        }
        return toRet;
    }

    List getNotasFiscaisTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select 0 as entSai, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, tf.opcao as codTpFrete, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, cp.tpCondicao as tpCond, n.valoresNfTerceiros.valorFrete as vlrFrete, n.valoresNfTerceiros.valorSeguro as vlrSeguro, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorIpiIndustria as vlrIpi, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, n.valoresNfTerceiros.valorCofinsST as vlrCofinsST, n.valoresNfTerceiros.valorPisSt as vlrPisST,  n.identificador as identificador, cp.entrada as efetuaEntrada, cp.numeroParcelas as numeroParcelas from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.condicoesPagamento cp where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Terceiros: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setEfetuaEntrada((Integer)h.get("efetuaEntrada"));
            r.setNumParcelas((Integer)h.get("numeroParcelas"));
            if (!this.isDocCancelado(r.getCodSituacaoDoc())) {
                this.getInformacoesComplementares(r);
                this.getFatura(r);
                this.getItensDocumento(r);
            }
            toRet.add(r);
        }
        return toRet;
    }

    List getNotasFiscaisTerceirosBloco062928(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select 0 as entSai, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModFiscal, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as valorDesconto, n.valoresNfTerceiros.valorDespAcess as valorDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorIcmsSt as vlrIcmsSt, n.valoresNfTerceiros.bcIcmsSt as bcIcmsSt, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, t.codigo as tipoLigacao, g.codigo as grupoTensao, tc.codigo as tipoConsumoEnergia, n.identificador as identificador from NotaFiscalTerceiros n left join n.tipoLigacaoEnergia t left join n.grupoTensaoEnergia g left join n.tipoConsumoEnergia tc  where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "06");
        q.setString("cod2", "29");
        q.setString("cod3", "28");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC500> toRet = new ArrayList<RegC500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC500 r = new RegC500();
            r.setEntSaiNatOP((Integer)h.get("entSai"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setSerie((String)h.get("serie"));
            r.setCodConsumoEnergia((String)h.get("codConsumoEnergia"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(1);
            r.setNumeroDoc((Integer)h.get("numNota"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorDespAcessorias((Double)h.get("valorDespAcess"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setTipoLigacao((String)h.get("tipoLigacao"));
            r.setGrupoTensao((String)h.get("grupoTensao"));
            r.setIdentificador((Long)h.get("identificador"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            toRet.add(r);
        }
        return toRet;
    }

    List getAlteracoesParticipante(Long idPessoa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogPessoa l where l.pessoa.identificador=:idPessoa and l.dataAlteracao  between :dataIn and :dataFim");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        return q.list();
    }

    private LogProduto salvarAtualizarLogProduto(LogProduto l) throws ExceptionDatabase {
        return (LogProduto)CoreDAOFactory.getInstance().getDAOLogProduto().saveOrUpdate(l);
    }

    List getMovimentoCiap(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getDAODepreciacaoCiap().getVOClass());
        c.add(Restrictions.between((String)"periodo", (Object)dataIn, (Object)dataFim));
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        return c.list();
    }

    public List getSaldoTodosProdutos(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil) throws ExceptionService, SpedWritterException {
        List result = this.findSaldoTodosProdutosProprio(dataInventario, empresa, contabil);
        result.addAll(this.findSaldoTodosProdutosPoderInformante(dataInventario, empresa, contabil));
        result.addAll(this.findSaldoTodosProdutosPoderTerceiros(dataInventario, empresa, contabil));
        return result;
    }

    private List findSaldoTodosProdutosProprio(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil) throws ExceptionService {
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoProdutoLista(null, null, dataInventario, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        ArrayList<InventarioSped> dados = new ArrayList<InventarioSped>();
        Iterator<SaldoEstoqueGeral> iterator = saldos.iterator();
        while (iterator.hasNext()) {
            SaldoEstoqueGeral o;
            SaldoEstoqueGeral h = o = iterator.next();
            InventarioSped r = new InventarioSped();
            Produto p = h.getProduto();
            r.setProduto(p);
            r.setQuantidade(h.getQuantidade());
            r.setVlrItem(h.getValor());
            r.setVlrUnitario(h.getValorMedio());
            r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.ESTOQUE_PROPRIO_0.getValue()));
            r.setPlanoConta(contabil.getPlanoContaEstProprio());
            dados.add(r);
        }
        return dados;
    }

    private List findSaldoTodosProdutosTerc(Date dataInventario, Empresa empresa, int tpEstoque, EmpresaContabilidade contabil) throws ExceptionService, SpedWritterException {
        Session s = CoreBdUtil.getInstance().getSession();
        String sql = "select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, ip.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria inner join item_nota_propria ip on ip.id_item_nota_propria = gip.id_item_nota_fiscal_propria group by s.id_pessoa, ip.id_produto  union all  select sum(s.qtd_saldo) as sum_quantidade,  sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as sum_valor,  cast(cast(sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as numeric(12,2))  / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, it.id_produto as id_produto  from saldo_estoque_terceiros_2014(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0, 99999) s  inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros inner join item_nota_terceiros it on it.id_item_nota_terceiros = git.id_item_nota_terceiros group by s.id_pessoa, it.id_produto";
        NativeQuery q = s.createSQLQuery(sql);
        q.setDate("dataInventario", dataInventario);
        q.setEntity("empresa", (Object)empresa);
        q.setInteger("tipoEstoque", tpEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List prod = q.list();
        ArrayList<InventarioSped> dados = new ArrayList<InventarioSped>();
        for (Object o : prod) {
            HashMap h = (HashMap)o;
            InventarioSped r = new InventarioSped();
            Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getProdutoDAO(), ((Integer)h.get("ID_PRODUTO")).longValue());
            r.setProduto(produto);
            r.setQuantidade(Double.valueOf(((BigDecimal)h.get("SUM_QUANTIDADE")).doubleValue()));
            r.setVlrItem(Double.valueOf(((BigDecimal)h.get("SUM_VALOR")).doubleValue()));
            r.setVlrUnitario(Double.valueOf(((BigDecimal)h.get("VALOR_MEDIO")).doubleValue()));
            if (tpEstoque == 6) {
                if (contabil.getPlanoContaEstTercOutros() == null) {
                    throw new SpedWritterException("Primeiro cadastre uma Conta Cont\u00e1bil de Estoque de Terceiros de outros em meu poder.");
                }
                r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_MEU_PODER_2.getValue()));
                r.setPlanoConta(contabil.getPlanoContaEstTercOutros());
            } else {
                if (contabil.getPlanoContaEstTercMeu() == null) {
                    throw new SpedWritterException("Primeiro cadastre uma Conta Cont\u00e1bil de Estoque de Terceiros meu em poder dos outros.");
                }
                r.setIndicadorPropriedade(Short.valueOf(EnumConstSpedFiscalTpPropEstoque.EST_TERCEIROS_EM_PODER_TERCEIROS_1.getValue()));
                r.setPlanoConta(contabil.getPlanoContaEstTercMeu());
            }
            Pessoa p = (Pessoa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPessoa(), ((Integer)h.get("ID_PESSOA")).longValue());
            r.setPessoa(p);
            dados.add(r);
        }
        return dados;
    }

    private List findSaldoTodosProdutosPoderInformante(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 2, contabil);
    }

    public List findSaldoTodosProdutosPoderTerceiros(Date dataInventario, Empresa empresa, EmpresaContabilidade contabil) throws ExceptionService, SpedWritterException {
        return this.findSaldoTodosProdutosTerc(dataInventario, empresa, 6, contabil);
    }

    Double getSaldoIcmsPeriodoAnt(Date periodo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum((db.vlrTotIcms +  db.vlrTotIcmsSt +  db.vlrTotIcmsFrete +  db.vlrTotIcmsDifAliq)),0) from DepreciacaoCiap db where db.periodo=(select max (d1.periodo) from DepreciacaoCiap d1 where d1.periodo<:periodo)");
        q.setDate("periodo", periodo);
        Double valorCiap = (Double)q.uniqueResult();
        return (double)valorCiap;
    }

    private List getNotasFiscaisTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, tc.codigo as codigoTipoCte, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, tf.opcao as codTpFrete, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.tipoCte tc where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc(((Integer)h.get("numNota")).longValue());
            System.out.println("Nr Nota Terceiros de Transporte: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            if ((Short)h.get("codigoTipoCte") != null) {
                r.setCodTipoCTe(((Short)h.get("codigoTipoCte")).toString());
            }
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("codTpFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Long pc = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(pc);
            toRet.add(r);
        }
        return toRet;
    }

    List getNotasTerceirosTelecomD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, n.valoresNfTerceiros.valorDespAcess as vlrDespAcess, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms, n.valoresNfTerceiros.valorPis as vlrPis, n.valoresNfTerceiros.valorCofins as vlrCofins, t.codigo as codTipoAssinante from NotaFiscalTerceiros n left join n.tipoAssinanteTelefone t where (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2) and  n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD500> toRet = new ArrayList<RegD500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD500 r = new RegD500();
            r.setIdentificador((Long)h.get("identificador"));
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Terceiros Telecomunicacao: " + r.getNumeroDoc().toString());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setSerie((String)h.get("serie"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            r.setCodTipoAssinante((String)h.get("codTipoAssinante"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Long idPlanoConta = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(idPlanoConta);
            toRet.add(r);
        }
        return toRet;
    }

    List getApuracoesIcms(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoICMS p where p.anoMes between :dataIn and :dataFim and p.tipoApuracao=:tp and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tp", (short)0);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    List getApuracoesIcmsST(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoICMS p where p.anoMes between :dataIn and :dataFim and p.empresa=:empresa and p.tipoApuracao=:tp");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tp", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    List getApuracoesIpi(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ApuracaoIPI p where p.dataFinal between :dataIn and :dataFim and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    List getInutilizacoesNFe(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from InutilizacaoNumeracaoNFe p where p.periodo between :dataIn and :dataFim and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        return q.list();
    }

    private List getConhecimentosSaidaTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.identificador as identificador, c.modeloDocFiscal.codigo as codModDocFiscal, c.situacaoDocumento.codigo as sitDoc, c.clienteTomador.cliente.pessoa.identificador as idPessoa, c.serie as serie, c.numero as numeroCte, c.chaveCte as chaveCte, c.dataEmissao as dataEmissao, tc.codigo as codTipoCte, c.indicadorTipoFrete as indTipoFrete, c.cteVlrImpostos.baseCalcIcms as bcIcms, c.cteVlrImpostos.vrIcms as vrIcms, c.cteVlrImpostos.percRedBaseCalcIcms as vrNaoTributado, c.cteVlrImpostos.vrReceber as valorTotal, c.cteVlrImpostos.vrDesconto as valorDesconto, lv.planoConta.identificador as planoConta from Cte c  left join c.tipoCte tc left join c.livrosFiscais lv where  (c.modeloDocFiscal.codigo=:cod1 or c.modeloDocFiscal.codigo=:cod2) and c.dataEmissao between :dataIn and :dataFim and c.empresa=:empresa");
        q.setString("cod1", "57");
        q.setString("cod2", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc((Long)h.get("numeroCte"));
            System.out.println("\n\nNr CTRC: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveCte"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModDocFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEmissao"));
            Short tipo = (Short)h.get("codTipoCte");
            if (tipo != null) {
                r.setCodTipoCTe(tipo.toString());
            }
            if ((Short)h.get("indTipoFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("indTipoFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((double)((Double)h.get("bcIcms")));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setValorICMS((double)((Double)h.get("vrIcms")));
            r.setValorDoc((double)((Double)h.get("valorTotal")));
            r.setValorTotMercadorias((double)((Double)h.get("valorTotal")));
            r.setIdentificador((Long)h.get("identificador"));
            Long planoConta = (Long)h.get("planoConta");
            r.setPlanoConta(planoConta);
            if (r.getCodModDocFiscal().equals("08")) {
                r.setRegistrosD130(this.getComplConhecimentos(r.getIdentificador()));
                r.setRegistrosD160(this.getCargaTransportada(r.getIdentificador()));
            }
            toRet.add(r);
        }
        return toRet;
    }

    List getReducoesZBlocoC3(Empresa emp, Date dataIn, Date dataFim, Long idImpressora) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ReducaoZ p where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa and p.impressoraFiscal.identificador = :idImpressora");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setLong("idImpressora", idImpressora.longValue());
        List ret = q.list();
        return ret;
    }

    public List getResumoItensRegC420_Teste(Date dataReducao, Long idImpressora, Empresa emp, String tribItem, BigDecimal aliquotaICMS) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("select p.id_produto as ID_PRODUTO, um.sigla as SIGLA, sum(g.quantidade) as QTDE, sum(i.valor_total) as VALOR, sum(i.vlr_pis) as VR_PIS, sum(i.vlr_cofins) as VR_COFINS  from item_cupom_fiscal i  inner join item_estnota ie on i.id_item_cp_fiscal =  ie.id_item_estnota  inner join estnota e on ie.id_estnota = e.id_estnota  inner join cupom_fiscal c on e.id_estnota = c.id_cupom_fiscal  inner join tipo_tributacao_item_cp_f t on i.id_tipo_tributacao_item_cp_f = t.id_tipo_tributacao_item_cp_f  inner join produto p on p.id_produto = ie.id_produto  inner join grade_item_estnota g on g.id_item_estnota = ie.id_item_estnota  inner join unidade_medida um on um.id_unidade_medida = p.id_unidade_medida  where c.id_impressora_fiscal = :impressora  and e.data_emissao = :dataReducao  and e.id_empresa = :empresa  and t.sigla = :sigla and c.cancelado = :cancelado and i.cancelado = :cancelado and i.aliquota_icms = :aliquotaICMS group by p.id_produto, um.sigla;");
        q.setDate("dataReducao", dataReducao);
        q.setLong("impressora", idImpressora.longValue());
        q.setLong("empresa", emp.getIdentificador().longValue());
        q.setString("sigla", tribItem);
        q.setInteger("cancelado", 0);
        q.setBigDecimal("aliquotaICMS", aliquotaICMS);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC425> dados = new ArrayList<RegC425>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC425 r = new RegC425();
            r.setIdProduto(((Integer)h.get("ID_PRODUTO")).longValue());
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setQuantidade(((BigDecimal)h.get("QTDE")).doubleValue());
            r.setValorTotal(((BigDecimal)h.get("VALOR")).doubleValue());
            if ((BigDecimal)h.get("VR_PIS") != null) {
                r.setValorPis(((BigDecimal)h.get("VR_PIS")).doubleValue());
            } else {
                r.setValorPis(0.0);
            }
            if ((BigDecimal)h.get("VR_COFINS") != null) {
                r.setValorCofins(((BigDecimal)h.get("VR_COFINS")).doubleValue());
            } else {
                r.setValorCofins(0.0);
            }
            dados.add(r);
        }
        return dados;
    }

    public List getResumoItensRegC420(Date dataReducao, Long idImpressora, Empresa emp, String tribItem, Double aliquotaICMS) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.identificador as ID_PRODUTO, p.unidadeMedida.sigla as SIGLA, sum(g.quantidade) as QTDE, sum(i.valorTotal) as VALOR, sum(i.vrPis) as VR_PIS, sum(i.vrCofins) as VR_COFINS  from ItemCupomFiscal i  inner join i.produto p inner join i.grade g  where i.cupomFiscal.impressoraFiscal.identificador = :impressora  and i.cupomFiscal.cupom.dataEmissao = :dataReducao  and i.cupomFiscal.cupom.empresa = :empresa  and i.tipoTributacaoItemCPFiscal.sigla = :sigla and i.cupomFiscal.cancelado = :cancelado and i.cancelado = :cancelado and i.aliquotaICMS = :aliquotaICMS group by p.identificador, p.unidadeMedida.sigla");
        q.setDate("dataReducao", dataReducao);
        q.setLong("impressora", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setString("sigla", tribItem);
        q.setInteger("cancelado", 0);
        q.setDouble("aliquotaICMS", aliquotaICMS.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC425> dados = new ArrayList<RegC425>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC425 r = new RegC425();
            r.setIdProduto((long)((Long)h.get("ID_PRODUTO")));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setQuantidade((double)((Double)h.get("QTDE")));
            r.setValorTotal((double)((Double)h.get("VALOR")));
            if ((Double)h.get("VR_PIS") != null) {
                r.setValorPis((double)((Double)h.get("VR_PIS")));
            } else {
                r.setValorPis(0.0);
            }
            if ((Double)h.get("VR_COFINS") != null) {
                r.setValorCofins((double)((Double)h.get("VR_COFINS")));
            } else {
                r.setValorCofins(0.0);
            }
            dados.add(r);
        }
        return dados;
    }

    private void getLivrosFiscaisNotasPropriasBloco011B0455(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select      distinct lv  from NotaFiscalPropria n inner join n.livrosFiscais lv where      n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regC100.setRegC190(this.getRegC190(ret));
        }
    }

    private List getRegC190(List livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (Object ob : livrosFiscais) {
            LivroFiscal h = (LivroFiscal)ob;
            RegC190 r = this.getRegC190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            if (r == null) {
                r = new RegC190();
                toRet.add(r);
            }
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setBcCalculoIcmsSt(h.getValorBCIcmsSt() + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(h.getValorIcmsSt() + r.getValorIcmsST());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setValorIpi(h.getValorIpiIndustria() + h.getValorIpiComercio() + r.getValorIpi());
            r.setRegC195(this.getRegC195(r.getRegC195(), h.getObsLivroFiscal()));
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasTerceirosBloco011B0455(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select distinct lv from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regC100.setRegC190(this.getRegC190(ret));
        }
    }

    private void getLivrosFiscaisNotasTerceirosBloco062928(List<RegC500> registrosC500) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC500> iterator = registrosC500.iterator();
        while (iterator.hasNext()) {
            RegC500 o;
            RegC500 regC500 = o = iterator.next();
            Long idNota = regC500.getIdentificador();
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms, sum(lv.valorBCIcmsSt) as valorBCIcmsSt, sum(lv.valorIcmsSt) as valorIcmsSt, sum(lv.vrNaoTribIcms) as valorNaoTribIcms, obs.obsFaturamento.identificador as obsLivroFiscal from NotaFiscalTerceiros n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idNota group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms, obs.obsFaturamento.identificador");
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC590> toRet = new ArrayList<RegC590>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC590 r = new RegC590();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setBcCalculoIcmsSt((Double)h.get("valorBCIcmsSt"));
                r.setValorIcmsST((Double)h.get("valorIcmsSt"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
                toRet.add(r);
            }
            regC500.setRegC590(toRet);
        }
    }

    private boolean isDocCancelado(String sitDoc) {
        boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
        return docCancInut;
    }

    private void getInformacoesComplementares(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        Query q = s.createQuery("select n.observacoesIntFisco as obsIntFisco  from NotaFiscalTerceiros n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ObservacaoIntFiscoNFTerceiros> obsIntFisco = new ArrayList<ObservacaoIntFiscoNFTerceiros>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoIntFiscoNFTerceiros obs = (ObservacaoIntFiscoNFTerceiros)h.get("obsIntFisco");
            obsIntFisco.add(obs);
        }
        q = s.createQuery("select n.observacaoNotaTerceiros as obsEstNota from NotaFiscalTerceiros n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        ArrayList<ObservacaoNotaTerceiros> obsEstNota = new ArrayList<ObservacaoNotaTerceiros>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoNotaTerceiros obs = (ObservacaoNotaTerceiros)h.get("obsEstNota");
            obsEstNota.add(obs);
        }
        if (!obsIntFisco.isEmpty() || !obsEstNota.isEmpty()) {
            RegC110 r = new RegC110();
            r.setObsIntFiscoNFTerceiros(obsIntFisco);
            r.setObsNotaTerceiros(obsEstNota);
            toRet.add(r);
        }
        regC100.setRegC110(toRet);
        if (!regC100.getRegC110().isEmpty()) {
            this.getProcessosReferenciados(regC100);
            this.getDocArrecadacaoReferenciados(regC100);
            this.getDocFiscalReferenciados(regC100);
            this.getCuponsReferenciados(regC100);
        }
    }

    private List getInfComplNotasTerceirosBloco011B0455(List<RegC100> regC100) {
        ArrayList<Reg450> toRet = new ArrayList<Reg450>();
        for (RegC100 o : regC100) {
            Reg450 reg450;
            RegC100 r = o;
            if (r.getRegC110() == null || r.getRegC110().isEmpty()) continue;
            RegC110 regC110 = r.getRegC110().get(0);
            Iterator<ObservacaoEstNota> iterator = regC110.getObsEstNota().iterator();
            while (iterator.hasNext()) {
                ObservacaoEstNota observacaoEstNota;
                ObservacaoEstNota obsEstNota = observacaoEstNota = iterator.next();
                reg450 = new Reg450();
                reg450.setIdObservacao(obsEstNota.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsEstNota.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
            for (ObservacaoEstNota observacaoEstNota : regC110.getObsIntFisco()) {
                ObservacaoIntFiscalNotaFiscalPropria obsIntFisco = (ObservacaoIntFiscalNotaFiscalPropria)observacaoEstNota;
                reg450 = new Reg450();
                reg450.setIdObservacao(obsIntFisco.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsIntFisco.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
        }
        return toRet;
    }

    private void getProcessosReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalTerceiros n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        regC100.setRegC111(toRet);
    }

    private void getDocArrecadacaoReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.tipoDocArrecadacao.codigo as codDocArrecadacao, p.unidadeFederativa.sigla as uf, p.numeroDocumento as nrDoc, p.codigoAutenticacaoBanc as codAutBanco, p.valorDocArrecadacao as valorDocArrecadacao, p.dataVencimento as dataVencimento, p.dataPagamento as dataPagamento from NotaFiscalTerceiros n inner join n.docArrecadacaoReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC112> toRet = new ArrayList<RegC112>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC112 r = new RegC112();
            r.setCodigoProc((Short)h.get("codDocArrecadacao"));
            r.setUf((String)h.get("uf"));
            r.setNrDocArrecadacao((String)h.get("nrDoc"));
            r.setCodAutenticacao((String)h.get("codAutBanco"));
            r.setValorDoc((Double)h.get("valorDocArrecadacao"));
            r.setDataPagamento((Date)h.get("dataPagamento"));
            r.setDataVencimento((Date)h.get("dataVencimento"));
            toRet.add(r);
        }
        regC100.setRegC112(toRet);
    }

    private void getDocFiscalReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalTerceiros n inner join n.notaReferenciada p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            Long idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasPropriasReferenciadas(idNotaRef));
        }
        regC100.setRegC113(toRet);
    }

    private List getNotasPropriasReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida                      as entSai,     n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                         as codModeloDocFiscal,     n.serie                                          as serie,     n.numeroNota                                     as numeroNota,     n.dataEmissaoNota                                as dataEmissao from NotaFiscalPropria n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((Short)h.get("entSai"));
            r.setIndicadorEmitente((short)0);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getNotasTerceirosReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.modeloDocFiscal.codigo as codModeloDocFiscal, n.serie as serie, n.numeroNota as numeroNota, n.dataEmissao as dataEmissao from NotaFiscalTerceiros n where n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((short)0);
            r.setIndicadorEmitente((short)1);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getCuponsReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.cupomFiscal.modeloDocFiscal.codigo as modDocFiscal, p.cupomFiscal.cupom.impressoraFiscal.serie as serie, p.cupomFiscal.cupom.nrCOO as nrSeq, p.cupomFiscal.cupom.impressoraFiscal.nrSequencialEcf as nrCaixa, p.cupomFiscal.cupom.dataEmissao as dataEmissao from NotaFiscalTerceiros n inner join n.cuponsReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC114> toRet = new ArrayList<RegC114>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC114 r = new RegC114();
            r.setCodModeloDocFiscal((String)h.get("modDocFiscal"));
            r.setNrSerieFabECF((String)h.get("serie"));
            r.setNrDocumento((Integer)h.get("nrSeq"));
            r.setNrCaixa((Short)h.get("nrCaixa"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        regC100.setRegC114(toRet);
    }

    private void getFatura(RegC100 regC100) {
        String codModDocFiscal = regC100.getCodModDocFiscal();
        Integer efetuaEntrada = regC100.getEfetuaEntrada();
        Integer numParcelas = regC100.getNumParcelas();
        if ((codModDocFiscal.equalsIgnoreCase("01") || codModDocFiscal.equalsIgnoreCase("1A")) && efetuaEntrada != null && efetuaEntrada != 1 && numParcelas != null && numParcelas != 1) {
            Session s = CoreBdUtil.getInstance().getSession();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select n.titulos as titulos from NotaFiscalTerceiros n where n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            Double valorTotalTit = 0.0;
            Integer tam = ret.size();
            ArrayList dadosTitulos = new ArrayList();
            for (Object o : ret) {
                Titulo t = (Titulo)o;
                valorTotalTit = valorTotalTit + t.getValor();
                HashMap<String, Comparable<Short>> h = new HashMap<String, Comparable<Short>>();
                h.put("numParcela", t.getNumParcTituloEstnota());
                h.put("dataVencimento", t.getDataVencimento());
                h.put("valorParcela", t.getValor());
                dadosTitulos.add(h);
            }
            RegC140 regC140 = new RegC140();
            regC140.setIndicadorEmitente((short)1);
            regC140.setIndicadorTipoTitulo("00");
            regC140.setNumeroTitulo(idNota);
            regC140.setNumeroParcelas(tam.shortValue());
            regC140.setValorTitulos(valorTotalTit);
            regC140.setRegC141(this.getVencimentoFatura(dadosTitulos));
            regC100.setRegC140(regC140);
        }
    }

    private List getVencimentoFatura(List dadosTitulos) {
        ArrayList<RegC141> toRet = new ArrayList<RegC141>();
        for (Object o : dadosTitulos) {
            HashMap h = (HashMap)o;
            RegC141 regC141 = new RegC141();
            regC141.setDataVencimento((Date)h.get("dataVencimento"));
            regC141.setValorTitulo((Double)h.get("valorParcela"));
            regC141.setNumParcela((Short)h.get("numParcela"));
            toRet.add(regC141);
        }
        return toRet;
    }

    private void getItensDocumento(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select distinct  p.produto.identificador as idProduto, p.numeroItem as numeroItem, p.produto.nome as nomeProduto, sum(g.quantidade) as quantidade, p.unidadeMedida.sigla as sigla, p.itemNotaLivroFiscal.valorTotal as valorTotal, p.valorDesconto as valorDesconto, g.movimentacaoFisica as movimentacaoFisica, p.incidenciaIcms.codigo as codIncidenciaIcms, p.itemNotaLivroFiscal.cfop.codigo as cfop, p.naturezaOperacao.identificador as idNatOperacao, p.itemNotaLivroFiscal.vrIcmsTributado as vrIcmsTrib, p.itemNotaLivroFiscal.aliquotaIcms as aliquotaIcms, p.itemNotaLivroFiscal.vrIcms as valorIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST as aliquotaIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt as valorIcmsSt, p.incidenciaIpi.codigo as codIncidenciaIpi, p.itemNotaLivroFiscal.vrIpiTributado as vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi as aliquotaIpi, p.itemNotaLivroFiscal.vrIpiIndustria as vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio as vrIpiComercio, p.incidenciaPisCofins.codigo as codIncidenciaPisCofins, (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,  p.itemNotaLivroFiscal.aliquotaPis as aliquotaPis, p.itemNotaLivroFiscal.vrPis as vrPis, p.itemNotaLivroFiscal.aliquotaCofins as aliquotaCofins, p.itemNotaLivroFiscal.vrCofins as vrCofins, p.planoContaCred.identificador as planoContaCred, p.planoContaDeb.identificador as planoContaDeb, p.naturezaOperacao.entradaSaida as natEntSaida from NotaFiscalTerceiros n inner join n.itemNotaTerceiros p left join p.grade g where n.identificador  = :idNota group by p.numeroItem, p.produto.identificador, p.produto.nome, p.unidadeMedida.sigla, p.itemNotaLivroFiscal.valorTotal, p.valorDesconto,  g.movimentacaoFisica, p.incidenciaIcms.codigo, p.itemNotaLivroFiscal.cfop.codigo, p.naturezaOperacao.identificador, p.itemNotaLivroFiscal.vrIcmsTributado, p.itemNotaLivroFiscal.vrIcms, p.itemNotaLivroFiscal.aliquotaIcms, p.itemNotaLivroFiscal.vrBcCalculoIcmsSt, p.itemNotaLivroFiscal.vrIcmsSt, p.itemNotaLivroFiscal.aliquotaIcmsST,p.incidenciaIpi.codigo, p.itemNotaLivroFiscal.vrIpiTributado, p.itemNotaLivroFiscal.aliquotaIpi,  p.itemNotaLivroFiscal.vrIpiIndustria, p.itemNotaLivroFiscal.vrIpiComercio, p.incidenciaPisCofins.codigo,  (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto), p.itemNotaLivroFiscal.aliquotaPis, p.itemNotaLivroFiscal.vrPis, p.itemNotaLivroFiscal.aliquotaCofins, p.itemNotaLivroFiscal.vrCofins, p.planoContaCred.identificador, p.planoContaDeb.identificador, p.naturezaOperacao.entradaSaida   ");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            if (h.get("quantidade") != null) {
                r.setQuantidade((Double)h.get("quantidade"));
            } else {
                r.setQuantidade(0.0);
            }
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            if (h.get("movimentacaoFisica") != null) {
                r.setMovimentacaoFisica((Short)h.get("movimentacaoFisica"));
            } else {
                r.setMovimentacaoFisica((short)1);
            }
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((Long)h.get("planoContaCred"));
            r.setPlanoDeb((Long)h.get("planoContaDeb"));
            toRet.add(r);
        }
        regC100.setRegC170(toRet);
    }

    private void getItensDocumentoNotaPropria(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select distinct      p.produto.identificador                 as idProduto,     p.numeroItem                            as numeroItem,     p.produto.nome                          as nomeProduto,     sum(g.quantidade)                       as quantidade,     p.unidadeMedida.sigla                   as sigla,     p.itemNotaLivroFiscal.valorTotal        as valorTotal,     p.valorDesconto                         as valorDesconto,     g.movimentacaoFisica                    as movimentacaoFisica,     p.incidenciaIcms.codigo                 as codIncidenciaIcms,     p.itemNotaLivroFiscal.cfop.codigo       as cfop,     p.notaFiscalPropria.naturezaOperacao.identificador        as idNatOperacao,     p.itemNotaLivroFiscal.vrIcmsTributado   as vrIcmsTrib,     p.itemNotaLivroFiscal.aliquotaIcms      as aliquotaIcms,     p.itemNotaLivroFiscal.vrIcms            as valorIcms,     p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt,     p.itemNotaLivroFiscal.aliquotaIcmsST    as aliquotaIcmsSt,     p.itemNotaLivroFiscal.vrIcmsSt          as valorIcmsSt,     p.incidenciaIpi.codigo                  as codIncidenciaIpi,     p.itemNotaLivroFiscal.vrIpiTributado    as vrIpiTributado,     p.itemNotaLivroFiscal.aliquotaIpi       as aliquotaIpi,     p.itemNotaLivroFiscal.vrIpiIndustria    as vrIpiIndustria,     p.itemNotaLivroFiscal.vrIpiComercio     as vrIpiComercio,     p.incidenciaPisCofins.codigo            as codIncidenciaPisCofins,     (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,     p.itemNotaLivroFiscal.aliquotaPis       as aliquotaPis,     p.itemNotaLivroFiscal.vrPis             as vrPis,     p.itemNotaLivroFiscal.aliquotaCofins    as aliquotaCofins,     p.itemNotaLivroFiscal.vrCofins          as vrCofins,     p.planoContaCred.identificador          as planoContaCred,     p.planoContaDeb.identificador           as planoContaDeb,     p.notaFiscalPropria.naturezaOperacao.entradaSaida         as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p inner join p.gradesNotaFiscalPropria g where     n.identificador  = :idNota group by     p.numeroItem,     p.produto.identificador,     p.produto.nome,     p.unidadeMedida.sigla,     p.itemNotaLivroFiscal.valorTotal,     p.valorDesconto,     g.movimentacaoFisica,     p.incidenciaIcms.codigo,     p.itemNotaLivroFiscal.cfop.codigo,     p.notaFiscalPropria.naturezaOperacao.identificador,     p.itemNotaLivroFiscal.vrIcmsTributado,     p.itemNotaLivroFiscal.vrIcms,     p.itemNotaLivroFiscal.aliquotaIcms,     p.itemNotaLivroFiscal.vrBcCalculoIcmsSt,     p.itemNotaLivroFiscal.vrIcmsSt,     p.itemNotaLivroFiscal.aliquotaIcmsST,     p.incidenciaIpi.codigo,     p.itemNotaLivroFiscal.vrIpiTributado,     p.itemNotaLivroFiscal.aliquotaIpi,     p.itemNotaLivroFiscal.vrIpiIndustria,     p.itemNotaLivroFiscal.vrIpiComercio,     p.incidenciaPisCofins.codigo,     (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto),     p.itemNotaLivroFiscal.aliquotaPis,     p.itemNotaLivroFiscal.vrPis,     p.itemNotaLivroFiscal.aliquotaCofins,     p.itemNotaLivroFiscal.vrCofins,     p.planoContaCred.identificador,     p.planoContaDeb.identificador,      p.notaFiscalPropria.naturezaOperacao.entradaSaida");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setMovimentacaoFisica((Short)h.get("movimentacaoFisica"));
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((Long)h.get("planoContaCred"));
            r.setPlanoDeb((Long)h.get("planoContaDeb"));
            toRet.add(r);
        }
        regC100.setRegC170(toRet);
    }

    private List<Reg200> getProdutosNotaTerceirosBloco011b0455(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.produto.identificador as idProduto, i.produto.nome as nomeProduto, i.produto.unidadeMedida.sigla as unidadeMedida, i.produto.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, i.produto.aliquotaIcms as aliquotaIcms from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i left join i.produto.ncm nc left join i.produto.genero g where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotaPropriaBloco011b0455(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      i.produto.identificador         as idProduto,     i.produto.nome                  as nomeProduto,     i.produto.unidadeMedida.sigla   as unidadeMedida,     i.produto.tipoIemSped.codigo    as codTipoItemSped,     nc.codigo                       as codNcm,     g.codigo                        as codGenero,     i.produto.aliquotaIcms          as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left  join i.produto.ncm nc left  join i.produto.genero g where      (   n.modeloDocFiscal.codigo=:cod1      or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3      )      and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa     and (  n.situacaoDocumento.codigo = :codSitDoc1         or n.situacaoDocumento.codigo = :codSitDoc2         or n.situacaoDocumento.codigo = :codSitDoc3         or n.situacaoDocumento.codigo = :codSitDoc4         or n.situacaoDocumento.codigo = :codSitDoc5         )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    public List getAlteracoesProduto(Long idProduto, Date dataIn, Date dataFim) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from LogProduto l where l.produto.identificador=:idProduto and l.dataFimUtilDesc  between :dataIn and :dataFim and l.identificador=(select max(lp.identificador) from LogProduto lp  where lp.produto.identificador=:idProduto and lp.dataFimUtilDesc between :dataIn and :dataFim)");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", DateUtil.previousDays(dataFim, 1));
        List ret = q.list();
        ArrayList<Reg205> toRet = new ArrayList<Reg205>();
        for (Object o : ret) {
            LogProduto l = (LogProduto)o;
            if (l.getDataFimUtilDesc() == null) {
                l.setDataFimUtilDesc(dataFim);
                l = this.salvarAtualizarLogProduto(l);
            }
            Reg205 r = new Reg205();
            r.setDescricaoAnterior(l.getConteudoAnterior());
            r.setDataInicial(l.getDataIniUtilDesc());
            r.setDataFinal(l.getDataFimUtilDesc());
            toRet.add(r);
        }
        return toRet;
    }

    public List<Reg220> getFatoresConversao(String unidadeMedida) {
        ArrayList<Reg220> toRet = new ArrayList<Reg220>();
        Reg220 r = new Reg220();
        r.setFatorConversao(1.0);
        r.setUnidadeMedida(unidadeMedida);
        toRet.add(r);
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotaTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.naturezaOperacao.identificador as idNatOperacao, i.naturezaOperacao.descricao as descNatOperacao from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg400> getNatOperacaoNotaPropriaBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     n.naturezaOperacao.identificador as idNatOperacao,     n.naturezaOperacao.descricao     as descNatOperacao from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (        n.situacaoDocumento.codigo = :codSitDoc1     or n.situacaoDocumento.codigo = :codSitDoc2     or n.situacaoDocumento.codigo = :codSitDoc3     or n.situacaoDocumento.codigo = :codSitDoc4     or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  i.planoContaDeb.identificador as idPlanoDeb, i.planoContaDeb.dataCadastro as dataCadastroDeb, i.planoContaDeb.marca as marcaDeb, i.planoContaDeb.codigo as codContaDeb, i.planoContaDeb.descricao as descricaoContaDeb, i.planoContaDeb.naturezaOperacaoPC.codigo as codNatPC from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaDeb = (Long)h.get("idPlanoDeb");
            if (idPlanoContaDeb == null || idPlanoContaDeb <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaDeb);
            r.setDataInclusao((Date)h.get("dataCadastroDeb"));
            r.setDescricao((String)h.get("descricaoContaDeb"));
            r.setMarca((Integer)h.get("marcaDeb"));
            r.setCodigo((String)h.get("codContaDeb"));
            r.setCodNatPC((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.planoContaCred.identificador  as idPlanoCred,     i.planoContaCred.dataCadastro   as dataCadastroCred,     i.planoContaCred.marca          as marcaCred,     i.planoContaCred.codigo         as codContaCred,     i.planoContaCred.descricao      as descricaoContaCred from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (         n.situacaoDocumento.codigo = :codSitDoc1      or n.situacaoDocumento.codigo = :codSitDoc2      or n.situacaoDocumento.codigo = :codSitDoc3      or n.situacaoDocumento.codigo = :codSitDoc4      or n.situacaoDocumento.codigo = :codSitDoc5      )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaTerceirosBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.unidadeMedida.identificador as idUnidMedida,  i.unidadeMedida.sigla as sigla, i.unidadeMedida.descricao as descricao, i.produto.unidadeMedida.identificador as idUnidMedidaProd, i.produto.unidadeMedida.sigla as siglaProd, i.produto.unidadeMedida.descricao as descricaoProd from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaPropriaBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.unidadeMedida.identificador           as idUnidMedida,     i.unidadeMedida.sigla                   as sigla,     i.unidadeMedida.descricao               as descricao,     i.produto.unidadeMedida.identificador   as idUnidMedidaProd,     i.produto.unidadeMedida.sigla           as siglaProd,     i.produto.unidadeMedida.descricao       as descricaoProd from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getReducoesZBlocoC405(List<RegC400> registrosC400, Date dataIn, Date dataFim, Empresa emp, char perfil) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC400> iterator = registrosC400.iterator();
        while (iterator.hasNext()) {
            RegC400 o;
            RegC400 r = o = iterator.next();
            Long idImpressora = r.getIdImpressora();
            Query q = s.createQuery("select distinct p.dataEmissao as dataEmissao, p.contadorReinicio as contadorReinicio,  p.contadorCRZ as contadorCRZ,  p.ultimoCOO as ultimoCOO, p.valorTotalGeral as valorTotal, p.valorVendaBruta as valorVendaBruta, p.identificador as idReducaoZ,  p.valorCancelamentoICMS as vrCanc, p.valorDescontoICMS as vrDesc, p.valorAcrescimoICMS as vrAcres from ReducaoZ p where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa and p.impressoraFiscal.identificador = :idImpressora");
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
            q.setEntity("empresa", (Object)emp);
            q.setLong("idImpressora", idImpressora.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegC405> toRet = new ArrayList<RegC405>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegC405 rC405 = new RegC405();
                rC405.setDataMovimento((Date)h.get("dataEmissao"));
                rC405.setContadorCRZ((Long)h.get("contadorCRZ"));
                rC405.setUltimoCOO((Long)h.get("ultimoCOO"));
                rC405.setContadorReinicio((Long)h.get("contadorReinicio"));
                rC405.setValorTotalGeral((Double)h.get("valorTotal"));
                rC405.setValorVendaBruta((Double)h.get("valorVendaBruta"));
                rC405.setIdReducaoZ((Long)h.get("idReducaoZ"));
                rC405.setVrCancelamentoIcms((Double)h.get("vrCanc"));
                rC405.setVrDescontoIcms((Double)h.get("vrDesc"));
                rC405.setVrAcrescimoIcms((Double)h.get("vrAcres"));
                if (rC405.getValorVendaBruta() > 0.0) {
                    this.getPisCofinsRegC410(rC405);
                }
                this.getTotalizadoresParciaisRegC420(rC405, idImpressora, emp, perfil);
                if (perfil == 'A') {
                    this.getCuponsFiscaisRegC460(rC405, idImpressora, emp);
                }
                this.getLivrosFiscaisRegC490(rC405);
                toRet.add(rC405);
            }
            r.setReducoes(toRet);
        }
    }

    private void getPisCofinsRegC410(RegC405 rC405) {
        block0: {
            Session s = CoreBdUtil.getInstance().getSession();
            Long idReducaoZ = rC405.getIdReducaoZ();
            Query q = s.createQuery("select sum(lv.valorPis) as valorPis, sum(lv.valorCofins) as valorCofins from ReducaoZ p  inner join p.livrosFiscais lv where p.identificador = :idReducaoZ");
            q.setLong("idReducaoZ", idReducaoZ.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            Iterator iterator = ret.iterator();
            if (!iterator.hasNext()) break block0;
            Object ob = iterator.next();
            HashMap h = (HashMap)ob;
            RegC410 r = new RegC410();
            r.setVrPis((Double)h.get("valorPis"));
            r.setVrCofins((Double)h.get("valorCofins"));
            rC405.setPisCofins(r);
        }
    }

    private void getTotalizadoresParciaisRegC420(RegC405 r, Long idImpressora, Empresa emp, char perfil) {
        RegC420 reg;
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select i.aliquotaICMS as ALIQUOTA_ICMS, i.tipoTributacaoItemCPFiscal.sigla as SIGLA, sum(i.valorFinal) as VALOR_TOTAL  from ItemCupomFiscal i  where i.cupomFiscal.impressoraFiscal.identificador = :impressora  and i.cupomFiscal.cupom.dataEmissao = :dataReducao and i.cupomFiscal.cupom.empresa = :empresa and i.cancelado = :cancelado  and i.cupomFiscal.cancelado= :cancelado  group by i.aliquotaICMS, i.tipoTributacaoItemCPFiscal.sigla");
        q.setDate("dataReducao", r.getDataMovimento());
        q.setLong("impressora", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setInteger("cancelado", 0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC420> toRet = new ArrayList<RegC420>();
        int total = 1;
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Double aliq = (Double)h.get("ALIQUOTA_ICMS");
            Double vrTotal = (Double)h.get("VALOR_TOTAL");
            String tribItem = (String)h.get("SIGLA");
            String aliqIcms = aliq.toString();
            RegC420 rC420 = new RegC420();
            if (tribItem.equalsIgnoreCase("TT")) {
                if (aliqIcms.length() <= 3) {
                    rC420.setCodigoTotalizador(ToolString.completaZeros((String)String.valueOf(total), (int)2, (boolean)true) + "T0" + ToolString.completaZeros((String)ClearUtil.refinaAll(aliqIcms), (int)3));
                } else {
                    rC420.setCodigoTotalizador(ToolString.completaZeros((String)String.valueOf(total), (int)2, (boolean)true) + "T" + ToolString.completaZeros((String)ClearUtil.refinaAll(aliqIcms), (int)4));
                }
                rC420.setValor(vrTotal);
                rC420.setNrTotalizador("0" + total);
                rC420.setDescricao("Tributado " + aliqIcms + "%");
                ++total;
            } else {
                rC420.setCodigoTotalizador(tribItem.substring(0, 1) + "1");
                rC420.setValor(vrTotal);
            }
            if (perfil == 'B') {
                rC420.setItens(this.getResumoItensRegC420(r.getDataMovimento(), idImpressora, emp, tribItem, aliq));
            }
            toRet.add(rC420);
        }
        if (r.getVrCancelamentoIcms() != null && r.getVrCancelamentoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("Can-T");
            reg.setValor(r.getVrCancelamentoIcms());
            toRet.add(reg);
        }
        if (r.getVrDescontoIcms() != null && r.getVrDescontoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("DT");
            reg.setValor(r.getVrDescontoIcms());
            toRet.add(reg);
        }
        if (r.getVrAcrescimoIcms() != null && r.getVrAcrescimoIcms() > 0.0) {
            reg = new RegC420();
            reg.setCodigoTotalizador("AT");
            reg.setValor(r.getVrAcrescimoIcms());
            toRet.add(reg);
        }
        r.setTotalizadoresParciais(toRet);
    }

    private void getCuponsFiscaisRegC460(RegC405 rC405, Long idImpressora, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  c.identificador as idCupomFiscal,  c.cupom.nrCOO as nrCupom, c.modeloDocFiscal.codigo as codModeloDocFiscal, c.cancelado as cancelado, c.cupom.dataEmissao as dataEmissao, c.valorTotal as valorTotal, c.valorPis as vrPis, c.valorCofins as vrCofins, c.cpfCliente as cpfCliente, c.nomeCliente as nomeCliente  from CupomFiscal c where c.cupom.dataEmissao = :dataEmissao  and (c.modeloDocFiscal.codigo = :cod1 or  c.modeloDocFiscal.codigo = :cod2) and c.cupom.impressoraFiscal.identificador = :idImpressoraFiscal  and c.cupom.empresa=:empresa");
        q.setDate("dataEmissao", rC405.getDataMovimento());
        q.setLong("idImpressoraFiscal", idImpressora.longValue());
        q.setEntity("empresa", (Object)emp);
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC460> toRet = new ArrayList<RegC460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC460 r = new RegC460();
            r.setIdCupomFiscal((Long)h.get("idCupomFiscal"));
            r.setCodModDocFiscal((String)h.get("codModeloDocFiscal"));
            r.setCancelado((Short)h.get("cancelado"));
            r.setCpfCnpj((String)h.get("cpfCliente"));
            r.setNomeCliente((String)h.get("nomeCliente"));
            r.setNumeroDoc((Long)h.get("nrCupom"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setValorTotal((Double)h.get("valorTotal"));
            r.setValorPis((Double)h.get("vrPis"));
            r.setValorCofins((Double)h.get("vrCofins"));
            r.setItensCupom(this.getItensCupomFiscalRegC470(r));
            toRet.add(r);
        }
        rC405.setCuponsFiscais(toRet);
    }

    private List<RegC470> getItensCupomFiscalRegC470(RegC460 rC460) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select i.identificador as identificador, i.produto.identificador as idProduto, i.quantidadeTotal as quantidade, i.produto.unidadeMedida.sigla as unidMedida, i.valorFinal as valorTotal, i.tributacaoItemProduto.tributacaoItem.incidenciaIcms.codigo as codIncidenciaIcms, i.cfop.codigo as cfop, i.aliquotaICMS as aliquotaIcms, i.vrPis as valorPis, i.vrCofins as valorCofins from ItemCupomFiscal i where i.cupomFiscal.identificador = :idCupomFiscal and i.cancelado = :cancelado ");
        q.setLong("idCupomFiscal", rC460.getIdCupomFiscal().longValue());
        q.setShort("cancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC470> toRet = new ArrayList<RegC470>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC470 r = new RegC470();
            r.setCodItem((Long)h.get("idProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidMedida((String)h.get("unidMedida"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setIncidenciaIcms((String)h.get("codIncidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorPis((Double)h.get("valorPis"));
            r.setValorCofins((Double)h.get("valorCofins"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisRegC490(RegC405 regC405) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms,  obs.obsFaturamento.identificador as obsLivroFiscal from ReducaoZ n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idReducaoZ group by lv.incidenciaIcms.codigo, lv.cfop.codigo, lv.aliquotaIcms, obs.obsFaturamento.identificador");
        q.setLong("idReducaoZ", regC405.getIdReducaoZ().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC490> toRet = new ArrayList<RegC490>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC490 r = new RegC490();
            r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
            r.setCfop((String)h.get("cfop"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setValorOperacao((Double)h.get("valorTotal"));
            r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
            r.setValorIcms((Double)h.get("valorIcms"));
            r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
            toRet.add(r);
        }
        regC405.setLivrosFiscais(toRet);
    }

    private List<Reg200> getProdutosCuponsFiscaisBlocoC400_Teste(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("select distinct p.id_produto as ID_PRODUTO, p.nome as NOME_PRODUTO, un.sigla as SIGLA, t.codigo as COD_TIPO_ITEM_SPED, n.codigo as COD_NCM, g.codigo as COD_GENERO, p.aliquota_icms as ALIQUOTA_ICMS from Item_cupom_fiscal I inner join item_estnota IE on ie.id_item_estnota = i.id_item_cp_fiscal inner join produto P on ie.id_produto = p.id_produto inner join unidade_medida UN on un.id_unidade_medida = p.id_unidade_medida left join ncm N on n.id_ncm = p.id_ncm left join genero G on g.id_genero = p.id_genero left join tipo_item_sped T on t.id_tipo_item_sped = p.id_tipo_item_sped inner join estnota E on e.id_estnota = ie.id_estnota inner join cupom_fiscal C on c.id_cupom_fiscal = e.id_estnota   inner join modelo_doc_fiscal M on m.id_modelo_doc_fiscal = c.id_modelo_doc_fiscal where (m.codigo=:cod1 or m.codigo=:cod2) and e.data_emissao between :dataIn and :dataFim and e.id_empresa =:empresa and c.cancelado = :cancelado  and i.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setLong("empresa", emp.getIdentificador().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto(((Integer)h.get("ID_PRODUTO")).longValue());
            r.setDescricao((String)h.get("NOME_PRODUTO"));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setTipoItem((String)h.get("COD_TIPO_ITEM_SPED"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            r.setCodNcm((String)h.get("COD_NCM"));
            r.setCodGenero((String)h.get("COD_GENERO"));
            BigDecimal aliq = (BigDecimal)h.get("ALIQUOTA_ICMS");
            r.setAliquotaIcms(aliq.doubleValue());
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosCuponsFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p.identificador as ID_PRODUTO, p.nome as NOME_PRODUTO, p.unidadeMedida.sigla as SIGLA, t.codigo as COD_TIPO_ITEM_SPED, n.codigo as COD_NCM, g.codigo as COD_GENERO, p.aliquotaIcms as ALIQUOTA_ICMS from ItemCupomFiscal i inner join i.produto p left join p.ncm n left join p.genero g left join p.tipoIemSped t where (i.cupomFiscal.modeloDocFiscal.codigo=:cod1 or i.cupomFiscal.modeloDocFiscal.codigo=:cod2) and i.cupomFiscal.cupom.dataEmissao between :dataIn and :dataFim and i.cupomFiscal.cupom.empresa =:empresa and i.cupomFiscal.cancelado = :cancelado  and i.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((long)((Long)h.get("ID_PRODUTO")));
            r.setDescricao((String)h.get("NOME_PRODUTO"));
            r.setUnidadeMedida((String)h.get("SIGLA"));
            r.setTipoItem((String)h.get("COD_TIPO_ITEM_SPED"));
            r.setCodNcm((String)h.get("COD_NCM"));
            r.setCodGenero((String)h.get("COD_GENERO"));
            Double aliq = (Double)h.get("ALIQUOTA_ICMS");
            r.setAliquotaIcms(aliq);
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasCuponsFiscaisBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.produto.unidadeMedida.identificador as idUnidMedida,  i.produto.unidadeMedida.sigla as sigla, i.produto.unidadeMedida.descricao as descricao from CupomFiscal n  inner join n.itemCupomFiscal i where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.cupom.dataEmissao between :dataIn and :dataFim and n.cupom.empresa=:empresa and n.cancelado = :cancelado");
        q.setString("cod1", "02");
        q.setString("cod2", "2D");
        q.setShort("cancelado", (short)0);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
        }
        return toRet;
    }

    List getParticipantesNotasTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("cnpj"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasTerceirosD100(List<RegD100> registrosD100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD100> iterator = registrosD100.iterator();
        while (iterator.hasNext()) {
            RegD100 o;
            RegD100 regD100 = o = iterator.next();
            Long idNota = regD100.getIdentificador();
            Query q = s.createQuery("select distinct lv from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regD100.setLivrosFiscais(this.getRegD190(ret));
        }
    }

    private void getLivrosFiscaisConhecimentosSaidaD100(List<RegD100> registrosD100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD100> iterator = registrosD100.iterator();
        while (iterator.hasNext()) {
            RegD100 o;
            RegD100 regD100 = o = iterator.next();
            Long idNota = regD100.getIdentificador();
            System.out.println("\nLIVRO FISCAL REFERENTE AO CTRC ID: " + idNota + "\n");
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcmsIsento) as valorIcmsIsento,  sum(lv.valorIcmsOutros) as valorIcmsOutros, sum(lv.valorIcms) as valorIcms, sum(lv.vrNaoTribIcms) as valorNaoTribIcms from Cte n inner join n.livrosFiscais lv where n.identificador  = :idNota and (n.situacaoDocumento.codigo != :cod2 and n.situacaoDocumento.codigo != :cod3 and n.situacaoDocumento.codigo != :cod4 and n.situacaoDocumento.codigo != :cod5) group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms");
            q.setLong("idNota", idNota.longValue());
            q.setString("cod2", "02");
            q.setString("cod3", "03");
            q.setString("cod4", "04");
            q.setString("cod5", "05");
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegD190> toRet = new ArrayList<RegD190>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegD190 r = new RegD190();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado") + (Double)h.get("valorIcmsIsento") + (Double)h.get("valorIcmsOutros"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                toRet.add(r);
            }
            regD100.setLivrosFiscais(toRet);
        }
    }

    private List getParticipantesConhecimentosSaidaTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from Cte n  inner join n.clienteTomador u inner join u.cliente c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2) and n.dataEmissao between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "57");
        q.setString("cod2", "08");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD130> getComplConhecimentos(Long idCte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.ctrc.complConhecimento from Cte c  where   c.identificador = :idCte");
        q.setLong("idCte", idCte.longValue());
        List ret = q.list();
        ArrayList<RegD130> toRet = new ArrayList<RegD130>();
        for (Object o : ret) {
            CtrcComplConhecimento c = (CtrcComplConhecimento)o;
            RegD130 r = new RegD130();
            r.setComplConhecimento(c);
            toRet.add(r);
        }
        return toRet;
    }

    private List<RegD130> getComplConhecimentos2(Ctrc ctrc) {
        ArrayList<RegD130> toRet = new ArrayList<RegD130>();
        if (ctrc.getComplConhecimento() != null) {
            for (Object o : ctrc.getComplConhecimento()) {
                CtrcComplConhecimento c = (CtrcComplConhecimento)o;
                RegD130 r = new RegD130();
                r.setComplConhecimento(c);
                toRet.add(r);
            }
        }
        return toRet;
    }

    private List<RegD160> getCargaTransportada(Long idCte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  c.ctrc.cargaTransportada from Cte c  where   c.identificador = :idCte");
        q.setLong("idCte", idCte.longValue());
        List ret = q.list();
        ArrayList<RegD160> toRet = new ArrayList<RegD160>();
        for (Object o : ret) {
            CtrcCargaTransportada c = (CtrcCargaTransportada)o;
            RegD160 r = new RegD160();
            r.setCargaTransportada(c);
            r.setRegistroD161(this.getColetaEntregaD161(c.getCtrcColetaEntrega()));
            r.setRegistrosD162(this.getDocFisais(c.getCtrcDocFiscais()));
            toRet.add(r);
        }
        return toRet;
    }

    private RegD161 getColetaEntregaD161(CtrcColetaEntrega c) {
        RegD161 r = new RegD161();
        r.setColetaEntrega(c);
        return r;
    }

    private List<RegD162> getDocFisais(List<CtrcDocumentosFiscais> docFiscais) {
        ArrayList<RegD162> toRet = new ArrayList<RegD162>();
        Iterator<CtrcDocumentosFiscais> iterator = docFiscais.iterator();
        while (iterator.hasNext()) {
            CtrcDocumentosFiscais o;
            CtrcDocumentosFiscais c = o = iterator.next();
            RegD162 r = new RegD162();
            r.setDocFiscais(c);
            toRet.add(r);
        }
        return toRet;
    }

    private void getLivrosFiscaisNotasTerceirosTelecomD500(List<RegD500> registrosD500) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD500> iterator = registrosD500.iterator();
        while (iterator.hasNext()) {
            RegD500 o;
            RegD500 regD500 = o = iterator.next();
            Long idNota = regD500.getIdentificador();
            Query q = s.createQuery("select lv.incidenciaIcms.codigo as incidenciaIcms, lv.cfop.codigo as cfop, lv.aliquotaIcms as aliquotaIcms, sum(lv.valorTotal) as valorTotal, sum(lv.valorIcmsTributado) as valorIcmsTributado, sum(lv.valorIcms) as valorIcms, sum(lv.valorBCIcmsSt) as valorBCIcmsSt, sum(lv.valorIcmsSt) as valorIcmsSt, sum(lv.vrNaoTribIcms) as valorNaoTribIcms, obs.obsFaturamento.identificador as obsLivroFiscal from NotaFiscalTerceiros n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where n.identificador  = :idNota group by lv.incidenciaIcms.codigo, lv.cfop.codigo,lv.aliquotaIcms, obs.obsFaturamento.identificador");
            q.setLong("idNota", idNota.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ret = q.list();
            ArrayList<RegD590> toRet = new ArrayList<RegD590>();
            for (Object ob : ret) {
                HashMap h = (HashMap)ob;
                RegD590 r = new RegD590();
                r.setIncidenciaIcms((String)h.get("incidenciaIcms"));
                r.setCfop((String)h.get("cfop"));
                r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
                r.setValorOperacao((Double)h.get("valorTotal"));
                r.setBcCalculoIcms((Double)h.get("valorIcmsTributado"));
                r.setValorIcms((Double)h.get("valorIcms"));
                r.setBcCalculoIcmsSt((Double)h.get("valorBCIcmsSt"));
                r.setValorIcmsST((Double)h.get("valorIcmsSt"));
                r.setValorNaoTribIcms((Double)h.get("valorNaoTribIcms"));
                r.setObservacoesLv((Long)h.get("obsLivroFiscal"));
                toRet.add(r);
            }
            regD500.setLivrosFiscais(toRet);
        }
    }

    private List getParticipantesNotasTerceirosTelecomD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalNotasTerceirosTelecomD500(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  obs.obsFaturamento.identificador as idObsLancFiscal, obs.obsFaturamento.nome as nomeObsLancFiscal  from NotaFiscalTerceiros n  inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "21");
        q.setString("cod2", "22");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalNotasFiscaisPropriasBloco011B0455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct obs.obsFaturamento.identificador as idObsLancFiscal,     obs.obsFaturamento.nome          as nomeObsLancFiscal from NotaFiscalPropria n inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where     (    n.modeloDocFiscal.codigo=:cod1       or n.modeloDocFiscal.codigo=:cod2       or n.modeloDocFiscal.codigo=:cod3       or n.modeloDocFiscal.codigo=:cod4      )      and n.dataEmissaoNota between :dataIn and :dataFim      and n.empresa=:empresa      and (n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5       )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalNotaTerceirosBloco011B455(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  obs.obsFaturamento.identificador as idObsLancFiscal, obs.obsFaturamento.nome as nomeObsLancFiscal  from NotaFiscalTerceiros n  inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4) and n.dataEmissao between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalNotasTerceirosBloco062928(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  obs.obsFaturamento.identificador as idObsLancFiscal, obs.obsFaturamento.nome as nomeObsLancFiscal  from NotaFiscalTerceiros n  inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where (n.modeloDocFiscal.codigo=:cod1 or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "06");
        q.setString("cod2", "28");
        q.setString("cod3", "29");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalBlocoC400(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  obs.obsFaturamento.identificador as idObsLancFiscal, obs.obsFaturamento.nome as nomeObsLancFiscal  from ReducaoZ p  inner join p.livrosFiscais lv left join lv.obsLivroFiscal obs where p.dataEmissao between :dataIn and :dataFim and p.empresa=:empresa");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg460> getObsLancFiscalNotasTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  obs.obsFaturamento.identificador as idObsLancFiscal, obs.obsFaturamento.nome as nomeObsLancFiscal  from NotaFiscalTerceiros n  inner join n.livrosFiscais lv left join lv.obsLivroFiscal obs where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg460> toRet = new ArrayList<Reg460>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg460 r = new Reg460();
            r.setIdObservacao((Long)h.get("idObsLancFiscal"));
            r.setDescricao((String)h.get("nomeObsLancFiscal"));
            toRet.add(r);
        }
        return toRet;
    }

    List getFatoresConversao(String unidadeMedida, Long idProduto, Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      it.fatorConversao as fatorConversao,     it.unidadeMedida.sigla as sigla from ItemNotaTerceiros it  where          it.notaFiscalTerceiros.dataEntrada between :dataIn and :dataFim     and it.notaFiscalTerceiros.empresa=:empresa     and it.produto.identificador = :idProduto");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg220> toRet = new ArrayList<Reg220>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg220 r = new Reg220();
            r.setFatorConversao((Double)h.get("fatorConversao"));
            r.setUnidadeMedida((String)h.get("sigla"));
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private Long getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta.identificador as idPlanoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long pc = (Long)h.get("idPlanoConta");
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    public Reg150 createReg150dromPessoa(Pessoa p) {
        Reg150 r = new Reg150();
        r.setIdPessoa(p.getIdentificador());
        r.setNomePessoa(p.getNome());
        r.setBairro(p.getEndereco().getBairro());
        r.setCnpj(p.getComplemento().getCnpj());
        r.setCodPais(p.getEndereco().getCidade().getUf().getPais().getCodIbge());
        r.setCodUf(p.getEndereco().getCidade().getUf().getCodIbge());
        r.setCodigoMunicipio(p.getEndereco().getCidade().getCodIbge());
        r.setComplemento(p.getEndereco().getComplemento());
        r.setEndereco(p.getEndereco().getLogradouro());
        r.setInscricaoEstadual(p.getComplemento().getInscEst());
        r.setNumero(p.getEndereco().getNumero());
        r.setSuframa(p.getComplemento().getSuframa());
        return r;
    }

    public Reg200 createReg200FromProduto(Produto p) {
        Reg200 r = new Reg200();
        r.setIdProduto(p.getIdentificador());
        r.setDescricao(p.getNome());
        r.setUnidadeMedida(p.getUnidadeMedida().getSigla());
        r.setTipoItem(p.getTipoIemSped().getCodigo());
        if (p.getNcm() != null && p.getNcm().getCodigo() != null) {
            r.setCodNcm(p.getNcm().getCodigo());
        }
        if (p.getGenero() != null && p.getGenero().getCodigo() != null) {
            r.setCodGenero(p.getGenero().getCodigo());
        }
        r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
        r.setAliquotaIcms(p.getAliquotaIcms());
        return r;
    }

    public Reg190 createReg190FromUnidMedida(UnidadeMedida u) {
        Reg190 r = new Reg190();
        r.setIdUnidMedida(u.getIdentificador());
        r.setCodUnidMedida(u.getSigla());
        r.setDescUnidMedida(u.getDescricao());
        return r;
    }

    private RegC190 getRegC190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegC190 r = (RegC190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    private List<Reg200> getProdutosNotaPropriaBlocoC300(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      i.produto.identificador         as idProduto,     i.produto.nome                  as nomeProduto,     i.produto.unidadeMedida.sigla   as unidadeMedida,     i.produto.tipoIemSped.codigo    as codTipoItemSped,     nc.codigo                       as codNcm,     g.codigo                        as codGenero,     i.produto.aliquotaIcms          as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left  join i.produto.ncm nc left  join i.produto.genero g where         n.modeloDocFiscal.codigo = :cod1     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaPropriaBlocoC300(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.unidadeMedida.identificador           as idUnidMedida,     i.unidadeMedida.sigla                   as sigla,     i.unidadeMedida.descricao               as descricao,     i.produto.unidadeMedida.identificador   as idUnidMedidaProd,     i.produto.unidadeMedida.sigla           as siglaProd,     i.produto.unidadeMedida.descricao       as descricaoProd from NotaFiscalPropria n inner join n.itensNotaPropria i where         n.modeloDocFiscal.codigo = :cod1     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa");
        q.setString("cod1", "02");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    public Reg460 getObsLancFiscal(Long idObsFat) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   obs.identificador as idObsLancFiscal, obs.nome as nomeObsLancFiscal  from ObsFaturamento  obs  where obs.identificador = :idObs");
        q.setLong("idObs", idObsFat.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        Reg460 r = new Reg460();
        r.setIdObservacao((Long)h.get("idObsLancFiscal"));
        r.setDescricao((String)h.get("nomeObsLancFiscal"));
        return r;
    }

    HashMap findDadosNotaTerceiros(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select   n.unidadeFatFornecedor.fornecedor.pessoa as PESSOA, n.serie as SERIE, n.modeloDocFiscal as MOD_DOC_FISCAL, n.numeroNota as NUMERO_NOTA, n.dataEmissao as DATA_EMISSAO  from NotaFiscalTerceiros  n  where n.identificador = :idNota)");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        return h;
    }

    HashMap findDadosNotaPropria(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select       n.unidadeFatCliente.cliente.pessoa as PESSOA,     n.serie                            as SERIE,     n.modeloDocFiscal                  as MOD_DOC_FISCAL,     n.numeroNota                       as NUMERO_NOTA,     n.dataEmissaoNota                  as DATA_EMISSAO from NotaFiscalPropria  n  where      n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        return h;
    }

    private List<RegC195> getRegC195(List<RegC195> regC195, List<ObservacaoLivroFiscal> obsLivroFiscal) {
        for (ObservacaoLivroFiscal os : obsLivroFiscal) {
            RegC195 r = new RegC195();
            if (os.getObsFaturamento() != null) {
                r.setIdObservacao(os.getObsFaturamento().getIdentificador());
            }
            r.setTextoObs(os.getConteudo());
            ArrayList<RegC197> aux = new ArrayList<RegC197>();
            for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
                RegC197 c197 = new RegC197();
                c197.setAliquotaIcms(out.getAliquotaIcms());
                c197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
                c197.setDescricaoComp(out.getDescricaoComp());
                if (out.getProduto() != null) {
                    c197.setIdProduto(out.getProduto().getIdentificador());
                }
                c197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
                c197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
                c197.setVlrOutros(out.getVlrOutros());
                aux.add(c197);
            }
            r.setAjustesLvFiscal(aux);
            regC195.add(r);
        }
        return regC195;
    }

    private List<RegD190> getRegD190(List ret) {
        ArrayList<RegD190> toRet = new ArrayList<RegD190>();
        for (Object ob : ret) {
            LivroFiscal h = (LivroFiscal)ob;
            RegD190 r = this.getRegD190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            if (r == null) {
                r = new RegD190();
                r.setRegD195(new ArrayList<RegD195>());
                toRet.add(r);
            }
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setRegD195(this.getRegD195(r.getRegD195(), h.getObsLivroFiscal()));
        }
        return toRet;
    }

    private List<RegD195> getRegD195(List<RegD195> regD195, List<ObservacaoLivroFiscal> obsLivroFiscal) {
        for (ObservacaoLivroFiscal os : obsLivroFiscal) {
            RegD195 r = new RegD195();
            r.setIdObservacao(os.getObsFaturamento().getIdentificador());
            r.setTextoObs(os.getConteudo());
            ArrayList<RegD197> aux = new ArrayList<RegD197>();
            for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
                RegD197 d197 = new RegD197();
                d197.setAliquotaIcms(out.getAliquotaIcms());
                d197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
                d197.setDescricaoComp(out.getDescricaoComp());
                if (out.getProduto() != null) {
                    d197.setIdProduto(out.getProduto().getIdentificador());
                }
                d197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
                d197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
                d197.setVlrOutros(out.getVlrOutros());
                aux.add(d197);
            }
            r.setAjustesLvFiscal(aux);
            regD195.add(r);
        }
        return regD195;
    }

    private RegD190 getRegD190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegD190 r = (RegD190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    public Bloco1 getReg1600(Date dataIn, Date dataFim, Empresa emp) {
        Bloco1 bloco1 = new Bloco1();
        bloco1.setReg1600(this.getVendasCartaoCredDebReg1600(dataIn, dataFim, emp));
        bloco1.setParticipantes(this.getParticipantesCartaoCredDeb1600(dataIn, dataFim, emp));
        return bloco1;
    }

    private List<Reg1600> getVendasCartaoCredDebReg1600(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.formasPagCupomFiscal.pessoa.identificador as ID_PESSOA,  sum(p.valor) as VALOR, p.formasPagCupomFiscal.tipoPagamento.codigo as TIPO_CARTAO from PagamentoCupomFiscal p  where p.cupom.dataEmissao between :dataIn and :dataFim and p.cupom.empresa  = :empresa and (p.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoDebito or p.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoCredito) group by p.formasPagCupomFiscal.pessoa.identificador, p.formasPagCupomFiscal.tipoPagamento.codigo");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tipoCartaoDebito", (short)2);
        q.setShort("tipoCartaoCredito", (short)6);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg1600> aux = new ArrayList<Reg1600>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Reg1600 r = new Reg1600();
            r.setIdParticipante((Long)h.get("ID_PESSOA"));
            Short tipoCartao = (Short)h.get("TIPO_CARTAO");
            if (tipoCartao.equals((short)6)) {
                r.setTotalCredito((Double)h.get("VALOR"));
                r.setTotalDebito(0.0);
            } else {
                r.setTotalDebito((Double)h.get("VALOR"));
                r.setTotalCredito(0.0);
            }
            aux.add(r);
        }
        return aux;
    }

    private List<Reg150> getParticipantesCartaoCredDeb1600(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade from PagamentoCupomFiscal pag inner join pag.formasPagCupomFiscal f inner join f.pessoa p  where pag.cupom.dataEmissao between :dataIn and :dataFim and pag.cupom.empresa  = :empresa and (pag.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoDebito or pag.formasPagCupomFiscal.tipoPagamento.codigo = :tipoCartaoCredito)");
        q.setEntity("empresa", (Object)emp);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("tipoCartaoDebito", (short)2);
        q.setShort("tipoCartaoCredito", (short)6);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : lista) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

