/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao008.util.blococ;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg190;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg400;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg450;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg500;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.BlocoC;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC100;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC110;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC111;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC112;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC113;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC114;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC170;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC190;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC195;
import mentorcore.service.impl.spedfiscal.versao008.model2.blococ.RegC197;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoC100NotaPropria {
    public BlocoC getBlocoC100NotasProprias(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        BlocoC b = new BlocoC();
        b.setRegistrosC100(this.getNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
        if (b.getRegistrosC100() != null && !b.getRegistrosC100().isEmpty()) {
            this.getLivrosFiscaisNotasPropriasBlocoC100(b.getRegistrosC100());
            b.setParticipantes(this.getParticipantesNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotasFiscaisPropriasBlocoC100(dataIn, dataFim, emp, b.getRegistrosC100()));
            b.setObservacoes(this.getInfComplNotasPropriasBlocoC100(b.getRegistrosC100()));
        }
        return b;
    }

    private List getNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida           as entSai,     n.modeloDocFiscal.codigo                  as codModFiscal,     n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa,     tf.opcao                                  as codTpFrete,     n.situacaoDocumento.codigo                as sitDoc,     n.serie                                   as serie,     n.numeroNota                              as numNota,     n.chaveNFE                                as chaveNfe,     n.dataEmissaoNota                         as dataEmissao,     n.dataEntradaSaida                        as dataEntSai,     n.valoresNfPropria.valorTotal             as valorTotal,     n.valoresNfPropria.valorProduto + n.valoresNfPropria.valorServico as valorProdServ,     cp.tpCondicao                             as tpCond,     n.valoresNfPropria.valorFrete             as vlrFrete,     n.valoresNfPropria.valorSeguro            as vlrSeguro,     n.valoresNfPropria.valorDesconto          as vlrDesconto,     n.valoresNfPropria.valorDespAcess         as vlrDespAcess,     n.valoresNfPropria.valorIcmsTributado     as bcIcms,     n.valoresNfPropria.valorIcms              as vlrIcms,     n.valoresNfPropria.valorIcmsSt            as vlrIcmsSt,     n.valoresNfPropria.bcIcmsSt               as bcIcmsSt,     n.valoresNfPropria.valorIpiIndustria      as vlrIpi,     n.valoresNfPropria.valorPis               as vlrPis,     n.valoresNfPropria.valorCofins            as vlrCofins,     n.valoresNfPropria.valorCofinsSt          as vlrCofinsST,     n.valoresNfPropria.valorPisSt             as vlrPisST,     n.identificador                           as identificador from NotaFiscalPropria n  left join n.dadosTransNfPropria.tipoFrete tf left join n.condicaoPagamento cp where      (        n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )  and n.dataEmissaoNota between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC100> toRet = new ArrayList<RegC100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegC100 r = new RegC100();
            r.setNumeroDoc((Integer)h.get("numNota"));
            System.out.println("Nr Nota Propria: " + r.getNumeroDoc().toString());
            r.setChaveNFe((String)h.get("chaveNfe"));
            r.setEntSaiNatOP(((Short)h.get("entSai")).shortValue());
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            r.setIndTipoEmitente(0);
            if ((Short)h.get("tpCond") != null) {
                r.setIndTipoPagamento(((Short)h.get("tpCond")).shortValue());
            } else {
                r.setIndTipoPagamento(2);
            }
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete(((Short)h.get("codTpFrete")).shortValue());
            } else {
                r.setIndicadorTipoFrete(9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorAbatNT(0.0);
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorBCIcmsST((Double)h.get("bcIcmsSt"));
            r.setValorCofins((Double)h.get("vlrCofins"));
            r.setValorCofinsSt((Double)h.get("vlrCofinsST"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDespAcessorias((Double)h.get("vlrDespAcess"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorFrete((Double)h.get("vlrFrete"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorIcmsST((Double)h.get("vlrIcmsSt"));
            r.setValorIpi((Double)h.get("vlrIpi"));
            r.setValorPis((Double)h.get("vlrPis"));
            r.setValorPisSt((Double)h.get("vlrPisST"));
            r.setValorSeguro((Double)h.get("vlrSeguro"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            if (!this.isDocCancelado(r.getCodSituacaoDoc())) {
                this.getInformacoesComplementares(r);
                this.getItensDocumentoNotaPropria(r);
            }
            toRet.add(r);
        }
        return toRet;
    }

    private boolean isDocCancelado(String sitDoc) {
        boolean docCancInut = sitDoc.equalsIgnoreCase("02") || sitDoc.equalsIgnoreCase("03") || sitDoc.equalsIgnoreCase("05") || sitDoc.equalsIgnoreCase("04");
        return docCancInut;
    }

    private void getItensDocumentoNotaPropria(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select distinct      p.produto.identificador                 as idProduto,     p.numeroItem                            as numeroItem,     p.produto.nome                          as nomeProduto,     p.quantidadeTotal                       as quantidade,     p.unidadeMedida.sigla                   as sigla,     p.itemNotaLivroFiscal.valorTotal        as valorTotal,     p.valorDesconto                         as valorDesconto,     p.modeloFiscal.movimentacaoFisica                    as movimentacaoFisica,     p.incidenciaIcms.codigo                 as codIncidenciaIcms,     p.itemNotaLivroFiscal.cfop.codigo       as cfop,     p.modeloFiscal.naturezaOperacao.identificador        as idNatOperacao,     p.itemNotaLivroFiscal.vrIcmsTributado   as vrIcmsTrib,     p.itemNotaLivroFiscal.aliquotaIcms      as aliquotaIcms,     p.itemNotaLivroFiscal.vrIcms            as valorIcms,     p.itemNotaLivroFiscal.vrBcCalculoIcmsSt as vrBcCalculoIcmsSt,     p.itemNotaLivroFiscal.aliquotaIcmsST    as aliquotaIcmsSt,     p.itemNotaLivroFiscal.vrIcmsSt          as valorIcmsSt,     p.incidenciaIpi.codigo                  as codIncidenciaIpi,     p.itemNotaLivroFiscal.vrIpiTributado    as vrIpiTributado,     p.itemNotaLivroFiscal.aliquotaIpi       as aliquotaIpi,     p.itemNotaLivroFiscal.vrIpiIndustria    as vrIpiIndustria,     p.itemNotaLivroFiscal.vrIpiComercio     as vrIpiComercio,     p.incidenciaPisCofins.codigo            as codIncidenciaPisCofins,     (p.vrProduto + p.vrSeguro + p.vrServico + p.valorDespAcessoria + p.valorFrete - p.valorDesconto) as BCGeral,     p.itemNotaLivroFiscal.aliquotaPis       as aliquotaPis,     p.itemNotaLivroFiscal.vrPis             as vrPis,     p.itemNotaLivroFiscal.aliquotaCofins    as aliquotaCofins,     p.itemNotaLivroFiscal.vrCofins          as vrCofins,     p.planoContaCred.identificador          as planoContaCred,     p.planoContaDeb.identificador           as planoContaDeb,     p.modeloFiscal.naturezaOperacao.entradaSaida         as natEntSaida from NotaFiscalPropria n inner join n.itensNotaPropria p where     n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC170> toRet = new ArrayList<RegC170>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC170 r = new RegC170();
            r.setCodigoItem((Long)h.get("idProduto"));
            r.setNumeroItem((Integer)h.get("numeroItem"));
            r.setDescricaoComp((String)h.get("nomeProduto"));
            r.setQuantidade((Double)h.get("quantidade"));
            r.setUnidadeMedida((String)h.get("sigla"));
            r.setValorItem((Double)h.get("valorTotal"));
            r.setValorDesconto((Double)h.get("valorDesconto"));
            r.setMovimentacaoFisica((Short)h.get("movimentacaoFisica"));
            r.setCfop((String)h.get("cfop"));
            r.setCodNatOperacao((Long)h.get("idNatOperacao"));
            r.setCstIcms((String)h.get("codIncidenciaIcms"));
            r.setValorBCIcms((Double)h.get("vrIcmsTrib"));
            r.setAliqIcms((Double)h.get("aliquotaIcms"));
            r.setVlrIcms((Double)h.get("valorIcms"));
            r.setVlrBCIcmsST((Double)h.get("vrBcCalculoIcmsSt"));
            r.setVlrIcmsSt((Double)h.get("valorIcmsSt"));
            r.setAliquotaST((Double)h.get("aliquotaIcmsSt"));
            r.setCstIpi((String)h.get("codIncidenciaIpi"));
            r.setVlrBCIpi((Double)h.get("vrIpiTributado"));
            r.setAliqIpi((Double)h.get("aliquotaIpi"));
            r.setVlrIpi((Double)h.get("vrIpiIndustria") + (Double)h.get("vrIpiComercio"));
            r.setCstPis((String)h.get("codIncidenciaPisCofins"));
            r.setVlrBCPis((Double)h.get("BCGeral"));
            r.setAliqPis((Double)h.get("aliquotaPis"));
            r.setVlrPis((Double)h.get("vrPis"));
            r.setCstCofins((String)h.get("codIncidenciaPisCofins"));
            r.setBcCofins((Double)h.get("BCGeral"));
            r.setAliqCofins((Double)h.get("aliquotaCofins"));
            r.setVlrCofins((Double)h.get("vrCofins"));
            r.setEntSaiNatOperacao((Short)h.get("natEntSaida"));
            r.setPlanoCred((Long)h.get("planoContaCred"));
            r.setPlanoDeb((Long)h.get("planoContaDeb"));
            toRet.add(r);
        }
        regC100.setRegC170(toRet);
    }

    private void getLivrosFiscaisNotasPropriasBlocoC100(List<RegC100> registrosC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegC100> iterator = registrosC100.iterator();
        while (iterator.hasNext()) {
            RegC100 o;
            RegC100 regC100 = o = iterator.next();
            Long idNota = regC100.getIdentificador();
            Query q = s.createQuery("select      distinct lv  from NotaFiscalPropria n inner join n.livrosFiscais lv where      n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regC100.setRegC190(this.getRegC190(ret));
        }
    }

    private List getRegC190(List livrosFiscais) {
        ArrayList<RegC190> toRet = new ArrayList<RegC190>();
        for (Object ob : livrosFiscais) {
            LivroFiscal h = (LivroFiscal)ob;
            RegC190 r = this.getRegC190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            if (r == null) {
                r = new RegC190();
                toRet.add(r);
            }
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setBcCalculoIcmsSt(h.getValorBCIcmsSt() + r.getBcCalculoIcmsSt());
            r.setValorIcmsST(h.getValorIcmsSt() + r.getValorIcmsST());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setValorIpi(h.getValorIpiIndustria() + h.getValorIpiComercio() + r.getValorIpi());
            r.setRegC195(this.getRegC195(r.getRegC195(), h.getObsLivroFiscal()));
        }
        return toRet;
    }

    private RegC190 getRegC190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegC190 r = (RegC190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    private List<RegC195> getRegC195(List<RegC195> regC195, List<ObservacaoLivroFiscal> obsLivroFiscal) {
        for (ObservacaoLivroFiscal os : obsLivroFiscal) {
            RegC195 r = new RegC195();
            if (os.getObsFaturamento() != null) {
                r.setIdObservacao(os.getObsFaturamento().getIdentificador());
                r.setDescricaoObservacao(os.getObsFaturamento().getNome());
            }
            r.setTextoObs(os.getConteudo());
            ArrayList<RegC197> aux = new ArrayList<RegC197>();
            for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
                RegC197 c197 = new RegC197();
                c197.setAliquotaIcms(out.getAliquotaIcms());
                c197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
                c197.setDescricaoComp(out.getDescricaoComp());
                if (out.getProduto() != null) {
                    c197.setIdProduto(out.getProduto().getIdentificador());
                }
                c197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
                c197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
                c197.setVlrOutros(out.getVlrOutros());
                aux.add(c197);
            }
            r.setAjustesLvFiscal(aux);
            regC195.add(r);
        }
        return regC195;
    }

    List getParticipantesNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      p.identificador                     as idPessoa,     p.endereco.numero                   as numero,     p.endereco.logradouro               as logradouro,     p.endereco.complemento              as complemento,     p.endereco.bairro                   as bairro,     p.complemento.cnpj                  as cnpj,     p.complemento.inscEst               as inscEst,     p.complemento.suframa               as suframa,     p.nome                              as nome,     p.endereco.cidade.uf.pais.codIbge   as codPais,     p.endereco.cidade.uf.codIbge        as codUf,     p.endereco.cidade.codIbge           as codCidade from NotaFiscalPropria n inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa p where     (   n.modeloDocFiscal.codigo=:cod1      or n.modeloDocFiscal.codigo=:cod2      or n.modeloDocFiscal.codigo=:cod3      or n.modeloDocFiscal.codigo=:cod4      )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (  n.situacaoDocumento.codigo = :codSitDoc1         or n.situacaoDocumento.codigo = :codSitDoc2         or n.situacaoDocumento.codigo = :codSitDoc3         or n.situacaoDocumento.codigo = :codSitDoc4         or n.situacaoDocumento.codigo = :codSitDoc5         )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setCodUf((String)h.get("codUf"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("dataEntSai"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct      i.produto.identificador         as idProduto,     i.produto.nome                  as nomeProduto,     i.produto.unidadeMedida.sigla   as unidadeMedida,     i.produto.tipoIemSped.codigo    as codTipoItemSped,     nc.codigo                       as codNcm,     g.codigo                        as codGenero,     i.produto.aliquotaIcms          as aliquotaIcms from NotaFiscalPropria n  inner join n.itensNotaPropria i left  join i.produto.ncm nc left  join i.produto.genero g where      (   n.modeloDocFiscal.codigo=:cod1      or n.modeloDocFiscal.codigo=:cod2       or n.modeloDocFiscal.codigo=:cod3       or n.modeloDocFiscal.codigo=:cod4      )      and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa = :empresa     and (  n.situacaoDocumento.codigo = :codSitDoc1         or n.situacaoDocumento.codigo = :codSitDoc2         or n.situacaoDocumento.codigo = :codSitDoc3         or n.situacaoDocumento.codigo = :codSitDoc4         or n.situacaoDocumento.codigo = :codSitDoc5         )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            toRet.add(r);
        }
        return toRet;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private List<Reg400> getNatOperacaoNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     n.naturezaOperacao.identificador as idNatOperacao,     n.naturezaOperacao.descricao     as descNatOperacao from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (        n.situacaoDocumento.codigo = :codSitDoc1     or n.situacaoDocumento.codigo = :codSitDoc2     or n.situacaoDocumento.codigo = :codSitDoc3     or n.situacaoDocumento.codigo = :codSitDoc4     or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg400> toRet = new ArrayList<Reg400>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg400 r = new Reg400();
            r.setIdNatOperacao((Long)h.get("idNatOperacao"));
            r.setDescricaoNatOperacao((String)h.get("descNatOperacao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg500> getPlanoContasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.planoContaCred.identificador             as idPlanoCred,     i.planoContaCred.dataCadastro              as dataCadastroCred,     i.planoContaCred.marca                     as marcaCred,     i.planoContaCred.codigo                    as codContaCred,     i.planoContaCred.descricao                 as descricaoContaCred,     i.planoContaDeb.naturezaOperacaoPC.codigo  as codNatPC from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (         n.situacaoDocumento.codigo = :codSitDoc1      or n.situacaoDocumento.codigo = :codSitDoc2      or n.situacaoDocumento.codigo = :codSitDoc3      or n.situacaoDocumento.codigo = :codSitDoc4      or n.situacaoDocumento.codigo = :codSitDoc5      )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg500> toRet = new ArrayList<Reg500>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long idPlanoContaCred = (Long)h.get("idPlanoCred");
            if (idPlanoContaCred == null || idPlanoContaCred <= 0L) continue;
            Reg500 r = new Reg500();
            r.setIdPlanoContas(idPlanoContaCred);
            r.setDataInclusao((Date)h.get("dataCadastroCred"));
            r.setDescricao((String)h.get("descricaoContaCred"));
            r.setMarca((Integer)h.get("marcaCred"));
            r.setCodigo((String)h.get("codContaCred"));
            r.setCodNatPC((String)h.get("codNatPC"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg190> getUnidMedidasNotaPropriaBlocoC100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct     i.unidadeMedida.identificador           as idUnidMedida,     i.unidadeMedida.sigla                   as sigla,     i.unidadeMedida.descricao               as descricao,     i.produto.unidadeMedida.identificador   as idUnidMedidaProd,     i.produto.unidadeMedida.sigla           as siglaProd,     i.produto.unidadeMedida.descricao       as descricaoProd from NotaFiscalPropria n inner join n.itensNotaPropria i where     (  n.modeloDocFiscal.codigo=:cod1     or n.modeloDocFiscal.codigo=:cod2     or n.modeloDocFiscal.codigo=:cod3     or n.modeloDocFiscal.codigo=:cod4     )     and n.dataEmissaoNota between :dataIn and :dataFim     and n.empresa=:empresa     and (n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5     )");
        q.setString("cod1", "01");
        q.setString("cod2", "1B");
        q.setString("cod3", "04");
        q.setString("cod4", "55");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg190> toRet = new ArrayList<Reg190>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg190 r = new Reg190();
            Long idUnidMedItens = (Long)h.get("idUnidMedida");
            r.setIdUnidMedida((Long)h.get("idUnidMedida"));
            r.setCodUnidMedida((String)h.get("sigla"));
            r.setDescUnidMedida((String)h.get("descricao"));
            toRet.add(r);
            Long idUnidMedProd = (Long)h.get("idUnidMedidaProd");
            if (idUnidMedItens == idUnidMedProd) continue;
            r = new Reg190();
            r.setIdUnidMedida((Long)h.get("idUnidMedidaProd"));
            r.setCodUnidMedida((String)h.get("siglaProd"));
            r.setDescUnidMedida((String)h.get("descricaoProd"));
            toRet.add(r);
        }
        return toRet;
    }

    private void getInformacoesComplementares(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        ArrayList<RegC110> toRet = new ArrayList<RegC110>();
        Query q = s.createQuery("select n.observacaoIntFiscalNotaFiscalPropria as obsIntFisco  from NotaFiscalPropria n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ObservacaoIntFiscalNotaFiscalPropria> obsIntFisco = new ArrayList<ObservacaoIntFiscalNotaFiscalPropria>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoIntFiscalNotaFiscalPropria obs = (ObservacaoIntFiscalNotaFiscalPropria)h.get("obsIntFisco");
            obsIntFisco.add(obs);
        }
        q = s.createQuery("select n.observacaoNota as obsNota from NotaFiscalPropria n where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        ArrayList<ObservacaoNotaPropria> obsNotaPropria = new ArrayList<ObservacaoNotaPropria>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            ObservacaoNotaPropria obs = (ObservacaoNotaPropria)h.get("obsNota");
            obsNotaPropria.add(obs);
        }
        if (!obsIntFisco.isEmpty() || !obsNotaPropria.isEmpty()) {
            RegC110 r = new RegC110();
            r.setObsIntFiscoNFPropria(obsIntFisco);
            r.setObsNotaPropria(obsNotaPropria);
            toRet.add(r);
        }
        regC100.setRegC110(toRet);
    }

    private void getProcessosReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.nrProcesso as nrProcesso, p.tipoProcesso.codigo as codTipoProcesso from NotaFiscalPropria n inner join n.processosReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC111> toRet = new ArrayList<RegC111>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC111 r = new RegC111();
            r.setNumeroProcesso((String)h.get("nrProcesso"));
            r.setCodOrigem((Short)h.get("codTipoProcesso"));
            toRet.add(r);
        }
        regC100.setRegC111(toRet);
    }

    private void getDocArrecadacaoReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.tipoDocArrecadacao.codigo as codDocArrecadacao, p.unidadeFederativa.sigla as uf, p.numeroDocumento as nrDoc, p.codigoAutenticacaoBanc as codAutBanco, p.valorDocArrecadacao as valorDocArrecadacao, p.dataVencimento as dataVencimento, p.dataPagamento as dataPagamento from NotaFiscalPropria n inner join n.docArrecadacaoReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC112> toRet = new ArrayList<RegC112>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC112 r = new RegC112();
            r.setCodigoProc((Short)h.get("codDocArrecadacao"));
            r.setUf((String)h.get("uf"));
            r.setNrDocArrecadacao((String)h.get("nrDoc"));
            r.setCodAutenticacao((String)h.get("codAutBanco"));
            r.setValorDoc((Double)h.get("valorDocArrecadacao"));
            r.setDataPagamento((Date)h.get("dataPagamento"));
            r.setDataVencimento((Date)h.get("dataVencimento"));
            toRet.add(r);
        }
        regC100.setRegC112(toRet);
    }

    private void getDocFiscalReferenciados(RegC100 regC100) {
        Long idNotaRef;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalPropria n inner join n.notaReferenciada p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            h = (HashMap)ob;
            idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasPropriasReferenciadas(idNotaRef));
        }
        q = s.createQuery("select p.identificador as idNotaRef from NotaFiscalPropria n inner join n.notaTerceirosReferenciadas p where n.identificador = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ret = q.list();
        for (Object ob : ret) {
            h = (HashMap)ob;
            idNotaRef = (Long)h.get("idNotaRef");
            toRet.addAll(this.getNotasTerceirosReferenciadas(idNotaRef));
        }
        regC100.setRegC113(toRet);
    }

    private void getCuponsReferenciados(RegC100 regC100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long idNota = regC100.getIdentificador();
        Query q = s.createQuery("select p.cupomFiscal.modeloDocFiscal.codigo as modDocFiscal, p.cupomFiscal.cupom.impressoraFiscal.serie as serie, p.cupomFiscal.cupom.nrCOO as nrSeq, p.cupomFiscal.cupom.impressoraFiscal.nrSequencialEcf as nrCaixa, p.cupomFiscal.cupom.dataEmissao as dataEmissao from NotaFiscalPropria n inner join n.cuponsReferenciados p where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC114> toRet = new ArrayList<RegC114>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC114 r = new RegC114();
            r.setCodModeloDocFiscal((String)h.get("modDocFiscal"));
            r.setNrSerieFabECF((String)h.get("serie"));
            r.setNrDocumento((Integer)h.get("nrSeq"));
            r.setNrCaixa((Short)h.get("nrCaixa"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        regC100.setRegC114(toRet);
    }

    private List getNotasPropriasReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.naturezaOperacao.entradaSaida                  as entSai,     n.unidadeFatCliente.cliente.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                         as codModeloDocFiscal,     n.serie                                          as serie,     n.numeroNota                                     as numeroNota,     n.dataEmissaoNota                                as dataEmissao from NotaFiscalPropria n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((Short)h.get("entSai"));
            r.setIndicadorEmitente((short)0);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getNotasTerceirosReferenciadas(Long idNotaRef) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select      n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa,     n.modeloDocFiscal.codigo                               as codModeloDocFiscal,     n.serie                                                as serie,     n.numeroNota                                           as numeroNota,     n.dataEmissao                                          as dataEmissao from NotaFiscalTerceiros n where      n.identificador  = :idNota");
        q.setLong("idNota", idNotaRef.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegC113> toRet = new ArrayList<RegC113>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            RegC113 r = new RegC113();
            r.setIndicadorOperacao((short)0);
            r.setIndicadorEmitente((short)1);
            r.setCodParticipante((Long)h.get("idPessoa"));
            r.setCodModFiscal((String)h.get("codModeloDocFiscal"));
            r.setSerie((String)h.get("serie"));
            r.setNumDocumento((Integer)h.get("numeroNota"));
            r.setDataEmissao((Date)h.get("dataEmissao"));
            toRet.add(r);
        }
        return toRet;
    }

    private List getInfComplNotasPropriasBlocoC100(List<RegC100> regC100) {
        ArrayList<Reg450> toRet = new ArrayList<Reg450>();
        for (RegC100 o : regC100) {
            Reg450 reg450;
            RegC100 r = o;
            if (r.getRegC110() == null || r.getRegC110().isEmpty()) continue;
            RegC110 regC110 = r.getRegC110().get(0);
            Iterator<ObservacaoNotaPropria> iterator = regC110.getObsNotaPropria().iterator();
            while (iterator.hasNext()) {
                ObservacaoNotaPropria observacaoNotaPropria;
                ObservacaoNotaPropria obsNotaPropria = observacaoNotaPropria = iterator.next();
                reg450 = new Reg450();
                reg450.setIdObservacao(obsNotaPropria.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsNotaPropria.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
            for (ObservacaoNotaPropria observacaoNotaPropria : regC110.getObsIntFiscoNFPropria()) {
                ObservacaoIntFiscalNotaFiscalPropria obsIntFisco = (ObservacaoIntFiscalNotaFiscalPropria)observacaoNotaPropria;
                reg450 = new Reg450();
                reg450.setIdObservacao(obsIntFisco.getObsFaturamento().getIdentificador());
                reg450.setDescricao(obsIntFisco.getObsFaturamento().getNome());
                toRet.add(reg450);
            }
        }
        return toRet;
    }

    private Object getProdutoAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idProduto, p.nome as nomeProduto, p.unidadeMedida.sigla as unidadeMedida, p.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, p.aliquotaIcms as aliquotaIcms from Produto p left join p.ncm nc left join p.genero g where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            return r;
        }
        return null;
    }

    private List<Reg200> getProdutosNotasFiscaisPropriasBlocoC100(Date dataIn, Date dataFim, Empresa emp, List<RegC100> registrosC100) {
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (RegC100 r100 : registrosC100) {
            if (r100.getRegC190() == null || r100.getRegC190().isEmpty()) continue;
            for (RegC190 r190 : r100.getRegC190()) {
                if (r190.getRegC195() == null || r190.getRegC195().isEmpty()) continue;
                for (RegC195 r195 : r190.getRegC195()) {
                    if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                    for (RegC197 r197 : r195.getAjustesLvFiscal()) {
                        if (r197.getIdProduto() == null) continue;
                        toRet.add((Reg200)this.getProdutoAjustesFiscais(r197.getIdProduto()));
                    }
                }
            }
        }
        return toRet;
    }
}

