/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.spedfiscal.versao008.util.blocod;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg150;
import mentorcore.service.impl.spedfiscal.versao008.model2.Reg200;
import mentorcore.service.impl.spedfiscal.versao008.model2.blocod.BlocoD;
import mentorcore.service.impl.spedfiscal.versao008.model2.blocod.RegD100;
import mentorcore.service.impl.spedfiscal.versao008.model2.blocod.RegD190;
import mentorcore.service.impl.spedfiscal.versao008.model2.blocod.RegD195;
import mentorcore.service.impl.spedfiscal.versao008.model2.blocod.RegD197;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilBDSpedFiscalBlocoD100NotaTerceiros {
    public BlocoD getBlocoD100NotasTerceirosTransporte(Empresa emp, Date dataIn, Date dataFim) throws ExceptionDatabase {
        BlocoD b = new BlocoD();
        b.setRegistrosD100(this.getNotasFiscaisTerceirosTransporteD100(dataIn, dataFim, emp));
        if (b.getRegistrosD100() != null && !b.getRegistrosD100().isEmpty()) {
            this.getLivrosFiscaisNotasTerceirosD100(b.getRegistrosD100());
            b.setParticipantes(this.getParticipantesNotasTerceirosTransporteD100(dataIn, dataFim, emp));
            b.setProdutos(this.getProdutosNotaTerceirosBlocoD100(b.getRegistrosD100()));
        }
        return b;
    }

    private List getNotasFiscaisTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct n.identificador as identificador, n.modeloDocFiscal.codigo as codModFiscal, n.unidadeFatFornecedor.fornecedor.pessoa.identificador as idPessoa, n.situacaoDocumento.codigo as sitDoc, n.serie as serie, n.numeroNota as numNota, n.chaveNFE as chaveNfe, n.dataEmissao as dataEmissao, n.dataEntrada as dataEntSai, tc.codigo as codigoTipoCte, n.valoresNfTerceiros.valorTotal as valorTotal, n.valoresNfTerceiros.valorProduto + n.valoresNfTerceiros.valorServico as valorProdServ, tf.opcao as codTpFrete, n.valoresNfTerceiros.valorDesconto as vlrDesconto, n.valoresNfTerceiros.valorIcmsTributado as bcIcms, n.valoresNfTerceiros.valorIcms as vlrIcms from NotaFiscalTerceiros n  left join n.tipoFrete tf left join n.tipoCte tc where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<RegD100> toRet = new ArrayList<RegD100>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            RegD100 r = new RegD100();
            r.setNumeroDoc(((Integer)h.get("numNota")).longValue());
            System.out.println("Nr Nota Terceiros de Transporte: " + r.getNumeroDoc().toString());
            r.setChaveNfe((String)h.get("chaveNfe"));
            r.setIdParticipante((Long)h.get("idPessoa"));
            r.setCodModDocFiscal((String)h.get("codModFiscal"));
            r.setCodSituacaoDoc((String)h.get("sitDoc"));
            if ((Short)h.get("codigoTipoCte") != null) {
                r.setCodTipoCTe(((Short)h.get("codigoTipoCte")).toString());
            }
            r.setDataEmissao((Date)h.get("dataEmissao"));
            r.setDataEntSaida((Date)h.get("dataEntSai"));
            if ((Short)h.get("codTpFrete") != null) {
                r.setIndicadorTipoFrete((Short)h.get("codTpFrete"));
            } else {
                r.setIndicadorTipoFrete((short)9);
            }
            r.setSerie((String)h.get("serie"));
            r.setValorBCIcms((Double)h.get("bcIcms"));
            r.setValorDesconto((Double)h.get("vlrDesconto"));
            r.setValorDoc((Double)h.get("valorTotal"));
            r.setValorICMS((Double)h.get("vlrIcms"));
            r.setValorTotMercadorias((Double)h.get("valorProdServ"));
            r.setIdentificador((Long)h.get("identificador"));
            ObsFaturamento obs = this.getObservacoesNota(r.getIdentificador());
            r.setObsFaturamento(obs);
            Long pc = this.getPlanoContaNota(r.getIdentificador());
            r.setPlanoConta(pc);
            toRet.add(r);
        }
        return toRet;
    }

    private ObsFaturamento getObservacoesNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select obs1 as obsEstNota, obs2 as obsIntFisco  from NotaFiscalTerceiros n left join n.observacaoNotaTerceiros as obsEstNota left join obsEstNota.obsFaturamento obs1 left join n.observacoesIntFisco as obsIntFisco  left join obsIntFisco.obsFaturamento obs2 where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ObsFaturamento obsEstNota = (ObsFaturamento)h.get("obsEstNota");
            if (obsEstNota != null) {
                return obsEstNota;
            }
            ObsFaturamento obsIntFisco = (ObsFaturamento)h.get("obsIntFisco");
            if (obsIntFisco == null) continue;
            return obsIntFisco;
        }
        return null;
    }

    private Long getPlanoContaNota(Long idNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select lv.planoConta.identificador as idPlanoConta from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
        q.setLong("idNota", idNota.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Long pc = (Long)h.get("idPlanoConta");
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private void getLivrosFiscaisNotasTerceirosD100(List<RegD100> registrosD100) {
        Session s = CoreBdUtil.getInstance().getSession();
        Iterator<RegD100> iterator = registrosD100.iterator();
        while (iterator.hasNext()) {
            RegD100 o;
            RegD100 regD100 = o = iterator.next();
            Long idNota = regD100.getIdentificador();
            Query q = s.createQuery("select distinct lv from NotaFiscalTerceiros n inner join n.livrosFiscais lv where n.identificador  = :idNota");
            q.setLong("idNota", idNota.longValue());
            List ret = q.list();
            regD100.setLivrosFiscais(this.getRegD190(ret));
        }
    }

    private List<RegD190> getRegD190(List ret) {
        ArrayList<RegD190> toRet = new ArrayList<RegD190>();
        for (Object ob : ret) {
            LivroFiscal h = (LivroFiscal)ob;
            RegD190 r = this.getRegD190(h.getIncidenciaIcms().getCodigo(), h.getCfop().getCodigo(), h.getAliquotaIcms(), toRet);
            if (r == null) {
                r = new RegD190();
                r.setRegD195(new ArrayList<RegD195>());
                toRet.add(r);
            }
            r.setIncidenciaIcms(h.getIncidenciaIcms().getCodigo());
            r.setCfop(h.getCfop().getCodigo());
            r.setAliquotaIcms(h.getAliquotaIcms());
            r.setValorOperacao(h.getValorTotal() + r.getValorOperacao());
            r.setBcCalculoIcms(h.getValorIcmsTributado() + r.getBcCalculoIcms());
            r.setValorIcms(h.getValorIcms() + r.getValorIcms());
            r.setValorNaoTribIcms(h.getVrNaoTribIcms() + r.getValorNaoTribIcms());
            r.setRegD195(this.getRegD195(r.getRegD195(), h.getObsLivroFiscal()));
        }
        return toRet;
    }

    private List<RegD195> getRegD195(List<RegD195> regD195, List<ObservacaoLivroFiscal> obsLivroFiscal) {
        for (ObservacaoLivroFiscal os : obsLivroFiscal) {
            RegD195 r = new RegD195();
            r.setIdObservacao(os.getObsFaturamento().getIdentificador());
            r.setTextoObs(os.getConteudo());
            ArrayList<RegD197> aux = new ArrayList<RegD197>();
            for (OutrasObrigLivroFiscal out : os.getOutrasObrigLivroFiscal()) {
                RegD197 d197 = new RegD197();
                d197.setAliquotaIcms(out.getAliquotaIcms());
                d197.setCodTipoAjusteApIcms(out.getTipoAjusteIcmsDocFiscal().getCodigo());
                d197.setDescricaoComp(out.getDescricaoComp());
                if (out.getProduto() != null) {
                    d197.setIdProduto(out.getProduto().getIdentificador());
                }
                d197.setVlrBCIcmsIcmsST(out.getVlrBCIcmsIcmsST());
                d197.setVlrIcmsIcmsST(out.getVlrIcmsIcmsST());
                d197.setVlrOutros(out.getVlrOutros());
                aux.add(d197);
            }
            r.setAjustesLvFiscal(aux);
            regD195.add(r);
        }
        return regD195;
    }

    private RegD190 getRegD190(String inc, String cfop, Double aliqIcms, List toRet) {
        for (Object o : toRet) {
            RegD190 r = (RegD190)o;
            if (r.getAliquotaIcms().doubleValue() != aliqIcms.doubleValue() || !r.getIncidenciaIcms().equalsIgnoreCase(inc) || !r.getCfop().equalsIgnoreCase(cfop)) continue;
            return r;
        }
        return null;
    }

    List getParticipantesNotasTerceirosTransporteD100(Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idPessoa, p.endereco.numero as numero, p.endereco.logradouro as logradouro, p.endereco.complemento as complemento, p.endereco.bairro as bairro, p.complemento.cnpj as cnpj, p.complemento.inscEst as inscEst, p.complemento.suframa as suframa, p.nome as nome, p.endereco.cidade.uf.pais.codIbge as codPais, p.endereco.cidade.uf.codIbge as codUf, p.endereco.cidade.codIbge as codCidade  from NotaFiscalTerceiros n  inner join n.unidadeFatFornecedor u inner join u.fornecedor c inner join c.pessoa p where  (n.modeloDocFiscal.codigo=:cod1  or n.modeloDocFiscal.codigo=:cod2 or n.modeloDocFiscal.codigo=:cod3 or n.modeloDocFiscal.codigo=:cod4 or n.modeloDocFiscal.codigo=:cod5 or n.modeloDocFiscal.codigo=:cod6 or n.modeloDocFiscal.codigo=:cod7 or n.modeloDocFiscal.codigo=:cod8 or n.modeloDocFiscal.codigo=:cod9) and n.dataEntrada between :dataIn and :dataFim and n.empresa=:empresa and (n.situacaoDocumento.codigo = :codSitDoc1 or  n.situacaoDocumento.codigo = :codSitDoc2 or n.situacaoDocumento.codigo = :codSitDoc3 or n.situacaoDocumento.codigo = :codSitDoc4 or n.situacaoDocumento.codigo = :codSitDoc5 )");
        q.setString("cod1", "07");
        q.setString("cod2", "08");
        q.setString("cod3", "8B");
        q.setString("cod4", "09");
        q.setString("cod5", "10");
        q.setString("cod6", "11");
        q.setString("cod7", "26");
        q.setString("cod8", "27");
        q.setString("cod9", "57");
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)emp);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<Reg150> toRet = new ArrayList<Reg150>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Reg150 r = new Reg150();
            r.setBairro((String)h.get("bairro"));
            r.setCnpj((String)h.get("cnpj"));
            r.setCodPais((String)h.get("codPais"));
            r.setCodUf((String)h.get("codUf"));
            r.setCodigoMunicipio((String)h.get("codCidade"));
            r.setComplemento((String)h.get("complemento"));
            r.setCpf((String)h.get("cnpj"));
            r.setEndereco((String)h.get("logradouro"));
            r.setIdPessoa((Long)h.get("idPessoa"));
            r.setInscricaoEstadual((String)h.get("inscEst"));
            r.setNomePessoa((String)h.get("nome"));
            r.setNumero((String)h.get("numero"));
            r.setSuframa((String)h.get("suframa"));
            toRet.add(r);
        }
        return toRet;
    }

    private List<Reg200> getProdutosNotaTerceirosBlocoD100(List<RegD100> registrosD100) throws ExceptionDatabase {
        ArrayList<Reg200> toRet = new ArrayList<Reg200>();
        for (RegD100 r100 : registrosD100) {
            if (r100.getLivrosFiscais() == null || r100.getLivrosFiscais().isEmpty()) continue;
            for (RegD190 r190 : r100.getLivrosFiscais()) {
                if (r190.getRegD195() == null || r190.getRegD195().isEmpty()) continue;
                for (RegD195 r195 : r190.getRegD195()) {
                    if (r195.getAjustesLvFiscal() == null || r195.getAjustesLvFiscal().isEmpty()) continue;
                    for (RegD197 r197 : r195.getAjustesLvFiscal()) {
                        if (r197.getIdProduto() == null) continue;
                        toRet.add((Reg200)this.getProdutoAjustesFiscais(r197.getIdProduto()));
                    }
                }
            }
        }
        return toRet;
    }

    private Object getProdutoAjustesFiscais(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct  p.identificador as idProduto, p.nome as nomeProduto, p.unidadeMedida.sigla as unidadeMedida, p.tipoIemSped.codigo as codTipoItemSped, nc.codigo as codNcm, g.codigo as codGenero, p.aliquotaIcms as aliquotaIcms from Produto p left join p.ncm nc left join p.genero g where  p.identificador = :idProduto");
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            HashMap h = (HashMap)o;
            Reg200 r = new Reg200();
            r.setIdProduto((Long)h.get("idProduto"));
            r.setDescricao((String)h.get("nomeProduto"));
            r.setUnidadeMedida((String)h.get("unidadeMedida"));
            r.setTipoItem((String)h.get("codTipoItemSped"));
            r.setCodNcm((String)h.get("codNcm"));
            r.setCodGenero((String)h.get("codGenero"));
            r.setAliquotaIcms((Double)h.get("aliquotaIcms"));
            r.setCodBarras(this.getCodigoBarrasProduto(r.getIdProduto()));
            return r;
        }
        return null;
    }

    private String getCodigoBarrasProduto(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.codigoBarras from CodigoBarras c where c.usarComoCodPrincTrib=:sim and c.produto.identificador=:idProd");
        q.setLong("idProd", idProduto.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

